/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.ipcamera.onvifdiscovery;

import io.antmedia.ipcamera.onvifdiscovery.DeviceDiscovery;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class OnvifDiscovery {
    public static List<URL> discoverOnvifDevices(boolean useIpv4, ArrayList<String> addressList) {
        ArrayList<URL> onvifPointers = new ArrayList<URL>();
        Collection<URL> urls = DeviceDiscovery.discoverWsDevicesAsUrls("^http$", ".*onvif.*", useIpv4, addressList);
        for (URL url : urls) {
            try {
                onvifPointers.add(url);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return onvifPointers;
    }

    public static void main(String[] args) throws IOException {
        ArrayList<String> addressList = new ArrayList<String>();
        for (int i = 2; i < 255; ++i) {
            addressList.add("192.168.1." + i);
        }
        List<URL> onvifDevices = OnvifDiscovery.discoverOnvifDevices(true, addressList);
        if (onvifDevices.size() == 0) {
            System.out.println("No Onvif device found");
        }
        for (URL url : onvifDevices) {
            System.out.println("Device discovered: " + url.toString());
        }
    }
}

