/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.security;

import io.antmedia.AppSettings;
import io.antmedia.datastore.db.DataStoreFactory;
import io.antmedia.datastore.db.IDataStore;
import io.antmedia.datastore.db.types.Token;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.red5.server.api.Red5;
import org.red5.server.api.scope.IScope;
import org.red5.server.api.stream.IStreamPublishSecurity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class TokenService
implements ApplicationContextAware,
IStreamPublishSecurity {
    public static final String BEAN_NAME = "token.service";
    protected static Logger logger = LoggerFactory.getLogger(TokenService.class);
    private AppSettings settings;
    private IDataStore dataStore;
    Map<String, String> authenticatedMap = new ConcurrentHashMap<String, String>();
    private ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        if (applicationContext.containsBean("app.settings")) {
            this.settings = (AppSettings)applicationContext.getBean("app.settings");
        }
    }

    public boolean checkToken(String tokenId, String streamId, String sessionId, String type) {
        boolean result = false;
        if (streamId != null && sessionId != null) {
            Token token = new Token();
            token.setTokenId(tokenId);
            token.setStreamId(streamId);
            token.setType(type);
            if (this.getDataStore().validateToken(token) != null) {
                result = true;
                if (type.equals("play")) {
                    this.authenticatedMap.put(sessionId, streamId);
                }
            } else if (this.authenticatedMap.containsKey(sessionId) && this.authenticatedMap.get(sessionId).equals(streamId)) {
                result = true;
            }
        }
        return result;
    }

    public boolean isPublishAllowed(IScope scope, String name, String mode, Map<String, String> queryParams) {
        boolean result = true;
        if (this.settings.isTokenControlEnabled()) {
            result = false;
            if (queryParams == null || !queryParams.containsKey("token")) {
                Red5.getConnectionLocal().close();
                return false;
            }
            String token = queryParams.get("token");
            if (this.checkToken(token, name, "sessionId", "publish")) {
                result = true;
            } else {
                logger.info("Token {} is not valid for publishing ", (Object)token);
                Red5.getConnectionLocal().close();
            }
        }
        return result;
    }

    public AppSettings getSettings() {
        return this.settings;
    }

    public void setSettings(AppSettings settings) {
        this.settings = settings;
    }

    public IDataStore getDataStore() {
        if (this.dataStore == null) {
            this.dataStore = ((DataStoreFactory)this.applicationContext.getBean("dataStoreFactory")).getDataStore();
        }
        return this.dataStore;
    }

    public void setDataStore(IDataStore dataStore) {
        this.dataStore = dataStore;
    }
}

