/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.red5.logging.Red5LoggerFactory;
import org.red5.server.api.IApplicationContext;
import org.red5.server.api.IApplicationLoader;
import org.slf4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public abstract class LoaderBase
implements ApplicationContextAware {
    private static Logger log = Red5LoggerFactory.getLogger(LoaderBase.class);
    protected static ApplicationContext applicationContext;
    public static final Map<String, IApplicationContext> red5AppCtx;
    protected static ThreadLocal<IApplicationLoader> loader;
    protected String webappFolder = null;

    public static IApplicationLoader getApplicationLoader() {
        log.debug("Get application loader");
        return loader.get();
    }

    public static void setApplicationLoader(IApplicationLoader loader) {
        log.debug("Set application loader: {}", (Object)loader);
        LoaderBase.loader.set(loader);
    }

    public static Map<String, IApplicationContext> getRed5ApplicationContexts() {
        log.debug("Get all red5 application contexts");
        return red5AppCtx;
    }

    public static IApplicationContext getRed5ApplicationContext(String path) {
        log.debug("Get red5 application context - path: {}", (Object)path);
        return red5AppCtx.get(path);
    }

    public static void setRed5ApplicationContext(String path, IApplicationContext context) {
        log.debug("Set red5 application context - path: {} context: {}", (Object)path, (Object)context);
        if (context != null) {
            red5AppCtx.put(path, context);
        } else {
            red5AppCtx.remove(path);
        }
    }

    public static IApplicationContext removeRed5ApplicationContext(String path) {
        log.debug("Remove red5 application context - path: {}", (Object)path);
        return red5AppCtx.remove(path);
    }

    public static ApplicationContext getApplicationContext() {
        log.debug("Get application context: {}", (Object)applicationContext);
        return applicationContext;
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        log.debug("Set application context: {}", (Object)context);
        applicationContext = context;
    }

    public void setWebappFolder(String webappFolder) {
        File fp = new File(webappFolder);
        if (!fp.canRead()) {
            throw new RuntimeException(String.format("Webapp folder %s cannot be accessed.", webappFolder));
        }
        if (!fp.isDirectory()) {
            throw new RuntimeException(String.format("Webapp folder %s doesn't exist.", webappFolder));
        }
        fp = null;
        this.webappFolder = webappFolder;
    }

    public void removeContext(String path) {
        throw new UnsupportedOperationException();
    }

    static {
        red5AppCtx = new HashMap<String, IApplicationContext>();
        loader = new ThreadLocal();
    }
}

