/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.console;

import io.antmedia.AntMediaApplicationAdapter;
import io.antmedia.cluster.IClusterNotifier;
import io.antmedia.console.datastore.ConsoleDataStoreFactory;
import io.vertx.core.Vertx;
import jakarta.annotation.Nullable;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.red5.server.adapter.MultiThreadedApplicationAdapter;
import org.red5.server.api.IConnection;
import org.red5.server.api.IContext;
import org.red5.server.api.scope.IBroadcastScope;
import org.red5.server.api.scope.IGlobalScope;
import org.red5.server.api.scope.IScope;
import org.red5.server.api.scope.ScopeType;
import org.red5.server.scope.WebScope;
import org.red5.server.tomcat.WarDeployer;
import org.red5.server.util.ScopeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class AdminApplication
extends MultiThreadedApplicationAdapter {
    private static final Logger log = LoggerFactory.getLogger(AdminApplication.class);
    public static final String APP_NAME = "ConsoleApp";
    private ConsoleDataStoreFactory dataStoreFactory;
    private IScope rootScope;
    private Vertx vertx;
    private WarDeployer warDeployer;
    private boolean isCluster = false;
    private IClusterNotifier clusterNotifier;
    private Queue<String> currentApplicationCreationProcesses = new ConcurrentLinkedQueue<String>();

    @Override
    public boolean appStart(IScope app) {
        this.isCluster = app.getContext().hasBean("tomcat.cluster");
        this.vertx = (Vertx)this.scope.getContext().getBean("vertxCore");
        this.warDeployer = (WarDeployer)app.getContext().getBean("warDeployer");
        if (this.isCluster) {
            this.clusterNotifier = (IClusterNotifier)app.getContext().getBean("tomcat.cluster");
            this.clusterNotifier.registerCreateAppListener((appName, warFileURI) -> this.createApplicationWithURL(appName, warFileURI));
            this.clusterNotifier.registerDeleteAppListener(appName -> {
                log.info("Deleting application with name {}", (Object)appName);
                return this.deleteApplication(appName, false);
            });
        }
        return super.appStart(app);
    }

    public boolean createApplicationWithURL(String appName, String warFileURI) {
        if (this.currentApplicationCreationProcesses.contains(appName)) {
            log.warn("{} application has already been installing", (Object)appName);
            return false;
        }
        log.info("Creating application with name {}", (Object)appName);
        boolean result = false;
        try {
            String warFileFullPath = null;
            if (warFileURI != null && !warFileURI.isEmpty()) {
                warFileFullPath = this.downloadWarFile(appName, warFileURI).getAbsolutePath();
            }
            result = this.createApplication(appName, warFileFullPath);
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        return result;
    }

    @Override
    public boolean connect(IConnection conn, IScope scope, Object[] params) {
        this.scope = scope;
        return false;
    }

    @Override
    public void disconnect(IConnection conn, IScope scope) {
        super.disconnect(conn, scope);
    }

    public IScope getRootScope() {
        if (this.rootScope == null) {
            this.rootScope = ScopeUtils.findRoot(this.scope);
        }
        return this.rootScope;
    }

    public int getTotalLiveStreamSize() {
        List<String> appNames = this.getApplications();
        int size = 0;
        for (String name : appNames) {
            IScope scope = this.getRootScope().getScope(name);
            size += this.getAppLiveStreamCount(scope);
        }
        return size;
    }

    public List<ApplicationInfo> getApplicationInfo() {
        List<String> appNames = this.getApplications();
        ArrayList<ApplicationInfo> appsInfo = new ArrayList<ApplicationInfo>();
        for (String name : appNames) {
            if (name.equals(APP_NAME)) continue;
            ApplicationInfo info = new ApplicationInfo();
            info.name = name;
            info.liveStreamCount = this.getAppLiveStreamCount(this.getRootScope().getScope(name));
            info.vodCount = this.getVoDCount(this.getRootScope().getScope(name));
            info.storage = this.getStorage(name);
            appsInfo.add(info);
        }
        return appsInfo;
    }

    public AntMediaApplicationAdapter getApplicationAdaptor(IScope appScope) {
        return (AntMediaApplicationAdapter)appScope.getContext().getApplicationContext().getBean("web.handler");
    }

    private long getStorage(String name) {
        File appFolder = new File("webapps/" + name);
        return FileUtils.sizeOfDirectory((File)appFolder);
    }

    public int getVoDCount(IScope appScope) {
        int size = 0;
        if (appScope != null) {
            size = (int)this.getApplicationAdaptor(appScope).getDataStore().getTotalVodNumber();
        }
        return size;
    }

    public List<BroadcastInfo> getAppLiveStreams(String name) {
        IScope root = this.getRootScope();
        IScope appScope = root.getScope(name);
        ArrayList<BroadcastInfo> broadcastInfoList = new ArrayList<BroadcastInfo>();
        Set<String> basicScopeNames = appScope.getBasicScopeNames(ScopeType.BROADCAST);
        for (String scopeName : basicScopeNames) {
            IBroadcastScope broadcastScope = appScope.getBroadcastScope(scopeName);
            BroadcastInfo info = new BroadcastInfo(broadcastScope.getName(), broadcastScope.getConsumers().size());
            broadcastInfoList.add(info);
        }
        return broadcastInfoList;
    }

    public boolean deleteVoDStream(String appname, String streamName) {
        File vodStream = new File("webapps/" + appname + "/streams/" + streamName);
        boolean result = false;
        if (vodStream.exists()) {
            try {
                Files.delete(vodStream.toPath());
                result = true;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public List<String> getApplications() {
        IScope root = this.getRootScope();
        Set<String> names = root.getScopeNames();
        ArrayList<String> apps = new ArrayList<String>();
        for (String name : names) {
            if (name.equals("root")) continue;
            apps.add(name);
        }
        Collections.sort(apps);
        return apps;
    }

    public int getTotalConnectionSize() {
        IScope root = this.getRootScope();
        return root.getStatistics().getActiveClients();
    }

    public ApplicationContext getApplicationContext(String scopeName) {
        IContext context;
        IScope scope = this.getScope(scopeName);
        if (scope != null && (context = scope.getContext()) != null) {
            return context.getApplicationContext();
        }
        log.warn("Application:{} is not initilized", (Object)scopeName);
        return null;
    }

    private IScope getScope(String scopeName) {
        IGlobalScope root = (IGlobalScope)ScopeUtils.findRoot(this.scope);
        return this.getScopes(root, scopeName);
    }

    private IScope getScopes(IGlobalScope root, String scopeName) {
        if (root.getName().equals(scopeName)) {
            return root;
        }
        if (root instanceof IScope) {
            try {
                IScope scope = root.getScope(scopeName);
                if (scope != null) {
                    return scope;
                }
            }
            catch (NullPointerException npe) {
                log.debug(npe.toString());
            }
        }
        return null;
    }

    public ConsoleDataStoreFactory getDataStoreFactory() {
        return this.dataStoreFactory;
    }

    public void setDataStoreFactory(ConsoleDataStoreFactory dataStoreFactory) {
        this.dataStoreFactory = dataStoreFactory;
    }

    public int getAppLiveStreamCount(IScope appScope) {
        int size = 0;
        if (appScope != null) {
            size = (int)this.getApplicationAdaptor(appScope).getDataStore().getActiveBroadcastCount();
        }
        return size;
    }

    public boolean createApplication(String appName, String warFileFullPath) {
        if (this.currentApplicationCreationProcesses.contains(appName)) {
            log.warn("{} application has already been installing", (Object)appName);
            return false;
        }
        this.currentApplicationCreationProcesses.add(appName);
        boolean success = false;
        logger.info("Running create app script, war file name (null if default): {}, app name: {} ", (Object)warFileFullPath, (Object)appName);
        WebScope appScope = (WebScope)this.getRootScope().getScope(appName);
        if (appScope != null && appScope.isRunning()) {
            logger.info("{} already exists and running", (Object)appName);
            this.currentApplicationCreationProcesses.remove(appName);
            return false;
        }
        String dbConnectionURL = this.getDataStoreFactory().getDbHost();
        String mongoUser = this.getDataStoreFactory().getDbUser();
        String mongoPass = this.getDataStoreFactory().getDbPassword();
        success = this.runCreateAppScript(appName, this.isCluster, dbConnectionURL, mongoUser, mongoPass, warFileFullPath);
        this.vertx.executeBlocking(() -> {
            try {
                this.warDeployer.deploy(true);
            }
            finally {
                this.currentApplicationCreationProcesses.remove(appName);
            }
            return null;
        });
        return success;
    }

    public Queue<String> getCurrentApplicationCreationProcesses() {
        return this.currentApplicationCreationProcesses;
    }

    @Nullable
    public static File saveWARFile(String appName, InputStream inputStream) {
        File file = null;
        String fileExtension = "war";
        try {
            String tmpsDirectory = System.getProperty("java.io.tmpdir");
            File savedFile = new File(tmpsDirectory + File.separator + appName + "." + fileExtension);
            int read = 0;
            byte[] bytes = new byte[2048];
            try (FileOutputStream outpuStream = new FileOutputStream(savedFile);){
                while ((read = inputStream.read(bytes)) != -1) {
                    ((OutputStream)outpuStream).write(bytes, 0, read);
                }
                outpuStream.flush();
                logger.info("War file uploaded for application, filesize = {} path = {}", (Object)savedFile.length(), (Object)savedFile.getPath());
            }
            file = savedFile;
        }
        catch (Exception iox) {
            logger.error(iox.getMessage());
        }
        return file;
    }

    public CloseableHttpClient getHttpClient() {
        return HttpClients.createDefault();
    }

    public File downloadWarFile(String appName, String warFileUrl) throws IOException {
        try (CloseableHttpClient client = this.getHttpClient();){
            File file;
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(2000).setSocketTimeout(5000).build();
            HttpRequestBase get = (HttpRequestBase)RequestBuilder.get().setUri(warFileUrl).build();
            get.setConfig(requestConfig);
            CloseableHttpResponse response = client.execute((HttpUriRequest)get);
            try (BufferedInputStream in = new BufferedInputStream(response.getEntity().getContent());){
                file = AdminApplication.saveWARFile(appName, in);
            }
            return file;
        }
    }

    public synchronized boolean deleteApplication(String appName, boolean deleteDB) {
        boolean success = false;
        WebScope appScope = (WebScope)this.getRootScope().getScope(appName);
        if (appScope != null && appScope.isRunning()) {
            logger.info("Deleting app:{} and appscope is running:{}", (Object)appName, (Object)appScope.isRunning());
            this.getApplicationAdaptor(appScope).stopApplication(deleteDB);
            success = this.runDeleteAppScript(appName);
            this.warDeployer.undeploy(appName);
            try {
                appScope.destroy();
            }
            catch (Exception e) {
                log.error(ExceptionUtils.getStackTrace((Throwable)e));
                success = false;
            }
        } else {
            logger.info("Application scope for app:{} is not available to delete.", (Object)appName);
            Path currentPath = Paths.get("", new String[0]);
            File f = new File(currentPath.toAbsolutePath().toString() + "/webapps/" + appName);
            if (f.exists()) {
                logger.error("It detects an non-completed app deployment directory with name {}. It's being deleted.", (Object)appName);
                success = this.runDeleteAppScript(appName);
            }
        }
        return success;
    }

    public boolean runCreateAppScript(String appName) {
        return this.runCreateAppScript(appName, false, null, null, null, null);
    }

    public boolean runCreateAppScript(String appName, boolean isCluster, String dbConnectionUrl, String dbUser, String dbPass, String warFileName) {
        Path currentRelativePath = Paths.get("", new String[0]);
        String webappsPath = currentRelativePath.toAbsolutePath().toString();
        String command = "/bin/bash create_app.sh -n " + appName + " -w true -p " + webappsPath + " -c " + isCluster;
        if (!"mapdb".equals(this.getDataStoreFactory().getDbType())) {
            if (StringUtils.isNotBlank((CharSequence)dbConnectionUrl)) {
                command = command + " -m " + dbConnectionUrl;
            }
            if (StringUtils.isNotBlank((CharSequence)dbUser)) {
                command = command + " -u " + dbUser;
            }
            if (StringUtils.isNotBlank((CharSequence)dbPass)) {
                command = command + " -s " + dbPass;
            }
        }
        if (StringUtils.isNotBlank((CharSequence)warFileName)) {
            command = command + " -f " + warFileName;
        }
        log.info("Creating application with command: {}", (Object)command);
        return this.runCommand(command);
    }

    public boolean runDeleteAppScript(String appName) {
        Path currentRelativePath = Paths.get("", new String[0]);
        String webappsPath = currentRelativePath.toAbsolutePath().toString();
        String command = "/bin/bash delete_app.sh -n " + appName + " -p " + webappsPath;
        return this.runCommand(command);
    }

    public IClusterNotifier getClusterNotifier() {
        return this.clusterNotifier;
    }

    public boolean runCommand(String command) {
        boolean result = false;
        try {
            final Process process = this.getProcess(command);
            if (process != null) {
                new Thread(){

                    @Override
                    public void run() {
                        InputStream inputStream = process.getInputStream();
                        byte[] data = new byte[1024];
                        try {
                            int length;
                            while ((length = inputStream.read(data, 0, data.length)) > 0) {
                                log.info(new String(data, 0, length));
                            }
                        }
                        catch (IOException e) {
                            log.error(ExceptionUtils.getStackTrace((Throwable)e));
                        }
                    }
                }.start();
                result = process.waitFor() == 0;
            }
        }
        catch (IOException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (InterruptedException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            Thread.currentThread().interrupt();
        }
        return result;
    }

    public Process getProcess(String command) throws IOException {
        String[] parameters = command.split(" ");
        String[] parametersToRun = new String[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            Object param = parameters[i];
            if (((String)param).matches(".*[;&|<>()$`\\r\\n\\t*?{}\\[\\]\\\\\"'\\s].*")) {
                logger.warn("Command includes special characters. Escaping the special characters. Argument:{} and full command:{}", param, (Object)command);
                param = "'" + (String)param + "'";
            }
            parametersToRun[i] = param;
        }
        ProcessBuilder pb = this.getProcessBuilder(parametersToRun);
        return pb.start();
    }

    public ProcessBuilder getProcessBuilder(String[] parametersToRun) {
        return new ProcessBuilder(parametersToRun);
    }

    public void setVertx(Vertx vertx) {
        this.vertx = vertx;
    }

    public void setWarDeployer(WarDeployer warDeployer) {
        this.warDeployer = warDeployer;
    }

    public static class ApplicationInfo {
        public String name;
        public int liveStreamCount;
        public int vodCount;
        public long storage;
    }

    public static class BroadcastInfo {
        public String name;
        public int watcherCount;

        public BroadcastInfo(String name, int watcherCount) {
            this.name = name;
            this.watcherCount = watcherCount;
        }
    }
}

