/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.datastore.db.types;

import dev.morphia.annotations.Entity;
import dev.morphia.annotations.Field;
import dev.morphia.annotations.Id;
import dev.morphia.annotations.Index;
import dev.morphia.annotations.Indexes;
import io.antmedia.rest.model.UserType;
import io.swagger.v3.oas.annotations.media.Schema;
import org.bson.types.ObjectId;

@Schema(description="The user information")
@Entity(value="user")
@Indexes(value={@Index(fields={@Field(value="email")}), @Index(fields={@Field(value="fullName")})})
public class User {
    @Schema(description="The email of the user")
    private String email;
    @Schema(description="The password of the user")
    private String password;
    @Schema(description="The type of the user", allowableValues={"ADMIN", "READ-ONLY", "USER"})
    private UserType userType;
    @Schema(description="The scope of the user. If it's 'system', it can access system-level stuff. If it's an application name, it can access application-level stuff.")
    private String scope;
    @Schema(description="The new password of the user")
    private String newPassword;
    @Schema(description="The first name of the user")
    private String firstName;
    @Schema(description="The last name of the user")
    private String lastName;
    @Deprecated
    @Schema(description="The full name of the user")
    private String fullName;
    @Schema(description="The URL of the user's picture")
    private String picture;
    @Schema(description="The id of the user")
    @Id
    private ObjectId id;

    public User(String email, String password, UserType userType, String scope) {
        this.email = email;
        this.password = password;
        this.userType = userType;
        this.scope = scope;
    }

    public User() {
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public UserType getUserType() {
        return this.userType;
    }

    public void setUserType(UserType userType) {
        this.userType = userType;
    }

    public String getNewPassword() {
        return this.newPassword;
    }

    public void setNewPassword(String newPassword) {
        this.newPassword = newPassword;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getPicture() {
        return this.picture;
    }

    public void setPicture(String picture) {
        this.picture = picture;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }
}

