/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.filter;

import io.antmedia.datastore.db.types.Broadcast;
import io.antmedia.filter.StatisticsFilter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

public class DashStatisticsFilter
extends StatisticsFilter {
    @Override
    public boolean isViewerCountExceeded(HttpServletRequest request, HttpServletResponse response, String streamId) throws IOException {
        Broadcast broadcast = this.getBroadcast(request, streamId);
        if (broadcast != null && broadcast.getDashViewerLimit() != -1 && broadcast.getDashViewerCount() >= broadcast.getDashViewerLimit()) {
            response.sendError(403, "Viewer Limit Reached");
            return true;
        }
        return false;
    }

    @Override
    public boolean isFilterMatching(String requestURI) {
        return requestURI != null && (requestURI.endsWith("m4s") || requestURI.endsWith("mpd"));
    }

    @Override
    public String getBeanName() {
        return "dash.viewerstats";
    }
}

