/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.filter;

import io.antmedia.AppSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class StreamAcceptFilter
implements ApplicationContextAware {
    private AppSettings appSettings;
    private String streamId;
    protected static Logger logger = LoggerFactory.getLogger(StreamAcceptFilter.class);

    public boolean isValidStreamParameters(int width, int height, int fps, int bitrate, String streamId) {
        this.streamId = streamId;
        return this.checkFPSAccept(fps) && this.checkResolutionAccept(width, height) && this.checkBitrateAccept(bitrate);
    }

    public boolean checkFPSAccept(int fps) {
        if (fps != 0 && this.getMaxFps() > 0 && this.getMaxFps() < fps) {
            logger.error("Exceeding Max FPS({}) limit. FPS is: {} streamId: {}", new Object[]{this.getMaxFps(), fps, this.streamId});
            return false;
        }
        return true;
    }

    public boolean checkResolutionAccept(int width, int height) {
        if (height != 0 && this.getMaxResolution() > 0 && this.getMaxResolution() < height) {
            logger.error("Exceeding Max Resolution({}) acceptable limit. Resolution is: {} streamId:{}", new Object[]{this.getMaxResolution(), height, this.streamId});
            return false;
        }
        return true;
    }

    public boolean checkBitrateAccept(long streamBitrateValue) {
        if (streamBitrateValue != 0L && this.getMaxBitrate() > 0 && (long)this.getMaxBitrate() < streamBitrateValue) {
            logger.error("Exceeding Max Bitrate({}) acceptable limit. Stream Bitrate is: {} streamId:{}", new Object[]{this.getMaxBitrate(), streamBitrateValue, this.streamId});
            return false;
        }
        return true;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        if (applicationContext.containsBean("app.settings")) {
            this.appSettings = (AppSettings)applicationContext.getBean("app.settings");
        }
    }

    public AppSettings getAppSettings() {
        return this.appSettings;
    }

    public int getMaxFps() {
        return 0;
    }

    public int getMaxResolution() {
        if (this.appSettings != null) {
            return this.appSettings.getMaxResolutionAccept();
        }
        return 0;
    }

    public int getMaxBitrate() {
        return 0;
    }
}

