/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.muxer;

import io.antmedia.AntMediaApplicationAdapter;
import io.antmedia.AppSettings;
import io.antmedia.EncoderSettings;
import io.antmedia.RecordType;
import io.antmedia.analytic.model.KeyFrameStatsEvent;
import io.antmedia.analytic.model.PublishStatsEvent;
import io.antmedia.datastore.db.DataStore;
import io.antmedia.datastore.db.IDataStoreFactory;
import io.antmedia.datastore.db.types.Broadcast;
import io.antmedia.datastore.db.types.Endpoint;
import io.antmedia.logger.LoggerUtils;
import io.antmedia.muxer.HLSMuxer;
import io.antmedia.muxer.IAntMediaStreamHandler;
import io.antmedia.muxer.IEndpointStatusListener;
import io.antmedia.muxer.Mp4Muxer;
import io.antmedia.muxer.Muxer;
import io.antmedia.muxer.RecordMuxer;
import io.antmedia.muxer.RtmpMuxer;
import io.antmedia.muxer.WebMMuxer;
import io.antmedia.muxer.parser.AACConfigParser;
import io.antmedia.muxer.parser.SpsParser;
import io.antmedia.muxer.parser.codec.AACAudio;
import io.antmedia.plugin.PacketFeeder;
import io.antmedia.plugin.api.IPacketListener;
import io.antmedia.plugin.api.StreamParametersInfo;
import io.antmedia.rest.model.Result;
import io.antmedia.settings.ServerSettings;
import io.antmedia.storage.StorageClient;
import io.vertx.core.Vertx;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.mina.core.buffer.IoBuffer;
import org.bytedeco.ffmpeg.avcodec.AVCodecParameters;
import org.bytedeco.ffmpeg.avcodec.AVPacket;
import org.bytedeco.ffmpeg.avformat.AVFormatContext;
import org.bytedeco.ffmpeg.avformat.AVStream;
import org.bytedeco.ffmpeg.avutil.AVChannelLayout;
import org.bytedeco.ffmpeg.avutil.AVRational;
import org.bytedeco.ffmpeg.global.avutil;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.Pointer;
import org.red5.codec.AVCVideo;
import org.red5.codec.IAudioStreamCodec;
import org.red5.codec.IStreamCodecInfo;
import org.red5.codec.IVideoStreamCodec;
import org.red5.server.api.IConnection;
import org.red5.server.api.IContext;
import org.red5.server.api.scope.IScope;
import org.red5.server.api.stream.IBroadcastStream;
import org.red5.server.api.stream.IStreamCapableConnection;
import org.red5.server.api.stream.IStreamPacket;
import org.red5.server.net.rtmp.event.CachedEvent;
import org.red5.server.stream.ClientBroadcastStream;
import org.red5.server.stream.IRecordingListener;
import org.red5.server.stream.consumer.FileConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class MuxAdaptor
implements IRecordingListener,
IEndpointStatusListener {
    public static final int STAT_UPDATE_PERIOD_MS = 10000;
    public static final String ADAPTIVE_SUFFIX = "_adaptive";
    private static Logger logger = LoggerFactory.getLogger(MuxAdaptor.class);
    protected ConcurrentLinkedQueue<IStreamPacket> streamPacketQueue = new ConcurrentLinkedQueue();
    protected AtomicBoolean isPipeReaderJobRunning = new AtomicBoolean(false);
    private AtomicBoolean isBufferedWriterRunning = new AtomicBoolean(false);
    protected List<Muxer> muxerList = Collections.synchronizedList(new ArrayList());
    protected boolean deleteHLSFilesOnExit = true;
    protected boolean deleteDASHFilesOnExit = true;
    private int videoStreamIndex;
    protected int audioStreamIndex;
    protected boolean previewOverwrite = false;
    protected volatile boolean enableVideo = false;
    protected volatile boolean enableAudio = false;
    boolean firstAudioPacketSkipped = false;
    boolean firstVideoPacketSkipped = false;
    private long packetPollerId = -1L;
    private ConcurrentSkipListSet<IStreamPacket> bufferQueue = new ConcurrentSkipListSet((a, b) -> Long.compare(a.getTimestamp(), b.getTimestamp()));
    private volatile boolean stopRequestExist = false;
    public static final int RECORDING_ENABLED_FOR_STREAM = 1;
    public static final int RECORDING_DISABLED_FOR_STREAM = -1;
    public static final int RECORDING_NO_SET_FOR_STREAM = 0;
    protected static final long WAIT_TIME_MILLISECONDS = 5L;
    protected AtomicBoolean isRecording = new AtomicBoolean(false);
    protected ClientBroadcastStream broadcastStream;
    protected boolean mp4MuxingEnabled;
    protected boolean webMMuxingEnabled;
    protected boolean addDateTimeToMp4FileName;
    protected boolean hlsMuxingEnabled;
    protected boolean dashMuxingEnabled;
    protected boolean objectDetectionEnabled;
    protected ConcurrentHashMap<String, Boolean> isHealthCheckStartedMap = new ConcurrentHashMap();
    protected ConcurrentHashMap<String, Integer> errorCountMap = new ConcurrentHashMap();
    protected ConcurrentHashMap<String, Integer> retryCounter = new ConcurrentHashMap();
    protected ConcurrentHashMap<String, String> statusMap = new ConcurrentHashMap();
    protected int rtmpEndpointRetryLimit;
    protected int healthCheckPeriodMS;
    protected boolean webRTCEnabled = false;
    protected StorageClient storageClient;
    protected String hlsTime;
    protected String hlsListSize;
    protected String hlsPlayListType;
    protected String dashSegDuration;
    protected String dashFragmentDuration;
    protected String targetLatency;
    List<EncoderSettings> adaptiveResolutionList = null;
    protected DataStore dataStore;
    private boolean firstKeyFrameReceivedChecked = false;
    private long lastKeyFramePTS = 0L;
    protected String streamId;
    protected long startTime;
    protected IScope scope;
    private String oldQuality;
    public static final AVRational TIME_BASE_FOR_MS;
    private IAntMediaStreamHandler appAdapter;
    protected List<EncoderSettings> encoderSettingsList;
    protected static boolean isStreamSource;
    private int previewCreatePeriod;
    private double latestSpeed;
    private long lastQualityUpdateTime = 0L;
    private Broadcast broadcast;
    protected AppSettings appSettings;
    private int previewHeight;
    private int lastFrameTimestamp;
    private int maxAnalyzeDurationMS = 1000;
    protected boolean generatePreview = true;
    private int firstReceivedFrameTimestamp = -1;
    protected int totalIngestedVideoPacketCount = 0;
    private long bufferTimeMs = 0L;
    protected ServerSettings serverSettings;
    private Deque<PacketTime> packetTimeList = new ConcurrentLinkedDeque<PacketTime>();
    protected Vertx vertx;
    private AtomicBoolean buffering = new AtomicBoolean(false);
    private int bufferLogCounter;
    private volatile long bufferingFinishTimeMs = 0L;
    private boolean avc = true;
    private long bufferedPacketWriterId = -1L;
    private volatile long lastPacketTimeMsInQueue = 0L;
    private volatile long firstPacketReadyToSentTimeMs = 0L;
    protected String dataChannelWebHookURL = null;
    protected long absoluteTotalIngestTime = 0L;
    protected Muxer dashMuxer = null;
    private long checkStreamsStartTime = -1L;
    private byte[] videoDataConf;
    private byte[] audioDataConf;
    private AtomicInteger queueSize = new AtomicInteger(0);
    protected long totalIngestTime;
    private int fps = 0;
    private int width;
    protected int height;
    protected int keyFramePerMin = 0;
    protected long lastKeyFrameStatsTimeMs = -1L;
    private long totalByteReceived = 0L;
    protected AVFormatContext streamSourceInputFormatContext;
    private AVCodecParameters videoCodecParameters;
    protected AVCodecParameters audioCodecParameters;
    private BytePointer audioExtraDataPointer;
    private BytePointer videoExtraDataPointer;
    private AtomicLong endpointStatusUpdaterTimer = new AtomicLong(-1L);
    private ConcurrentHashMap<String, String> endpointStatusUpdateMap = new ConcurrentHashMap();
    protected PacketFeeder packetFeeder;
    private static final int COUNT_TO_LOG_BUFFER = 500;
    private AVRational videoTimeBase = TIME_BASE_FOR_MS;
    private AVRational audioTimeBase = TIME_BASE_FOR_MS;
    protected AVChannelLayout channelLayout;
    private long lastTotalByteReceived = 0L;

    public boolean addID3Data(String data) {
        for (Muxer muxer : this.muxerList) {
            if (!(muxer instanceof HLSMuxer)) continue;
            ((HLSMuxer)muxer).addID3Data(data);
            return true;
        }
        return false;
    }

    public boolean addSEIData(String data) {
        for (Muxer muxer : this.muxerList) {
            if (!(muxer instanceof HLSMuxer)) continue;
            ((HLSMuxer)muxer).setSeiData(data);
            return true;
        }
        return false;
    }

    public static MuxAdaptor initializeMuxAdaptor(ClientBroadcastStream clientBroadcastStream, Broadcast broadcast, boolean isSource, IScope scope) {
        MuxAdaptor muxAdaptor = null;
        ApplicationContext applicationContext = scope.getContext().getApplicationContext();
        boolean tryEncoderAdaptor = false;
        if (applicationContext.containsBean("app.settings")) {
            AppSettings appSettings = (AppSettings)applicationContext.getBean("app.settings");
            tryEncoderAdaptor = MuxAdaptor.isEncoderAdaptorShouldBeTried(broadcast, appSettings);
        }
        if (tryEncoderAdaptor) {
            try {
                Class<?> transraterClass = Class.forName("io.antmedia.enterprise.adaptive.EncoderAdaptor");
                muxAdaptor = (MuxAdaptor)transraterClass.getConstructor(ClientBroadcastStream.class).newInstance(clientBroadcastStream);
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
        }
        if (muxAdaptor == null) {
            muxAdaptor = new MuxAdaptor(clientBroadcastStream);
        }
        muxAdaptor.setStreamSource(isSource);
        muxAdaptor.setBroadcast(broadcast);
        return muxAdaptor;
    }

    public static boolean isEncoderAdaptorShouldBeTried(Broadcast broadcast, AppSettings appSettings) {
        return broadcast != null && broadcast.getEncoderSettingsList() != null && !broadcast.getEncoderSettingsList().isEmpty() || appSettings.getEncoderSettings() != null && !appSettings.getEncoderSettings().isEmpty() || appSettings.isWebRTCEnabled() || appSettings.isForceDecoding();
    }

    protected MuxAdaptor(ClientBroadcastStream clientBroadcastStream) {
        this.broadcastStream = clientBroadcastStream;
    }

    public boolean addMuxer(Muxer muxer) {
        return this.addMuxer(muxer, 0);
    }

    public boolean addMuxer(Muxer muxer, int resolutionHeight) {
        boolean result = false;
        if (this.directMuxingSupported() && (resolutionHeight == 0 || resolutionHeight == this.height)) {
            result = this.isRecording.get() ? this.prepareMuxer(muxer, resolutionHeight) : this.addMuxerInternal(muxer);
        }
        return result;
    }

    public boolean removeMuxer(Muxer muxer) {
        boolean result = false;
        if (this.muxerList.remove(muxer)) {
            muxer.writeTrailer();
            result = true;
        }
        return result;
    }

    protected boolean addMuxerInternal(Muxer muxer) {
        boolean result = false;
        if (!this.muxerList.contains(muxer)) {
            result = this.muxerList.add(muxer);
        }
        return result;
    }

    @Override
    public boolean init(IConnection conn, String name, boolean isAppend) {
        return this.init(conn.getScope(), name, isAppend);
    }

    public void enableSettings() {
        AppSettings appSettingsLocal = this.getAppSettings();
        this.hlsMuxingEnabled = appSettingsLocal.isHlsMuxingEnabled();
        this.dashMuxingEnabled = appSettingsLocal.isDashMuxingEnabled();
        this.mp4MuxingEnabled = appSettingsLocal.isMp4MuxingEnabled();
        this.webMMuxingEnabled = appSettingsLocal.isWebMMuxingEnabled();
        this.objectDetectionEnabled = appSettingsLocal.isObjectDetectionEnabled();
        this.addDateTimeToMp4FileName = appSettingsLocal.isAddDateTimeToMp4FileName();
        this.webRTCEnabled = appSettingsLocal.isWebRTCEnabled();
        this.deleteHLSFilesOnExit = appSettingsLocal.isDeleteHLSFilesOnEnded();
        this.deleteDASHFilesOnExit = appSettingsLocal.isDeleteDASHFilesOnEnded();
        this.hlsListSize = appSettingsLocal.getHlsListSize();
        this.hlsTime = appSettingsLocal.getHlsTime();
        this.hlsPlayListType = appSettingsLocal.getHlsPlayListType();
        Broadcast.HLSParameters broadcastHLSParameters = this.getBroadcast().getHlsParameters();
        if (broadcastHLSParameters != null) {
            if (StringUtils.isNotBlank((CharSequence)broadcastHLSParameters.getHlsListSize())) {
                this.hlsListSize = broadcastHLSParameters.getHlsListSize();
            }
            if (StringUtils.isNotBlank((CharSequence)broadcastHLSParameters.getHlsTime())) {
                this.hlsTime = broadcastHLSParameters.getHlsTime();
            }
            if (StringUtils.isNotBlank((CharSequence)broadcastHLSParameters.getHlsPlayListType())) {
                this.hlsPlayListType = broadcastHLSParameters.getHlsPlayListType();
            }
        }
        this.dashSegDuration = appSettingsLocal.getDashSegDuration();
        this.dashFragmentDuration = appSettingsLocal.getDashFragmentDuration();
        this.targetLatency = appSettingsLocal.getTargetLatency();
        this.previewOverwrite = appSettingsLocal.isPreviewOverwrite();
        this.encoderSettingsList = this.getBroadcast() != null && this.getBroadcast().getEncoderSettingsList() != null && !this.getBroadcast().getEncoderSettingsList().isEmpty() ? this.getBroadcast().getEncoderSettingsList() : appSettingsLocal.getEncoderSettings();
        this.previewCreatePeriod = appSettingsLocal.getCreatePreviewPeriod();
        this.maxAnalyzeDurationMS = appSettingsLocal.getMaxAnalyzeDurationMS();
        this.generatePreview = appSettingsLocal.isGeneratePreview();
        this.previewHeight = appSettingsLocal.getPreviewHeight();
        this.bufferTimeMs = appSettingsLocal.getRtmpIngestBufferTimeMs();
        this.dataChannelWebHookURL = appSettingsLocal.getDataChannelWebHookURL();
        this.rtmpEndpointRetryLimit = appSettingsLocal.getEndpointRepublishLimit();
        this.healthCheckPeriodMS = appSettingsLocal.getEndpointHealthCheckPeriodMs();
    }

    public void initStorageClient() {
        if (this.scope.getContext().getApplicationContext().containsBean("app.storageClient")) {
            this.storageClient = (StorageClient)this.scope.getContext().getApplicationContext().getBean("app.storageClient");
        }
    }

    @Override
    public boolean init(IScope scope, String streamId, boolean isAppend) {
        this.streamId = streamId;
        this.scope = scope;
        this.packetFeeder = new PacketFeeder(streamId);
        this.getDataStore();
        this.getStreamHandler().updateBroadcastStatus(streamId, 0L, "RTMP", this.getDataStore().get(streamId));
        this.enableSettings();
        this.initServerSettings();
        this.initStorageClient();
        this.enableMp4Setting();
        this.enableWebMSetting();
        this.initVertx();
        if (this.mp4MuxingEnabled) {
            this.addMp4Muxer();
            logger.info("adding MP4 Muxer, add datetime to file name {}", (Object)this.addDateTimeToMp4FileName);
        }
        if (this.hlsMuxingEnabled) {
            this.addHLSMuxer();
        }
        this.getDashMuxer();
        if (this.dashMuxer != null) {
            this.addMuxer(this.dashMuxer);
        }
        for (Muxer muxer : this.muxerList) {
            muxer.init(scope, streamId, 0, this.broadcast.getSubFolder(), 0);
        }
        this.getStreamHandler().muxAdaptorAdded(this);
        return true;
    }

    public HLSMuxer addHLSMuxer() {
        HLSMuxer hlsMuxer = new HLSMuxer(this.vertx, this.storageClient, this.getAppSettings().getS3StreamsFolderPath(), this.getAppSettings().getUploadExtensionsToS3(), this.getAppSettings().getHlsHttpEndpoint(), this.getAppSettings().isAddDateTimeToHlsFileName());
        hlsMuxer.setHlsParameters(this.hlsListSize, this.hlsTime, this.hlsPlayListType, this.getAppSettings().getHlsflags(), this.getAppSettings().getHlsEncryptionKeyInfoFile(), this.getAppSettings().getHlsSegmentType());
        hlsMuxer.setDeleteFileOnExit(this.deleteHLSFilesOnExit);
        hlsMuxer.setId3Enabled(this.appSettings.isId3TagEnabled());
        this.addMuxer(hlsMuxer);
        logger.info("adding HLS Muxer for {}", (Object)this.streamId);
        return hlsMuxer;
    }

    public Muxer getDashMuxer() {
        if (this.dashMuxingEnabled && this.dashMuxer == null) {
            try {
                Class<?> dashMuxerClass = Class.forName("io.antmedia.enterprise.muxer.DASHMuxer");
                logger.info("adding DASH Muxer for {}", (Object)this.streamId);
                this.dashMuxer = (Muxer)dashMuxerClass.getConstructors()[0].newInstance(this.vertx, this.dashFragmentDuration, this.dashSegDuration, this.targetLatency, this.deleteDASHFilesOnExit, !this.appSettings.getEncoderSettings().isEmpty(), this.appSettings.getDashWindowSize(), this.appSettings.getDashExtraWindowSize(), this.appSettings.islLDashEnabled(), this.appSettings.islLHLSEnabled(), this.appSettings.isHlsEnabledViaDash(), this.appSettings.isUseTimelineDashMuxing(), this.appSettings.isDashHttpStreaming(), this.appSettings.getDashHttpEndpoint(), this.serverSettings.getDefaultHttpPort());
            }
            catch (ClassNotFoundException e) {
                logger.info("DashMuxer class not found for stream:{}", (Object)this.streamId);
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return this.dashMuxer;
    }

    private void initVertx() {
        if (this.scope.getContext().getApplicationContext().containsBean("vertxCore")) {
            this.vertx = (Vertx)this.scope.getContext().getApplicationContext().getBean("vertxCore");
            logger.info("vertx exist {}", (Object)this.vertx);
        } else {
            logger.info("No vertx bean for stream {}", (Object)this.streamId);
        }
    }

    protected void initServerSettings() {
        if (this.scope.getContext().getApplicationContext().containsBean("ant.media.server.settings")) {
            this.serverSettings = (ServerSettings)this.scope.getContext().getApplicationContext().getBean("ant.media.server.settings");
            logger.info("serverSettings exist {}", (Object)this.serverSettings);
        } else {
            logger.info("No serverSettings bean for stream {}", (Object)this.streamId);
        }
    }

    protected void enableMp4Setting() {
        this.broadcast = this.getBroadcast();
        if (this.broadcast.getMp4Enabled() == -1) {
            this.mp4MuxingEnabled = false;
        } else if (this.broadcast.getMp4Enabled() == 1) {
            this.mp4MuxingEnabled = true;
        }
    }

    protected void enableWebMSetting() {
        this.broadcast = this.getBroadcast();
        if (this.broadcast.getWebMEnabled() == -1) {
            this.webMMuxingEnabled = false;
        } else if (this.broadcast.getWebMEnabled() == 1) {
            this.webMMuxingEnabled = true;
        }
    }

    public static void setUpEndPoints(MuxAdaptor muxAdaptor, Broadcast broadcast, Vertx vertx) {
        List<Endpoint> endPointList;
        if (broadcast != null && (endPointList = broadcast.getEndPointList()) != null && !endPointList.isEmpty()) {
            for (Endpoint endpoint : endPointList) {
                RtmpMuxer rtmpMuxer = new RtmpMuxer(endpoint.getRtmpUrl(), vertx);
                rtmpMuxer.setStatusListener(muxAdaptor);
                muxAdaptor.addMuxer(rtmpMuxer);
            }
        }
    }

    public AVCodecParameters getAudioCodecParameters() {
        if (this.audioDataConf != null && this.audioCodecParameters == null) {
            AACConfigParser aacParser = new AACConfigParser(this.audioDataConf, 0);
            if (!aacParser.isErrorOccured()) {
                this.audioCodecParameters = new AVCodecParameters();
                this.audioCodecParameters.sample_rate(aacParser.getSampleRate());
                this.channelLayout = new AVChannelLayout();
                avutil.av_channel_layout_default((AVChannelLayout)this.channelLayout, (int)aacParser.getChannelCount());
                this.audioCodecParameters.ch_layout(this.channelLayout);
                this.audioCodecParameters.codec_id(86018);
                this.audioCodecParameters.codec_type(1);
                if (aacParser.getObjectType() == AACConfigParser.AudioObjectTypes.AAC_LC) {
                    this.audioCodecParameters.profile(1);
                } else if (aacParser.getObjectType() == AACConfigParser.AudioObjectTypes.AAC_LTP) {
                    this.audioCodecParameters.profile(3);
                } else if (aacParser.getObjectType() == AACConfigParser.AudioObjectTypes.AAC_MAIN) {
                    this.audioCodecParameters.profile(0);
                } else if (aacParser.getObjectType() == AACConfigParser.AudioObjectTypes.AAC_SSR) {
                    this.audioCodecParameters.profile(2);
                }
                this.audioCodecParameters.frame_size(aacParser.getFrameSize());
                this.audioCodecParameters.format(8);
                this.audioExtraDataPointer = new BytePointer(avutil.av_malloc((long)this.audioDataConf.length)).capacity((long)this.audioDataConf.length);
                this.audioExtraDataPointer.position(0L).put(this.audioDataConf);
                this.audioCodecParameters.extradata(this.audioExtraDataPointer);
                this.audioCodecParameters.extradata_size(this.audioDataConf.length);
                this.audioCodecParameters.codec_tag(0);
            } else {
                logger.warn("Cannot parse AAC header succesfully for stream:{}", (Object)this.streamId);
            }
        }
        return this.audioCodecParameters;
    }

    public AVCodecParameters getVideoCodecParameters() {
        if (this.videoDataConf != null && this.videoCodecParameters == null) {
            SpsParser spsParser = new SpsParser(MuxAdaptor.getAnnexbExtradata(this.videoDataConf), 5);
            this.videoCodecParameters = new AVCodecParameters();
            this.width = spsParser.getWidth();
            this.height = spsParser.getHeight();
            this.videoCodecParameters.width(spsParser.getWidth());
            this.videoCodecParameters.height(spsParser.getHeight());
            this.videoCodecParameters.codec_id(27);
            this.videoCodecParameters.codec_type(0);
            this.videoExtraDataPointer = new BytePointer(avutil.av_malloc((long)this.videoDataConf.length)).capacity((long)this.videoDataConf.length);
            this.videoExtraDataPointer.position(0L).put(this.videoDataConf);
            this.videoCodecParameters.extradata_size(this.videoDataConf.length);
            this.videoCodecParameters.extradata(this.videoExtraDataPointer);
            this.videoCodecParameters.format(0);
            this.videoCodecParameters.codec_tag(0);
        }
        return this.videoCodecParameters;
    }

    public boolean prepare() throws Exception {
        AVCodecParameters parameters;
        int streamIndex = 0;
        AVCodecParameters codecParameters = this.getVideoCodecParameters();
        if (codecParameters != null) {
            logger.info("Incoming video width: {} height:{} stream:{}", new Object[]{codecParameters.width(), codecParameters.height(), this.streamId});
            this.addStream2Muxers(codecParameters, TIME_BASE_FOR_MS, streamIndex);
            this.videoStreamIndex = streamIndex++;
        }
        if ((parameters = this.getAudioCodecParameters()) != null) {
            this.addStream2Muxers(parameters, TIME_BASE_FOR_MS, streamIndex);
            this.audioStreamIndex = streamIndex;
        } else {
            logger.info("There is no audio in the stream or not received AAC Sequence header for stream:{} muting the audio", (Object)this.streamId);
            this.enableAudio = false;
        }
        this.prepareMuxerIO();
        this.registerToMainTrackIfExists();
        return true;
    }

    public void registerToMainTrackIfExists() {
        String mainTrack;
        if (this.broadcastStream.getParameters() != null && (mainTrack = this.broadcastStream.getParameters().get("mainTrack")) != null) {
            Broadcast broadcastLocal = this.getBroadcast();
            broadcastLocal.setMainTrackStreamId(mainTrack);
            this.getDataStore().updateBroadcastFields(this.streamId, broadcastLocal);
            Broadcast mainBroadcast = this.getDataStore().get(mainTrack);
            if (mainBroadcast == null) {
                mainBroadcast = new Broadcast();
                try {
                    mainBroadcast.setStreamId(mainTrack);
                }
                catch (Exception e) {
                    logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                }
                mainBroadcast.setZombi(true);
                mainBroadcast.setStatus("broadcasting");
                mainBroadcast.getSubTrackStreamIds().add(this.streamId);
                this.getDataStore().save(mainBroadcast);
            } else {
                mainBroadcast.getSubTrackStreamIds().add(this.streamId);
                this.getDataStore().updateBroadcastFields(mainTrack, mainBroadcast);
            }
        }
    }

    public boolean prepareFromInputFormatContext(AVFormatContext inputFormatContext) throws Exception {
        this.streamSourceInputFormatContext = inputFormatContext;
        int streamIndex = 0;
        int streamCount = inputFormatContext.nb_streams();
        for (int i = 0; i < streamCount; ++i) {
            AVStream stream = inputFormatContext.streams(i);
            AVCodecParameters codecpar = stream.codecpar();
            if (codecpar.codec_type() == 0 && !this.isBlacklistCodec(codecpar.codec_id())) {
                this.videoTimeBase = inputFormatContext.streams(i).time_base();
                logger.info("Video format codec Id: {} width:{} height:{} for stream: {} source index:{} target index:{}", new Object[]{codecpar.codec_id(), codecpar.width(), codecpar.height(), this.streamId, i, streamIndex});
                this.width = codecpar.width();
                this.height = codecpar.height();
                this.addStream2Muxers(codecpar, stream.time_base(), i);
                this.videoStreamIndex = streamIndex++;
                this.videoCodecParameters = codecpar;
                continue;
            }
            if (codecpar.codec_type() != 1) continue;
            logger.info("Audio format sample rate:{} bitrate:{} for stream: {} source index:{} target index:{}", new Object[]{codecpar.sample_rate(), codecpar.bit_rate(), this.streamId, i, streamIndex});
            this.audioTimeBase = inputFormatContext.streams(i).time_base();
            this.addStream2Muxers(codecpar, stream.time_base(), i);
            this.audioStreamIndex = streamIndex++;
            this.audioCodecParameters = codecpar;
        }
        if (this.enableVideo && (this.width == 0 || this.height == 0)) {
            logger.info("Width or height is zero so returning for stream: {}", (Object)this.streamId);
            return false;
        }
        this.isRecording.set(true);
        this.prepareMuxerIO();
        return true;
    }

    public static byte[] getAnnexbExtradata(byte[] avcExtradata) {
        IoBuffer buffer = IoBuffer.wrap((byte[])avcExtradata);
        buffer.skip(6);
        short spsSize = buffer.getShort();
        byte[] sps = new byte[spsSize];
        buffer.get(sps);
        buffer.skip(1);
        short ppsSize = buffer.getShort();
        byte[] pps = new byte[ppsSize];
        buffer.get(pps);
        byte[] extradataAnnexb = new byte[8 + spsSize + ppsSize];
        extradataAnnexb[0] = 0;
        extradataAnnexb[1] = 0;
        extradataAnnexb[2] = 0;
        extradataAnnexb[3] = 1;
        System.arraycopy(sps, 0, extradataAnnexb, 4, spsSize);
        extradataAnnexb[4 + spsSize] = 0;
        extradataAnnexb[5 + spsSize] = 0;
        extradataAnnexb[6 + spsSize] = 0;
        extradataAnnexb[7 + spsSize] = 1;
        System.arraycopy(pps, 0, extradataAnnexb, 8 + spsSize, ppsSize);
        return extradataAnnexb;
    }

    public static String getStreamType(int codecType) {
        String streamType = "not_known";
        if (codecType == 0) {
            streamType = "video";
        } else if (codecType == 1) {
            streamType = "audio";
        } else if (codecType == 2) {
            streamType = "data";
        } else if (codecType == 3) {
            streamType = "subtitle";
        } else if (codecType == 4) {
            streamType = "attachment";
        }
        return streamType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStream2Muxers(AVCodecParameters codecParameters, AVRational rat, int streamIndex) {
        List<Muxer> list = this.muxerList;
        synchronized (list) {
            for (Muxer muxer : this.muxerList) {
                if (muxer.addStream(codecParameters, rat, streamIndex)) continue;
                logger.warn("addStream returns false {} for stream: {} for {} stream", new Object[]{muxer.getFormat(), this.streamId, MuxAdaptor.getStreamType(codecParameters.codec_type())});
            }
        }
        this.startTime = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareMuxerIO() {
        List<Muxer> list = this.muxerList;
        synchronized (list) {
            Iterator<Muxer> iterator = this.muxerList.iterator();
            while (iterator.hasNext()) {
                Muxer muxer = iterator.next();
                if (muxer.prepareIO()) continue;
                iterator.remove();
                logger.error("prepareIO returns false {} for stream: {}", (Object)muxer.getFormat(), (Object)this.streamId);
            }
        }
        this.startTime = System.currentTimeMillis();
    }

    public void updateStreamQualityParameters(String streamId, String quality, double speed, int inputQueueSize) {
        long now = System.currentTimeMillis();
        this.latestSpeed = speed;
        if (now - this.lastQualityUpdateTime > 10000L || this.lastQualityUpdateTime == 0L && speed > 0.8) {
            logger.info("Stream queue size:{} speed:{} for streamId:{} ", new Object[]{inputQueueSize, speed, streamId});
            this.lastQualityUpdateTime = now;
            long byteTransferred = this.totalByteReceived - this.lastTotalByteReceived;
            this.lastTotalByteReceived = this.totalByteReceived;
            PublishStatsEvent publishStatsEvent = new PublishStatsEvent();
            publishStatsEvent.setApp(this.scope.getName());
            publishStatsEvent.setStreamId(streamId);
            publishStatsEvent.setTotalByteReceived(this.totalByteReceived);
            publishStatsEvent.setByteTransferred(byteTransferred);
            publishStatsEvent.setDurationMs(System.currentTimeMillis() - this.broadcast.getStartTime());
            publishStatsEvent.setWidth(this.width);
            publishStatsEvent.setHeight(this.height);
            this.getStreamHandler().setQualityParameters(streamId, quality, speed, inputQueueSize, System.currentTimeMillis());
            this.oldQuality = quality;
        }
    }

    public double getLatestSpeed() {
        return this.latestSpeed;
    }

    public IAntMediaStreamHandler getStreamHandler() {
        if (this.appAdapter == null) {
            IContext context = this.scope.getContext();
            ApplicationContext appCtx = context.getApplicationContext();
            this.appAdapter = (IAntMediaStreamHandler)appCtx.getBean("web.handler");
        }
        return this.appAdapter;
    }

    public AppSettings getAppSettings() {
        if (this.appSettings == null && this.scope.getContext().getApplicationContext().containsBean("app.settings")) {
            this.appSettings = (AppSettings)this.scope.getContext().getApplicationContext().getBean("app.settings");
        }
        return this.appSettings;
    }

    public DataStore getDataStore() {
        if (this.dataStore == null) {
            IDataStoreFactory dsf = (IDataStoreFactory)this.scope.getContext().getBean("dataStoreFactory");
            this.dataStore = dsf.getDataStore();
        }
        return this.dataStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeStreamPacket(IStreamPacket packet) {
        long dts = (long)packet.getTimestamp() & 0xFFFFFFFFL;
        if (packet.getDataType() == 9) {
            if (!this.enableVideo) {
                logger.warn("Video data was disabled beginning of the stream, so discarding video packets.");
                return;
            }
            logger.trace("writeVideoBuffer video data packet timestamp:{} and packet timestamp:{} streamId:{}", new Object[]{dts, packet.getTimestamp(), this.streamId});
            this.measureIngestTime(dts, ((CachedEvent)packet).getReceivedTime());
            if (!this.firstVideoPacketSkipped) {
                this.firstVideoPacketSkipped = true;
                return;
            }
            int bodySize = packet.getData().limit();
            byte frameType = packet.getData().position(0).get();
            int compositionTimeOffset = packet.getData().position(2).get() << 16 | packet.getData().position(3).getShort();
            long pts = dts + (long)compositionTimeOffset;
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(bodySize - 5);
            byteBuffer.put(packet.getData().buf().position(5));
            List<Muxer> list = this.muxerList;
            synchronized (list) {
                this.packetFeeder.writeVideoBuffer(byteBuffer, dts, 0, this.videoStreamIndex, (frameType & 0xF0) == 16, 0L, pts);
                for (Muxer muxer : this.muxerList) {
                    muxer.writeVideoBuffer(byteBuffer, dts, 0, this.videoStreamIndex, (frameType & 0xF0) == 16, 0L, pts);
                }
            }
        }
        if (packet.getDataType() == 8) {
            if (!this.enableAudio) {
                logger.debug("Audio data was disabled beginning of the stream, so discarding audio packets.");
                return;
            }
            if (!this.firstAudioPacketSkipped) {
                this.firstAudioPacketSkipped = true;
                return;
            }
            int bodySize = packet.getData().limit();
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(bodySize - 2);
            byteBuffer.put(packet.getData().buf().position(2));
            logger.trace("writeAudioBuffer video data packet timestamp:{} and packet timestamp:{} streamId:{}", new Object[]{dts, packet.getTimestamp(), this.streamId});
            List<Muxer> list = this.muxerList;
            synchronized (list) {
                this.packetFeeder.writeAudioBuffer(byteBuffer, this.audioStreamIndex, dts);
                for (Muxer muxer : this.muxerList) {
                    muxer.writeAudioBuffer(byteBuffer, this.audioStreamIndex, dts);
                }
            }
        }
    }

    public void checkMaxAnalyzeTotalTime() {
        long totalTime = System.currentTimeMillis() - this.checkStreamsStartTime;
        int elapsedFrameTimeStamp = this.lastFrameTimestamp - this.firstReceivedFrameTimestamp;
        if (totalTime >= (long)(2 * this.maxAnalyzeDurationMS)) {
            logger.error("Total max time({}) is spent to determine video and audio existence for stream:{}. It's skipped waiting", (Object)(2 * this.maxAnalyzeDurationMS), (Object)this.streamId);
            logger.info("Streams for {} enableVideo:{} enableAudio:{} total spend time: {} elapsed frame timestamp:{} stop request exists: {}", new Object[]{this.streamId, this.enableVideo, this.enableAudio, totalTime, elapsedFrameTimeStamp, this.stopRequestExist});
            if (this.enableAudio || this.enableVideo) {
                this.prepareParameters();
            } else {
                logger.error("There is no video and audio in the incoming stream: {} closing rtmp connection", (Object)this.streamId);
                this.closeRtmpConnection();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        if (this.isPipeReaderJobRunning.compareAndSet(false, true)) {
            try {
                IStreamPacket packet;
                if (!this.isRecording.get()) {
                    if (this.checkStreamsStartTime == -1L) {
                        this.checkStreamsStartTime = System.currentTimeMillis();
                    }
                    if (this.stopRequestExist) {
                        logger.info("Stop request exists for stream:{}", (Object)this.streamId);
                        this.broadcastStream.removeStreamListener(this);
                        logger.warn("closing adaptor for {} ", (Object)this.streamId);
                        this.closeResources();
                        logger.warn("closed adaptor for {}", (Object)this.streamId);
                        this.getStreamHandler().stopPublish(this.streamId);
                        return;
                    }
                    IStreamCodecInfo codecInfo = this.broadcastStream.getCodecInfo();
                    this.enableVideo = codecInfo.hasVideo();
                    this.enableAudio = codecInfo.hasAudio();
                    this.getVideoDataConf(codecInfo);
                    this.getAudioDataConf(codecInfo);
                    if (this.enableVideo && this.enableAudio && this.getAudioCodecParameters() != null) {
                        logger.info("Video and audio is enabled in stream:{} queue size: {}", (Object)this.streamId, (Object)this.queueSize.get());
                        this.prepareParameters();
                    } else {
                        this.checkMaxAnalyzeTotalTime();
                    }
                }
                if (!this.isRecording.get()) {
                    return;
                }
                Boolean isKeyFrame = false;
                while ((packet = this.streamPacketQueue.poll()) != null) {
                    this.queueSize.decrementAndGet();
                    if (packet.getDataType() == 9) {
                        byte frameType = packet.getData().position(0).get();
                        isKeyFrame = (frameType & 0xF0) == 16;
                        if (!this.firstKeyFrameReceivedChecked) {
                            if (isKeyFrame.booleanValue()) {
                                this.firstKeyFrameReceivedChecked = true;
                                if (!this.appAdapter.isValidStreamParameters(this.width, this.height, this.fps, 0, this.streamId)) {
                                    logger.info("Stream({}) has not passed specified validity checks so it's stopping", (Object)this.streamId);
                                    this.closeRtmpConnection();
                                    break;
                                }
                            } else {
                                logger.warn("First video packet is not key frame. It will drop for direct muxing. Stream {}", (Object)this.streamId);
                                return;
                            }
                        }
                    }
                    long dts = (long)packet.getTimestamp() & 0xFFFFFFFFL;
                    this.updateQualityParameters(dts, TIME_BASE_FOR_MS, 0L, isKeyFrame);
                    if (this.bufferTimeMs == 0L) {
                        this.writeStreamPacket(packet);
                        continue;
                    }
                    if (this.bufferTimeMs <= 0L) continue;
                    this.addBufferQueue(packet);
                }
                if (this.stopRequestExist) {
                    this.broadcastStream.removeStreamListener(this);
                    logger.warn("closing adaptor for {} ", (Object)this.streamId);
                    this.closeResources();
                    logger.warn("closed adaptor for {}", (Object)this.streamId);
                    this.getStreamHandler().stopPublish(this.streamId);
                }
            }
            finally {
                this.isPipeReaderJobRunning.compareAndSet(true, false);
            }
        }
    }

    public void addBufferQueue(IStreamPacket packet) {
        this.bufferQueue.add(packet);
        try {
            IStreamPacket pktHead = this.bufferQueue.first();
            IStreamPacket pktTrailer = this.bufferQueue.last();
            int bufferedDuration = pktTrailer.getTimestamp() - pktHead.getTimestamp();
            if ((long)bufferedDuration > this.bufferTimeMs * 5L) {
                this.buffering.set(true);
                Iterator<IStreamPacket> iterator = this.bufferQueue.iterator();
                while (iterator.hasNext()) {
                    pktHead = iterator.next();
                    bufferedDuration = pktTrailer.getTimestamp() - pktHead.getTimestamp();
                    if ((long)bufferedDuration < this.bufferTimeMs * 2L) break;
                    iterator.remove();
                }
            }
            bufferedDuration = pktTrailer.getTimestamp() - pktHead.getTimestamp();
            logger.trace("bufferedDuration:{} trailer timestamp:{} head timestamp:{}", new Object[]{bufferedDuration, pktTrailer.getTimestamp(), pktHead.getTimestamp()});
            if ((long)bufferedDuration > this.bufferTimeMs) {
                if (this.buffering.get()) {
                    this.bufferingFinishTimeMs = System.currentTimeMillis();
                    this.firstPacketReadyToSentTimeMs = pktTrailer.getTimestamp();
                    logger.info("Switching buffering from true to false for stream: {}", (Object)this.streamId);
                }
                this.buffering.set(false);
            }
            ++this.bufferLogCounter;
            if (this.bufferLogCounter % 500 == 0) {
                logger.info("ReadPacket -> Buffering status {}, buffer duration {}ms buffer time {}ms stream: {}", new Object[]{this.buffering, bufferedDuration, this.bufferTimeMs, this.streamId});
                this.bufferLogCounter = 0;
            }
        }
        catch (NoSuchElementException e) {
            logger.warn("You may or may not ignore this exception. I mean It can happen time to time in multithread environment -> {}", (Object)e.getMessage());
        }
    }

    private void getVideoDataConf(IStreamCodecInfo codecInfo) {
        if (this.enableVideo) {
            IVideoStreamCodec videoCodec = codecInfo.getVideoCodec();
            if (videoCodec instanceof AVCVideo) {
                IoBuffer videoBuffer = videoCodec.getDecoderConfiguration();
                if (videoBuffer != null) {
                    this.videoDataConf = new byte[videoBuffer.limit() - 5];
                    videoBuffer.position(5).get(this.videoDataConf);
                }
            } else {
                logger.warn("Video codec is not AVC(H264) for stream: {}", (Object)this.streamId);
            }
        }
    }

    private void getAudioDataConf(IStreamCodecInfo codecInfo) {
        if (this.enableAudio) {
            IAudioStreamCodec audioCodec = codecInfo.getAudioCodec();
            if (audioCodec instanceof AACAudio) {
                IoBuffer audioBuffer = ((AACAudio)audioCodec).getDecoderConfiguration();
                if (audioBuffer != null) {
                    this.audioDataConf = new byte[audioBuffer.limit() - 2];
                    audioBuffer.position(2).get(this.audioDataConf);
                }
            } else {
                logger.warn("Audio codec is not AAC for stream: {}", (Object)this.streamId);
            }
        }
    }

    private void prepareParameters() {
        try {
            this.prepare();
            this.isRecording.set(true);
            this.getStreamHandler().startPublish(this.streamId, this.broadcastStream.getAbsoluteStartTimeMs(), "RTMP");
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            this.closeRtmpConnection();
        }
    }

    private void measureIngestTime(long pktTimeStamp, long receivedTime) {
        ++this.totalIngestedVideoPacketCount;
        long currentTime = System.currentTimeMillis();
        long packetIngestTime = currentTime - receivedTime;
        this.totalIngestTime += packetIngestTime;
        long absolutePacketIngestTime = currentTime - this.broadcastStream.getAbsoluteStartTimeMs() - pktTimeStamp;
        this.absoluteTotalIngestTime += absolutePacketIngestTime;
    }

    public long getAbsoluteTimeMs() {
        if (this.broadcastStream != null) {
            return this.broadcastStream.getAbsoluteStartTimeMs();
        }
        return 0L;
    }

    public void updateQualityParameters(long pts, AVRational timebase, long packetSize, boolean isKeyFrame) {
        long packetTime = avutil.av_rescale_q((long)pts, (AVRational)timebase, (AVRational)TIME_BASE_FOR_MS);
        this.packetTimeList.add(new PacketTime(packetTime, System.currentTimeMillis()));
        if (this.packetTimeList.size() > 300) {
            this.packetTimeList.removeFirst();
        }
        PacketTime firstPacket = this.packetTimeList.getFirst();
        PacketTime lastPacket = this.packetTimeList.getLast();
        long elapsedTime = lastPacket.systemTimeMs - firstPacket.systemTimeMs;
        long packetTimeDiff = lastPacket.packetTimeMs - firstPacket.packetTimeMs;
        if (this.lastKeyFrameStatsTimeMs == -1L) {
            this.lastKeyFrameStatsTimeMs = firstPacket.systemTimeMs;
        }
        double speed = 0.0;
        if (elapsedTime > 0L) {
            speed = (double)packetTimeDiff / (double)elapsedTime;
            if (logger.isWarnEnabled() && Double.isNaN(speed)) {
                logger.warn("speed is NaN, packetTime: {}, first item packetTime: {}, elapsedTime:{}", new Object[]{packetTime, firstPacket.packetTimeMs, elapsedTime});
            }
        }
        if (isKeyFrame) {
            long timeDiff = 0L;
            if (this.lastKeyFramePTS != 0L) {
                long keyFrameDiff = pts - this.lastKeyFramePTS;
                timeDiff = avutil.av_rescale_q((long)keyFrameDiff, (AVRational)this.getVideoTimeBase(), (AVRational)TIME_BASE_FOR_MS);
                logger.debug("KeyFrame time difference ms:{} for streamId:{}", (Object)timeDiff, (Object)this.streamId);
            }
            this.lastKeyFramePTS = pts;
            if (timeDiff > 30L) {
                ++this.keyFramePerMin;
            }
            if (lastPacket.systemTimeMs - this.lastKeyFrameStatsTimeMs > 60000L) {
                KeyFrameStatsEvent keyFrameStatsEvent = new KeyFrameStatsEvent();
                keyFrameStatsEvent.setStreamId(this.streamId);
                keyFrameStatsEvent.setApp(this.scope.getName());
                keyFrameStatsEvent.setKeyFramesInLastMinute(this.keyFramePerMin);
                keyFrameStatsEvent.setKeyFrameIntervalMs((int)timeDiff);
                LoggerUtils.logAnalyticsFromServer(keyFrameStatsEvent);
                this.keyFramePerMin = 0;
                this.lastKeyFrameStatsTimeMs = lastPacket.systemTimeMs;
            }
        }
        this.totalByteReceived = this.broadcastStream != null ? this.broadcastStream.getBytesReceived() : this.totalByteReceived + packetSize;
        this.updateStreamQualityParameters(this.streamId, null, speed, this.getInputQueueSize());
    }

    public void closeRtmpConnection() {
        ClientBroadcastStream clientBroadcastStream = this.getBroadcastStream();
        if (clientBroadcastStream != null) {
            clientBroadcastStream.stop();
            IStreamCapableConnection connection = clientBroadcastStream.getConnection();
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writePacket(AVStream stream, AVPacket pkt) {
        int keyFrame = 0;
        if (stream.codecpar().codec_type() == 0) {
            keyFrame = pkt.flags() & 1;
            if (!this.firstKeyFrameReceivedChecked) {
                if (keyFrame == 1) {
                    this.firstKeyFrameReceivedChecked = true;
                    if (!this.appAdapter.isValidStreamParameters(this.width, this.height, this.fps, 0, this.streamId)) {
                        logger.info("Stream({}) has not passed specified validity checks so it's stopping", (Object)this.streamId);
                        this.closeRtmpConnection();
                        return;
                    }
                } else {
                    logger.warn("First video packet is not key frame. It will drop for direct muxing. Stream {}", (Object)this.streamId);
                    return;
                }
            }
        }
        this.updateQualityParameters(pkt.pts(), stream.time_base(), pkt.size(), keyFrame == 1);
        List<Muxer> list = this.muxerList;
        synchronized (list) {
            this.packetFeeder.writePacket(pkt, stream.codecpar().codec_type());
            for (Muxer muxer : this.muxerList) {
                if (muxer instanceof WebMMuxer) continue;
                muxer.writePacket(pkt, stream);
            }
        }
    }

    public synchronized void writeTrailer() {
        this.packetFeeder.writeTrailer();
        for (Muxer muxer : this.muxerList) {
            muxer.writeTrailer();
        }
        long byteTransferred = this.totalByteReceived - this.lastTotalByteReceived;
        this.lastTotalByteReceived = this.totalByteReceived;
        PublishStatsEvent publishStatsEvent = new PublishStatsEvent();
        publishStatsEvent.setApp(this.scope.getName());
        publishStatsEvent.setStreamId(this.streamId);
        publishStatsEvent.setTotalByteReceived(this.totalByteReceived);
        publishStatsEvent.setByteTransferred(byteTransferred);
        publishStatsEvent.setDurationMs(System.currentTimeMillis() - this.broadcast.getStartTime());
        LoggerUtils.logAnalyticsFromServer(publishStatsEvent);
    }

    public synchronized void closeResources() {
        logger.info("close resources for streamId -> {}", (Object)this.streamId);
        if (this.packetPollerId != -1L) {
            this.vertx.cancelTimer(this.packetPollerId);
            logger.info("Cancelling packet poller task(id:{}) for streamId: {}", (Object)this.packetPollerId, (Object)this.streamId);
            this.packetPollerId = -1L;
        }
        if (this.bufferedPacketWriterId != -1L) {
            logger.info("Removing buffered packet writer id {} for stream: {}", (Object)this.bufferedPacketWriterId, (Object)this.streamId);
            this.vertx.cancelTimer(this.bufferedPacketWriterId);
            this.bufferedPacketWriterId = -1L;
            this.writeAllBufferedPackets();
        }
        this.writeTrailer();
        if (this.videoExtraDataPointer != null) {
            avutil.av_free((Pointer)this.videoExtraDataPointer.position(0L));
            this.videoExtraDataPointer.close();
            this.videoExtraDataPointer = null;
        }
        if (this.audioExtraDataPointer != null) {
            avutil.av_free((Pointer)this.audioExtraDataPointer.position(0L));
            this.audioExtraDataPointer.close();
            this.audioExtraDataPointer = null;
        }
        this.updateStreamQualityParameters(this.streamId, null, 0.0, this.getInputQueueSize());
        this.getStreamHandler().muxAdaptorRemoved(this);
        this.isRecording.set(false);
    }

    public boolean directMuxingSupported() {
        return true;
    }

    @Override
    public void start() {
        logger.info("Number of items in the queue while adaptor is being started to prepare is {}", (Object)this.getInputQueueSize());
        this.vertx.executeBlocking(() -> {
            logger.info("before prepare for {}", (Object)this.streamId);
            Boolean successful = false;
            try {
                this.packetPollerId = this.vertx.setPeriodic(10L, t -> this.vertx.executeBlocking(() -> {
                    try {
                        this.execute();
                    }
                    catch (Exception e) {
                        logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                    }
                    return null;
                }, false));
                if (this.bufferTimeMs > 0L) {
                    logger.info("Scheduling the buffered packet writer for stream: {} buffer duration:{}ms", (Object)this.streamId, (Object)this.bufferTimeMs);
                    this.bufferedPacketWriterId = this.vertx.setPeriodic(10L, k -> this.vertx.executeBlocking(() -> {
                        try {
                            this.writeBufferedPacket();
                        }
                        catch (Exception e) {
                            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                        }
                        return null;
                    }, false));
                }
                logger.info("Number of items in the queue while starting: {} for stream: {}", (Object)this.getInputQueueSize(), (Object)this.streamId);
                successful = true;
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
            return successful;
        }, false);
    }

    @Override
    public void stop(boolean shutdownCompletely) {
        logger.info("Calling stop for {} input queue size:{}", (Object)this.streamId, (Object)this.getInputQueueSize());
        this.stopRequestExist = true;
    }

    public int getInputQueueSize() {
        return this.queueSize.get();
    }

    public boolean isStopRequestExist() {
        return this.stopRequestExist;
    }

    public void debugSetStopRequestExist(boolean stopRequest) {
        this.stopRequestExist = stopRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeBufferedPacket() {
        MuxAdaptor muxAdaptor = this;
        synchronized (muxAdaptor) {
            if (this.isBufferedWriterRunning.compareAndSet(false, true)) {
                try {
                    if (!this.buffering.get()) {
                        while (!this.bufferQueue.isEmpty()) {
                            IStreamPacket tempPacket = this.bufferQueue.first();
                            long now = System.currentTimeMillis();
                            long passedTime = now - this.bufferingFinishTimeMs;
                            long pktTimeDifferenceMs = (long)tempPacket.getTimestamp() - this.firstPacketReadyToSentTimeMs;
                            if (pktTimeDifferenceMs >= passedTime) break;
                            this.writeStreamPacket(tempPacket);
                            this.bufferQueue.remove(tempPacket);
                        }
                        this.buffering.set(this.bufferQueue.isEmpty());
                    }
                    ++this.bufferLogCounter;
                    if (this.bufferLogCounter % 500 == 0) {
                        IStreamPacket streamPacket = !this.bufferQueue.isEmpty() ? this.bufferQueue.first() : null;
                        int bufferedDuration = 0;
                        if (streamPacket != null) {
                            bufferedDuration = this.bufferQueue.last().getTimestamp() - streamPacket.getTimestamp();
                        }
                        logger.info("WriteBufferedPacket -> Buffering status {}, buffer duration {}ms buffer time {}ms stream: {}", new Object[]{this.buffering, bufferedDuration, this.bufferTimeMs, this.streamId});
                        this.bufferLogCounter = 0;
                    }
                }
                finally {
                    this.isBufferedWriterRunning.compareAndSet(true, false);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeAllBufferedPackets() {
        MuxAdaptor muxAdaptor = this;
        synchronized (muxAdaptor) {
            logger.info("write all buffered packets for stream: {} ", (Object)this.streamId);
            while (!this.bufferQueue.isEmpty()) {
                IStreamPacket tempPacket = this.bufferQueue.first();
                this.writeStreamPacket(tempPacket);
                this.bufferQueue.remove(tempPacket);
            }
        }
    }

    @Override
    public void packetReceived(IBroadcastStream stream, IStreamPacket packet) {
        this.lastFrameTimestamp = packet.getTimestamp();
        if (this.firstReceivedFrameTimestamp == -1) {
            logger.info("first received frame timestamp: {} for stream:{} ", (Object)this.lastFrameTimestamp, (Object)this.streamId);
            this.firstReceivedFrameTimestamp = this.lastFrameTimestamp;
        }
        if (this.stopRequestExist) {
            logger.warn("Stop request exist and dropping incoming packet for stream:{}", (Object)this.streamId);
            this.closeRtmpConnection();
            return;
        }
        this.queueSize.incrementAndGet();
        CachedEvent event = new CachedEvent();
        event.setData(packet.getData().duplicate());
        event.setDataType(packet.getDataType());
        event.setReceivedTime(System.currentTimeMillis());
        event.setTimestamp(packet.getTimestamp());
        this.streamPacketQueue.add(event);
    }

    @Override
    public boolean isRecording() {
        return this.isRecording.get();
    }

    @Override
    public boolean isAppending() {
        return false;
    }

    @Override
    public FileConsumer getFileConsumer() {
        return null;
    }

    @Override
    public void setFileConsumer(FileConsumer recordingConsumer) {
    }

    @Override
    public String getFileName() {
        return null;
    }

    @Override
    public void setFileName(String fileName) {
    }

    public List<Muxer> getMuxerList() {
        return this.muxerList;
    }

    public void setStorageClient(StorageClient storageClient) {
        this.storageClient = storageClient;
    }

    public boolean isWebRTCEnabled() {
        return this.webRTCEnabled;
    }

    public void setWebRTCEnabled(boolean webRTCEnabled) {
        this.webRTCEnabled = webRTCEnabled;
    }

    public void setHLSFilesDeleteOnExit(boolean deleteHLSFilesOnExit) {
        this.deleteHLSFilesOnExit = deleteHLSFilesOnExit;
    }

    public void setPreviewOverwrite(boolean overwrite) {
        this.previewOverwrite = overwrite;
    }

    public boolean isPreviewOverwrite() {
        return this.previewOverwrite;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public List<EncoderSettings> getEncoderSettingsList() {
        return this.encoderSettingsList;
    }

    public void setEncoderSettingsList(List<EncoderSettings> encoderSettingsList) {
        this.encoderSettingsList = encoderSettingsList;
    }

    public boolean isStreamSource() {
        return isStreamSource;
    }

    public void setStreamSource(boolean isStreamSource) {
        MuxAdaptor.isStreamSource = isStreamSource;
    }

    public boolean isObjectDetectionEnabled() {
        return this.objectDetectionEnabled;
    }

    public void setObjectDetectionEnabled(Boolean objectDetectionEnabled) {
        this.objectDetectionEnabled = objectDetectionEnabled;
    }

    public int getPreviewCreatePeriod() {
        return this.previewCreatePeriod;
    }

    public void setPreviewCreatePeriod(int previewCreatePeriod) {
        this.previewCreatePeriod = previewCreatePeriod;
    }

    public String getStreamId() {
        return this.streamId;
    }

    public void setStreamId(String streamId) {
        this.streamId = streamId;
    }

    public StorageClient getStorageClient() {
        return this.storageClient;
    }

    public void setFirstKeyFrameReceivedChecked(boolean firstKeyFrameReceivedChecked) {
        this.firstKeyFrameReceivedChecked = firstKeyFrameReceivedChecked;
    }

    public Broadcast getBroadcast() {
        if (this.broadcast == null) {
            this.broadcast = this.dataStore.get(this.streamId);
        }
        return this.broadcast;
    }

    public void setBroadcast(Broadcast broadcast) {
        this.broadcast = broadcast;
    }

    public void setGeneratePreview(boolean generatePreview) {
        this.generatePreview = generatePreview;
    }

    public int getPreviewHeight() {
        return this.previewHeight;
    }

    public void setPreviewHeight(int previewHeight) {
        this.previewHeight = previewHeight;
    }

    public Mp4Muxer createMp4Muxer() {
        Mp4Muxer mp4Muxer = new Mp4Muxer(this.storageClient, this.vertx, this.appSettings.getS3StreamsFolderPath());
        mp4Muxer.setAddDateTimeToSourceName(this.addDateTimeToMp4FileName);
        return mp4Muxer;
    }

    private Muxer addMp4Muxer() {
        Mp4Muxer mp4Muxer = this.createMp4Muxer();
        this.addMuxer(mp4Muxer);
        this.getDataStore().setMp4Muxing(this.streamId, 1);
        return mp4Muxer;
    }

    public RecordMuxer startRecording(RecordType recordType, int resolutionHeight) {
        if (!this.isRecording.get()) {
            logger.warn("Starting recording return false for stream:{} because stream is being prepared", (Object)this.streamId);
            return null;
        }
        if (this.isAlreadyRecording(recordType, resolutionHeight)) {
            logger.warn("Record is called while {} is already recording.", (Object)this.streamId);
            return null;
        }
        Mp4Muxer muxer = null;
        if (recordType == RecordType.MP4) {
            Mp4Muxer mp4Muxer;
            muxer = mp4Muxer = this.createMp4Muxer();
            this.addMuxer(muxer, resolutionHeight);
        } else if (recordType != RecordType.WEBM) {
            logger.error("Unrecognized record type: {}", (Object)recordType);
        }
        return muxer;
    }

    public boolean prepareMuxer(Muxer muxer, int resolutionHeight) {
        boolean streamAdded = false;
        muxer.init(this.scope, this.streamId, resolutionHeight, this.broadcast != null ? this.broadcast.getSubFolder() : null, 0);
        logger.info("prepareMuxer for stream:{} muxer:{}", (Object)this.streamId, (Object)muxer.getClass().getSimpleName());
        if (this.streamSourceInputFormatContext != null) {
            for (int i = 0; i < this.streamSourceInputFormatContext.nb_streams(); ++i) {
                if (!muxer.addStream(this.streamSourceInputFormatContext.streams(i).codecpar(), this.streamSourceInputFormatContext.streams(i).time_base(), i)) {
                    logger.warn("muxer add streams returns false {}", (Object)muxer.getFormat());
                    break;
                }
                streamAdded = true;
            }
        } else {
            AVCodecParameters audioParameters;
            AVCodecParameters videoParameters = this.getVideoCodecParameters();
            if (videoParameters != null) {
                logger.info("Add video stream to muxer:{} for streamId:{}", (Object)muxer.getClass().getSimpleName(), (Object)this.streamId);
                if (muxer.addStream(videoParameters, TIME_BASE_FOR_MS, this.videoStreamIndex)) {
                    streamAdded = true;
                }
            }
            if ((audioParameters = this.getAudioCodecParameters()) != null) {
                logger.info("Add audio stream to muxer:{} for streamId:{}", (Object)muxer.getClass().getSimpleName(), (Object)this.streamId);
                if (muxer.addStream(audioParameters, TIME_BASE_FOR_MS, this.audioStreamIndex)) {
                    streamAdded = true;
                }
            }
        }
        boolean prepared = false;
        if (streamAdded) {
            prepared = muxer.prepareIO();
            if (prepared) {
                prepared = this.addMuxerInternal(muxer);
                logger.info("Muxer:{} is prepared succesfully for streamId:{}", (Object)muxer.getClass().getSimpleName(), (Object)this.streamId);
            } else {
                logger.warn("Muxer:{} cannot be prepared for streamId:{}", (Object)muxer.getClass().getSimpleName(), (Object)this.streamId);
            }
        }
        return prepared;
    }

    public boolean isAlreadyRecording(RecordType recordType, int resolutionHeight) {
        for (Muxer muxer : this.muxerList) {
            if ((!(muxer instanceof Mp4Muxer) || recordType != RecordType.MP4) && (!(muxer instanceof WebMMuxer) || recordType != RecordType.WEBM) || resolutionHeight != 0 && resolutionHeight != this.height) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Muxer findDynamicRecordMuxer(RecordType recordType) {
        List<Muxer> list = this.muxerList;
        synchronized (list) {
            for (Muxer muxer : this.muxerList) {
                if ((recordType != RecordType.MP4 || !(muxer instanceof Mp4Muxer)) && (recordType != RecordType.WEBM || !(muxer instanceof WebMMuxer))) continue;
                return muxer;
            }
        }
        return null;
    }

    public RecordMuxer stopRecording(RecordType recordType, int resolutionHeight) {
        logger.info("stopRecording is called for streamId:{} and resolution:{}", (Object)this.streamId, (Object)resolutionHeight);
        Muxer muxer = this.findDynamicRecordMuxer(recordType);
        if (muxer != null && recordType == RecordType.MP4) {
            this.muxerList.remove(muxer);
            muxer.writeTrailer();
            return (RecordMuxer)muxer;
        }
        return null;
    }

    public ClientBroadcastStream getBroadcastStream() {
        return this.broadcastStream;
    }

    public Result startRtmpStreaming(String rtmpUrl, int resolutionHeight) {
        Result result = new Result(false);
        rtmpUrl = rtmpUrl.replaceAll("[\n\r\t]", "_");
        if (!this.isRecording.get()) {
            logger.warn("Start rtmp streaming return false for stream:{} because stream is being prepared", (Object)this.streamId);
            result.setMessage("Start rtmp streaming return false for stream:" + this.streamId + " because stream is being prepared. Try again");
            return result;
        }
        logger.info("start rtmp streaming for stream id:{} to {} with requested resolution height{} stream resolution:{}", new Object[]{this.streamId, rtmpUrl, resolutionHeight, this.height});
        if (resolutionHeight == 0 || resolutionHeight == this.height) {
            RtmpMuxer rtmpMuxer = new RtmpMuxer(rtmpUrl, this.vertx);
            rtmpMuxer.setStatusListener(this);
            if (this.prepareMuxer(rtmpMuxer, resolutionHeight)) {
                result.setSuccess(true);
            } else {
                logger.error("RTMP prepare returned false so that rtmp pushing to {} for {} didn't started ", (Object)rtmpUrl, (Object)this.streamId);
                result.setMessage("RTMP prepare returned false so that rtmp pushing to " + rtmpUrl + " for " + this.streamId + " didn't started ");
            }
        }
        return result;
    }

    public void sendEndpointErrorNotifyHook(String url) {
        IContext context = this.scope.getContext();
        ApplicationContext appCtx = context.getApplicationContext();
        AntMediaApplicationAdapter adaptor = (AntMediaApplicationAdapter)appCtx.getBean("web.handler");
        adaptor.endpointFailedUpdate(this.streamId, url);
    }

    public void endpointStatusHealthCheck(String url) {
        this.rtmpEndpointRetryLimit = this.appSettings.getEndpointRepublishLimit();
        this.healthCheckPeriodMS = this.appSettings.getEndpointHealthCheckPeriodMs();
        this.vertx.setPeriodic((long)this.healthCheckPeriodMS, id -> {
            String status = this.statusMap.getOrDefault(url, null);
            logger.info("Checking the endpoint health for: {} and status: {} ", (Object)url, (Object)status);
            if (this.broadcast == null || status == null || status.equals("finished")) {
                logger.info("Endpoint trailer is written or broadcast deleted for: {} ", (Object)url);
                this.clearCounterMapsAndCancelTimer(url, (Long)id);
            }
            if (status.equals("broadcasting")) {
                logger.info("Health check process finished since endpoint {} is broadcasting", (Object)url);
                this.clearCounterMapsAndCancelTimer(url, (Long)id);
            } else if (status.equals("error") || this.statusMap.get(url).equals("failed")) {
                this.tryToRepublish(url, (Long)id);
            }
        });
    }

    public void clearCounterMapsAndCancelTimer(String url, Long id) {
        this.isHealthCheckStartedMap.remove(url);
        this.errorCountMap.remove(url);
        this.retryCounter.remove(url);
        this.vertx.cancelTimer(id.longValue());
    }

    private void tryToRepublish(String url, Long id) {
        int errorCount = this.errorCountMap.getOrDefault(url, 1);
        if (errorCount < 3) {
            this.errorCountMap.put(url, errorCount + 1);
            logger.info("Endpoint check returned error for {} times for endpoint {}", (Object)errorCount, (Object)url);
        } else {
            int tmpRetryCount = this.retryCounter.getOrDefault(url, 1);
            if (tmpRetryCount <= this.rtmpEndpointRetryLimit) {
                logger.info("Health check process failed, trying to republish to the endpoint: {}", (Object)url);
                this.stopRtmpStreaming(url, 0);
                this.startRtmpStreaming(url, this.height);
                this.retryCounter.put(url, tmpRetryCount + 1);
            } else {
                logger.info("Exceeded republish retry limit, endpoint {} can't be reached and will be closed", (Object)url);
                this.stopRtmpStreaming(url, 0);
                this.sendEndpointErrorNotifyHook(url);
                this.retryCounter.remove(url);
            }
            this.isHealthCheckStartedMap.remove(url);
            this.errorCountMap.remove(url);
            this.vertx.cancelTimer(id.longValue());
        }
    }

    @Override
    public void endpointStatusUpdated(String url, String status) {
        logger.info("Endpoint status updated to {}  for streamId: {} for url: {}", new Object[]{status, this.streamId, url});
        this.endpointStatusUpdateMap.put(url, status);
        this.statusMap.put(url, status);
        if ((status.equals("error") || status.equals("failed")) && !this.isHealthCheckStartedMap.getOrDefault(url, false).booleanValue()) {
            this.endpointStatusHealthCheck(url);
            this.isHealthCheckStartedMap.put(url, true);
        }
        if (status.equals("broadcasting") && this.retryCounter.getOrDefault(url, null) != null) {
            this.retryCounter.remove(url);
        }
        if (this.endpointStatusUpdaterTimer.get() == -1L) {
            long timerId = this.vertx.setTimer(3000L, h -> {
                this.endpointStatusUpdaterTimer.set(-1L);
                try {
                    logger.info("Updating endpoint status in datastore for streamId:{}", (Object)this.streamId);
                    this.broadcast = this.getDataStore().get(this.broadcast.getStreamId());
                    this.updateBroadcastRecord();
                    this.endpointStatusUpdateMap.clear();
                }
                catch (Exception e) {
                    logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                }
            });
            this.endpointStatusUpdaterTimer.set(timerId);
        }
    }

    private void updateBroadcastRecord() {
        if (this.broadcast != null) {
            for (Endpoint endpoint : this.broadcast.getEndPointList()) {
                String statusUpdate = this.endpointStatusUpdateMap.getOrDefault(endpoint.getRtmpUrl(), null);
                if (statusUpdate != null) {
                    endpoint.setStatus(statusUpdate);
                    continue;
                }
                logger.warn("Endpoint is not found to update its status to {} for rtmp url:{}", (Object)statusUpdate, (Object)endpoint.getRtmpUrl());
            }
            this.getDataStore().updateBroadcastFields(this.broadcast.getStreamId(), this.broadcast);
        } else {
            logger.error("Broadcast with streamId:{} is not found to update its endpoint status. It's likely a zombi stream", (Object)this.streamId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RtmpMuxer getRtmpMuxer(String rtmpUrl) {
        RtmpMuxer rtmpMuxer = null;
        List<Muxer> list = this.muxerList;
        synchronized (list) {
            for (Muxer muxer : this.muxerList) {
                if (!(muxer instanceof RtmpMuxer) || !((RtmpMuxer)muxer).getOutputURL().equals(rtmpUrl)) continue;
                rtmpMuxer = (RtmpMuxer)muxer;
                break;
            }
        }
        return rtmpMuxer;
    }

    public Result stopRtmpStreaming(String rtmpUrl, int resolutionHeight) {
        Result result = new Result(false);
        if (resolutionHeight == 0 || resolutionHeight == this.height) {
            RtmpMuxer rtmpMuxer = this.getRtmpMuxer(rtmpUrl);
            String status = this.statusMap.getOrDefault(rtmpUrl, null);
            if (rtmpMuxer != null) {
                this.muxerList.remove(rtmpMuxer);
                this.statusMap.remove(rtmpUrl);
                rtmpMuxer.writeTrailer();
                result.setSuccess(true);
            } else if (status == null || "error".equals(status) || "failed".equals(status) || "finished".equals(status)) {
                result.setSuccess(true);
            }
        }
        return result;
    }

    public boolean isEnableVideo() {
        return this.enableVideo;
    }

    public void setEnableVideo(boolean enableVideo) {
        this.enableVideo = enableVideo;
    }

    public boolean isEnableAudio() {
        return this.enableAudio;
    }

    public void setEnableAudio(boolean enableAudio) {
        this.enableAudio = enableAudio;
    }

    public int getLastFrameTimestamp() {
        return this.lastFrameTimestamp;
    }

    public void setLastFrameTimestamp(int lastFrameTimestamp) {
        this.lastFrameTimestamp = lastFrameTimestamp;
    }

    public void setAppSettings(AppSettings appSettings) {
        this.appSettings = appSettings;
    }

    public long getBufferTimeMs() {
        return this.bufferTimeMs;
    }

    public boolean isBuffering() {
        return this.buffering.get();
    }

    public void setBuffering(boolean buffering) {
        this.buffering.set(buffering);
    }

    public String getDataChannelWebHookURL() {
        return this.dataChannelWebHookURL;
    }

    public boolean isDeleteDASHFilesOnExit() {
        return this.deleteDASHFilesOnExit;
    }

    public void setDeleteDASHFilesOnExit(boolean deleteDASHFilesOnExit) {
        this.deleteDASHFilesOnExit = deleteDASHFilesOnExit;
    }

    public boolean isAvc() {
        return this.avc;
    }

    public void setAvc(boolean avc) {
        this.avc = avc;
    }

    public ConcurrentSkipListSet<IStreamPacket> getBufferQueue() {
        return this.bufferQueue;
    }

    public void setBufferingFinishTimeMs(long bufferingFinishTimeMs) {
        this.bufferingFinishTimeMs = bufferingFinishTimeMs;
    }

    public Queue<PacketTime> getPacketTimeList() {
        return this.packetTimeList;
    }

    public int getVideoStreamIndex() {
        return this.videoStreamIndex;
    }

    public void setVideoStreamIndex(int videoStreamIndex) {
        this.videoStreamIndex = videoStreamIndex;
    }

    public int getAudioStreamIndex() {
        return this.audioStreamIndex;
    }

    public void setAudioStreamIndex(int audioStreamIndex) {
        this.audioStreamIndex = audioStreamIndex;
    }

    public void addPacketListener(IPacketListener listener) {
        StreamParametersInfo videoInfo = new StreamParametersInfo();
        videoInfo.setCodecParameters(this.getVideoCodecParameters());
        videoInfo.setTimeBase(this.getVideoTimeBase());
        videoInfo.setEnabled(this.enableVideo);
        StreamParametersInfo audioInfo = new StreamParametersInfo();
        audioInfo.setCodecParameters(this.getAudioCodecParameters());
        audioInfo.setTimeBase(this.getAudioTimeBase());
        audioInfo.setEnabled(this.enableAudio);
        listener.setVideoStreamInfo(this.streamId, videoInfo);
        listener.setAudioStreamInfo(this.streamId, audioInfo);
        this.packetFeeder.addListener(listener);
    }

    public boolean removePacketListener(IPacketListener listener) {
        return this.packetFeeder.removeListener(listener);
    }

    public void setVideoCodecParameter(AVCodecParameters videoCodecParameters) {
        this.videoCodecParameters = videoCodecParameters;
    }

    public void setAudioCodecParameter(AVCodecParameters audioCodecParameters) {
        this.audioCodecParameters = audioCodecParameters;
    }

    public AVRational getVideoTimeBase() {
        return this.videoTimeBase;
    }

    public AVRational getAudioTimeBase() {
        return this.audioTimeBase;
    }

    public void setVideoTimeBase(AVRational videoTimeBase) {
        this.videoTimeBase = videoTimeBase;
    }

    public void setAudioTimeBase(AVRational audioTimeBase) {
        this.audioTimeBase = audioTimeBase;
    }

    public Vertx getVertx() {
        return this.vertx;
    }

    public Map<String, String> getEndpointStatusUpdateMap() {
        return this.endpointStatusUpdateMap;
    }

    public Map<String, Boolean> getIsHealthCheckStartedMap() {
        return this.isHealthCheckStartedMap;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getHeight() {
        return this.height;
    }

    public void setIsRecording(boolean isRecording) {
        this.isRecording.set(isRecording);
    }

    public void setAudioDataConf(byte[] audioDataConf) {
        this.audioDataConf = audioDataConf;
    }

    public boolean isBlacklistCodec(int codecId) {
        return codecId == 61;
    }

    public void setBufferTimeMs(long bufferTimeMs) {
        this.bufferTimeMs = bufferTimeMs;
    }

    public AtomicBoolean getIsPipeReaderJobRunning() {
        return this.isPipeReaderJobRunning;
    }

    public long getTotalByteReceived() {
        return this.totalByteReceived;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    static {
        isStreamSource = false;
        TIME_BASE_FOR_MS = new AVRational();
        TIME_BASE_FOR_MS.num(1);
        TIME_BASE_FOR_MS.den(1000);
    }

    public static class PacketTime {
        public final long packetTimeMs;
        public final long systemTimeMs;

        public PacketTime(long packetTimeMs, long systemTimeMs) {
            this.packetTimeMs = packetTimeMs;
            this.systemTimeMs = systemTimeMs;
        }
    }
}

