/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.muxer;

import io.antmedia.AntMediaApplicationAdapter;
import io.antmedia.AppSettings;
import io.antmedia.muxer.Muxer;
import io.antmedia.storage.StorageClient;
import io.vertx.core.Vertx;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import org.apache.tika.utils.StringUtils;
import org.bytedeco.ffmpeg.avcodec.AVCodecParameters;
import org.bytedeco.ffmpeg.avformat.AVFormatContext;
import org.bytedeco.ffmpeg.avformat.AVStream;
import org.bytedeco.ffmpeg.global.avcodec;
import org.bytedeco.ffmpeg.global.avformat;
import org.red5.server.api.IContext;
import org.red5.server.api.scope.IScope;
import org.springframework.context.ApplicationContext;

public abstract class RecordMuxer
extends Muxer {
    protected File fileTmp;
    protected StorageClient storageClient = null;
    protected int resolution;
    protected boolean uploadMP4ToS3 = true;
    protected String previewPath;
    private static final int S3_CONSTANT = 1;
    private String s3FolderPath = "streams";
    private long startTime = 0L;
    private String vodId;
    protected int[] SUPPORTED_CODECS;

    protected RecordMuxer(StorageClient storageClient, Vertx vertx, String s3FolderPath) {
        super(vertx);
        this.storageClient = storageClient;
        this.s3FolderPath = s3FolderPath;
        this.firstAudioDts = -1L;
        this.firstVideoDts = -1L;
        this.firstKeyFrameReceived = false;
    }

    @Override
    public boolean isCodecSupported(int codecId) {
        for (int i = 0; i < this.SUPPORTED_CODECS.length; ++i) {
            if (codecId != this.SUPPORTED_CODECS[i]) continue;
            return true;
        }
        return false;
    }

    @Override
    public void init(IScope scope, String name, int resolutionHeight, String subFolder, int bitrate) {
        super.init(scope, name, resolutionHeight, false, subFolder, bitrate);
        this.streamId = name;
        this.resolution = resolutionHeight;
        this.startTime = System.currentTimeMillis();
    }

    @Override
    public AVFormatContext getOutputFormatContext() {
        if (this.outputFormatContext == null) {
            this.outputFormatContext = new AVFormatContext(null);
            this.fileTmp = new File(this.file.getAbsolutePath() + ".tmp_extension");
            int ret = avformat.avformat_alloc_output_context2((AVFormatContext)this.outputFormatContext, null, (String)this.format, (String)this.fileTmp.getAbsolutePath());
            if (ret < 0) {
                this.logger.info("Could not create output context for {}", (Object)this.streamId);
                return null;
            }
        }
        return this.outputFormatContext;
    }

    protected boolean prepareAudioOutStream(AVStream inStream, AVStream outStream) {
        int ret = avcodec.avcodec_parameters_copy((AVCodecParameters)outStream.codecpar(), (AVCodecParameters)inStream.codecpar());
        if (ret < 0) {
            this.logger.info("Cannot get codec parameters for {}", (Object)this.streamId);
            return false;
        }
        return true;
    }

    @Override
    public String getOutputURL() {
        return this.fileTmp.getAbsolutePath();
    }

    public void setPreviewPath(String path) {
        this.previewPath = path;
    }

    @Override
    public synchronized void writeTrailer() {
        super.writeTrailer();
        this.vertx.executeBlocking(() -> {
            try {
                AntMediaApplicationAdapter adaptor = this.getAppAdaptor();
                AppSettings appSettings = this.getAppSettings();
                File f = this.getFinalFileName(appSettings.isS3RecordingEnabled());
                this.finalizeRecordFile(f);
                adaptor.muxingFinished(this.streamId, f, this.startTime, RecordMuxer.getDurationInMs(f, this.streamId), this.resolution, this.previewPath, this.vodId);
                this.logger.info("File: {} exist: {}", (Object)this.fileTmp.getAbsolutePath(), (Object)this.fileTmp.exists());
                if ((appSettings.getUploadExtensionsToS3() & 1) == 0) {
                    this.uploadMP4ToS3 = false;
                }
                if (appSettings.isS3RecordingEnabled() && this.uploadMP4ToS3) {
                    this.logger.info("Storage client is available saving {} to storage", (Object)f.getName());
                    RecordMuxer.saveToStorage(this.s3FolderPath + File.separator + (String)(this.subFolder != null ? this.subFolder + File.separator : ""), f, f.getName(), this.storageClient);
                }
            }
            catch (Exception e) {
                this.logger.error(e.getMessage());
            }
            return null;
        });
    }

    public AntMediaApplicationAdapter getAppAdaptor() {
        IContext context = this.scope.getContext();
        ApplicationContext appCtx = context.getApplicationContext();
        AntMediaApplicationAdapter adaptor = (AntMediaApplicationAdapter)appCtx.getBean("web.handler");
        return adaptor;
    }

    public static String getS3Prefix(String s3FolderPath, String subFolder) {
        return RecordMuxer.replaceDoubleSlashesWithSingleSlash(s3FolderPath + File.separator + (subFolder != null ? subFolder : "") + File.separator);
    }

    public File getFinalFileName(boolean isS3Enabled) {
        String absolutePath = this.fileTmp.getAbsolutePath();
        Object origFileName = absolutePath.replace(".tmp_extension", "");
        String prefix = RecordMuxer.getS3Prefix(this.s3FolderPath, this.subFolder);
        Object fileName = this.getFile().getName();
        File f = new File((String)origFileName);
        if (isS3Enabled && this.uploadMP4ToS3 && this.storageClient != null && RecordMuxer.doesFileExistInS3(this.storageClient, prefix + (String)fileName)) {
            int i = 0;
            do {
                fileName = this.initialResourceNameWithoutExtension + "_" + ++i + this.extension;
                origFileName = ((String)origFileName).substring(0, ((String)origFileName).lastIndexOf("/") + 1) + (String)fileName;
                f = new File((String)origFileName);
            } while (RecordMuxer.doesFileExistInS3(this.storageClient, prefix + (String)fileName) || f.exists() || f.isDirectory());
        }
        return f;
    }

    private static boolean doesFileExistInS3(StorageClient storageClient, String name) {
        return storageClient.fileExist(name);
    }

    public static void saveToStorage(String prefix, File fileToUpload, String fileName, StorageClient storageClient) {
        RecordMuxer.saveToStorage(prefix, fileToUpload, fileName, storageClient, true);
    }

    public static void saveToStorage(String prefix, File fileToUpload, String fileName, StorageClient storageClient, boolean deleteLocalFile) {
        storageClient.save(prefix + fileName, fileToUpload, deleteLocalFile);
    }

    protected void finalizeRecordFile(File file) throws IOException {
        Files.move(this.fileTmp.toPath(), file.toPath(), new CopyOption[0]);
        this.logger.info("{} is ready", (Object)file.getName());
    }

    public boolean isUploadingToS3() {
        return this.uploadMP4ToS3;
    }

    public String getVodId() {
        return this.vodId;
    }

    public void setVodId(String vodId) {
        this.vodId = vodId;
    }

    @Override
    public void setSubfolder(String subFolder) {
        this.subFolder = subFolder;
        String recordingSubfolder = this.getAppSettings().getRecordingSubfolder();
        if (!StringUtils.isBlank((String)recordingSubfolder)) {
            this.subFolder = !StringUtils.isBlank((String)this.subFolder) ? subFolder + File.separator + recordingSubfolder : recordingSubfolder;
        }
    }
}

