/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.rest;

import com.amazonaws.util.Base32;
import io.antmedia.RecordType;
import io.antmedia.StreamIdValidator;
import io.antmedia.cluster.IStreamInfo;
import io.antmedia.datastore.db.DataStore;
import io.antmedia.datastore.db.types.Broadcast;
import io.antmedia.datastore.db.types.ConferenceRoom;
import io.antmedia.datastore.db.types.Endpoint;
import io.antmedia.datastore.db.types.Subscriber;
import io.antmedia.datastore.db.types.SubscriberStats;
import io.antmedia.datastore.db.types.TensorFlowObject;
import io.antmedia.datastore.db.types.Token;
import io.antmedia.datastore.db.types.WebRTCViewerInfo;
import io.antmedia.ipcamera.OnvifCamera;
import io.antmedia.muxer.MuxAdaptor;
import io.antmedia.muxer.Muxer;
import io.antmedia.rest.RestServiceBase;
import io.antmedia.rest.RootRestService;
import io.antmedia.rest.WebRTCClientStats;
import io.antmedia.rest.model.BasicStreamInfo;
import io.antmedia.rest.model.Result;
import io.antmedia.security.TOTPGenerator;
import io.antmedia.statistic.type.RTMPToWebRTCStats;
import io.antmedia.statistic.type.WebRTCAudioReceiveStats;
import io.antmedia.statistic.type.WebRTCAudioSendStats;
import io.antmedia.statistic.type.WebRTCVideoReceiveStats;
import io.antmedia.statistic.type.WebRTCVideoSendStats;
import io.antmedia.streamsource.StreamFetcher;
import io.antmedia.webrtc.api.IWebRTCAdaptor;
import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.info.Contact;
import io.swagger.v3.oas.annotations.info.Info;
import io.swagger.v3.oas.annotations.info.License;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.servers.Server;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.springframework.stereotype.Component;

@OpenAPIDefinition(info=@Info(description="Ant Media Server REST API for Broadcasts", version="v2.0", title="Ant Media Server REST API Reference", contact=@Contact(name="Ant Media Info", email="contact@antmedia.io", url="https://antmedia.io"), license=@License(name="Apache 2.0", url="https://www.apache.org/licenses/LICENSE-2.0")), externalDocs=@ExternalDocumentation(description="Rest Guide", url="https://antmedia.io/docs"), servers={@Server(description="test server", url="https://test.antmedia.io:5443/Sandbox/rest/")})
@Component
@Path(value="/v2/broadcasts")
public class BroadcastRestService
extends RestServiceBase {
    private static final String REPLACE_CHARS = "[\n|\r|\t]";
    private static final String STREAM_ID_NOT_VALID = "Stream id not valid";
    private static final String RELATIVE_MOVE = "relative";
    private static final String ABSOLUTE_MOVE = "absolute";
    private static final String CONTINUOUS_MOVE = "continuous";

    @Operation(description="Creates a Broadcast, IP Camera or Stream Source and returns the full broadcast object with rtmp address and other information. The different between Broadcast and IP Camera or Stream Source is that Broadcast is ingested by Ant Media ServerIP Camera or Stream Source is pulled by Ant Media Server")
    @ApiResponses(value={@ApiResponse(responseCode="400", description="If stream id is already used in the data store, it returns error", content={@Content(mediaType="application/json", schema=@Schema(implementation=Result.class))}), @ApiResponse(responseCode="200", description="Returns the created stream", content={@Content(mediaType="application/json", schema=@Schema(implementation=Broadcast.class))})})
    @POST
    @Consumes(value={"application/json"})
    @Path(value="/create")
    @Produces(value={"application/json"})
    public Response createBroadcast(@Parameter(description="Broadcast object. Set the required fields, it may be null as well.", required=false) Broadcast broadcast, @Parameter(description="Only effective if stream is IP Camera or Stream Source. If it's true, it starts automatically pulling stream. Its value is false by default", required=false) @QueryParam(value="autoStart") boolean autoStart) {
        if (broadcast != null && broadcast.getStreamId() != null) {
            try {
                broadcast.setStreamId(broadcast.getStreamId().trim());
                if (!broadcast.getStreamId().isEmpty()) {
                    Broadcast broadcastTmp = this.getDataStore().get(broadcast.getStreamId());
                    if (broadcastTmp != null) {
                        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new Result(false, "Stream id is already being used. Please change stream id or keep it empty")).build();
                    }
                    if (!StreamIdValidator.isStreamIdValid(broadcast.getStreamId())) {
                        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new Result(false, "Stream id is not valid.")).build();
                    }
                }
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new Result(false, "Stream id set generated exception")).build();
            }
        }
        Object returnObject = new Result(false, "unexpected parameters received");
        if (autoStart) {
            if (broadcast != null) {
                returnObject = this.addStreamSource(broadcast);
            }
        } else {
            if (broadcast != null && ("ipCamera".equals(broadcast.getType()) && !BroadcastRestService.validateStreamURL(broadcast.getIpAddr()) || "streamSource".equals(broadcast.getType()) && !this.checkStreamUrl(broadcast.getStreamUrl()))) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new Result(false, "Stream url is not valid. ")).build();
            }
            if (broadcast != null && broadcast.getSubFolder() != null && broadcast.getSubFolder().contains("..")) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new Result(false, "Subfolder is not valid. ")).build();
            }
            returnObject = this.createBroadcastWithStreamID(broadcast);
        }
        return Response.status((Response.Status)Response.Status.OK).entity(returnObject).build();
    }

    @Override
    @Operation(summary="Delete broadcast from data store and stop if it's broadcasting")
    @ApiResponse(responseCode="200", description="If it's deleted, success is true. If it's not deleted, success if false.", content={@Content(mediaType="application/json", schema=@Schema(implementation=Broadcast.class))})
    @DELETE
    @Consumes(value={"application/json"})
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public Result deleteBroadcast(@Parameter(description=" Id of the broadcast", required=true) @PathParam(value="id") String id) {
        return super.deleteBroadcast(id);
    }

    @Override
    @Hidden
    @Deprecated
    @DELETE
    @Consumes(value={"application/json"})
    @Path(value="/bulk")
    @Produces(value={"application/json"})
    public Result deleteBroadcasts(@Parameter(description="Id of the broadcast", required=true) String[] streamIds) {
        return super.deleteBroadcasts(streamIds);
    }

    @Operation(description="Delete multiple broadcasts from data store and stop if they are broadcasting")
    @ApiResponse(responseCode="200", description="If it's deleted, success is true. If it's not deleted, success if false.", content={@Content(mediaType="application/json", schema=@Schema(implementation=Broadcast.class))})
    @DELETE
    @Consumes(value={"application/json"})
    @Path(value="/")
    @Produces(value={"application/json"})
    public Result deleteBroadcastsBulk(@Parameter(description="Comma-separated stream Ids", required=true) @QueryParam(value="ids") String streamIds) {
        if (StringUtils.isNotBlank((CharSequence)streamIds)) {
            return super.deleteBroadcasts(streamIds.split(","));
        }
        return new Result(false, "ids parameter is blank");
    }

    @Operation(description="Get broadcast object")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Return the broadcast object", content={@Content(mediaType="application/json", schema=@Schema(implementation=Broadcast.class))}), @ApiResponse(responseCode="404", description="Broadcast object not found")})
    @GET
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public Response getBroadcast(@Parameter(description="id of the broadcast", required=true) @PathParam(value="id") String id) {
        Broadcast broadcast = null;
        if (id != null) {
            broadcast = this.lookupBroadcast(id);
        }
        if (broadcast != null) {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)broadcast).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @Operation(description="Gets the broadcast list from database. It returns max 50 items at a time")
    @GET
    @Path(value="/list/{offset}/{size}")
    @Produces(value={"application/json"})
    public List<Broadcast> getBroadcastList(@Parameter(description="This is the offset of the list, it is useful for pagination. If you want to use sort mechanism, we recommend using Mongo DB.", required=true) @PathParam(value="offset") int offset, @Parameter(description="Number of items that will be fetched. If there is not enough item in the datastore, returned list size may less then this value", required=true) @PathParam(value="size") int size, @Parameter(description="Type of the stream. Possible values are \"liveStream\", \"ipCamera\", \"streamSource\", \"VoD\"", required=false) @QueryParam(value="type_by") String typeBy, @Parameter(description="Field to sort. Possible values are \"name\", \"date\", \"status\"", required=false) @QueryParam(value="sort_by") String sortBy, @Parameter(description="\"asc\" for Ascending, \"desc\" Descending order", required=false) @QueryParam(value="order_by") String orderBy, @Parameter(description="Search parameter, returns specific items that contains search string", required=false) @QueryParam(value="search") String search) {
        return this.getDataStore().getBroadcastList(offset, size, typeBy, sortBy, orderBy, search);
    }

    @Operation(description="Updates the Broadcast objects fields if it's not null. The updated fields are as follows: name, description, userName, password, IP address, streamUrl of the broadcast. It also updates the social endpoints")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="If it's updated, success field is true. If it's not updated, success field is false.")})
    @PUT
    @Consumes(value={"application/json"})
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public Result updateBroadcast(@Parameter(description="Broadcast id", required=true) @PathParam(value="id") String id, @Parameter(description="Broadcast object with the updates") Broadcast broadcast) {
        Result result = new Result(false);
        if (id != null && broadcast != null) {
            Broadcast broadcastInDB = this.getDataStore().get(id);
            if (broadcastInDB == null) {
                String streamId = id.replaceAll(REPLACE_CHARS, "_");
                logger.info("Broadcast with stream id: {} is null", (Object)streamId);
                return new Result(false, "Broadcast with streamId: " + streamId + " does not exist");
            }
            result = broadcastInDB.getType() != null && (broadcastInDB.getType().equals("ipCamera") || broadcastInDB.getType().equals("streamSource") || broadcastInDB.getType().equals("VoD") || broadcastInDB.getType().equals("playlist")) ? super.updateStreamSource(id, broadcast, broadcastInDB) : super.updateBroadcast(id, broadcast, broadcastInDB);
        }
        return result;
    }

    @Operation(description="Gets the durations of the stream url in milliseconds", responses={@ApiResponse(responseCode="200", description="If operation is successful, duration will be in dataId field and success field is true. If it's failed, errorId has the error code(-1: duration is not available, -2: url is not opened, -3: cannot get stream info) and success field is false", content={@Content(mediaType="application/json", schema=@Schema(implementation=Result.class))})})
    @GET
    @Consumes(value={"application/json"})
    @Path(value="/duration")
    @Produces(value={"application/json"})
    public Result getDuration(@Parameter(description="Url of the stream that its duration will be returned", required=true) @QueryParam(value="url") String url) {
        Result result = new Result(false);
        if (StringUtils.isNotBlank((CharSequence)url)) {
            long durationInMs = Muxer.getDurationInMs(url, null);
            if (durationInMs >= 0L) {
                result.setSuccess(true);
                result.setDataId(Long.toString(durationInMs));
            } else {
                result.setErrorId((int)durationInMs);
            }
        }
        return result;
    }

    @Operation(description="Seeks the playing stream source, vod or playlist on the fly. It accepts seekTimeMs parameter in milliseconds")
    @PUT
    @Consumes(value={"application/json"})
    @Path(value="/{id}/seek-time/{seekTimeMs}")
    @Produces(value={"application/json"})
    public Result updateSeekTime(@Parameter(description="Broadcast id", required=true) @PathParam(value="id") String id, @Parameter(description="Seek time in milliseconds", required=true) @PathParam(value="seekTimeMs") long seekTimeMs) {
        Result result = new Result(false);
        if (StringUtils.isNotBlank((CharSequence)id)) {
            StreamFetcher streamFetcher = this.getApplication().getStreamFetcherManager().getStreamFetcher(id);
            if (streamFetcher != null) {
                streamFetcher.seekTime(seekTimeMs);
                result.setSuccess(true);
            } else {
                result.setMessage("Not active stream source found with this id: " + id + " make sure you give the id of a running stream source");
            }
        } else {
            result.setMessage("Id field is blank.");
        }
        return result;
    }

    @Hidden
    @Deprecated
    @POST
    @Consumes(value={"application/json"})
    @Path(value="/{id}/endpoint")
    @Produces(value={"application/json"})
    public Result addEndpointV2(@Parameter(description="Broadcast id", required=true) @PathParam(value="id") String id, @Parameter(description="RTMP url of the endpoint that stream will be republished. If required, please encode the URL", required=true) @QueryParam(value="rtmpUrl") String rtmpUrl) {
        Result result = super.addEndpoint(id, rtmpUrl);
        if (result.isSuccess()) {
            String status = this.getDataStore().get(id).getStatus();
            if (status.equals("broadcasting")) {
                result = this.getMuxAdaptor(id).startRtmpStreaming(rtmpUrl, 0);
            }
        } else if (logger.isErrorEnabled()) {
            logger.error("Rtmp endpoint({}) was not added to the stream: {}", (Object)(rtmpUrl != null ? rtmpUrl.replaceAll(REPLACE_CHARS, "_") : null), (Object)id.replaceAll(REPLACE_CHARS, "_"));
        }
        return result;
    }

    @Operation(summary="Adds a third party RTMP end point to the stream", description="It supports adding after broadcast is started. Resolution can be specified to send a specific adaptive resolution. If an URL is already added to a stream, trying to add the same RTMP URL will return false.", responses={@ApiResponse(responseCode="200", description="Add RTMP endpoint response", content={@Content(mediaType="application/json", schema=@Schema(implementation=Result.class))})})
    @POST
    @Consumes(value={"application/json"})
    @Path(value="/{id}/rtmp-endpoint")
    @Produces(value={"application/json"})
    public Result addEndpointV3(@Parameter(description="Broadcast id", required=true) @PathParam(value="id") String id, @Parameter(description="RTMP url of the endpoint that stream will be republished. If required, please encode the URL", required=true) Endpoint endpoint, @Parameter(description="Resolution height of the broadcast that is wanted to send to the RTMP endpoint. ", required=false) @QueryParam(value="resolutionHeight") int resolutionHeight) {
        String rtmpUrl = null;
        Result result = new Result(false);
        if (endpoint != null && endpoint.getRtmpUrl() != null) {
            Broadcast broadcast = this.getDataStore().get(id);
            if (broadcast != null) {
                List<Endpoint> endpoints = broadcast.getEndPointList();
                if (endpoints == null || endpoints.stream().noneMatch(o -> o.getRtmpUrl().equals(endpoint.getRtmpUrl()))) {
                    rtmpUrl = endpoint.getRtmpUrl();
                    if (broadcast.getStatus().equals("broadcasting")) {
                        result = this.processRTMPEndpoint(broadcast.getStreamId(), broadcast.getOriginAdress(), rtmpUrl, true, resolutionHeight);
                        if (result.isSuccess()) {
                            result = super.addEndpoint(id, endpoint);
                        }
                    } else {
                        result = super.addEndpoint(id, endpoint);
                    }
                    if (!result.isSuccess()) {
                        result.setMessage("Rtmp endpoint is not added to stream: " + id);
                    }
                    this.logRtmpEndpointInfo(id, endpoint, result.isSuccess());
                } else {
                    result.setMessage("Rtmp endpoint is not added to datastore for stream " + id + ". It is already added ->" + endpoint.getRtmpUrl());
                }
            }
        } else {
            result.setMessage("Missing rtmp url");
        }
        return result;
    }

    private void logRtmpEndpointInfo(String id, Endpoint endpoint, boolean result) {
        if (logger.isInfoEnabled()) {
            logger.info("Rtmp endpoint({}) adding to the stream: {} is {}", new Object[]{endpoint.getRtmpUrl().replaceAll(REPLACE_CHARS, "_"), id.replaceAll(REPLACE_CHARS, "_"), result});
        }
    }

    @Override
    @Hidden
    @Deprecated
    @DELETE
    @Consumes(value={"application/json"})
    @Path(value="/{id}/endpoint")
    @Produces(value={"application/json"})
    public Result removeEndpoint(@Parameter(description="Broadcast id", required=true) @PathParam(value="id") String id, @Parameter(description="RTMP url of the endpoint that will be stopped.", required=true) @QueryParam(value="rtmpUrl") String rtmpUrl) {
        Result result = super.removeEndpoint(id, rtmpUrl);
        if (result.isSuccess()) {
            String status = this.getDataStore().get(id).getStatus();
            if (status.equals("broadcasting")) {
                result = this.getMuxAdaptor(id).stopRtmpStreaming(rtmpUrl, 0);
            }
        } else if (logger.isErrorEnabled()) {
            logger.error("Rtmp endpoint({}) was not removed from the stream: {}", (Object)(rtmpUrl != null ? rtmpUrl.replaceAll(REPLACE_CHARS, "_") : null), (Object)id.replaceAll(REPLACE_CHARS, "_"));
        }
        return result;
    }

    @Operation(summary="Remove third-party RTMP end point from the stream", description="For the stream that is broadcasting, it will stop immediately.", responses={@ApiResponse(responseCode="200", description="Remove RTMP endpoint response", content={@Content(mediaType="application/json", schema=@Schema(implementation=Result.class))})})
    @DELETE
    @Consumes(value={"application/json"})
    @Path(value="/{id}/rtmp-endpoint")
    @Produces(value={"application/json"})
    public Result removeEndpointV2(@Parameter(description="Broadcast id", required=true) @PathParam(value="id") String id, @Parameter(description="RTMP url of the endpoint that will be stopped.", required=true) @QueryParam(value="endpointServiceId") String endpointServiceId, @Parameter(description="Resolution specifier if endpoint has been added with resolution. Only applicable if user added RTMP endpoint with a resolution speficier. Otherwise won't work and won't remove the endpoint.") @QueryParam(value="resolutionHeight") int resolutionHeight) {
        Endpoint endpoint;
        String rtmpUrl = null;
        Broadcast broadcast = this.getDataStore().get(id);
        Result result = new Result(false);
        if (broadcast != null && endpointServiceId != null && broadcast.getEndPointList() != null && !broadcast.getEndPointList().isEmpty() && (endpoint = this.getRtmpUrlFromList(endpointServiceId, broadcast)) != null && endpoint.getRtmpUrl() != null) {
            rtmpUrl = endpoint.getRtmpUrl();
            result = this.removeRTMPEndpointProcess(broadcast, endpoint, resolutionHeight, id);
        }
        if (logger.isInfoEnabled()) {
            logger.info("Rtmp endpoint({}) removal operation is {} from the stream: {}", new Object[]{rtmpUrl != null ? rtmpUrl.replaceAll(REPLACE_CHARS, "_") : null, result.isSuccess(), id.replaceAll(REPLACE_CHARS, "_")});
        }
        return result;
    }

    private Result removeRTMPEndpointProcess(Broadcast broadcast, Endpoint endpoint, int resolutionHeight, String id) {
        Result result;
        if ("broadcasting".equals(broadcast.getStatus())) {
            result = this.processRTMPEndpoint(broadcast.getStreamId(), broadcast.getOriginAdress(), endpoint.getRtmpUrl(), false, resolutionHeight);
            if (result.isSuccess()) {
                result = super.removeRTMPEndpoint(id, endpoint);
            }
        } else {
            result = super.removeRTMPEndpoint(id, endpoint);
        }
        return result;
    }

    private Endpoint getRtmpUrlFromList(String endpointServiceId, Broadcast broadcast) {
        Endpoint endpoint = null;
        for (Endpoint selectedEndpoint : broadcast.getEndPointList()) {
            if (!selectedEndpoint.getEndpointServiceId().equals(endpointServiceId)) continue;
            endpoint = selectedEndpoint;
        }
        return endpoint;
    }

    @Operation(summary="Retrieve detected objects from the stream", description="Fetches detected objects from the stream, using specified offset and size parameters.", responses={@ApiResponse(responseCode="200", description="List of detected TensorFlow objects", content={@Content(mediaType="application/json", schema=@Schema(implementation=TensorFlowObject.class, type="array"))})})
    @GET
    @Path(value="/{id}/detections/{offset}/{size}")
    @Produces(value={"application/json"})
    public List<TensorFlowObject> getDetectionListV2(@Parameter(description="the id of the stream", required=true) @PathParam(value="id") String id, @Parameter(description="starting point of the list", required=true) @PathParam(value="offset") int offset, @Parameter(description="total size of the return list", required=true) @PathParam(value="size") int size) {
        return super.getDetectionList(id, offset, size);
    }

    @Operation(summary="Get total number of detected objects", description="Retrieves the total count of objects detected.", responses={@ApiResponse(responseCode="200", description="Total number of detected objects", content={@Content(mediaType="application/json", schema=@Schema(implementation=Long.class))})})
    @GET
    @Path(value="/{id}/detections/count")
    @Produces(value={"application/json"})
    public SimpleStat getObjectDetectedTotal(@Parameter(description="id of the stream", required=true) @PathParam(value="id") String id) {
        return new SimpleStat(this.getDataStore().getObjectDetectedTotal(id));
    }

    @Operation(summary="Import Live Streams to Stalker Portal", description="Imports live streams into the Stalker Portal.", responses={@ApiResponse(responseCode="200", description="Import operation result", content={@Content(mediaType="application/json", schema=@Schema(implementation=Result.class))})})
    @POST
    @Path(value="/import-to-stalker")
    @Produces(value={"application/json"})
    public Result importLiveStreams2StalkerV2() {
        return super.importLiveStreams2Stalker();
    }

    @Operation(summary="Get the total number of broadcasts", description="Retrieves the total number of broadcasts.", responses={@ApiResponse(responseCode="200", description="Total number of broadcasts", content={@Content(mediaType="application/json", schema=@Schema(implementation=SimpleStat.class))})})
    @GET
    @Path(value="/count")
    @Produces(value={"application/json"})
    public SimpleStat getTotalBroadcastNumberV2() {
        return new SimpleStat(this.getDataStore().getTotalBroadcastNumber());
    }

    @Operation(summary="Get the number of broadcasts based on search criteria", description="Retrieves the number of broadcasts matching the specified search criteria.", responses={@ApiResponse(responseCode="200", description="Number of broadcasts for searched items", content={@Content(mediaType="application/json", schema=@Schema(implementation=SimpleStat.class))})})
    @GET
    @Path(value="/count/{search}")
    @Produces(value={"application/json"})
    public SimpleStat getTotalBroadcastNumberV2(@Parameter(description="Search parameter to get the number of items including it ", required=true) @PathParam(value="search") String search) {
        return new SimpleStat(this.getDataStore().getPartialBroadcastNumber(search));
    }

    @Operation(summary="Return the active live streams", description="Retrieves the currently active live streams.", responses={@ApiResponse(responseCode="200", description="Active live streams", content={@Content(mediaType="application/json", schema=@Schema(implementation=SimpleStat.class))})})
    @GET
    @Path(value="/active-live-stream-count")
    @Produces(value={"application/json"})
    public SimpleStat getAppLiveStatistics() {
        return new SimpleStat(this.getDataStore().getActiveBroadcastCount());
    }

    @Operation(description="Generates random one-time token for specified stream")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Returns token", content={@Content(mediaType="application/json", schema=@Schema(implementation=Token.class))}), @ApiResponse(responseCode="400", description="When there is an error in creating token", content={@Content(mediaType="application/json", schema=@Schema(implementation=Result.class))})})
    @GET
    @Path(value="/{id}/token")
    @Produces(value={"application/json"})
    public Response getTokenV2(@Parameter(description="The id of the stream", required=true) @PathParam(value="id") String streamId, @Parameter(description="The expire time of the token. It's in unix timestamp seconds", required=true) @QueryParam(value="expireDate") long expireDate, @Parameter(description="Type of the token. It may be play or publish ", required=true) @QueryParam(value="type") String type, @Parameter(description="Room Id that token belongs to. It's not mandatory ", required=false) @QueryParam(value="roomId") String roomId) {
        Object result = super.getToken(streamId, expireDate, type, roomId);
        if (result instanceof Token) {
            return Response.status((Response.Status)Response.Status.OK).entity(result).build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(result).build();
    }

    @Operation(description="Generates JWT token for specified stream. It's not required to let the server generate JWT. Generally JWT tokens should be generated on the client side.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Returns token", content={@Content(mediaType="application/json", schema=@Schema(implementation=Token.class))}), @ApiResponse(responseCode="400", description="When there is an error in creating token", content={@Content(mediaType="application/json", schema=@Schema(implementation=Result.class))})})
    @GET
    @Path(value="/{id}/jwt-token")
    @Produces(value={"application/json"})
    public Response getJwtTokenV2(@Parameter(description="The id of the stream", required=true) @PathParam(value="id") String streamId, @Parameter(description="The expire time of the token. It's in unix timestamp seconds.", required=true) @QueryParam(value="expireDate") long expireDate, @Parameter(description="Type of the JWT token. It may be play or publish ", required=true) @QueryParam(value="type") String type, @Parameter(description="Room Id that token belongs to. It's not mandatory ", required=false) @QueryParam(value="roomId") String roomId) {
        Object result = super.getJwtToken(streamId, expireDate, type, roomId);
        if (result instanceof Token) {
            return Response.status((Response.Status)Response.Status.OK).entity(result).build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(result).build();
    }

    @Operation(summary="Perform validation of token for requested stream", description="If validated, success field is true, not validated success field is false", responses={@ApiResponse(responseCode="200", description="Token validation response", content={@Content(mediaType="application/json", schema=@Schema(implementation=Result.class))})})
    @POST
    @Consumes(value={"application/json"})
    @Path(value="/validate-token")
    @Produces(value={"application/json"})
    public Result validateTokenV2(@Parameter(description="Token to be validated", required=true) Token token) {
        boolean result = false;
        Token validateToken = super.validateToken(token);
        if (validateToken != null) {
            result = true;
        }
        return new Result(result);
    }

    @Operation(summary="Removes all tokens related with requested stream", description="", responses={@ApiResponse(responseCode="200", description="Removal of tokens response", content={@Content(mediaType="application/json", schema=@Schema(implementation=Result.class))})})
    @DELETE
    @Consumes(value={"application/json"})
    @Path(value="/{id}/tokens")
    @Produces(value={"application/json"})
    public Result revokeTokensV2(@Parameter(description="the id of the stream", required=true) @PathParam(value="id") String streamId) {
        return super.revokeTokens(streamId);
    }

    @Operation(summary="Get all tokens of requested stream", description="", responses={@ApiResponse(responseCode="200", description="List of tokens", content={@Content(mediaType="application/json", schema=@Schema(implementation=Token.class, type="array"))})})
    @GET
    @Path(value="/{id}/tokens/list/{offset}/{size}")
    @Produces(value={"application/json"})
    public List<Token> listTokensV2(@Parameter(description="the id of the stream", required=true) @PathParam(value="id") String streamId, @Parameter(description="the starting point of the list", required=true) @PathParam(value="offset") int offset, @Parameter(description="size of the return list (max:50 )", required=true) @PathParam(value="size") int size) {
        List<Token> tokens = null;
        if (streamId != null) {
            tokens = this.getDataStore().listAllTokens(streamId, offset, size);
        }
        return tokens;
    }

    @Operation(summary="Get all subscribers of the requested stream", description="It does not return subscriber-stats. Please use subscriber-stats method", responses={@ApiResponse(responseCode="200", description="List of subscribers", content={@Content(mediaType="application/json", schema=@Schema(implementation=Subscriber.class, type="array"))})})
    @GET
    @Path(value="/{id}/subscribers/list/{offset}/{size}")
    @Produces(value={"application/json"})
    public List<Subscriber> listSubscriberV2(@Parameter(description="the id of the stream", required=true) @PathParam(value="id") String streamId, @Parameter(description="the starting point of the list", required=true) @PathParam(value="offset") int offset, @Parameter(description="size of the return list (max:50 )", required=true) @PathParam(value="size") int size) {
        List<Subscriber> subscribers = null;
        if (streamId != null) {
            subscribers = this.getDataStore().listAllSubscribers(streamId, offset, size);
        }
        return subscribers;
    }

    @Operation(summary="Retrieve all subscriber statistics of the requested stream", description="Fetches comprehensive statistics for all subscribers of the specified stream.", responses={@ApiResponse(responseCode="200", description="List of subscriber statistics", content={@Content(mediaType="application/json", schema=@Schema(implementation=SubscriberStats.class, type="array"))})})
    @GET
    @Path(value="/{id}/subscriber-stats/list/{offset}/{size}")
    @Produces(value={"application/json"})
    public List<SubscriberStats> listSubscriberStatsV2(@Parameter(description="the id of the stream", required=true) @PathParam(value="id") String streamId, @Parameter(description="the starting point of the list", required=true) @PathParam(value="offset") int offset, @Parameter(description="size of the return list (max:50 )", required=true) @PathParam(value="size") int size) {
        List<SubscriberStats> subscriberStats = null;
        if (streamId != null) {
            subscriberStats = this.getDataStore().listAllSubscriberStats(streamId, offset, size);
        }
        return subscriberStats;
    }

    @Operation(summary="Add Subscriber to the requested stream", description="Adds a subscriber to the requested stream. If the subscriber's type is 'publish', they can also play the stream, which is critical in conferencing. If the subscriber's type is 'play', they can only play the stream. If 'b32Secret' is not set, it will default to the AppSettings. The length of 'b32Secret' should be a multiple of 8 and use base32 characters A\u2013Z, 2\u20137.", responses={@ApiResponse(responseCode="200", description="Result of adding a subscriber", content={@Content(mediaType="application/json", schema=@Schema(implementation=Result.class))})})
    @POST
    @Consumes(value={"application/json"})
    @Path(value="/{id}/subscribers")
    @Produces(value={"application/json"})
    public Result addSubscriber(@Parameter(description="The id of the stream", required=true) @PathParam(value="id") String streamId, @Parameter(description="Subscriber to be added to this stream", required=true) Subscriber subscriber) {
        boolean result = false;
        String message = "";
        if (subscriber != null && !StringUtils.isBlank((CharSequence)subscriber.getSubscriberId()) && subscriber.getSubscriberId().length() > 3 && StringUtils.isNotBlank((CharSequence)streamId)) {
            subscriber.setStreamId(streamId);
            subscriber.setStats(new SubscriberStats());
            subscriber.setConnected(false);
            subscriber.setCurrentConcurrentConnections(0);
            boolean secretCodeLengthCorrect = true;
            if (StringUtils.isNotBlank((CharSequence)subscriber.getB32Secret())) {
                try {
                    Base32.decode((byte[])subscriber.getB32Secret().getBytes());
                }
                catch (Exception e) {
                    logger.warn("Secret code is not b32 compatible. It will not add subscriber ");
                    secretCodeLengthCorrect = false;
                }
            }
            if (secretCodeLengthCorrect) {
                result = this.getDataStore().addSubscriber(streamId, subscriber);
            } else {
                message = "Secret code is not multiple of 8 bytes length. Use b32Secret which is a string and its lenght is multiple of 8 bytes and allowed characters A-Z, 2-7";
            }
        } else {
            message = "Missing parameter: Make sure you set subscriber object correctly and make subscriberId's length at least 3";
        }
        return new Result(result, message);
    }

    @Operation(description="Return TOTP for the subscriberId, streamId, type. This is a helper method. You can generate TOTP on your end.If subscriberId is not in the database, it generates TOTP from the secret in the AppSettings. Secret code is for the subscriberId not in the database secretCode = Base32.encodeAsString({secretFromSettings(publishsecret or playsecret according to the type)} + {subscriberId} + {streamId} + {type(publish or play)} + {Number of X to have the length multiple of 8}'+' means concatenating the strings. There is no explicit '+' in the secretCode ")
    @GET
    @Consumes(value={"application/json"})
    @Path(value="/{id}/subscribers/{sid}/totp")
    @Produces(value={"application/json"})
    public Result getTOTP(@Parameter(description="The id of the stream that TOTP will be generated", required=true) @PathParam(value="id") String streamId, @Parameter(description="The id of the subscriber that TOTP will be generated ", required=true) @PathParam(value="sid") String subscriberId, @Parameter(description="The type of token. It's being used if subscriber is not in the database. It can be publish, play", required=false) @QueryParam(value="type") String type) {
        boolean result = false;
        String message = "";
        String totp = "";
        if (!StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{streamId, subscriberId})) {
            Subscriber subscriber = this.getDataStore().getSubscriber(streamId, subscriberId);
            if (subscriber != null && StringUtils.isNotBlank((CharSequence)subscriber.getB32Secret())) {
                byte[] decodedSubscriberSecret = Base32.decode((byte[])subscriber.getB32Secret().getBytes());
                totp = TOTPGenerator.generateTOTP(decodedSubscriberSecret, this.getAppSettings().getTimeTokenPeriod(), 6, "HmacSHA1");
            } else {
                String secretFromSettings = this.getAppSettings().getTimeTokenSecretForPublish();
                if ("play".equals(type)) {
                    secretFromSettings = this.getAppSettings().getTimeTokenSecretForPlay();
                }
                if (StringUtils.isNotBlank((CharSequence)secretFromSettings)) {
                    totp = TOTPGenerator.generateTOTP(Base32.decode((byte[])TOTPGenerator.getSecretCodeForNotRecordedSubscriberId(subscriberId, streamId, type, secretFromSettings).getBytes()), this.getAppSettings().getTimeTokenPeriod(), 6, "HmacSHA1");
                } else {
                    message = "Secret is not set in AppSettings. Please set timtokensecret publish or play in Applicaiton settings";
                }
            }
            if (!StringUtils.isBlank((CharSequence)totp)) {
                result = true;
            }
        } else {
            message = "streamId or subscriberId is blank";
        }
        return new Result(result, totp, message);
    }

    @Operation(summary="Delete specific subscriber from data store", description="Deletes a specific subscriber from the data store for the selected stream.", responses={@ApiResponse(responseCode="200", description="Result of deleting the subscriber", content={@Content(mediaType="application/json", schema=@Schema(implementation=Result.class))})})
    @DELETE
    @Consumes(value={"application/json"})
    @Path(value="/{id}/subscribers/{sid}")
    @Produces(value={"application/json"})
    public Result deleteSubscriber(@Parameter(description="the id of the stream", required=true) @PathParam(value="id") String streamId, @Parameter(description="the id of the subscriber", required=true) @PathParam(value="sid") String subscriberId) {
        boolean result = false;
        if (streamId != null) {
            result = this.getDataStore().deleteSubscriber(streamId, subscriberId);
        }
        return new Result(result);
    }

    @Operation(summary="Block specific subscriber", description="Blocks a specific subscriber, enhancing security especially when used with TOTP streaming. The subscriber is blocked for a specified number of seconds from the moment this method is called.", responses={@ApiResponse(responseCode="200", description="Result of blocking the subscriber", content={@Content(mediaType="application/json", schema=@Schema(implementation=Result.class))})})
    @PUT
    @Consumes(value={"application/json"})
    @Path(value="/{id}/subscribers/{sid}/block/{seconds}/{type}")
    @Produces(value={"application/json"})
    public Result blockSubscriber(@Parameter(description="the id of the stream", required=true) @PathParam(value="id") String streamId, @Parameter(description="the id of the subscriber", required=true) @PathParam(value="sid") String subscriberId, @Parameter(description="seconds to block the user", required=true) @PathParam(value="seconds") int seconds, @Parameter(description="block type it can be 'publish', 'play' or 'publish_play'", required=true) @PathParam(value="type") String blockType) {
        boolean result = false;
        String message = "";
        if (!StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{streamId, subscriberId})) {
            result = this.getDataStore().blockSubscriber(streamId, subscriberId, blockType, seconds);
            if ("play".equals(blockType) || "publish_play".equals(blockType)) {
                this.getApplication().stopPlayingBySubscriberId(subscriberId);
            }
            if ("publish".equals(blockType) || "publish_play".equals(blockType)) {
                this.getApplication().stopPublishingBySubscriberId(subscriberId);
            }
        } else {
            message = "streamId or subscriberId is blank";
        }
        return new Result(result, message);
    }

    @Operation(summary="Removes all subscribers related to the requested stream", description="Deletes all subscriber data associated with the specified stream.", responses={@ApiResponse(responseCode="200", description="Result of removing all subscribers", content={@Content(mediaType="application/json", schema=@Schema(implementation=Result.class))})})
    @DELETE
    @Consumes(value={"application/json"})
    @Path(value="/{id}/subscribers")
    @Produces(value={"application/json"})
    public Result revokeSubscribers(@Parameter(description="the id of the stream", required=true) @PathParam(value="id") String streamId) {
        boolean result = false;
        if (streamId != null) {
            result = this.getDataStore().revokeSubscribers(streamId);
        }
        return new Result(result);
    }

    @Override
    @Operation(summary="Get the broadcast live statistics", description="Retrieves live statistics of the broadcast, including total RTMP watcher count, total HLS watcher count, and total WebRTC watcher count.", responses={@ApiResponse(responseCode="200", description="Broadcast live statistics", content={@Content(mediaType="application/json", schema=@Schema(implementation=RestServiceBase.BroadcastStatistics.class))})})
    @GET
    @Path(value="/{id}/broadcast-statistics")
    @Produces(value={"application/json"})
    public RestServiceBase.BroadcastStatistics getBroadcastStatistics(@Parameter(description="the id of the stream", required=true) @PathParam(value="id") String id) {
        return super.getBroadcastStatistics(id);
    }

    @Override
    @Operation(summary="Get total broadcast live statistics", description="Retrieves total live statistics of the broadcast, including total HLS watcher count and total WebRTC watcher count.", responses={@ApiResponse(responseCode="200", description="Total broadcast live statistics", content={@Content(mediaType="application/json", schema=@Schema(implementation=RestServiceBase.BroadcastStatistics.class))})})
    @GET
    @Path(value="/total-broadcast-statistics")
    @Produces(value={"application/json"})
    public RestServiceBase.AppBroadcastStatistics getBroadcastTotalStatistics() {
        return super.getBroadcastTotalStatistics();
    }

    @Operation(summary="Get WebRTC Low Level Send Stats", description="Retrieves general statistics for WebRTC low level send operations.", responses={@ApiResponse(responseCode="200", description="WebRTC low level send statistics", content={@Content(mediaType="application/json", schema=@Schema(implementation=WebRTCSendStats.class))})})
    @GET
    @Path(value="/webrtc-send-low-level-stats")
    @Produces(value={"application/json"})
    public WebRTCSendStats getWebRTCLowLevelSendStats() {
        return new WebRTCSendStats(this.getApplication().getWebRTCAudioSendStats(), this.getApplication().getWebRTCVideoSendStats());
    }

    @Operation(summary="Get WebRTC Low Level Receive Stats", description="Retrieves general statistics for WebRTC low level receive operations.", responses={@ApiResponse(responseCode="200", description="WebRTC low level receive statistics", content={@Content(mediaType="application/json", schema=@Schema(implementation=WebRTCReceiveStats.class))})})
    @GET
    @Path(value="/webrtc-receive-low-level-stats")
    @Produces(value={"application/json"})
    public WebRTCReceiveStats getWebRTCLowLevelReceiveStats() {
        return new WebRTCReceiveStats(this.getApplication().getWebRTCAudioReceiveStats(), this.getApplication().getWebRTCVideoReceiveStats());
    }

    @Operation(summary="Get RTMP to WebRTC Path Stats", description="Retrieves general statistics for the RTMP to WebRTC path.", responses={@ApiResponse(responseCode="200", description="RTMP to WebRTC path statistics", content={@Content(mediaType="application/json", schema=@Schema(implementation=RTMPToWebRTCStats.class))})})
    @GET
    @Path(value="/{id}/rtmp-to-webrtc-stats")
    @Produces(value={"application/json"})
    public RTMPToWebRTCStats getRTMPToWebRTCStats(@Parameter(description="the id of the stream", required=true) @PathParam(value="id") String id) {
        return this.getApplication().getRTMPToWebRTCStats(id);
    }

    @Operation(summary="Get WebRTC Client Statistics", description="Retrieves WebRTC client statistics, including audio bitrate, video bitrate, target bitrate, video sent period, etc.", responses={@ApiResponse(responseCode="200", description="WebRTC client statistics", content={@Content(mediaType="application/json", schema=@Schema(implementation=WebRTCClientStats.class, type="array"))})})
    @GET
    @Path(value="/{stream_id}/webrtc-client-stats/{offset}/{size}")
    @Produces(value={"application/json"})
    public List<WebRTCClientStats> getWebRTCClientStatsListV2(@Parameter(description="offset of the list", required=true) @PathParam(value="offset") int offset, @Parameter(description="Number of items that will be fetched", required=true) @PathParam(value="size") int size, @Parameter(description="the id of the stream", required=true) @PathParam(value="stream_id") String streamId) {
        return super.getWebRTCClientStatsList(offset, size, streamId);
    }

    @Hidden
    @Deprecated
    @Operation(summary="Returns filtered broadcast list according to type", description="Useful for retrieving IP Camera and Stream Sources from the entire broadcast list. For sorting mechanisms, using Mongo DB is recommended.", responses={@ApiResponse(responseCode="200", description="Filtered broadcast list", content={@Content(mediaType="application/json", schema=@Schema(implementation=Broadcast.class, type="array"))})})
    @GET
    @Consumes(value={"application/json"})
    @Path(value="/filter-list/{offset}/{size}/{type}")
    @Produces(value={"application/json"})
    public List<Broadcast> filterBroadcastListV2(@Parameter(description="starting point of the list", required=true) @PathParam(value="offset") int offset, @Parameter(description="size of the return list (max:50 )", required=true) @PathParam(value="size") int size, @Parameter(description="type of the stream. Possible values are \"liveStream\", \"ipCamera\", \"streamSource\", \"VoD\"", required=true) @PathParam(value="type") String type, @Parameter(description="field to sort", required=false) @QueryParam(value="sort_by") String sortBy, @Parameter(description="asc for Ascending, desc Descending order", required=false) @QueryParam(value="order_by") String orderBy) {
        return this.getDataStore().getBroadcastList(offset, size, type, sortBy, orderBy, null);
    }

    @Operation(summary="Set stream specific recording setting", description="This setting overrides the general Mp4 and WebM Muxing Setting for a specific stream.", responses={@ApiResponse(responseCode="200", description="Result of setting stream specific recording", content={@Content(mediaType="application/json", schema=@Schema(implementation=Result.class))})})
    @PUT
    @Consumes(value={"application/json"})
    @Path(value="/{id}/recording/{recording-status}")
    @Produces(value={"application/json"})
    public Result enableRecording(@Parameter(description="the id of the stream", required=true) @PathParam(value="id") String streamId, @Parameter(description="Change recording status. If true, starts recording. If false stop recording", required=true) @PathParam(value="recording-status") boolean enableRecording, @Parameter(description="Record type: 'mp4' or 'webm'. It's optional parameter.", required=false) @QueryParam(value="recordType") String recordType, @Parameter(description="Resolution height of the broadcast that is wanted to record. ", required=false) @QueryParam(value="resolutionHeight") int resolutionHeight) {
        if (logger.isInfoEnabled()) {
            logger.info("Recording method is called for {} to make it {} and record Type: {} resolution:{}", new Object[]{streamId.replaceAll(REPLACE_CHARS, "_"), enableRecording, recordType != null ? recordType.replaceAll(REPLACE_CHARS, "_") : null, resolutionHeight});
        }
        recordType = recordType == null ? RecordType.MP4.toString() : recordType;
        return this.enableRecordMuxing(streamId, enableRecording, recordType, resolutionHeight);
    }

    @Operation(summary="Get IP Camera Error after connection failure", description="Checks for an error after a connection failure with an IP camera. Returning true indicates an error; false indicates no error.", responses={@ApiResponse(responseCode="200", description="IP Camera error status", content={@Content(mediaType="application/json", schema=@Schema(implementation=Result.class))})})
    @GET
    @Consumes(value={"application/json"})
    @Path(value="/{streamId}/ip-camera-error")
    @Produces(value={"application/json"})
    public Result getCameraErrorV2(@Parameter(description="StreamId of the IP Camera Streaming.", required=true) @PathParam(value="streamId") String streamId) {
        return super.getCameraErrorById(streamId);
    }

    @Operation(summary="Start streaming sources", description="Initiates streaming for sources such as IP Cameras, Stream Sources, and PlayLists.", responses={@ApiResponse(responseCode="200", description="Result of starting streaming sources", content={@Content(mediaType="application/json", schema=@Schema(implementation=Result.class))})})
    @POST
    @Consumes(value={"application/json"})
    @Path(value="/{id}/start")
    @Produces(value={"application/json"})
    public Result startStreamSourceV2(@Parameter(description="the id of the stream. The broadcast type should be IP Camera or Stream Source otherwise it does not work", required=true) @PathParam(value="id") String id) {
        return super.startStreamSource(id);
    }

    @Override
    @Operation(summary="Specify the next playlist item to play by index", description="Sets the next playlist item to be played, based on its index. This method is applicable only to playlists.", responses={@ApiResponse(responseCode="200", description="Result of specifying the next playlist item", content={@Content(mediaType="application/json", schema=@Schema(implementation=Result.class))})})
    @POST
    @Consumes(value={"application/json"})
    @Path(value="/playlists/{id}/next")
    @Produces(value={"application/json"})
    public Result playNextItem(@Parameter(description="The id of the playlist stream.", required=true) @PathParam(value="id") String id, @Parameter(description="The next item to play. If it's not specified or it's -1, it plays next item. If it's number, it skips that item in the playlist to play. The first item index is 0. ", required=false) @QueryParam(value="index") Integer index) {
        return super.playNextItem(id, index);
    }

    @Operation(summary="Stop streaming for the active stream", description="Terminates streaming for the active stream, including both ingested (RTMP, WebRTC) and pulled stream sources (IP Cameras and Stream Sources).", responses={@ApiResponse(responseCode="200", description="Result of stopping the active stream", content={@Content(mediaType="application/json", schema=@Schema(implementation=Result.class))})})
    @POST
    @Consumes(value={"application/json"})
    @Path(value="/{id}/stop")
    @Produces(value={"application/json"})
    public Result stopStreamingV2(@Parameter(description="the id of the broadcast.", required=true) @PathParam(value="id") String id) {
        return super.stopStreaming(id);
    }

    @Operation(summary="Get Discovered ONVIF IP Cameras", description="Performs a discovery within the internal network to automatically retrieve information about ONVIF-enabled cameras.", responses={@ApiResponse(responseCode="200", description="Result of discovering ONVIF IP cameras", content={@Content(mediaType="application/json", schema=@Schema(implementation=Result.class))})})
    @GET
    @Path(value="/onvif-devices")
    @Produces(value={"application/json"})
    public String[] searchOnvifDevicesV2() {
        return super.searchOnvifDevices();
    }

    @Override
    @Operation(summary="Get the Profile List for an ONVIF IP Camera", description="Retrieves the profile list for an ONVIF IP camera.", responses={@ApiResponse(responseCode="200", description="Profile list for the ONVIF IP camera", content={@Content(mediaType="application/json", schema=@Schema(implementation=String[].class))})})
    @GET
    @Path(value="/{id}/ip-camera/device-profiles")
    @Produces(value={"application/json"})
    public String[] getOnvifDeviceProfiles(@Parameter(description="The id of the IP Camera", required=true) @PathParam(value="id") String id) {
        if (id != null && StreamIdValidator.isStreamIdValid(id)) {
            return super.getOnvifDeviceProfiles(id);
        }
        return null;
    }

    @Operation(summary="Move IP Camera", description="Supports continuous, relative, and absolute movement. By default, it's a relative move. Movement parameters should be provided according to the movement type. Generally, the following values are used: For Absolute move, value X and value Y are between -1.0f and 1.0f. Zoom value is between 0.0f and 1.0f. For Relative move, value X, value Y, and Zoom Value are between -1.0f and 1.0f. For Continuous move, value X, value Y, and Zoom Value are between -1.0f and 1.0f.", responses={@ApiResponse(responseCode="200", description="Result of moving the IP camera", content={@Content(mediaType="application/json", schema=@Schema(implementation=Result.class))})})
    @POST
    @Path(value="/{id}/ip-camera/move")
    @Produces(value={"application/json"})
    public Result moveIPCamera(@Parameter(description="The id of the IP Camera", required=true) @PathParam(value="id") String id, @Parameter(description="Movement in X direction. If not specified, it's assumed to be zero. Valid ranges between -1.0f and 1.0f for all movements ", required=false) @QueryParam(value="valueX") Float valueX, @Parameter(description="Movement in Y direction. If not specified, it's assumed to be zero. Valid ranges between -1.0f and 1.0f for all movements ", required=false) @QueryParam(value="valueY") Float valueY, @Parameter(description="Movement in Zoom. If not specified, it's assumed to be zero. Valid ranges for relative and continous move is between -1.0f and 1.0f. For absolute move between 0.0f and 1.0f ", required=false) @QueryParam(value="valueZ") Float valueZ, @Parameter(description="Movement type. It can be absolute, relative or continuous. If not specified, it's relative", required=false) @QueryParam(value="movement") String movement) {
        boolean result = false;
        Object message = STREAM_ID_NOT_VALID;
        if (id != null && StreamIdValidator.isStreamIdValid(id)) {
            message = "";
            if (valueX == null) {
                valueX = Float.valueOf(0.0f);
            }
            if (valueY == null) {
                valueY = Float.valueOf(0.0f);
            }
            if (valueZ == null) {
                valueZ = Float.valueOf(0.0f);
            }
            if (movement == null) {
                movement = RELATIVE_MOVE;
            }
            if (movement.equals(RELATIVE_MOVE)) {
                result = super.moveRelative(id, valueX.floatValue(), valueY.floatValue(), valueZ.floatValue());
            } else if (movement.equals(CONTINUOUS_MOVE)) {
                result = super.moveContinous(id, valueX.floatValue(), valueY.floatValue(), valueZ.floatValue());
            } else if (movement.equals(ABSOLUTE_MOVE)) {
                result = super.moveAbsolute(id, valueX.floatValue(), valueY.floatValue(), valueZ.floatValue());
            } else {
                message = "Movement type is not supported. Supported types are continous, relative and absolute but was " + movement;
            }
        }
        return new Result(result, (String)message);
    }

    @Operation(description="Stop move for IP Camera")
    @POST
    @Path(value="/{id}/ip-camera/stop-move")
    @Produces(value={"application/json"})
    public Result stopMove(@Parameter(description="the id of the IP Camera", required=true) @PathParam(value="id") String id) {
        boolean result = false;
        String message = STREAM_ID_NOT_VALID;
        if (id != null && StreamIdValidator.isStreamIdValid(id)) {
            OnvifCamera camera = this.getApplication().getOnvifCamera(id);
            if (camera != null) {
                result = camera.moveStop();
                message = "";
            } else {
                message = "Camera not found";
            }
        }
        return new Result(result, message);
    }

    @Operation(description="Creates a conference room with the parameters. The room name is key so if this is called with the same room name then new room is overwritten to old one")
    @ApiResponses(value={@ApiResponse(responseCode="400", description="If the operation is not completed for any reason", content={@Content(mediaType="application/json", schema=@Schema(implementation=Result.class))}), @ApiResponse(responseCode="200", description="Returns the created conference room", content={@Content(mediaType="application/json", schema=@Schema(implementation=ConferenceRoom.class))})})
    @POST
    @Consumes(value={"application/json"})
    @Path(value="/conference-rooms")
    @Produces(value={"application/json"})
    @Hidden
    @Deprecated(since="2.9.1", forRemoval=true)
    public Response createConferenceRoomV2(@Parameter(description="Conference Room object with start and end date", required=true) ConferenceRoom room) {
        try {
            Broadcast broadcast;
            if (room.getStartDate() == 0L) {
                room.setStartDate(Instant.now().getEpochSecond());
            }
            if (room.getEndDate() == 0L) {
                room.setEndDate(Instant.now().getEpochSecond() + 3600L);
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{room.getRoomId()}) && (broadcast = this.getDataStore().get(room.getRoomId())) != null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new Result(false, "Stream id is already being used. Please change stream id or keep it empty")).build();
            }
            broadcast = DataStore.conferenceToBroadcast(room);
            if (this.getDataStore().save(broadcast) != null) {
                ConferenceRoom confRoom = DataStore.broadcastToConference(this.getDataStore().get(broadcast.getStreamId()));
                return Response.status((Response.Status)Response.Status.OK).entity((Object)confRoom).build();
            }
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new Result(false, "Operation not completed")).build();
    }

    @Operation(description="Edits previously saved conference room")
    @ApiResponses(value={@ApiResponse(responseCode="400", description="If the operation is not completed for any reason", content={@Content(mediaType="application/json", schema=@Schema(implementation=Result.class))}), @ApiResponse(responseCode="200", description="Returns the updated Conference room", content={@Content(mediaType="application/json", schema=@Schema(implementation=ConferenceRoom.class))})})
    @PUT
    @Consumes(value={"application/json"})
    @Path(value="/conference-rooms/{room_id}")
    @Produces(value={"application/json"})
    @Hidden
    @Deprecated(since="2.9.1", forRemoval=true)
    public Response editConferenceRoom(@Parameter(description="Room id") @PathParam(value="room_id") String roomId, @Parameter(description="Conference Room object with start and end date", required=true) ConferenceRoom room) {
        if (room != null) {
            try {
                Broadcast conferenceToBroadcast = DataStore.conferenceToBroadcast(room);
                if (this.getDataStore().updateBroadcastFields(roomId, conferenceToBroadcast)) {
                    return Response.status((Response.Status)Response.Status.OK).entity((Object)room).build();
                }
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new Result(false, "Operation not completed")).build();
    }

    @Operation(summary="Delete a conference room", description="Deletes a conference room. The room ID is the key, so if this is called with the same room ID, then the new room overwrites the old one.", responses={@ApiResponse(responseCode="200", description="Result of deleting the conference room", content={@Content(mediaType="application/json", schema=@Schema(implementation=Result.class))})})
    @DELETE
    @Consumes(value={"application/json"})
    @Path(value="/conference-rooms/{room_id}")
    @Produces(value={"application/json"})
    @Hidden
    @Deprecated(since="2.9.1", forRemoval=true)
    public Result deleteConferenceRoomV2(@Parameter(description="the id of the conference room", required=true) @PathParam(value="room_id") String roomId) {
        return this.deleteBroadcast(roomId);
    }

    @Operation(summary="Add a subtrack to a main track (broadcast)", description="Adds a subtrack to a main track (broadcast).", responses={@ApiResponse(responseCode="200", description="Result of adding a subtrack", content={@Content(mediaType="application/json", schema=@Schema(implementation=Result.class))})})
    @POST
    @Consumes(value={"application/json"})
    @Path(value="/{id}/subtrack")
    @Produces(value={"application/json"})
    public Result addSubTrack(@Parameter(description="Broadcast id(main track)", required=true) @PathParam(value="id") String id, @Parameter(description="Subtrack Stream Id", required=true) @QueryParam(value="id") String subTrackId) {
        Result result = RestServiceBase.addSubTrack(id, subTrackId, this.getDataStore());
        if (result.isSuccess()) {
            this.getApplication().joinedTheRoom(id, subTrackId);
        }
        return result;
    }

    @Operation(summary="Delete a subtrack from a main track (broadcast)", description="Deletes a subtrack from a main track (broadcast).", responses={@ApiResponse(responseCode="200", description="Result of deleting a subtrack", content={@Content(mediaType="application/json", schema=@Schema(implementation=Result.class))})})
    @DELETE
    @Consumes(value={"application/json"})
    @Path(value="/{id}/subtrack")
    @Produces(value={"application/json"})
    public Result removeSubTrack(@Parameter(description="Broadcast id(main track)", required=true) @PathParam(value="id") String id, @Parameter(description="Subtrack Stream Id", required=true) @QueryParam(value="id") String subTrackId) {
        Result result = RestServiceBase.removeSubTrack(id, subTrackId, this.getDataStore());
        if (result.isSuccess()) {
            this.getApplication().leftTheRoom(id, subTrackId);
        }
        return result;
    }

    @Operation(summary="Get stream information", description="Returns the stream information including width, height, bitrates, and video codec.", responses={@ApiResponse(responseCode="200", description="Stream information", content={@Content(mediaType="application/json", schema=@Schema(implementation=BasicStreamInfo[].class))})})
    @GET
    @Consumes(value={"application/json"})
    @Path(value="/{id}/stream-info")
    @Produces(value={"application/json"})
    public BasicStreamInfo[] getStreamInfo(@PathParam(value="id") String streamId) {
        List<IStreamInfo> streamInfoList;
        boolean isCluster = this.getAppContext().containsBean("tomcat.cluster");
        if (isCluster) {
            streamInfoList = this.getDataStore().getStreamInfoList(streamId);
        } else {
            IWebRTCAdaptor webRTCAdaptor = (IWebRTCAdaptor)this.getAppContext().getBean("webrtc.adaptor");
            streamInfoList = webRTCAdaptor.getStreamInfo(streamId);
        }
        BasicStreamInfo[] basicStreamInfo = new BasicStreamInfo[]{};
        if (streamInfoList != null) {
            basicStreamInfo = new BasicStreamInfo[streamInfoList.size()];
            for (int i = 0; i < basicStreamInfo.length; ++i) {
                IStreamInfo iStreamInfo = streamInfoList.get(i);
                basicStreamInfo[i] = new BasicStreamInfo(iStreamInfo.getVideoHeight(), iStreamInfo.getVideoWidth(), iStreamInfo.getVideoBitrate(), iStreamInfo.getAudioBitrate(), iStreamInfo.getVideoCodec());
            }
        }
        return basicStreamInfo;
    }

    @Operation(summary="Send message to stream participants via Data Channel", description="Sends a message to stream participants through the Data Channel in a WebRTC stream.", responses={@ApiResponse(responseCode="200", description="Result of sending the message", content={@Content(mediaType="application/json", schema=@Schema(implementation=Result.class))})})
    @POST
    @Consumes(value={"application/json"})
    @Path(value="/{id}/data")
    @Produces(value={"application/json"})
    public Result sendMessage(@Parameter(description="Message through Data Channel which will be sent to all WebRTC stream participants", required=true) String message, @Parameter(description="Broadcast id", required=true) @PathParam(value="id") String id) {
        return RestServiceBase.sendDataChannelMessage(id, message, this.getApplication(), this.getDataStore());
    }

    @Operation(description="Gets the conference room list from database")
    @GET
    @Path(value="/conference-rooms/list/{offset}/{size}")
    @Produces(value={"application/json"})
    @Hidden
    @Deprecated(since="2.9.1", forRemoval=true)
    public List<ConferenceRoom> getConferenceRoomList(@Parameter(description="This is the offset of the list, it is useful for pagination. If you want to use sort mechanism, we recommend using Mongo DB.", required=true) @PathParam(value="offset") int offset, @Parameter(description="Number of items that will be fetched. If there is not enough item in the datastore, returned list size may less then this value", required=true) @PathParam(value="size") int size, @Parameter(description="field to sort", required=false) @QueryParam(value="sort_by") String sortBy, @Parameter(description="asc for Ascending, desc Descending order", required=false) @QueryParam(value="order_by") String orderBy, @Parameter(description="Search parameter, returns specific items that contains search string", required=false) @QueryParam(value="search") String search) {
        List<Broadcast> broadcastList = this.getDataStore().getBroadcastList(offset, size, null, sortBy, orderBy, search);
        ArrayList<ConferenceRoom> conferenceRoomList = new ArrayList<ConferenceRoom>();
        for (Broadcast broadcast : broadcastList) {
            conferenceRoomList.add(DataStore.broadcastToConference(broadcast));
        }
        return conferenceRoomList;
    }

    @Operation(description="Get conference room object")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Return the ConferenceRoom object", content={@Content(mediaType="application/json", schema=@Schema(implementation=ConferenceRoom.class))}), @ApiResponse(responseCode="404", description="ConferenceRoom object not found")})
    @GET
    @Path(value="/conference-rooms/{roomId}")
    @Produces(value={"application/json"})
    @Hidden
    public Response getConferenceRoom(@Parameter(description="id of the room", required=true) @PathParam(value="roomId") String id) {
        Broadcast broadcast;
        ConferenceRoom room = null;
        if (id != null && (broadcast = this.getDataStore().get(id)) != null) {
            room = DataStore.broadcastToConference(broadcast);
        }
        if (room != null) {
            return Response.status((Response.Status)Response.Status.OK).entity(room).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @Operation(summary="Get stream IDs in the room", description="Returns the stream IDs in the room.", responses={@ApiResponse(responseCode="200", description="List of stream IDs", content={@Content(mediaType="application/json", schema=@Schema(implementation=String.class, type="array"))})})
    @GET
    @Consumes(value={"application/json"})
    @Path(value="/conference-rooms/{room_id}/room-info")
    @Produces(value={"application/json"})
    @Hidden
    @Deprecated(since="2.9.1", forRemoval=true)
    public RootRestService.RoomInfo getRoomInfo(@Parameter(description="Room id", required=true) @PathParam(value="room_id") String roomId, @Parameter(description="If Stream Id is entered, that stream id will be isolated from the result", required=false) @QueryParam(value="streamId") String streamId) {
        RootRestService.RoomInfo roomInfo = new RootRestService.RoomInfo(roomId, null);
        if (StringUtils.isNotBlank((CharSequence)roomId)) {
            Broadcast broadcastRoom = this.getDataStore().get(roomId);
            if (broadcastRoom == null) {
                roomId = roomId.replaceAll(REPLACE_CHARS, "_");
                logger.warn("Room not found with id: {}", (Object)roomId);
            } else {
                roomInfo = new RootRestService.RoomInfo(roomId, RestServiceBase.getRoomInfoFromConference(broadcastRoom, streamId, this.getDataStore()));
                roomInfo.setStartDate(broadcastRoom.getPlannedStartDate());
                roomInfo.setEndDate(broadcastRoom.getPlannedEndDate());
            }
        }
        return roomInfo;
    }

    @Operation(summary="Add stream to the room", description="Adds the specified stream with stream ID to the room. Use PUT conference-rooms/{room_id}/{streamId}.", responses={@ApiResponse(responseCode="200", description="Result of adding the stream", content={@Content(mediaType="application/json", schema=@Schema(implementation=Result.class))})})
    @PUT
    @Consumes(value={"application/json"})
    @Path(value="/conference-rooms/{room_id}/add")
    @Produces(value={"application/json"})
    @Hidden
    @Deprecated(since="2.6.2", forRemoval=true)
    public Result addStreamToTheRoomDeprecated(@Parameter(description="Room id", required=true) @PathParam(value="room_id") String roomId, @Parameter(description="Stream id to add to the conference room", required=true) @QueryParam(value="streamId") String streamId) {
        return this.addSubTrack(roomId, streamId);
    }

    @Operation(summary="Add stream to the room", description="Adds the specified stream with stream ID to the room.", responses={@ApiResponse(responseCode="200", description="Result of adding the stream", content={@Content(mediaType="application/json", schema=@Schema(implementation=Result.class))})})
    @PUT
    @Consumes(value={"application/json"})
    @Path(value="/conference-rooms/{room_id}/{streamId}")
    @Produces(value={"application/json"})
    @Hidden
    @Deprecated(since="2.9.1", forRemoval=true)
    public Result addStreamToTheRoom(@Parameter(description="Room id", required=true) @PathParam(value="room_id") String roomId, @Parameter(description="Stream id to add to the conference room", required=true) @PathParam(value="streamId") String streamId) {
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{roomId, streamId})) {
            return this.addSubTrack(roomId, streamId);
        }
        return new Result(false, "Room id or stream id is empty");
    }

    @Operation(summary="Delete stream from the room", description="Deletes the specified stream correlated with stream ID in the room. Use DELETE /conference-rooms/{room_id}/{streamId}.", responses={@ApiResponse(responseCode="200", description="Result of deleting the stream")})
    @PUT
    @Consumes(value={"application/json"})
    @Path(value="/conference-rooms/{room_id}/delete")
    @Produces(value={"application/json"})
    @Hidden
    @Deprecated(since="2.6.2", forRemoval=true)
    public Result deleteStreamFromTheRoomDeprecated(@Parameter(description="Room id", required=true) @PathParam(value="room_id") String roomId, @Parameter(description="Stream id to delete from the conference room", required=true) @QueryParam(value="streamId") String streamId) {
        return this.removeSubTrack(roomId, streamId);
    }

    @Operation(description="Deletes the specified stream correlated with streamId in the room. Use removeSubTrack directly")
    @DELETE
    @Consumes(value={"application/json"})
    @Path(value="/conference-rooms/{room_id}/{streamId}")
    @Produces(value={"application/json"})
    @Hidden
    @Deprecated(since="2.9.1", forRemoval=true)
    public Result deleteStreamFromTheRoom(@Parameter(description="Room id", required=true) @PathParam(value="room_id") String roomId, @Parameter(description="Stream id to delete from the conference room", required=true) @PathParam(value="streamId") String streamId) {
        return this.removeSubTrack(roomId, streamId);
    }

    @Hidden
    @Deprecated(since="2.7.0", forRemoval=true)
    @GET
    @Path(value="/webrtc-viewers/list/{offset}/{size}")
    @Produces(value={"application/json"})
    public List<WebRTCViewerInfo> getWebRTCViewerList(@Parameter(description="This is the offset of the list, it is useful for pagination. If you want to use sort mechanism, we recommend using Mongo DB.", required=true) @PathParam(value="offset") int offset, @Parameter(description="Number of items that will be fetched. If there is not enough item in the datastore, returned list size may less then this value", required=true) @PathParam(value="size") int size, @Parameter(description="field to sort", required=false) @QueryParam(value="sort_by") String sortBy, @Parameter(description="asc for Ascending, desc Descending order", required=false) @QueryParam(value="order_by") String orderBy, @Parameter(description="Search parameter, returns specific items that contains search string", required=false) @QueryParam(value="search") String search) {
        return this.getDataStore().getWebRTCViewerList(offset, size, sortBy, orderBy, search);
    }

    @Hidden
    @Deprecated(since="2.7.0", forRemoval=true)
    @Operation(description="Stop player with a specified id")
    @POST
    @Consumes(value={"application/json"})
    @Path(value="/webrtc-viewers/{webrtc-viewer-id}/stop")
    @Produces(value={"application/json"})
    public Result stopPlaying(@Parameter(description="the id of the webrtc viewer.", required=true) @PathParam(value="webrtc-viewer-id") String viewerId) {
        boolean result = this.getApplication().stopPlaying(viewerId);
        return new Result(result);
    }

    @Operation(description="Add ID3 data to HLS stream at the moment")
    @POST
    @Consumes(value={"application/json"})
    @Path(value="/{stream_id}/id3")
    @Produces(value={"application/json"})
    public Result addID3Data(@Parameter(description="the id of the stream", required=true) @PathParam(value="stream_id") String streamId, @Parameter(description="ID3 data.", required=false) String data) {
        if (!this.getAppSettings().isId3TagEnabled()) {
            return new Result(false, null, "ID3 tag is not enabled");
        }
        MuxAdaptor muxAdaptor = this.getMuxAdaptor(streamId);
        if (muxAdaptor != null) {
            return new Result(muxAdaptor.addID3Data(data));
        }
        return new Result(false, null, "Stream is not available");
    }

    @Operation(description="Add SEI data to HLS stream at the moment")
    @POST
    @Consumes(value={"application/json"})
    @Path(value="/{stream_id}/sei")
    @Produces(value={"application/json"})
    public Result addSEIData(@Parameter(description="the id of the stream", required=true) @PathParam(value="stream_id") String streamId, @Parameter(description="SEI data.", required=false) String data) {
        MuxAdaptor muxAdaptor = this.getMuxAdaptor(streamId);
        if (muxAdaptor != null) {
            return new Result(muxAdaptor.addSEIData(data));
        }
        return new Result(false, null, "Stream is not available");
    }

    @Schema(description="Simple generic statistics class to return single values")
    public static class SimpleStat {
        @Schema(description="the stat value")
        public long number;

        public SimpleStat(long number) {
            this.number = number;
        }

        public long getNumber() {
            return this.number;
        }
    }

    @Schema(description="Aggregation of WebRTC Low Level Send Stats")
    public static class WebRTCSendStats {
        @Schema(description="Audio send stats")
        private final WebRTCAudioSendStats audioSendStats;
        @Schema(description="Video send stats")
        private final WebRTCVideoSendStats videoSendStats;

        public WebRTCSendStats(WebRTCAudioSendStats audioSendStats, WebRTCVideoSendStats videoSendStats) {
            this.audioSendStats = audioSendStats;
            this.videoSendStats = videoSendStats;
        }

        public WebRTCVideoSendStats getVideoSendStats() {
            return this.videoSendStats;
        }

        public WebRTCAudioSendStats getAudioSendStats() {
            return this.audioSendStats;
        }
    }

    @Schema(description="Aggregation of WebRTC Low Level Receive Stats")
    public static class WebRTCReceiveStats {
        @Schema(description="Audio receive stats")
        private final WebRTCAudioReceiveStats audioReceiveStats;
        @Schema(description="Video receive stats")
        private final WebRTCVideoReceiveStats videoReceiveStats;

        public WebRTCReceiveStats(WebRTCAudioReceiveStats audioReceiveStats, WebRTCVideoReceiveStats videoReceiveStats) {
            this.audioReceiveStats = audioReceiveStats;
            this.videoReceiveStats = videoReceiveStats;
        }

        public WebRTCVideoReceiveStats getVideoReceiveStats() {
            return this.videoReceiveStats;
        }

        public WebRTCAudioReceiveStats getAudioReceiveStats() {
            return this.audioReceiveStats;
        }
    }
}

