/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.rest;

import io.antmedia.AntMediaApplicationAdapter;
import io.antmedia.AppSettings;
import io.antmedia.RecordType;
import io.antmedia.datastore.db.DataStore;
import io.antmedia.datastore.db.DataStoreFactory;
import io.antmedia.datastore.db.types.Broadcast;
import io.antmedia.datastore.db.types.Endpoint;
import io.antmedia.datastore.db.types.TensorFlowObject;
import io.antmedia.datastore.db.types.Token;
import io.antmedia.datastore.db.types.VoD;
import io.antmedia.ipcamera.OnvifCamera;
import io.antmedia.ipcamera.onvifdiscovery.OnvifDiscovery;
import io.antmedia.muxer.Mp4Muxer;
import io.antmedia.muxer.MuxAdaptor;
import io.antmedia.muxer.Muxer;
import io.antmedia.muxer.RecordMuxer;
import io.antmedia.rest.WebRTCClientStats;
import io.antmedia.rest.model.Result;
import io.antmedia.rest.model.Version;
import io.antmedia.security.ITokenService;
import io.antmedia.settings.ServerSettings;
import io.antmedia.statistic.DashViewerStats;
import io.antmedia.statistic.HlsViewerStats;
import io.antmedia.statistic.IStatsCollector;
import io.antmedia.storage.StorageClient;
import io.antmedia.streamsource.StreamFetcher;
import io.antmedia.webrtc.api.IWebRTCAdaptor;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.servlet.ServletContext;
import jakarta.ws.rs.core.Context;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.red5.server.api.scope.IBroadcastScope;
import org.red5.server.api.scope.IScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public abstract class RestServiceBase {
    private static final String MAIN_TRACK_OF_THE_STREAM = "Main track of the stream ";
    public static final String REPLACE_CHARS_FOR_SECURITY = "[\n\r]";
    public static final String BUILD_NUMBER = "Build-Number";
    public static final String ENTERPRISE_EDITION = "Enterprise Edition";
    public static final String COMMUNITY_EDITION = "Community Edition";
    public static final int MAX_ITEM_IN_ONE_LIST = 50;
    public static final int ERROR_SOCIAL_ENDPOINT_UNDEFINED_CLIENT_ID = -1;
    public static final int ERROR_SOCIAL_ENDPOINT_UNDEFINED_ENDPOINT = -2;
    public static final int ERROR_SOCIAL_ENDPOINT_EXCEPTION_IN_ASKING_AUTHPARAMS = -3;
    public static final int RECORD_ENABLE = 1;
    public static final int RECORD_DISABLE = -1;
    public static final int RECORD_NO_SET = 0;
    public static final int HIGH_CPU_ERROR = -3;
    public static final int FETCHER_NOT_STARTED_ERROR = -4;
    public static final int INVALID_STREAM_NAME_ERROR = -5;
    public static final String HTTP = "http://";
    public static final String RTSP = "rtsp://";
    public static final String ENDPOINT_GENERIC = "generic";
    protected static Logger logger = LoggerFactory.getLogger(RestServiceBase.class);
    private ProcessBuilderFactory processBuilderFactory = null;
    public static final String IPV4_REGEX = "(([0-1]?[0-9]{1,2}\\.)|(2[0-4][0-9]\\.)|(25[0-5]\\.)){3}(([0-1]?[0-9]{1,2})|(2[0-4][0-9])|(25[0-5]))";
    public static final String LOOPBACK_REGEX = "^localhost$|^127(?:\\.[0-9]+){0,2}\\.[0-9]+$|^(?:0*\\:)*?:?0*1$";
    private static final String REPLACE_CHARS = "[\n|\r|\t]";
    @Context
    protected ServletContext servletContext;
    protected DataStoreFactory dataStoreFactory;
    private DataStore dbStore;
    protected ApplicationContext appCtx;
    protected IScope scope;
    protected AntMediaApplicationAdapter appInstance;
    private AppSettings appSettings;
    private ServerSettings serverSettings;

    public void setAppCtx(ApplicationContext appCtx) {
        this.appCtx = appCtx;
    }

    @Nullable
    public ApplicationContext getAppContext() {
        if (this.servletContext != null) {
            this.appCtx = (ApplicationContext)this.servletContext.getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
        }
        return this.appCtx;
    }

    public void setApplication(AntMediaApplicationAdapter app) {
        this.appInstance = app;
    }

    public AntMediaApplicationAdapter getApplication() {
        ApplicationContext appContext;
        if (this.appInstance == null && (appContext = this.getAppContext()) != null) {
            this.appInstance = (AntMediaApplicationAdapter)appContext.getBean("web.handler");
        }
        return this.appInstance;
    }

    public IScope getScope() {
        if (this.scope == null) {
            this.scope = this.getApplication().getScope();
        }
        return this.scope;
    }

    public void setScope(IScope scope) {
        this.scope = scope;
    }

    public DataStore getDataStore() {
        if (this.dbStore == null) {
            this.dbStore = this.getDataStoreFactory().getDataStore();
        }
        return this.dbStore;
    }

    public void setDataStore(DataStore dataStore) {
        this.dbStore = dataStore;
    }

    public DataStoreFactory getDataStoreFactory() {
        WebApplicationContext ctxt;
        if (this.dataStoreFactory == null && (ctxt = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.servletContext)) != null) {
            this.dataStoreFactory = (DataStoreFactory)ctxt.getBean("dataStoreFactory");
        }
        return this.dataStoreFactory;
    }

    public void setDataStoreFactory(DataStoreFactory dataStoreFactory) {
        this.dataStoreFactory = dataStoreFactory;
    }

    public Broadcast createBroadcastWithStreamID(Broadcast broadcast) {
        Broadcast createdBroadcast = RestServiceBase.saveBroadcast(broadcast, "created", this.getScope().getName(), this.getDataStore(), this.getAppSettings().getListenerHookURL(), this.getServerSettings(), 0L);
        if ("playlist".equals(createdBroadcast.getType())) {
            long now = System.currentTimeMillis();
            this.getApplication().schedulePlayList(now, createdBroadcast);
        }
        return createdBroadcast;
    }

    public static Broadcast saveBroadcast(Broadcast broadcast, String status, String scopeName, DataStore dataStore, String settingsListenerHookURL, ServerSettings serverSettings, long absoluteStartTimeMs) {
        String fqdn;
        if (broadcast == null) {
            broadcast = new Broadcast();
        }
        broadcast.setStatus(status);
        broadcast.setDate(System.currentTimeMillis());
        String listenerHookURL = broadcast.getListenerHookURL();
        if ((listenerHookURL == null || listenerHookURL.isEmpty()) && settingsListenerHookURL != null && !settingsListenerHookURL.isEmpty()) {
            broadcast.setListenerHookURL(settingsListenerHookURL);
        }
        if ((fqdn = serverSettings.getServerName()) == null || fqdn.length() == 0) {
            fqdn = serverSettings.getHostAddress();
        }
        broadcast.setOriginAdress(serverSettings.getHostAddress());
        broadcast.setAbsoluteStartTimeMs(absoluteStartTimeMs);
        RestServiceBase.removeEmptyPlayListItems(broadcast);
        if (fqdn != null && fqdn.length() >= 0) {
            broadcast.setRtmpURL("rtmp://" + fqdn + "/" + scopeName + "/");
        }
        RestServiceBase.updatePlayListItemDurationsIfApplicable(broadcast);
        dataStore.save(broadcast);
        return broadcast;
    }

    public static void updatePlayListItemDurationsIfApplicable(Broadcast broadcast) {
        List<Broadcast.PlayListItem> playListItemList = broadcast.getPlayListItemList();
        if (playListItemList != null) {
            for (Broadcast.PlayListItem playListItem : playListItemList) {
                if (!"VoD".equals(playListItem.getType())) continue;
                playListItem.setDurationInMs(Muxer.getDurationInMs(playListItem.getStreamUrl(), broadcast.getStreamId()));
            }
        }
    }

    public AppSettings getAppSettings() {
        ApplicationContext appContext;
        if (this.appSettings == null && (appContext = this.getAppContext()) != null) {
            this.appSettings = (AppSettings)appContext.getBean("app.settings");
        }
        return this.appSettings;
    }

    public void setAppSettings(AppSettings appSettings) {
        this.appSettings = appSettings;
    }

    public ServerSettings getServerSettings() {
        ApplicationContext appContext;
        if (this.serverSettings == null && (appContext = this.getAppContext()) != null) {
            this.serverSettings = (ServerSettings)appContext.getBean("ant.media.server.settings");
        }
        return this.serverSettings;
    }

    public void setServerSettings(ServerSettings serverSettings) {
        this.serverSettings = serverSettings;
    }

    protected Result deleteBroadcast(String id) {
        Result result = new Result(false);
        boolean stopResult = false;
        Broadcast broadcast = null;
        if (id != null && (broadcast = this.getDataStore().get(id)) != null) {
            stopResult = this.stopBroadcastInternal(broadcast);
            this.getApplication().cancelPlaylistSchedule(broadcast.getStreamId());
            result.setSuccess(this.getDataStore().delete(id));
            if (result.isSuccess()) {
                if (stopResult) {
                    logger.info("broadcast {} is deleted and stopped successfully", (Object)broadcast.getStreamId());
                    result.setMessage("broadcast is deleted and stopped successfully");
                } else {
                    logger.info("broadcast {} is deleted but could not stopped", (Object)broadcast);
                    result.setMessage("broadcast is deleted but could not stopped ");
                }
            }
        } else {
            logger.warn("Broadcast delete operation not successfull because broadcast is not found in db for stream id:{}", id != null ? id.replaceAll(REPLACE_CHARS, "_") : null);
        }
        return result;
    }

    protected Result deleteBroadcasts(String[] streamIds) {
        Result result = new Result(false);
        if (streamIds != null) {
            for (String id : streamIds) {
                result = this.deleteBroadcast(id);
                if (result.isSuccess()) continue;
                id = id.replaceAll(REPLACE_CHARS_FOR_SECURITY, "_");
                logger.warn("It cannot delete {} and breaking the loop", (Object)id);
                break;
            }
        } else {
            logger.warn("Requested deletion for Stream Ids is empty");
        }
        return result;
    }

    protected boolean stopBroadcastInternal(Broadcast broadcast) {
        boolean result = false;
        if (broadcast != null) {
            result = this.getApplication().stopStreaming(broadcast).isSuccess();
            if (result) {
                logger.info("broadcast is stopped streamId: {}", (Object)broadcast.getStreamId());
            } else {
                logger.error("No active broadcast found with id {}, so could not stopped", (Object)broadcast.getStreamId());
            }
        }
        return result;
    }

    protected Broadcast lookupBroadcast(String id) {
        Broadcast broadcast = null;
        try {
            broadcast = this.getDataStore().get(id);
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        return broadcast;
    }

    protected Result updateBroadcast(String streamId, Broadcast updatedBroadcast, Broadcast broadcastInDB) {
        boolean result = this.getDataStore().updateBroadcastFields(streamId, updatedBroadcast);
        return new Result(result);
    }

    private static void removeEmptyPlayListItems(Broadcast broadcast) {
        List<Broadcast.PlayListItem> playListItemList = broadcast.getPlayListItemList();
        if (playListItemList != null) {
            Iterator<Broadcast.PlayListItem> iterator = playListItemList.iterator();
            while (iterator.hasNext()) {
                Broadcast.PlayListItem listItem = iterator.next();
                if (listItem.getStreamUrl() != null && !listItem.getStreamUrl().isEmpty()) continue;
                iterator.remove();
            }
        }
    }

    public boolean isStreaming(Broadcast broadcast) {
        return AntMediaApplicationAdapter.isStreaming(broadcast);
    }

    protected Result updateStreamSource(String streamId, Broadcast updatedBroadcast, Broadcast broadcastInDB) {
        logger.debug("Updating stream source for stream {}", (Object)updatedBroadcast.getStreamId());
        boolean isPlayList = "playlist".equals(broadcastInDB.getType());
        if (StringUtils.isNotBlank((CharSequence)updatedBroadcast.getStreamUrl()) && !this.checkStreamUrl(updatedBroadcast.getStreamUrl()) && !isPlayList) {
            return new Result(false, "Stream URL is not valid");
        }
        boolean isStreamingActive = this.isStreaming(broadcastInDB);
        if (isStreamingActive && !isPlayList) {
            boolean resultStopStreaming = this.checkStopStreaming(broadcastInDB);
            this.waitStopStreaming(broadcastInDB, resultStopStreaming);
        }
        if ("ipCamera".equals(broadcastInDB.getType()) && !StringUtils.isAllBlank((CharSequence[])new CharSequence[]{updatedBroadcast.getIpAddr(), updatedBroadcast.getUsername(), updatedBroadcast.getPassword()})) {
            Result connectionRes;
            if (StringUtils.isBlank((CharSequence)updatedBroadcast.getIpAddr())) {
                updatedBroadcast.setIpAddr(broadcastInDB.getIpAddr());
            }
            if (StringUtils.isBlank((CharSequence)updatedBroadcast.getUsername())) {
                updatedBroadcast.setUsername(broadcastInDB.getUsername());
            }
            if (StringUtils.isBlank((CharSequence)updatedBroadcast.getPassword())) {
                updatedBroadcast.setPassword(broadcastInDB.getPassword());
            }
            if (!(connectionRes = this.connectToCamera(updatedBroadcast)).isSuccess()) {
                return connectionRes;
            }
            String rtspURL = connectionRes.getMessage();
            String authparam = updatedBroadcast.getUsername() + ":" + updatedBroadcast.getPassword() + "@";
            String rtspURLWithAuth = RTSP + authparam + rtspURL.substring(RTSP.length());
            logger.info("New Stream Source URL: {}", (Object)rtspURLWithAuth);
            updatedBroadcast.setStreamUrl(rtspURLWithAuth);
        }
        RestServiceBase.removeEmptyPlayListItems(updatedBroadcast);
        RestServiceBase.updatePlayListItemDurationsIfApplicable(updatedBroadcast);
        boolean result = this.getDataStore().updateBroadcastFields(streamId, updatedBroadcast);
        if (result) {
            if (broadcastInDB.getPlannedStartDate() != updatedBroadcast.getPlannedStartDate() && isPlayList) {
                this.getApplication().cancelPlaylistSchedule(broadcastInDB.getStreamId());
                this.getApplication().schedulePlayList(System.currentTimeMillis(), updatedBroadcast);
            }
            if (isStreamingActive && !isPlayList) {
                Broadcast fetchedBroadcast = this.getDataStore().get(streamId);
                this.getApplication().startStreaming(fetchedBroadcast);
            }
        }
        return new Result(result);
    }

    public boolean checkStopStreaming(Broadcast broadcast) {
        if ("broadcasting".equals(broadcast.getStatus())) {
            return this.getApplication().stopStreaming(broadcast).isSuccess();
        }
        if (this.getApplication().getStreamFetcherManager().isStreamRunning(broadcast)) {
            return this.getApplication().stopStreaming(broadcast).isSuccess();
        }
        return true;
    }

    public boolean waitStopStreaming(Broadcast broadcast, Boolean resultStopStreaming) {
        int i = 0;
        int waitPeriod = 250;
        while (!"finished".equals(this.getDataStore().get(broadcast.getStreamId()).getStatus()) && !resultStopStreaming.equals(true)) {
            try {
                logger.info("Waiting for stop broadcast: {} Total wait time: {}ms", (Object)broadcast.getStreamId(), (Object)(++i * waitPeriod));
                Thread.sleep(waitPeriod);
                if (i <= 20) continue;
                logger.warn("{} Stream ID broadcast could not be stopped. Total wait time: {}ms", (Object)broadcast.getStreamId(), (Object)(i * waitPeriod));
                break;
            }
            catch (InterruptedException e) {
                logger.error(e.getMessage());
                Thread.currentThread().interrupt();
            }
        }
        return true;
    }

    @Deprecated
    public Result addEndpoint(String id, String rtmpUrl) {
        boolean success = false;
        String message = null;
        try {
            if (RestServiceBase.validateStreamURL(rtmpUrl)) {
                Endpoint endpoint = new Endpoint();
                endpoint.setRtmpUrl(rtmpUrl);
                endpoint.setType(ENDPOINT_GENERIC);
                success = this.getDataStore().addEndpoint(id, endpoint);
            }
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        return new Result(success, message);
    }

    public Result addEndpoint(String id, Endpoint endpoint) {
        boolean success = false;
        String message = null;
        endpoint.setType(ENDPOINT_GENERIC);
        Object endpointServiceId = endpoint.getEndpointServiceId();
        if (endpointServiceId == null || ((String)endpointServiceId).isEmpty()) {
            endpointServiceId = "custom" + RandomStringUtils.randomAlphabetic((int)6);
        }
        endpoint.setEndpointServiceId((String)endpointServiceId);
        try {
            if (RestServiceBase.validateStreamURL(endpoint.getRtmpUrl())) {
                success = this.getDataStore().addEndpoint(id, endpoint);
            }
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        return new Result(success, (String)endpointServiceId, message);
    }

    @Deprecated
    public Result removeEndpoint(String id, String rtmpUrl) {
        Endpoint endpoint = new Endpoint();
        endpoint.setRtmpUrl(rtmpUrl);
        endpoint.setType(ENDPOINT_GENERIC);
        boolean removed = this.getDataStore().removeEndpoint(id, endpoint, true);
        return new Result(removed);
    }

    public Result removeRTMPEndpoint(String id, Endpoint endpoint) {
        boolean removed = this.getDataStore().removeEndpoint(id, endpoint, false);
        return new Result(removed);
    }

    public boolean isInSameNodeInCluster(String originAddress) {
        boolean isCluster = this.getAppContext().containsBean("tomcat.cluster");
        return !isCluster || originAddress.equals(this.getServerSettings().getHostAddress());
    }

    public Result processRTMPEndpoint(String streamId, String originAddress, String rtmpUrl, boolean addEndpoint, int resolution) {
        Result result = new Result(false);
        if (this.isInSameNodeInCluster(originAddress)) {
            result = addEndpoint ? this.getMuxAdaptor(streamId).startRtmpStreaming(rtmpUrl, resolution) : this.getMuxAdaptor(streamId).stopRtmpStreaming(rtmpUrl, resolution);
        } else {
            logger.error("Please send a RTMP Endpoint request to the {} node or {} RTMP Endpoint in a stopped broadcast.", (Object)originAddress, (Object)(addEndpoint ? "add" : "remove"));
            result.setSuccess(false);
        }
        return result;
    }

    public Result importLiveStreams2Stalker() {
        String stalkerDBServer = this.getAppSettings().getStalkerDBServer();
        String stalkerDBUsername = this.getAppSettings().getStalkerDBUsername();
        String stalkerDBPassword = this.getAppSettings().getStalkerDBPassword();
        boolean result = false;
        String message = "";
        int errorId = -1;
        if (stalkerDBServer != null && stalkerDBServer.length() > 0 && stalkerDBUsername != null && stalkerDBUsername.length() > 0 && stalkerDBPassword != null && stalkerDBPassword.length() > 0) {
            long broadcastCount = this.getDataStore().getBroadcastCount();
            int pageCount = (int)broadcastCount / 250 + (broadcastCount % 250L != 0L ? 1 : 0);
            ArrayList<Broadcast> broadcastList = new ArrayList<Broadcast>();
            for (int i = 0; i < pageCount; ++i) {
                broadcastList.addAll(this.getDataStore().getBroadcastList(i * 250, 250, null, null, null, null));
            }
            StringBuilder insertQueryString = new StringBuilder();
            insertQueryString.append("DELETE FROM stalker_db.ch_links;");
            insertQueryString.append("DELETE FROM stalker_db.itv;");
            String fqdn = this.getServerSettings().getServerName();
            if (fqdn == null || fqdn.length() == 0) {
                fqdn = this.getServerSettings().getHostAddress();
            }
            int number = 1;
            for (Broadcast broadcast : broadcastList) {
                String cmd = "ffmpeg http://" + fqdn + ":" + this.serverSettings.getDefaultHttpPort() + "/" + this.getScope().getName() + "/streams/" + broadcast.getStreamId() + ".m3u8";
                insertQueryString.append("INSERT INTO stalker_db.itv(name, number, tv_genre_id, base_ch, cmd, languages) VALUES ('" + broadcast.getName() + "' , " + number + ", 2, 1, '" + cmd + "', '');");
                insertQueryString.append("SET @last_id=LAST_INSERT_ID();INSERT INTO stalker_db.ch_links(ch_id, url) VALUES(@last_id, '" + cmd + "');");
                ++number;
            }
            result = this.runStalkerImportQuery(insertQueryString.toString(), stalkerDBServer, stalkerDBUsername, stalkerDBPassword);
        } else {
            message = "Portal DB info is missing";
            errorId = 404;
        }
        return new Result(result, message, errorId);
    }

    private boolean runStalkerImportQuery(String query, String stalkerDBServer, String stalkerDBUsername, String stalkerDBPassword) {
        boolean result = false;
        try {
            Process p = this.getProcess(query, stalkerDBServer, stalkerDBUsername, stalkerDBPassword);
            if (p != null) {
                int exitWith;
                InputStream is = p.getInputStream();
                if (is != null) {
                    int length;
                    byte[] data = new byte[1024];
                    while ((length = is.read(data, 0, data.length)) != -1) {
                        if (!logger.isInfoEnabled()) continue;
                        logger.info(new String(data, 0, length));
                    }
                }
                if ((exitWith = p.waitFor()) == 0) {
                    result = true;
                }
            }
        }
        catch (IOException e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (InterruptedException e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            Thread.currentThread().interrupt();
        }
        return result;
    }

    private Process getProcess(String query, String stalkerDBServer, String stalkerDBUsername, String stalkerDBPassword) {
        Process process = null;
        String mysqlClientPath = this.getAppSettings().getMySqlClientPath();
        if (this.processBuilderFactory != null) {
            process = this.processBuilderFactory.make(mysqlClientPath, "-h", stalkerDBServer, "-u", stalkerDBUsername, "-p" + stalkerDBPassword, "-e", query);
        } else {
            try {
                process = new ProcessBuilder(mysqlClientPath, "-h", stalkerDBServer, "-u", stalkerDBUsername, "-p" + stalkerDBPassword, "-e", query).redirectErrorStream(true).start();
            }
            catch (IOException e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return process;
    }

    public Result importVoDsToStalker() {
        String stalkerDBServer = this.getAppSettings().getStalkerDBServer();
        String stalkerDBUsername = this.getAppSettings().getStalkerDBUsername();
        String stalkerDBPassword = this.getAppSettings().getStalkerDBPassword();
        boolean result = false;
        String message = "";
        int errorId = -1;
        if (stalkerDBServer != null && stalkerDBUsername != null && stalkerDBPassword != null) {
            String vodFolderPath = this.getAppSettings().getVodFolder();
            if (vodFolderPath != null && !vodFolderPath.isEmpty()) {
                long totalVodNumber = this.getDataStore().getTotalVodNumber();
                int pageCount = (int)totalVodNumber / 250 + (totalVodNumber % 250L != 0L ? 1 : 0);
                ArrayList<VoD> vodList = new ArrayList<VoD>();
                for (int i = 0; i < pageCount; ++i) {
                    vodList.addAll(this.getDataStore().getVodList(i * 250, 250, null, null, null, null));
                }
                String fqdn = this.getServerSettings().getServerName();
                if (fqdn == null || fqdn.length() == 0) {
                    fqdn = this.getServerSettings().getHostAddress();
                }
                StringBuilder insertQueryString = new StringBuilder();
                insertQueryString.append("DELETE FROM stalker_db.video_series_files;");
                insertQueryString.append("DELETE FROM stalker_db.video;");
                for (VoD vod : vodList) {
                    if (!vod.getType().equals("userVod")) continue;
                    insertQueryString.append("INSERT INTO stalker_db.video(name, o_name, protocol, category_id, cat_genre_id_1, status, cost, path, accessed) values('" + vod.getVodName() + "', '" + vod.getVodName() + "', '', 1, 1, 1, 0, '" + vod.getVodName() + "', 1);");
                    File vodFolder = new File(vodFolderPath);
                    int lastIndexOf = vod.getFilePath().lastIndexOf(vodFolder.getName());
                    String filePath = vod.getFilePath().substring(lastIndexOf);
                    String cmd = "ffmpeg http://" + fqdn + ":" + this.serverSettings.getDefaultHttpPort() + "/" + this.getScope().getName() + "/streams/" + filePath;
                    insertQueryString.append("SET @last_id=LAST_INSERT_ID();");
                    insertQueryString.append("INSERT INTO stalker_db.video_series_files(video_id, file_type, protocol, url, languages, quality, date_add, date_modify, status, accessed)VALUES(@last_id, 'video', 'custom', '" + cmd + "', 'a:1:{i:0;s:2:\"en\";}', 5, NOW(), NOW(), 1, 1);");
                }
                result = this.runStalkerImportQuery(insertQueryString.toString(), stalkerDBServer, stalkerDBUsername, stalkerDBPassword);
            } else {
                message = "No VoD folder specified";
                errorId = 500;
            }
        } else {
            message = "Portal DB info is missing";
            errorId = 404;
        }
        return new Result(result, message, errorId);
    }

    protected ProcessBuilderFactory getProcessBuilderFactory() {
        return this.processBuilderFactory;
    }

    public void setProcessBuilderFactory(ProcessBuilderFactory processBuilderFactory) {
        this.processBuilderFactory = processBuilderFactory;
    }

    public IWebRTCAdaptor getWebRTCAdaptor() {
        Object webRTCAdaptorBean;
        IWebRTCAdaptor adaptor = null;
        ApplicationContext appContext = this.getAppContext();
        if (appContext != null && appContext.containsBean("webrtc.adaptor") && (webRTCAdaptorBean = appContext.getBean("webrtc.adaptor")) != null) {
            adaptor = (IWebRTCAdaptor)webRTCAdaptorBean;
        }
        return adaptor;
    }

    public Result addIPCamera(Broadcast stream) {
        Result connResult = new Result(false);
        if (RestServiceBase.validateStreamURL(stream.getIpAddr())) {
            logger.info("type {}", (Object)stream.getType());
            connResult = this.connectToCamera(stream);
            if (connResult.isSuccess()) {
                String authparam = stream.getUsername() + ":" + stream.getPassword() + "@";
                String rtspURLWithAuth = RTSP + authparam + connResult.getMessage().substring(RTSP.length());
                logger.info("rtsp url with auth: {}", (Object)rtspURLWithAuth);
                stream.setStreamUrl(rtspURLWithAuth);
                Date currentDate = new Date();
                long unixTime = currentDate.getTime();
                stream.setDate(unixTime);
                Broadcast savedBroadcast = RestServiceBase.saveBroadcast(stream, "created", this.getScope().getName(), this.getDataStore(), this.getAppSettings().getListenerHookURL(), this.getServerSettings(), 0L);
                connResult = this.getApplication().startStreaming(savedBroadcast);
                if (!connResult.isSuccess()) {
                    this.getDataStore().delete(savedBroadcast.getStreamId());
                }
            }
        } else {
            connResult.setMessage("IP camera addr is not valid: " + stream.getIpAddr());
        }
        return connResult;
    }

    public Result addStreamSource(Broadcast stream) {
        Result result = new Result(false);
        IStatsCollector monitor = (IStatsCollector)this.getAppContext().getBean("statsCollector");
        if (monitor.enoughResource()) {
            if (stream.getType().equals("ipCamera")) {
                result = this.addIPCamera(stream);
            } else if (stream.getType().equals("streamSource")) {
                result = this.addSource(stream);
            } else {
                result.setMessage("Auto start query needs an IP camera or stream source.");
            }
        } else {
            logger.error("Stream Fetcher can not be created due to high cpu load/limit: {}/{} ram free/minfree:{}/{}", new Object[]{monitor.getCpuLoad(), monitor.getCpuLimit(), monitor.getFreeRam(), monitor.getMinFreeRamSize()});
            result.setMessage("Resource usage is high");
            result.setErrorId(-3);
        }
        return result;
    }

    public Result connectToCamera(Broadcast stream) {
        Result result = new Result(false);
        OnvifCamera onvif = new OnvifCamera();
        int connResult = onvif.connect(stream.getIpAddr(), stream.getUsername(), stream.getPassword());
        if (connResult == 0) {
            result.setSuccess(true);
            result.setMessage(onvif.getRTSPStreamURI());
        } else {
            result.setMessage("Could not connect to " + stream.getIpAddr() + " result:" + connResult);
            result.setErrorId(connResult);
            logger.info("Cannot connect to ip camera:{}", (Object)stream.getIpAddr());
        }
        return result;
    }

    protected static boolean validateStreamURL(String url) {
        boolean ipAddrControl = false;
        String[] ipAddrParts = null;
        String serverAddr = url;
        if (url != null && (url.startsWith(HTTP) || url.startsWith("https://") || url.startsWith("rtmp://") || url.startsWith("rtmps://") || url.startsWith(RTSP))) {
            ipAddrParts = url.split("//");
            serverAddr = ipAddrParts[1];
            ipAddrControl = true;
        }
        if (serverAddr != null) {
            if (serverAddr.contains("@")) {
                ipAddrParts = serverAddr.split("@");
                serverAddr = ipAddrParts[1];
            }
            if (serverAddr.contains(":")) {
                ipAddrParts = serverAddr.split(":");
                serverAddr = ipAddrParts[0];
            }
            if (serverAddr.contains("/")) {
                ipAddrParts = serverAddr.split("/");
                serverAddr = ipAddrParts[0];
            }
            if (logger.isInfoEnabled()) {
                logger.info("IP: {}", (Object)serverAddr.replaceAll(REPLACE_CHARS, "_"));
            }
            if (serverAddr.split("\\.").length == 4 && RestServiceBase.validateIPaddress(serverAddr)) {
                ipAddrControl = true;
            }
        }
        return ipAddrControl;
    }

    protected static boolean validateIPaddress(String ipaddress) {
        Pattern patternIP4 = Pattern.compile(IPV4_REGEX);
        Pattern patternLoopBack = Pattern.compile(LOOPBACK_REGEX);
        return patternIP4.matcher(ipaddress).matches() || patternLoopBack.matcher(ipaddress).matches();
    }

    public boolean checkStreamUrl(String url) {
        boolean streamUrlControl = false;
        String[] ipAddrParts = null;
        String ipAddr = null;
        if (url != null && (url.startsWith(HTTP) || url.startsWith("https://") || url.startsWith("rtmp://") || url.startsWith("rtmps://") || url.startsWith(RTSP) || url.startsWith("udp://") || url.startsWith("srt://"))) {
            streamUrlControl = true;
            ipAddrParts = url.split("//");
            ipAddr = ipAddrParts[1];
            if (ipAddr.contains("@")) {
                ipAddrParts = ipAddr.split("@");
                ipAddr = ipAddrParts[1];
            }
            if (ipAddr.contains(":")) {
                ipAddrParts = ipAddr.split(":");
                ipAddr = ipAddrParts[0];
            }
            if (ipAddr.contains("/")) {
                ipAddrParts = ipAddr.split("/");
                ipAddr = ipAddrParts[0];
            }
        }
        return streamUrlControl;
    }

    protected Result addSource(Broadcast stream) {
        Result result = new Result(false);
        if (this.checkStreamUrl(stream.getStreamUrl())) {
            boolean isVoD;
            boolean bl = isVoD = stream.getStreamUrl().startsWith("http") && (stream.getStreamUrl().endsWith("mp4") || stream.getStreamUrl().endsWith("webm") || stream.getStreamUrl().endsWith("flv"));
            if (isVoD) {
                stream.setType("VoD");
            }
            Date currentDate = new Date();
            long unixTime = currentDate.getTime();
            stream.setDate(unixTime);
            Broadcast savedBroadcast = RestServiceBase.saveBroadcast(stream, "created", this.getScope().getName(), this.getDataStore(), this.getAppSettings().getListenerHookURL(), this.getServerSettings(), 0L);
            result = this.getApplication().startStreaming(savedBroadcast);
            if (!result.isSuccess()) {
                this.getDataStore().delete(savedBroadcast.getStreamId());
                result.setErrorId(-4);
            }
        }
        return result;
    }

    protected List<WebRTCClientStats> getWebRTCClientStatsList(int offset, int size, String streamId) {
        ArrayList<WebRTCClientStats> list = new ArrayList<WebRTCClientStats>();
        IWebRTCAdaptor webRTCAdaptor = this.getWebRTCAdaptor();
        if (webRTCAdaptor != null) {
            List<WebRTCClientStats> webRTCClientStats = webRTCAdaptor.getWebRTCClientStats(streamId);
            int t = 0;
            int itemCount = 0;
            if (size > 50) {
                size = 50;
            }
            if (offset < 0) {
                offset = 0;
            }
            for (WebRTCClientStats webrtcClientStat : webRTCClientStats) {
                if (t < offset) {
                    ++t;
                    continue;
                }
                list.add(webrtcClientStat);
                if (++itemCount < size) continue;
                return list;
            }
        }
        return list;
    }

    protected Result deleteVoD(String id) {
        boolean success = false;
        String message = "";
        ApplicationContext appContext = this.getAppContext();
        if (appContext != null) {
            File videoFile = null;
            VoD voD = this.getDataStore().getVoD(id);
            if (voD != null) {
                try {
                    File tmp;
                    boolean resultThumbnail;
                    String previewFilePath;
                    String filePath = String.format("webapps/%s/%s", this.getScope().getName(), voD.getFilePath());
                    videoFile = new File(filePath);
                    boolean result = Files.deleteIfExists(videoFile.toPath());
                    if (!result) {
                        logger.warn("File is not deleted because it does not exist {}", (Object)videoFile.getAbsolutePath());
                    }
                    if ((previewFilePath = voD.getPreviewFilePath()) != null && !(resultThumbnail = Files.deleteIfExists((tmp = new File(previewFilePath)).toPath()))) {
                        logger.warn("Preview is not deleted because it does not exist {}", (Object)tmp.getAbsolutePath());
                    }
                    if (success = this.getDataStore().deleteVod(id)) {
                        message = "vod deleted";
                    }
                    String fileName = videoFile.getName();
                    int indexOfFileExtension = fileName.lastIndexOf(".");
                    String finalFileName = fileName.substring(0, indexOfFileExtension);
                    File previewFile = Muxer.getPreviewFile(this.getScope(), finalFileName, ".png");
                    Files.deleteIfExists(previewFile.toPath());
                    StorageClient storageClient = (StorageClient)appContext.getBean("app.storageClient");
                    storageClient.delete(this.getAppSettings().getS3StreamsFolderPath() + File.separator + fileName);
                    storageClient.delete(this.getAppSettings().getS3PreviewsFolderPath() + File.separator + finalFileName + ".png");
                }
                catch (Exception e) {
                    logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                }
            }
        }
        return new Result(success, message);
    }

    protected Result deleteVoDs(String[] vodIds) {
        Result result = new Result(false);
        if (vodIds != null) {
            for (String id : vodIds) {
                result = this.deleteVoD(id);
                if (result.isSuccess()) continue;
                id = id.replaceAll(REPLACE_CHARS_FOR_SECURITY, "_");
                logger.warn("VoD:{} cannot be deleted and breaking the loop", (Object)id);
                break;
            }
        } else {
            logger.warn("Requested deletion for VoD Ids is empty");
        }
        return result;
    }

    protected String getStreamsDirectory(String appScopeName) {
        return String.format("%s/webapps/%s/%s", System.getProperty("red5.root"), appScopeName, "streams");
    }

    protected Result uploadVoDFile(String fileName, InputStream inputStream) {
        String id;
        String message;
        boolean success;
        block12: {
            success = false;
            message = "";
            id = null;
            String appScopeName = this.getScope().getName();
            String fileExtension = FilenameUtils.getExtension((String)fileName);
            try {
                if ("mp4".equalsIgnoreCase(fileExtension) || "webm".equalsIgnoreCase(fileExtension) || "mov".equalsIgnoreCase(fileExtension) || "avi".equalsIgnoreCase(fileExtension)) {
                    File streamsDirectory = new File(this.getStreamsDirectory(appScopeName));
                    if (!streamsDirectory.exists()) {
                        streamsDirectory.mkdirs();
                    }
                    String vodId = RandomStringUtils.randomNumeric((int)24);
                    File savedFile = new File(String.format("%s/webapps/%s/%s", System.getProperty("red5.root"), appScopeName, "streams/" + vodId + "." + fileExtension));
                    int read = 0;
                    byte[] bytes = new byte[2048];
                    try (FileOutputStream outpuStream = new FileOutputStream(savedFile);){
                        while ((read = inputStream.read(bytes)) != -1) {
                            ((OutputStream)outpuStream).write(bytes, 0, read);
                        }
                        outpuStream.flush();
                        long fileSize = savedFile.length();
                        long unixTime = System.currentTimeMillis();
                        String path = savedFile.getPath();
                        String relativePath = AntMediaApplicationAdapter.getRelativePath(path);
                        VoD newVod = new VoD(fileName, "file", relativePath, fileName, unixTime, 0L, Muxer.getDurationInMs(savedFile, fileName), fileSize, "uploadedVod", vodId, null);
                        id = this.getDataStore().addVod(newVod);
                        if (id != null) {
                            success = true;
                            message = id;
                            String vodFinishScript = this.getAppSettings().getVodUploadFinishScript();
                            if (vodFinishScript != null && !vodFinishScript.isEmpty()) {
                                this.getApplication().runScript(vodFinishScript + "  " + savedFile.getAbsolutePath());
                            }
                        }
                        break block12;
                    }
                }
                message = "notMp4File";
            }
            catch (IOException iox) {
                logger.error(iox.getMessage());
            }
        }
        return new Result(success, id, message);
    }

    protected Result synchUserVodList() {
        boolean result = false;
        int errorId = -1;
        String message = "";
        String vodFolder = this.getAppSettings().getVodFolder();
        logger.info("synch user vod list vod folder is {}", (Object)vodFolder);
        if (vodFolder != null && vodFolder.length() > 0) {
            result = this.getApplication().synchUserVoDFolder(null, vodFolder);
        } else {
            errorId = 404;
            message = "no VodD folder defined";
        }
        return new Result(result, message, errorId);
    }

    public MuxAdaptor getMuxAdaptor(String streamId) {
        AntMediaApplicationAdapter application = this.getApplication();
        MuxAdaptor selectedMuxAdaptor = null;
        if (application != null) {
            selectedMuxAdaptor = application.getMuxAdaptor(streamId);
        }
        return selectedMuxAdaptor;
    }

    @Nullable
    protected Mp4Muxer getMp4Muxer(MuxAdaptor muxAdaptor) {
        Mp4Muxer mp4Muxer = null;
        for (Muxer muxer : muxAdaptor.getMuxerList()) {
            if (!(muxer instanceof Mp4Muxer)) continue;
            mp4Muxer = (Mp4Muxer)muxer;
        }
        return mp4Muxer;
    }

    protected RecordMuxer startRecord(String streamId, RecordType recordType, int resolutionHeight) {
        MuxAdaptor muxAdaptor = this.getMuxAdaptor(streamId);
        if (muxAdaptor != null) {
            return muxAdaptor.startRecording(recordType, resolutionHeight);
        }
        logger.info("No mux adaptor found for {} recordType:{} resolutionHeight:{}", new Object[]{streamId != null ? streamId.replaceAll(REPLACE_CHARS_FOR_SECURITY, "_") : "null ", recordType, resolutionHeight});
        return null;
    }

    @Nullable
    protected RecordMuxer stopRecord(String streamId, RecordType recordType, int resolutionHeight) {
        MuxAdaptor muxAdaptor = this.getMuxAdaptor(streamId);
        if (muxAdaptor != null) {
            return muxAdaptor.stopRecording(recordType, resolutionHeight);
        }
        return null;
    }

    protected BroadcastStatistics getBroadcastStatistics(String id) {
        int totalRTMPViewer = -1;
        int totalWebRTCViewer = -1;
        int totalHLSViewer = -1;
        int totalDASHViewer = -1;
        if (id != null) {
            Broadcast broadcast;
            IBroadcastScope broadcastScope = this.getScope().getBroadcastScope(id);
            if (broadcastScope != null) {
                totalRTMPViewer = broadcastScope.getConsumers().size();
            }
            if ((broadcast = this.getDataStore().get(id)) != null) {
                totalHLSViewer = broadcast.getHlsViewerCount();
                totalDASHViewer = broadcast.getDashViewerCount();
                totalWebRTCViewer = broadcast.getWebRTCViewerCount();
            }
        }
        return new BroadcastStatistics(totalRTMPViewer, totalHLSViewer, totalWebRTCViewer, totalDASHViewer);
    }

    protected AppBroadcastStatistics getBroadcastTotalStatistics() {
        IWebRTCAdaptor webRTCAdaptor;
        int totalWebRTCViewer = -1;
        int totalHLSViewer = -1;
        int totalDASHViewer = -1;
        if (this.getAppContext().containsBean("hls.viewerstats")) {
            HlsViewerStats hlsViewerStats = (HlsViewerStats)this.getAppContext().getBean("hls.viewerstats");
            totalHLSViewer = hlsViewerStats.getTotalViewerCount();
        }
        if (this.getAppContext().containsBean("dash.viewerstats")) {
            DashViewerStats dashViewerStats = (DashViewerStats)this.getAppContext().getBean("dash.viewerstats");
            totalDASHViewer = dashViewerStats.getTotalViewerCount();
        }
        if ((webRTCAdaptor = this.getWebRTCAdaptor()) != null) {
            totalWebRTCViewer = webRTCAdaptor.getNumberOfTotalViewers();
        }
        int activeBroadcastCount = (int)this.getDataStore().getActiveBroadcastCount();
        return new AppBroadcastStatistics(-1, totalHLSViewer, totalWebRTCViewer, totalDASHViewer, activeBroadcastCount);
    }

    protected Result getCameraErrorById(String streamId) {
        Result result = new Result(false);
        if (streamId != null) {
            StreamFetcher camScheduler = this.getApplication().getStreamFetcherManager().getStreamFetcher(streamId);
            if (camScheduler != null) {
                result = camScheduler.getCameraError();
            } else {
                result.setMessage("Camera is not found with streamId: " + streamId);
            }
        } else {
            result.setMessage("StreamId parameter is " + streamId + " Please use none null values");
        }
        return result;
    }

    public Result startStreamSource(String id) {
        Result result = new Result(false);
        Broadcast broadcast = this.getDataStore().get(id);
        if (broadcast != null) {
            if (broadcast.getStreamUrl() != null || Objects.equals(broadcast.getType(), "playlist")) {
                result = this.getApplication().startStreaming(broadcast);
            } else if (Objects.equals(broadcast.getType(), "ipCamera")) {
                result = this.connectToCamera(broadcast);
                if (result.isSuccess()) {
                    String authparam = broadcast.getUsername() + ":" + broadcast.getPassword() + "@";
                    String rtspURLWithAuth = RTSP + authparam + result.getMessage().substring(RTSP.length());
                    logger.info("rtsp url with auth: {}", (Object)rtspURLWithAuth);
                    broadcast.setStreamUrl(rtspURLWithAuth);
                    result = this.getApplication().startStreaming(broadcast);
                }
            } else {
                result.setMessage("Stream url is null and it's not an IP camera to get stream url for id:" + id);
            }
        } else {
            result.setMessage("No Stream Exists with id:" + id);
        }
        return result;
    }

    public Result playNextItem(String id, Integer index) {
        Result result = new Result(false);
        Broadcast broadcast = this.getDataStore().get(id);
        if (broadcast == null) {
            result.setMessage("There is no playlist found. Please check Stream id again");
            return result;
        }
        if (!"playlist".equals(broadcast.getType())) {
            result.setMessage("This broadcast type is not playlist. This method is only available for playlists");
            return result;
        }
        if (index == null) {
            index = -1;
        }
        if (index < broadcast.getPlayListItemList().size()) {
            StreamFetcher streamFetcher = this.getApplication().getStreamFetcherManager().getStreamFetcher(id);
            if (streamFetcher != null) {
                StreamFetcher.IStreamFetcherListener streamFetcherListener = streamFetcher.getStreamFetcherListener();
                streamFetcher.setStreamFetcherListener(null);
                if (logger.isInfoEnabled()) {
                    logger.info("Switching to next item by REST method for playlist:{} and forwarding stream fetcher listener:{}", (Object)id.replaceAll(REPLACE_CHARS_FOR_SECURITY, "_"), (Object)streamFetcherListener.hashCode());
                }
                result = this.getApplication().getStreamFetcherManager().playItemInList(broadcast, streamFetcherListener, index);
            } else {
                result.setMessage("No active playlist for id:" + id + ". Start the playlist first");
            }
        } else {
            result.setMessage("Index is out of the list. Please specify the correct index");
        }
        return result;
    }

    public Result stopStreaming(String id) {
        Result result = new Result(false);
        Broadcast broadcast = this.getDataStore().get(id);
        if (broadcast != null) {
            result = this.getApplication().stopStreaming(broadcast);
        }
        return result;
    }

    protected String[] searchOnvifDevices() {
        String localIP = null;
        String[] list = null;
        Enumeration<NetworkInterface> interfaces = null;
        try {
            interfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        if (interfaces != null) {
            while (interfaces.hasMoreElements()) {
                NetworkInterface i = interfaces.nextElement();
                Enumeration<InetAddress> addresses = i.getInetAddresses();
                while (addresses.hasMoreElements() && (localIP == null || localIP.isEmpty())) {
                    InetAddress address = addresses.nextElement();
                    if (address.isLoopbackAddress() || !address.isSiteLocalAddress()) continue;
                    localIP = address.getHostAddress();
                }
            }
            logger.info("IP Address: {} ", (Object)localIP);
        }
        if (localIP != null) {
            String[] ipAddrParts = localIP.split("\\.");
            String ipAd = ipAddrParts[0] + "." + ipAddrParts[1] + "." + ipAddrParts[2] + ".";
            ArrayList<String> addressList = new ArrayList<String>();
            for (int i = 2; i < 255; ++i) {
                addressList.add(ipAd + i);
            }
            List<URL> onvifDevices = OnvifDiscovery.discoverOnvifDevices(true, addressList);
            list = this.getIPArray(onvifDevices);
        }
        return list;
    }

    protected String[] getOnvifDeviceProfiles(String id) {
        OnvifCamera camera = this.getApplication().getOnvifCamera(id);
        return camera.getProfiles();
    }

    public String[] getIPArray(List<URL> onvifDevices) {
        String[] list = null;
        if (onvifDevices != null) {
            list = new String[onvifDevices.size()];
            for (int i = 0; i < onvifDevices.size(); ++i) {
                list[i] = StringUtils.substringBetween((String)onvifDevices.get(i).toString(), (String)HTTP, (String)"/");
                logger.info("IP Camera found: {}", (Object)onvifDevices.get(i));
            }
        }
        return list;
    }

    protected boolean moveRelative(String id, float valueX, float valueY, float valueZoom) {
        boolean result = false;
        OnvifCamera camera = this.getApplication().getOnvifCamera(id);
        if (camera != null) {
            result = camera.moveRelative(valueX, valueY, valueZoom);
        }
        return result;
    }

    protected boolean moveAbsolute(String id, float valueX, float valueY, float valueZoom) {
        boolean result = false;
        OnvifCamera camera = this.getApplication().getOnvifCamera(id);
        if (camera != null) {
            result = camera.moveAbsolute(valueX, valueY, valueZoom);
        }
        return result;
    }

    protected boolean moveContinous(String id, float valueX, float valueY, float valueZoom) {
        boolean result = false;
        OnvifCamera camera = this.getApplication().getOnvifCamera(id);
        if (camera != null) {
            result = camera.moveContinous(valueX, valueY, valueZoom);
        }
        return result;
    }

    protected List<TensorFlowObject> getDetectionList(String id, int offset, int size) {
        List<Object> list = null;
        if (id != null) {
            list = this.getDataStore().getDetectionList(id, offset, size);
        }
        if (list == null) {
            list = new ArrayList();
        }
        return list;
    }

    protected ITokenService getTokenService() {
        ApplicationContext appContext = this.getAppContext();
        if (appContext != null && appContext.containsBean(ITokenService.BeanName.TOKEN_SERVICE.toString())) {
            return (ITokenService)appContext.getBean(ITokenService.BeanName.TOKEN_SERVICE.toString());
        }
        return null;
    }

    protected Object getToken(String streamId, long expireDate, String type, String roomId) {
        Token token = null;
        String message = "Define Stream ID, Token Type and Expire Date (unix time)";
        if (streamId != null && type != null && expireDate > 0L) {
            ITokenService tokenService = this.getTokenService();
            if (tokenService != null) {
                token = tokenService.createToken(streamId, expireDate, type, roomId);
                if (token != null) {
                    if (this.getDataStore().saveToken(token)) {
                        return token;
                    }
                    message = "Cannot save token to the datastore";
                } else {
                    message = "Cannot create token. It can be a mock token service";
                }
            } else {
                message = "No token service in this app";
            }
        }
        return new Result(false, message);
    }

    protected Object getJwtToken(String streamId, long expireDate, String type, String roomId) {
        Token token = null;
        String message = "Define Stream ID, Token Type and Expire Date (unix time)";
        if (streamId != null && type != null && expireDate > 0L) {
            ITokenService tokenService = this.getTokenService();
            if (tokenService != null) {
                token = tokenService.createJwtToken(streamId, expireDate, type, roomId);
                if (token != null) {
                    return token;
                }
                message = "Cannot create JWT token. The problem can be ->  this is community edition or JWT stream key is not set or it's length is less than 32";
            } else {
                message = "No token service in this app";
            }
        }
        return new Result(false, message);
    }

    protected Token validateToken(Token token) {
        Token validatedToken = null;
        if (token.getTokenId() != null) {
            validatedToken = this.getDataStore().validateToken(token);
        }
        return validatedToken;
    }

    protected Result revokeTokens(String streamId) {
        Result result = new Result(false);
        if (streamId != null) {
            result.setSuccess(this.getDataStore().revokeTokens(streamId));
        }
        return result;
    }

    protected VoD getVoD(String id) {
        VoD vod = null;
        if (id != null) {
            vod = this.getDataStore().getVoD(id);
        }
        if (vod == null) {
            vod = new VoD();
        }
        return vod;
    }

    public static Version getSoftwareVersion() {
        Version version = new Version();
        version.setVersionName(AntMediaApplicationAdapter.class.getPackage().getImplementationVersion());
        URL url = null;
        Class<RestServiceBase> clazz = RestServiceBase.class;
        String className = clazz.getSimpleName() + ".class";
        String classPath = clazz.getResource(className).toString();
        String manifestPath = classPath.substring(0, classPath.lastIndexOf("!") + 1) + "/META-INF/MANIFEST.MF";
        try {
            url = new URL(manifestPath);
        }
        catch (MalformedURLException e) {
            logger.error(e.getMessage());
        }
        try {
            if (url != null) {
                Manifest manifest = new Manifest(url.openStream());
                version.setBuildNumber(manifest.getMainAttributes().getValue(BUILD_NUMBER));
            } else {
                logger.error("url(META-INF/MANIFEST.MF) is null when getting software version");
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage());
        }
        version.setVersionType(RestServiceBase.isEnterprise() ? ENTERPRISE_EDITION : COMMUNITY_EDITION);
        logger.info("Version Name {} Version Type {}", (Object)version.getVersionName(), (Object)version.getVersionType());
        return version;
    }

    public static boolean isEnterprise() {
        try {
            Class.forName("io.antmedia.enterprise.adaptive.EncoderAdaptor");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    @Deprecated(forRemoval=true, since="2.9.1")
    public static Map<String, String> getRoomInfoFromConference(Broadcast broadcastRoom, String streamId, DataStore store) {
        HashMap<String, String> streamDetailsMap = null;
        if (broadcastRoom != null) {
            streamDetailsMap = new HashMap<String, String>();
            List<String> tempList = broadcastRoom.getSubTrackStreamIds();
            if (tempList != null) {
                for (String tmpStreamId : tempList) {
                    Broadcast broadcast = store.get(tmpStreamId);
                    if (broadcast == null || !broadcast.getStatus().equals("broadcasting")) continue;
                    streamDetailsMap.put(tmpStreamId, broadcast.getName());
                }
                streamDetailsMap.remove(streamId);
            }
        }
        return streamDetailsMap;
    }

    public static void setResultSuccess(Result result, boolean success, String failMessage) {
        if (success) {
            result.setSuccess(true);
        } else {
            result.setSuccess(false);
            result.setMessage(failMessage);
        }
    }

    public static void logWarning(String message, String ... arguments) {
        if (logger.isWarnEnabled()) {
            logger.warn(message, (Object[])arguments);
        }
    }

    public static Result addSubTrack(String id, String subTrackId, DataStore store) {
        Result result = new Result(false);
        Broadcast subTrack = store.get(subTrackId);
        Broadcast mainTrack = store.get(id);
        Object message = "";
        if (subTrack != null && mainTrack != null) {
            int subtrackLimit = mainTrack.getSubtracksLimit();
            List<String> subTrackStreamIds = mainTrack.getSubTrackStreamIds();
            if (subtrackLimit != -1 && subTrackStreamIds != null && subTrackStreamIds.size() >= subtrackLimit) {
                message = "Subtrack limit is reached for the main track:" + id;
                RestServiceBase.logWarning("Subtrack limit is reached for the main track:{}", id.replaceAll(REPLACE_CHARS, "_"));
                result.setMessage((String)message);
                return result;
            }
            if (subTrackStreamIds == null) {
                subTrackStreamIds = new ArrayList<String>();
            }
            subTrack.setMainTrackStreamId(id);
            boolean success = store.updateBroadcastFields(subTrackId, subTrack);
            if (success) {
                subTrackStreamIds.add(subTrackId);
                success = store.updateBroadcastFields(id, mainTrack);
                RestServiceBase.setResultSuccess(result, success, "Subtrack:" + subTrackId + " cannot be added to main track: " + id);
            } else {
                message = MAIN_TRACK_OF_THE_STREAM + subTrackId + " cannot be updated";
                RestServiceBase.logWarning("Main track of the stream :{} cannot be updated to {}", subTrackId.replaceAll(REPLACE_CHARS, "_"), id.replaceAll(REPLACE_CHARS, "_"));
            }
        } else {
            message = "There is no stream with id:" + subTrackId + " as subtrack or " + id + " as mainTrack";
            RestServiceBase.logWarning("There is no stream with id:{} as subtrack or {} as mainTrack", subTrackId.replaceAll(REPLACE_CHARS, "_"), id.replaceAll(REPLACE_CHARS, "_"));
        }
        result.setMessage((String)message);
        return result;
    }

    public static Result removeSubTrack(String id, String subTrackId, DataStore store) {
        Result result = new Result(false);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{id, subTrackId})) {
            subTrackId = subTrackId.replaceAll(REPLACE_CHARS, "_");
            boolean success = store.removeSubTrack(id = id.replaceAll(REPLACE_CHARS, "_"), subTrackId);
            if (success) {
                Broadcast subTrack = store.get(subTrackId);
                if (subTrack != null && id.equals(subTrack.getMainTrackStreamId())) {
                    subTrack.setMainTrackStreamId("");
                    success = store.updateBroadcastFields(subTrackId, subTrack);
                    if (success) {
                        RestServiceBase.setResultSuccess(result, success, "");
                    } else {
                        RestServiceBase.setResultSuccess(result, false, MAIN_TRACK_OF_THE_STREAM + subTrackId + " which is " + id + " cannot be removed");
                        logger.info("Main track of the stream  {} which is {} cannot be removed", (Object)subTrackId, (Object)id);
                    }
                } else {
                    RestServiceBase.setResultSuccess(result, false, MAIN_TRACK_OF_THE_STREAM + subTrackId + " which is " + id + " cannot be updated");
                    logger.info("Main track of the stream {} which is {} not updated because either subtrack is null or its maintrack does not match with mainTrackId:{}", new Object[]{subTrackId, id, id});
                }
            } else {
                RestServiceBase.setResultSuccess(result, false, "Subtrack(" + subTrackId + ") is not removed from mainTrack:" + id);
                logger.info("Subtrack({}) is not removed from mainTrack:{}", (Object)subTrackId, (Object)id);
            }
        }
        return result;
    }

    public static boolean isMainTrack(String streamId, DataStore store) {
        Broadcast broadcast;
        boolean result = false;
        if (streamId != null && (broadcast = store.get(streamId)) != null) {
            result = !broadcast.getSubTrackStreamIds().isEmpty();
        }
        return result;
    }

    public static Result sendDataChannelMessage(String id, String message, AntMediaApplicationAdapter application, DataStore store) {
        if (application != null && application.isDataChannelMessagingSupported()) {
            if (application.isDataChannelEnabled()) {
                if (application.doesWebRTCStreamExist(id) || RestServiceBase.isMainTrack(id, store)) {
                    boolean status = application.sendDataChannelMessage(id, message);
                    if (status) {
                        return new Result(true);
                    }
                    return new Result(false, "Operation not completed");
                }
                return new Result(false, "Requested WebRTC stream does not exist");
            }
            return new Result(false, "Data channels are not enabled");
        }
        return new Result(false, "Operation not supported in the Community Edition. Check the Enterprise version for more features.");
    }

    public static String logFailedOperation(boolean enableRecording, String streamId, RecordType type) {
        String id = streamId.replaceAll(REPLACE_CHARS, "_");
        if (enableRecording) {
            logger.warn("{} recording could not be started for stream: {}", (Object)type, (Object)id);
        } else {
            logger.warn("{} recording could not be stopped for stream: {}", (Object)type, (Object)id);
        }
        return id;
    }

    public Result enableRecordMuxing(String streamId, boolean enableRecording, String type, int resolutionHeight) {
        boolean result = false;
        Object message = null;
        String status = enableRecording ? "started" : "stopped";
        String vodId = null;
        RecordType recordType = null;
        if (type.equals(RecordType.MP4.toString())) {
            recordType = RecordType.MP4;
        } else if (type.equals(RecordType.WEBM.toString())) {
            recordType = RecordType.WEBM;
        }
        if (streamId != null && recordType != null) {
            Broadcast broadcast = this.getDataStore().get(streamId);
            if (broadcast != null) {
                if (!broadcast.getStatus().equals("broadcasting")) {
                    if (recordType == RecordType.MP4) {
                        broadcast.setMp4Enabled(enableRecording ? 1 : -1);
                    } else {
                        broadcast.setWebMEnabled(enableRecording ? 1 : -1);
                    }
                    result = true;
                } else {
                    boolean isAlreadyRecording = this.isAlreadyRecording(streamId, recordType, resolutionHeight);
                    if (enableRecording != isAlreadyRecording) {
                        result = true;
                        RecordMuxer muxer = null;
                        if (this.isInSameNodeInCluster(broadcast.getOriginAdress())) {
                            if (enableRecording) {
                                muxer = this.startRecord(streamId, recordType, resolutionHeight);
                                if (muxer != null) {
                                    vodId = RandomStringUtils.randomAlphanumeric((int)24);
                                    muxer.setVodId(vodId);
                                    message = Long.toString(muxer.getCurrentVoDTimeStamp());
                                    logger.warn("{} recording is {} for stream: {}", new Object[]{type, status, streamId});
                                }
                            } else {
                                muxer = this.stopRecord(streamId, recordType, resolutionHeight);
                                if (muxer != null) {
                                    vodId = muxer.getVodId();
                                    message = Long.toString(muxer.getCurrentVoDTimeStamp());
                                }
                            }
                            if (muxer == null) {
                                result = false;
                                RestServiceBase.logFailedOperation(enableRecording, streamId, recordType);
                                message = recordType + " recording couldn't be " + status;
                            }
                        } else {
                            message = "Please send " + type + " recording request to " + broadcast.getOriginAdress() + " node or send request in a stopped status.";
                            result = false;
                        }
                    } else {
                        message = enableRecording ? type + " recording couldn't be started" : type + " recording couldn't be stopped";
                        result = false;
                    }
                }
                if (result) {
                    if (recordType == RecordType.WEBM) {
                        result = this.getDataStore().setWebMMuxing(streamId, enableRecording ? 1 : -1);
                    } else if (recordType == RecordType.MP4) {
                        result = this.getDataStore().setMp4Muxing(streamId, enableRecording ? 1 : -1);
                    }
                }
            }
        } else {
            message = "No stream for this id: " + streamId + " or unexpected record type. Record type is " + recordType;
        }
        return new Result(result, vodId, (String)message);
    }

    public boolean isAlreadyRecording(String streamId, RecordType recordType, int resolutionHeight) {
        MuxAdaptor muxAdaptor = this.getMuxAdaptor(streamId);
        return muxAdaptor != null && muxAdaptor.isAlreadyRecording(recordType, resolutionHeight);
    }

    public Result importVoDs(String directory) {
        return this.getApplication().importVoDFolder(directory);
    }

    public Result unlinksVoD(String directory) {
        return this.getApplication().unlinksVoD(directory);
    }

    public static String replaceCharsForSecurity(String value) {
        return value.replaceAll(REPLACE_CHARS_FOR_SECURITY, "_");
    }

    public static interface ProcessBuilderFactory {
        public Process make(String ... var1);
    }

    public class BroadcastStatistics {
        @Schema(description="The total RTMP viewers of the stream")
        public final int totalRTMPWatchersCount;
        @Schema(description="The total HLS viewers of the stream")
        public final int totalHLSWatchersCount;
        @Schema(description="The total WebRTC viewers of the stream")
        public final int totalWebRTCWatchersCount;
        @Schema(description="The total DASH viewers of the stream")
        public final int totalDASHWatchersCount;

        public BroadcastStatistics(int totalRTMPWatchersCount, int totalHLSWatchersCount, int totalWebRTCWatchersCount, int totalDASHWatchersCount) {
            this.totalRTMPWatchersCount = totalRTMPWatchersCount;
            this.totalHLSWatchersCount = totalHLSWatchersCount;
            this.totalWebRTCWatchersCount = totalWebRTCWatchersCount;
            this.totalDASHWatchersCount = totalDASHWatchersCount;
        }
    }

    public class AppBroadcastStatistics
    extends BroadcastStatistics {
        @Schema(description="The total active live stream count")
        public final int activeLiveStreamCount;

        public AppBroadcastStatistics(int totalRTMPWatchersCount, int totalHLSWatchersCount, int totalWebRTCWatchersCount, int totalDASHWatchersCount, int activeLiveStreamCount) {
            super(totalRTMPWatchersCount, totalHLSWatchersCount, totalWebRTCWatchersCount, totalDASHWatchersCount);
            this.activeLiveStreamCount = activeLiveStreamCount;
        }
    }
}

