/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.rest;

import io.antmedia.rest.RestServiceBase;
import io.antmedia.rest.model.Version;
import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.info.Contact;
import io.swagger.v3.oas.annotations.info.Info;
import io.swagger.v3.oas.annotations.info.License;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.servers.Server;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@OpenAPIDefinition(info=@Info(description="Ant Media Server REST API Reference", version="V2.0", title="Ant Media Server REST API Reference", contact=@Contact(name="Ant Media Info", email="contact@antmedia.io", url="https://antmedia.io"), license=@License(name="Apache 2.0", url="http://www.apache.org")), servers={@Server(description="test server", url="https://test.antmedia.io:5443/Sandbox/rest/")}, externalDocs=@ExternalDocumentation(url="https://antmedia.io"))
@Component
@Path(value="/v2")
public class RootRestService
extends RestServiceBase {
    protected static Logger logger = LoggerFactory.getLogger(RootRestService.class);

    @Operation(summary="Returns the Ant Media Server Version", description="Retrieves the version information of the Ant Media Server.", responses={@ApiResponse(responseCode="200", description="Ant Media Server Version", content={@Content(mediaType="application/json", schema=@Schema(implementation=Version.class))})})
    @GET
    @Path(value="/version")
    @Produces(value={"application/json"})
    public Version getVersion() {
        return RootRestService.getSoftwareVersion();
    }

    public static class RoomInfo {
        private String roomId;
        private Map<String, String> streamDetailsMap;
        private long endDate = 0L;
        private long startDate = 0L;

        public RoomInfo(String roomId, Map<String, String> streamDetailsMap) {
            this.roomId = roomId;
            this.streamDetailsMap = streamDetailsMap;
        }

        public String getRoomId() {
            return this.roomId;
        }

        public void setEndDate(long endDate) {
            this.endDate = endDate;
        }

        public void setStartDate(long startDate) {
            this.startDate = startDate;
        }

        public long getEndDate() {
            return this.endDate;
        }

        public long getStartDate() {
            return this.startDate;
        }

        public void setRoomId(String roomId) {
            this.roomId = roomId;
        }

        public Map<String, String> getStreamDetailsMap() {
            return this.streamDetailsMap;
        }

        public void setStreamDetailsMap(Map<String, String> streamDetailsMap) {
            this.streamDetailsMap = streamDetailsMap;
        }
    }
}

