/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.whip;

import io.antmedia.rest.RestServiceBase;
import io.antmedia.rest.model.Result;
import io.antmedia.webrtc.PublishParameters;
import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.info.Contact;
import io.swagger.v3.oas.annotations.info.Info;
import io.swagger.v3.oas.annotations.info.License;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@OpenAPIDefinition(info=@Info(description="Ant Media Server WHIP endpoint", version="v2.0", title="Ant Media Server WHIP Endpoint", contact=@Contact(name="Ant Media Info", email="contact@antmedia.io", url="https://antmedia.io"), license=@License(name="Apache 2.0", url="https://www.apache.org/licenses/LICENSE-2.0")), externalDocs=@ExternalDocumentation(description="Rest Guide", url="https://antmedia.io/docs"))
@Component
@Path(value="/")
public class WhipEndpoint
extends RestServiceBase {
    private static final Logger logger = LoggerFactory.getLogger(WhipEndpoint.class);

    @Operation(summary="Publish a webrtc stream through WebRTC-HTTP ingestion protocol(WHIP). HTTP for signaling.")
    @POST
    @Consumes(value={"application/sdp"})
    @Path(value="/{streamId}")
    @Produces(value={"application/sdp"})
    public CompletableFuture<Response> startWhipPublish(@Context UriInfo uriInfo, @PathParam(value="streamId") String streamId, @QueryParam(value="video") Boolean enableVideo, @QueryParam(value="audio") Boolean enableAudio, @QueryParam(value="subscriberId") String subscriberId, @QueryParam(value="subscriberCode") String subscriberCode, @QueryParam(value="streamName") String streamName, @QueryParam(value="mainTrack") String mainTrack, @QueryParam(value="metaData") String metaData, @QueryParam(value="linkSession") String linkedSession, @HeaderParam(value="Authorization") String token, @Parameter String sdp) {
        PublishParameters publishParameters = new PublishParameters(streamId);
        publishParameters.setToken(token);
        publishParameters.setEnableVideo(enableVideo == null || enableVideo != false);
        publishParameters.setEnableAudio(enableAudio == null || enableAudio != false);
        publishParameters.setSubscriberId(subscriberId);
        publishParameters.setSubscriberCode(subscriberCode);
        publishParameters.setStreamName(streamName);
        publishParameters.setMainTrack(mainTrack);
        publishParameters.setMetaData(metaData);
        String sessionId = UUID.randomUUID().toString();
        CompletableFuture<Result> startHttpSignaling = this.getApplication().startHttpSignaling(publishParameters, sdp, sessionId);
        return ((CompletableFuture)startHttpSignaling.exceptionally(e -> {
            logger.error("Could not complete webrtc http signaling: {}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            return null;
        })).thenApply(result -> this.prepareResponse((Result)result, sessionId, uriInfo));
    }

    public Response prepareResponse(Result result, String sessionId, UriInfo uriInfo) {
        try {
            if (!result.isSuccess()) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)result.getMessage()).build();
            }
            String defaultStunStr = "stun:stun1.l.google.com:19302; rel=ice-server";
            ArrayList<Object> extensions = new ArrayList<Object>();
            extensions.add(defaultStunStr);
            String turnAddr = this.getApplication().getAppSettings().getStunServerURI();
            String turnServerUsername = this.getApplication().getAppSettings().getTurnServerUsername();
            String turnServerPassword = this.getApplication().getAppSettings().getTurnServerCredential();
            Object turnServerInfo = "";
            if (StringUtils.isNotBlank((CharSequence)turnServerUsername) && StringUtils.isNotBlank((CharSequence)turnServerPassword)) {
                turnServerInfo = turnAddr + "?transport=udp; rel=\"ice-server\" username=" + turnServerUsername + "; credential=" + turnServerPassword;
                extensions.add(turnServerInfo);
            }
            String eTag = sessionId;
            String resource = uriInfo.getRequestUri().toString() + "/" + eTag;
            URI uri = URI.create(resource);
            return Response.created((URI)uri).status(Response.Status.CREATED).entity((Object)result.getMessage()).header("ETag", (Object)eTag).header("Link", (Object)String.join((CharSequence)",", extensions)).type("application/sdp").build();
        }
        catch (Exception e) {
            logger.error("Exception in prepareResponse {}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            return Response.serverError().build();
        }
    }

    @Operation(summary="Stop a webrtc stream through WebRTC-HTTP ingestion protocol(WHIP). HTTP for signaling.")
    @DELETE
    @Consumes(value={"application/sdp"})
    @Path(value="/{streamId}/{eTag}")
    @Produces(value={"application/json"})
    public Response stopWhipPublish(@PathParam(value="streamId") String streamId, @PathParam(value="eTag") String eTag) {
        Result result = this.getApplication().stopWhipBroadcast(streamId, eTag);
        if (result.isSuccess()) {
            return Response.ok().entity((Object)result).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)result).build();
    }
}

