/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.rtmp.message;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.red5.server.net.rtmp.message.Constants;

public class Header
implements Constants,
Cloneable,
Externalizable {
    private static final long serialVersionUID = 8982665579411495024L;
    private int channelId;
    private int timerBase;
    private int timerDelta;
    private int size;
    private byte dataType;
    private Number streamId = 0.0;
    private int extendedTimestamp;

    public int getChannelId() {
        return this.channelId;
    }

    public void setChannelId(int channelId) {
        this.channelId = channelId;
    }

    public byte getDataType() {
        return this.dataType;
    }

    public void setDataType(byte dataType) {
        this.dataType = dataType;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public Number getStreamId() {
        return this.streamId;
    }

    public void setStreamId(Number streamId) {
        this.streamId = streamId;
    }

    public int getExtendedTimestamp() {
        return this.extendedTimestamp;
    }

    public void setExtendedTimestamp(int extendedTimestamp) {
        this.extendedTimestamp = extendedTimestamp;
    }

    public int getTimer() {
        return this.timerBase + this.timerDelta;
    }

    public void setTimer(int timer) {
        this.timerBase = timer;
        this.timerDelta = 0;
    }

    public void setTimerDelta(int timerDelta) {
        this.timerDelta = timerDelta;
    }

    public int getTimerDelta() {
        return this.timerDelta;
    }

    public void setTimerBase(int timerBase) {
        this.timerBase = timerBase;
    }

    public int getTimerBase() {
        return this.timerBase;
    }

    public boolean isEmpty() {
        return !((double)(this.channelId + this.dataType + this.size) + this.streamId.doubleValue() > 0.0);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.channelId;
        result = 31 * result + this.dataType;
        result = 31 * result + this.size;
        result = 31 * result + this.streamId.intValue();
        result = 31 * result + this.getTimer();
        result = 31 * result + this.extendedTimestamp;
        return result;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Header)) {
            return false;
        }
        Header header = (Header)other;
        return header.getChannelId() == this.channelId && header.getDataType() == this.dataType && header.getSize() == this.size && header.getTimer() == this.getTimer() && header.getStreamId() == this.streamId && header.getExtendedTimestamp() == this.extendedTimestamp;
    }

    public Header clone() {
        Header header = new Header();
        header.setChannelId(this.channelId);
        header.setTimerBase(this.timerBase);
        header.setTimerDelta(this.timerDelta);
        header.setSize(this.size);
        header.setDataType(this.dataType);
        header.setStreamId(this.streamId);
        header.setExtendedTimestamp(this.extendedTimestamp);
        return header;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.dataType = in.readByte();
        this.channelId = in.readInt();
        this.size = in.readInt();
        this.streamId = in.readDouble();
        this.timerBase = in.readInt();
        this.timerDelta = in.readInt();
        this.extendedTimestamp = in.readInt();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(this.dataType);
        out.writeInt(this.channelId);
        out.writeInt(this.size);
        out.writeDouble(this.streamId.doubleValue());
        out.writeInt(this.timerBase);
        out.writeInt(this.timerDelta);
        out.writeInt(this.extendedTimestamp);
    }

    public String toString() {
        if (this.isEmpty()) {
            return "empty";
        }
        return "Header [streamId=" + this.streamId + ", channelId=" + this.channelId + ", dataType=" + this.dataType + ", timerBase=" + this.timerBase + ", timerDelta=" + this.timerDelta + ", size=" + this.size + ", extendedTimestamp=" + this.extendedTimestamp + "]";
    }

    public static enum HeaderType {
        HEADER_NEW,
        HEADER_SAME_SOURCE,
        HEADER_TIMER_CHANGE,
        HEADER_CONTINUE;

    }
}

