/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.datastore.db;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import dev.morphia.Datastore;
import dev.morphia.DeleteOptions;
import dev.morphia.Morphia;
import dev.morphia.UpdateOptions;
import dev.morphia.aggregation.expressions.AccumulatorExpressions;
import dev.morphia.aggregation.expressions.Expressions;
import dev.morphia.aggregation.expressions.impls.Expression;
import dev.morphia.aggregation.stages.Group;
import dev.morphia.annotations.Entity;
import dev.morphia.query.FindOptions;
import dev.morphia.query.Query;
import dev.morphia.query.Sort;
import dev.morphia.query.Update;
import dev.morphia.query.filters.Filter;
import dev.morphia.query.filters.Filters;
import dev.morphia.query.filters.LogicalFilter;
import dev.morphia.query.internal.MorphiaCursor;
import dev.morphia.query.updates.UpdateOperator;
import dev.morphia.query.updates.UpdateOperators;
import io.antmedia.datastore.db.DataStore;
import io.antmedia.datastore.db.types.Broadcast;
import io.antmedia.datastore.db.types.BroadcastUpdate;
import io.antmedia.datastore.db.types.ConferenceRoom;
import io.antmedia.datastore.db.types.Endpoint;
import io.antmedia.datastore.db.types.P2PConnection;
import io.antmedia.datastore.db.types.StreamInfo;
import io.antmedia.datastore.db.types.Subscriber;
import io.antmedia.datastore.db.types.SubscriberMetadata;
import io.antmedia.datastore.db.types.TensorFlowObject;
import io.antmedia.datastore.db.types.Token;
import io.antmedia.datastore.db.types.VoD;
import io.antmedia.datastore.db.types.WebRTCViewerInfo;
import java.io.File;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoStore
extends DataStore {
    public static final String VOD_ID = "vodId";
    private static final String VIEWER_ID = "viewerId";
    private static final String TOKEN_ID = "tokenId";
    public static final String STREAM_ID = "streamId";
    public static final String SUBSCRIBER_ID = "subscriberId";
    private static final String MAIN_TRACK_STREAM_ID = "mainTrackStreamId";
    private static final String ROLE = "role";
    private Datastore datastore;
    private Datastore vodDatastore;
    private Datastore tokenDatastore;
    private Datastore subscriberDatastore;
    private Datastore detectionMap;
    private Datastore conferenceRoomDatastore;
    private MongoClient mongoClient;
    protected static Logger logger = LoggerFactory.getLogger(MongoStore.class);
    public static final String IMAGE_ID = "imageId";
    public static final String STATUS = "status";
    private static final String ORIGIN_ADDRESS = "originAdress";
    private static final String START_TIME = "startTime";
    private static final String DURATION = "duration";
    private static final String CREATION_DATE = "creationDate";
    private static final String RTMP_VIEWER_COUNT = "rtmpViewerCount";
    private static final String HLS_VIEWER_COUNT = "hlsViewerCount";
    private static final String DASH_VIEWER_COUNT = "dashViewerCount";
    private static final String WEBRTC_VIEWER_COUNT = "webRTCViewerCount";
    private static final String META_DATA = "metaData";
    private static final String UPDATE_TIME_FIELD = "updateTime";

    public MongoStore(String host, String username, String password, String dbName) {
        String uri = MongoStore.getMongoConnectionUri(host, username, password);
        this.mongoClient = MongoClients.create((String)uri);
        this.datastore = Morphia.createDatastore((MongoClient)this.mongoClient, (String)dbName);
        this.vodDatastore = Morphia.createDatastore((MongoClient)this.mongoClient, (String)(dbName + "VoD"));
        this.tokenDatastore = Morphia.createDatastore((MongoClient)this.mongoClient, (String)(dbName + "_token"));
        this.subscriberDatastore = Morphia.createDatastore((MongoClient)this.mongoClient, (String)(dbName + "_subscriber"));
        this.detectionMap = Morphia.createDatastore((MongoClient)this.mongoClient, (String)(dbName + "detection"));
        this.conferenceRoomDatastore = Morphia.createDatastore((MongoClient)this.mongoClient, (String)(dbName + "room"));
        this.datastore.getMapper().mapPackage("io.antmedia.datastore.db.types");
        this.tokenDatastore.getMapper().mapPackage("io.antmedia.datastore.db.types");
        this.subscriberDatastore.getMapper().mapPackage("io.antmedia.datastore.db.types");
        this.vodDatastore.getMapper().mapPackage("io.antmedia.datastore.db.types");
        this.detectionMap.getMapper().mapPackage("io.antmedia.datastore.db.types");
        this.conferenceRoomDatastore.getMapper().mapPackage("io.antmedia.datastore.db.types");
        this.tokenDatastore.ensureIndexes();
        this.subscriberDatastore.ensureIndexes();
        this.datastore.ensureIndexes();
        this.vodDatastore.ensureIndexes();
        this.detectionMap.ensureIndexes();
        this.conferenceRoomDatastore.ensureIndexes();
        this.available = true;
        this.migrateConferenceRoomsToBroadcasts();
    }

    @Override
    public void migrateConferenceRoomsToBroadcasts() {
        Query query;
        ConferenceRoom conferenceRoom;
        while ((conferenceRoom = (ConferenceRoom)(query = this.conferenceRoomDatastore.find(ConferenceRoom.class)).first()) != null) {
            try {
                Broadcast broadcast = MongoStore.conferenceToBroadcast(conferenceRoom);
                this.save(broadcast);
                this.conferenceRoomDatastore.delete((Object)conferenceRoom);
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
    }

    public static String getMongoConnectionUri(String host, String username, String password) {
        if (host.indexOf("mongodb://") == 0 || host.indexOf("mongodb+srv://") == 0) {
            return host;
        }
        Object credential = "";
        if (username != null && !username.isEmpty()) {
            credential = username + ":" + password + "@";
        }
        String uri = "mongodb://" + (String)credential + host;
        logger.info("uri:{}", (Object)uri);
        return uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String save(Broadcast broadcast) {
        if (broadcast == null) {
            return null;
        }
        try {
            Broadcast updatedBroadcast = super.saveBroadcast(broadcast);
            String streamId = updatedBroadcast.getStreamId();
            MongoStore mongoStore = this;
            synchronized (mongoStore) {
                this.datastore.save((Object)broadcast);
            }
            return streamId;
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Broadcast get(String id) {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            try {
                return (Broadcast)this.datastore.find(Broadcast.class).filter(new Filter[]{Filters.eq((String)STREAM_ID, (Object)id)}).first();
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VoD getVoD(String id) {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            try {
                return (VoD)this.vodDatastore.find(VoD.class).filter(new Filter[]{Filters.eq((String)VOD_ID, (Object)id)}).first();
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateStatus(String id, String status) {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            try {
                Query query = this.datastore.find(Broadcast.class).filter(new Filter[]{Filters.eq((String)STREAM_ID, (Object)id)});
                Update ops = query.update(UpdateOperators.set((String)STATUS, (Object)status), new UpdateOperator[0]);
                if (status.equals("broadcasting")) {
                    ops.add(UpdateOperators.set((String)START_TIME, (Object)System.currentTimeMillis()));
                } else if (status.equals("finished")) {
                    ops.add(UpdateOperators.set((String)WEBRTC_VIEWER_COUNT, (Object)0));
                    ops.add(UpdateOperators.set((String)HLS_VIEWER_COUNT, (Object)0));
                    ops.add(UpdateOperators.set((String)RTMP_VIEWER_COUNT, (Object)0));
                    ops.add(UpdateOperators.set((String)DASH_VIEWER_COUNT, (Object)0));
                }
                UpdateResult update = ops.execute();
                return update.getMatchedCount() == 1L;
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateVoDProcessStatus(String id, String status) {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            try {
                Query query = this.vodDatastore.find(VoD.class).filter(new Filter[]{Filters.eq((String)VOD_ID, (Object)id)});
                Update ops = query.update(UpdateOperators.set((String)"processStatus", (Object)status), new UpdateOperator[0]);
                if ("processing".equals(status)) {
                    ops.add(UpdateOperators.set((String)"processStartTime", (Object)System.currentTimeMillis()));
                } else if ("failed".equals(status) || "finished".equals(status)) {
                    ops.add(UpdateOperators.set((String)"processEndTime", (Object)System.currentTimeMillis()));
                }
                UpdateResult update = ops.execute();
                return update.getMatchedCount() == 1L;
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateDuration(String id, long duration) {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            try {
                Query query = this.datastore.find(Broadcast.class).filter(new Filter[]{Filters.eq((String)STREAM_ID, (Object)id)});
                return query.update(UpdateOperators.set((String)DURATION, (Object)duration), new UpdateOperator[0]).execute().getMatchedCount() == 1L;
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addEndpoint(String id, Endpoint endpoint) {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            if (id != null && endpoint != null) {
                try {
                    Query query = this.datastore.find(Broadcast.class).filter(new Filter[]{Filters.eq((String)STREAM_ID, (Object)id)});
                    return query.update((UpdateOperator)UpdateOperators.push((String)"endPointList", (Object)endpoint), new UpdateOperator[0]).execute().getMatchedCount() == 1L;
                }
                catch (Exception e) {
                    logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeEndpoint(String id, Endpoint endpoint, boolean checkRTMPUrl) {
        boolean result = false;
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            if (id != null && endpoint != null) {
                Query query = this.datastore.find(Broadcast.class).filter(new Filter[]{Filters.eq((String)STREAM_ID, (Object)id)});
                Update update = query.update(UpdateOperators.pullAll((String)"endPointList", Arrays.asList(endpoint)), new UpdateOperator[0]);
                boolean bl = update.execute().getMatchedCount() == 1L;
                return bl;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAllEndpoints(String id) {
        boolean result = false;
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            if (id != null) {
                Query query = this.datastore.find(Broadcast.class).filter(new Filter[]{Filters.eq((String)STREAM_ID, (Object)id)});
                boolean bl = query.update(UpdateOperators.unset((String)"endPointList"), new UpdateOperator[0]).execute().getMatchedCount() == 1L;
                return bl;
            }
        }
        return result;
    }

    @Override
    public long getBroadcastCount() {
        return this.getTotalBroadcastNumber();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean delete(String id) {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            try {
                Query query = this.datastore.find(Broadcast.class).filter(new Filter[]{Filters.eq((String)STREAM_ID, (Object)id)});
                return query.delete().getDeletedCount() == 1L;
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return false;
    }

    private boolean checkIfRegexValid(String regex) {
        try {
            Pattern.compile(regex);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Broadcast> getBroadcastList(int offset, int size, String type, String sortBy, String orderBy, String search) {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            try {
                Query query = this.datastore.find(Broadcast.class);
                this.datastore.ensureIndexes();
                if (size > 250) {
                    size = 250;
                }
                FindOptions findingOptions = new FindOptions().skip(offset).limit(size);
                if (sortBy != null && orderBy != null && !sortBy.isEmpty() && !orderBy.isEmpty()) {
                    findingOptions.sort(new Sort[]{orderBy.equals("desc") ? Sort.descending((String)sortBy) : Sort.ascending((String)sortBy)});
                }
                if (search != null && !search.isEmpty()) {
                    logger.info("Server side search in broadcast for the text -> {}", (Object)search);
                    if (!this.checkIfRegexValid(search)) {
                        query.filter(new Filter[]{Filters.text((String)search)});
                    } else {
                        query.filter(new Filter[]{Filters.or((Filter[])new Filter[]{Filters.regex((String)STREAM_ID).caseInsensitive().pattern(".*" + search + ".*"), Filters.regex((String)"name").caseInsensitive().pattern(".*" + search + ".*")})});
                    }
                }
                if (type != null && !type.isEmpty()) {
                    query.filter(new Filter[]{Filters.eq((String)"type", (Object)type)});
                }
                return query.iterator(findingOptions).toList();
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return null;
    }

    public Datastore getDataStore() {
        return this.datastore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Broadcast> getExternalStreamsList() {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            try {
                Query query = this.datastore.find(Broadcast.class);
                query.filter(new Filter[]{Filters.and((Filter[])new Filter[]{Filters.or((Filter[])new Filter[]{Filters.eq((String)"type", (Object)"ipCamera"), Filters.eq((String)"type", (Object)"streamSource")}), Filters.and((Filter[])new Filter[]{Filters.ne((String)STATUS, (Object)"preparing"), Filters.ne((String)STATUS, (Object)"broadcasting")})})});
                List streamList = query.iterator().toList();
                UpdateResult results = query.update(new UpdateOptions().multi(true), new UpdateOperator[]{UpdateOperators.set((String)STATUS, (Object)"preparing")});
                long updatedCount = results.getModifiedCount();
                if (updatedCount != (long)streamList.size()) {
                    logger.error("Only {} stream status updated out of {}", (Object)updatedCount, (Object)streamList.size());
                }
                return streamList;
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(boolean deleteDB) {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            this.available = false;
            if (deleteDB) {
                this.mongoClient.getDatabase(this.tokenDatastore.getDatabase().getName()).drop();
                this.mongoClient.getDatabase(this.subscriberDatastore.getDatabase().getName()).drop();
                this.mongoClient.getDatabase(this.datastore.getDatabase().getName()).drop();
                this.mongoClient.getDatabase(this.vodDatastore.getDatabase().getName()).drop();
                this.mongoClient.getDatabase(this.detectionMap.getDatabase().getName()).drop();
                this.mongoClient.getDatabase(this.conferenceRoomDatastore.getDatabase().getName()).drop();
            }
            this.mongoClient.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String addVod(VoD vod) {
        String id = null;
        boolean result = false;
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            try {
                if (vod.getVodId() == null) {
                    vod.setVodId(RandomStringUtils.randomAlphanumeric((int)12) + System.currentTimeMillis());
                }
                this.vodDatastore.save((Object)vod);
                result = true;
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
            if (result) {
                id = vod.getVodId();
            }
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<VoD> getVodList(int offset, int size, String sortBy, String orderBy, String filterStreamId, String search) {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            Query query = this.vodDatastore.find(VoD.class);
            if (filterStreamId != null && !filterStreamId.isEmpty()) {
                query.filter(new Filter[]{Filters.eq((String)STREAM_ID, (Object)filterStreamId)});
            }
            FindOptions findOptions = new FindOptions().skip(offset).limit(size);
            if (sortBy != null && orderBy != null && !sortBy.isEmpty() && !orderBy.isEmpty()) {
                String field = sortBy.contentEquals("name") ? "vodName" : CREATION_DATE;
                findOptions.sort(new Sort[]{orderBy.contentEquals("desc") ? Sort.descending((String)field) : Sort.ascending((String)field)});
            }
            if (search != null && !search.isEmpty()) {
                logger.info("Server side search is called for VoD, searchString =  {}", (Object)search);
                query.filter(new Filter[]{Filters.or((Filter[])new Filter[]{Filters.regex((String)STREAM_ID).caseInsensitive().pattern(".*" + search + ".*"), Filters.regex((String)"streamName").caseInsensitive().pattern(".*" + search + ".*"), Filters.regex((String)VOD_ID).caseInsensitive().pattern(".*" + search + ".*"), Filters.regex((String)"vodName").caseInsensitive().pattern(".*" + search + ".*")})});
            }
            return query.iterator(findOptions).toList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteVod(String id) {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            try {
                Query query = this.vodDatastore.find(VoD.class).filter(new Filter[]{Filters.eq((String)VOD_ID, (Object)id)});
                return query.delete().getDeletedCount() == 1L;
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getTotalVodNumber() {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            return this.vodDatastore.find(VoD.class).count();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int fetchUserVodList(File userfile) {
        if (userfile == null) {
            return 0;
        }
        int numberOfSavedFiles = 0;
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            try {
                this.vodDatastore.find(VoD.class).filter(new Filter[]{Filters.eq((String)"type", (Object)"userVod")}).delete(new DeleteOptions().multi(true));
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
            File[] listOfFiles = userfile.listFiles();
            if (listOfFiles != null) {
                for (File file : listOfFiles) {
                    String fileExtension = FilenameUtils.getExtension((String)file.getName());
                    if (!file.isFile() || !"mp4".equals(fileExtension) && !"flv".equals(fileExtension) && !"mkv".equals(fileExtension)) continue;
                    long fileSize = file.length();
                    long unixTime = System.currentTimeMillis();
                    String filePath = file.getPath();
                    String[] subDirs = filePath.split(Pattern.quote(File.separator));
                    Integer pathLength = subDirs.length;
                    String relativePath = "streams/" + subDirs[pathLength - 2] + "/" + subDirs[pathLength - 1];
                    String vodId = RandomStringUtils.randomNumeric((int)24);
                    VoD newVod = new VoD("vodFile", "vodFile", relativePath, file.getName(), unixTime, 0L, 0L, fileSize, "userVod", vodId, null);
                    this.addVod(newVod);
                    ++numberOfSavedFiles;
                }
            }
        }
        return numberOfSavedFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateSourceQualityParametersLocal(String id, String quality, double speed, int pendingPacketQueue) {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            try {
                Query query = this.datastore.find(Broadcast.class).filter(new Filter[]{Filters.eq((String)STREAM_ID, (Object)id)});
                ArrayList<UpdateOperator> updateOperators = new ArrayList<UpdateOperator>();
                updateOperators.add(UpdateOperators.set((String)"speed", (Object)speed));
                updateOperators.add(UpdateOperators.set((String)"pendingPacketSize", (Object)pendingPacketQueue));
                if (quality != null) {
                    updateOperators.add(UpdateOperators.set((String)"quality", (Object)quality));
                }
                return query.update(updateOperators).execute().getModifiedCount() == 1L;
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getTotalBroadcastNumber() {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            return this.datastore.find(Broadcast.class).count();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getPartialBroadcastNumber(String search) {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            Query query = this.datastore.find(Broadcast.class);
            if (search != null && !search.isEmpty()) {
                logger.info("Server side search is called for {}", (Object)search);
                query.filter(new Filter[]{Filters.or((Filter[])new Filter[]{Filters.regex((String)STREAM_ID).caseInsensitive().pattern(".*" + search + ".*"), Filters.regex((String)"name").caseInsensitive().pattern(".*" + search + ".*")})});
            }
            return query.count();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getPartialVodNumber(String search) {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            Query query = this.vodDatastore.find(VoD.class);
            if (search != null && !search.isEmpty()) {
                logger.info("Server side search is called for {}", (Object)search);
                query.filter(new Filter[]{Filters.or((Filter[])new Filter[]{Filters.regex((String)STREAM_ID).caseInsensitive().pattern(".*" + search + ".*"), Filters.regex((String)"streamName").caseInsensitive().pattern(".*" + search + ".*"), Filters.regex((String)VOD_ID).caseInsensitive().pattern(".*" + search + ".*"), Filters.regex((String)"vodName").caseInsensitive().pattern(".*" + search + ".*")})});
            }
            return query.count();
        }
    }

    public Datastore getVodDatastore() {
        return this.vodDatastore;
    }

    public void setVodDatastore(Datastore vodDatastore) {
        this.vodDatastore = vodDatastore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getActiveBroadcastCount() {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            LogicalFilter andFilter = Filters.and((Filter[])new Filter[]{Filters.eq((String)STATUS, (Object)"broadcasting")});
            return this.datastore.find(Broadcast.class).filter(new Filter[]{andFilter}).count();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveDetection(String id, long timeElapsed, List<TensorFlowObject> detectedObjects) {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            if (detectedObjects != null) {
                for (TensorFlowObject tensorFlowObject : detectedObjects) {
                    tensorFlowObject.setDetectionTime(timeElapsed);
                    tensorFlowObject.setImageId(id);
                    this.detectionMap.save((Object)tensorFlowObject);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TensorFlowObject> getDetectionList(String idFilter, int offsetSize, int batchSize) {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            try {
                if (batchSize > 250) {
                    batchSize = 250;
                }
                return this.detectionMap.find(TensorFlowObject.class).iterator(new FindOptions().skip(offsetSize).limit(batchSize)).toList();
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TensorFlowObject> getDetection(String id) {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            try {
                return this.detectionMap.find(TensorFlowObject.class).filter(new Filter[]{Filters.eq((String)IMAGE_ID, (Object)id)}).iterator().toList();
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getObjectDetectedTotal(String id) {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            return this.detectionMap.find(TensorFlowObject.class).filter(new Filter[]{Filters.eq((String)IMAGE_ID, (Object)id)}).count();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateBroadcastFields(String streamId, BroadcastUpdate broadcast) {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            try {
                Query query = this.datastore.find(Broadcast.class).filter(new Filter[]{Filters.eq((String)STREAM_ID, (Object)streamId)});
                ArrayList<UpdateOperator> updates = new ArrayList<UpdateOperator>();
                if (broadcast.getName() != null) {
                    updates.add(UpdateOperators.set((String)"name", (Object)broadcast.getName()));
                }
                if (broadcast.getDescription() != null) {
                    updates.add(UpdateOperators.set((String)"description", (Object)broadcast.getDescription()));
                }
                if (broadcast.getUsername() != null) {
                    updates.add(UpdateOperators.set((String)"username", (Object)broadcast.getUsername()));
                }
                if (broadcast.getPassword() != null) {
                    updates.add(UpdateOperators.set((String)"password", (Object)broadcast.getPassword()));
                }
                if (broadcast.getIpAddr() != null) {
                    updates.add(UpdateOperators.set((String)"ipAddr", (Object)broadcast.getIpAddr()));
                }
                if (broadcast.getStreamUrl() != null) {
                    updates.add(UpdateOperators.set((String)"streamUrl", (Object)broadcast.getStreamUrl()));
                }
                if (broadcast.getLatitude() != null) {
                    updates.add(UpdateOperators.set((String)"latitude", (Object)broadcast.getLatitude()));
                }
                if (broadcast.getLongitude() != null) {
                    updates.add(UpdateOperators.set((String)"longitude", (Object)broadcast.getLongitude()));
                }
                if (broadcast.getAltitude() != null) {
                    updates.add(UpdateOperators.set((String)"altitude", (Object)broadcast.getAltitude()));
                }
                if (broadcast.getMainTrackStreamId() != null) {
                    updates.add(UpdateOperators.set((String)MAIN_TRACK_STREAM_ID, (Object)broadcast.getMainTrackStreamId()));
                }
                if (broadcast.getPlayListItemList() != null) {
                    updates.add(UpdateOperators.set((String)"playListItemList", broadcast.getPlayListItemList()));
                }
                if (broadcast.getPlayListStatus() != null) {
                    updates.add(UpdateOperators.set((String)"playListStatus", (Object)broadcast.getPlayListStatus()));
                }
                if (broadcast.getEndPointList() != null) {
                    updates.add(UpdateOperators.set((String)"endPointList", broadcast.getEndPointList()));
                }
                if (broadcast.getSubFolder() != null) {
                    updates.add(UpdateOperators.set((String)"subFolder", (Object)broadcast.getSubFolder()));
                }
                if (broadcast.getListenerHookURL() != null && !broadcast.getListenerHookURL().isEmpty()) {
                    updates.add(UpdateOperators.set((String)"listenerHookURL", (Object)broadcast.getListenerHookURL()));
                }
                if (broadcast.getSpeed() != null) {
                    updates.add(UpdateOperators.set((String)"speed", (Object)broadcast.getSpeed()));
                }
                if (broadcast.getEncoderSettingsList() != null) {
                    updates.add(UpdateOperators.set((String)"encoderSettingsList", broadcast.getEncoderSettingsList()));
                }
                if (broadcast.getConferenceMode() != null) {
                    updates.add(UpdateOperators.set((String)"conferenceMode", (Object)broadcast.getConferenceMode()));
                }
                if (broadcast.getPlannedStartDate() != null) {
                    updates.add(UpdateOperators.set((String)"plannedStartDate", (Object)broadcast.getPlannedStartDate()));
                }
                if (broadcast.getSeekTimeInMs() != null) {
                    updates.add(UpdateOperators.set((String)"seekTimeInMs", (Object)broadcast.getSeekTimeInMs()));
                }
                if (broadcast.getReceivedBytes() != null) {
                    updates.add(UpdateOperators.set((String)"receivedBytes", (Object)broadcast.getReceivedBytes()));
                }
                if (broadcast.getBitrate() != null) {
                    updates.add(UpdateOperators.set((String)"bitrate", (Object)broadcast.getBitrate()));
                }
                if (broadcast.getUserAgent() != null) {
                    updates.add(UpdateOperators.set((String)"userAgent", (Object)broadcast.getUserAgent()));
                }
                if (broadcast.getWebRTCViewerLimit() != null) {
                    updates.add(UpdateOperators.set((String)"webRTCViewerLimit", (Object)broadcast.getWebRTCViewerLimit()));
                }
                if (broadcast.getHlsViewerLimit() != null) {
                    updates.add(UpdateOperators.set((String)"hlsViewerLimit", (Object)broadcast.getHlsViewerLimit()));
                }
                if (broadcast.getDashViewerLimit() != null) {
                    updates.add(UpdateOperators.set((String)"dashViewerLimit", (Object)broadcast.getDashViewerLimit()));
                }
                if (broadcast.getSubTrackStreamIds() != null) {
                    updates.add(UpdateOperators.set((String)"subTrackStreamIds", broadcast.getSubTrackStreamIds()));
                }
                if (broadcast.getMetaData() != null) {
                    updates.add(UpdateOperators.set((String)META_DATA, (Object)broadcast.getMetaData()));
                }
                if (broadcast.getUpdateTime() != null) {
                    updates.add(UpdateOperators.set((String)UPDATE_TIME_FIELD, (Object)broadcast.getUpdateTime()));
                }
                if (broadcast.getSubtracksLimit() != null) {
                    updates.add(UpdateOperators.set((String)"subtracksLimit", (Object)broadcast.getSubtracksLimit()));
                }
                if (broadcast.getCurrentPlayIndex() != null) {
                    updates.add(UpdateOperators.set((String)"currentPlayIndex", (Object)broadcast.getCurrentPlayIndex()));
                }
                if (broadcast.getPlaylistLoopEnabled() != null) {
                    updates.add(UpdateOperators.set((String)"playlistLoopEnabled", (Object)broadcast.getPlaylistLoopEnabled()));
                }
                if (broadcast.getAutoStartStopEnabled() != null) {
                    updates.add(UpdateOperators.set((String)"autoStartStopEnabled", (Object)broadcast.getAutoStartStopEnabled()));
                }
                if (broadcast.getPendingPacketSize() != null) {
                    updates.add(UpdateOperators.set((String)"pendingPacketSize", (Object)broadcast.getPendingPacketSize()));
                }
                if (broadcast.getPlannedEndDate() != null) {
                    updates.add(UpdateOperators.set((String)"plannedEndDate", (Object)broadcast.getPlannedEndDate()));
                }
                this.prepareFields(broadcast, updates);
                UpdateResult updateResult = query.update(updates).execute();
                return updateResult.getModifiedCount() == 1L;
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
        }
        return false;
    }

    private void prepareFields(BroadcastUpdate broadcast, List<UpdateOperator> updates) {
        if (broadcast.getDuration() != null) {
            updates.add(UpdateOperators.set((String)DURATION, (Object)broadcast.getDuration()));
        }
        if (broadcast.getStartTime() != null) {
            updates.add(UpdateOperators.set((String)START_TIME, (Object)broadcast.getStartTime()));
        }
        if (broadcast.getOriginAdress() != null) {
            updates.add(UpdateOperators.set((String)ORIGIN_ADDRESS, (Object)broadcast.getOriginAdress()));
        }
        if (broadcast.getStatus() != null) {
            updates.add(UpdateOperators.set((String)STATUS, (Object)broadcast.getStatus()));
        }
        if (broadcast.getAbsoluteStartTimeMs() != null) {
            updates.add(UpdateOperators.set((String)"absoluteStartTimeMs", (Object)broadcast.getAbsoluteStartTimeMs()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateHLSViewerCountLocal(String streamId, int diffCount) {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            try {
                Query query = this.datastore.find(Broadcast.class).filter(new Filter[]{Filters.eq((String)STREAM_ID, (Object)streamId)});
                UpdateResult result = query.update(UpdateOperators.inc((String)HLS_VIEWER_COUNT, (Number)diffCount), new UpdateOperator[0]).execute();
                return result.getMatchedCount() == 1L;
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateDASHViewerCountLocal(String streamId, int diffCount) {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            try {
                Query query = this.datastore.find(Broadcast.class).filter(new Filter[]{Filters.eq((String)STREAM_ID, (Object)streamId)});
                UpdateResult result = query.update(UpdateOperators.inc((String)DASH_VIEWER_COUNT, (Number)diffCount), new UpdateOperator[0]).execute();
                return result.getMatchedCount() == 1L;
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
        }
        return false;
    }

    @Override
    public boolean updateWebRTCViewerCountLocal(String streamId, boolean increment) {
        return this.updateViewerField(streamId, increment, WEBRTC_VIEWER_COUNT);
    }

    @Override
    public boolean updateRtmpViewerCountLocal(String streamId, boolean increment) {
        return this.updateViewerField(streamId, increment, RTMP_VIEWER_COUNT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateViewerField(String streamId, boolean increment, String fieldName) {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            try {
                Query query = this.datastore.find(Broadcast.class).filter(new Filter[]{Filters.eq((String)STREAM_ID, (Object)streamId)});
                if (!increment) {
                    query.filter(new Filter[]{Filters.gt((String)fieldName, (Object)0)});
                }
                UpdateResult updateResult = null;
                updateResult = increment ? query.update(UpdateOperators.inc((String)fieldName), new UpdateOperator[0]).execute() : query.update(UpdateOperators.dec((String)fieldName), new UpdateOperator[0]).execute();
                return updateResult.getModifiedCount() == 1L;
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveStreamInfo(StreamInfo streamInfo) {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            this.datastore.find(StreamInfo.class);
            this.datastore.save((Object)streamInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<StreamInfo> getStreamInfoList(String streamId) {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            return this.datastore.find(StreamInfo.class).filter(new Filter[]{Filters.eq((String)STREAM_ID, (Object)streamId)}).iterator().toList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearStreamInfoList(String streamId) {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            Query query = this.datastore.find(StreamInfo.class).filter(new Filter[]{Filters.eq((String)STREAM_ID, (Object)streamId)});
            long count = query.count();
            DeleteResult res = query.delete(new DeleteOptions().multi(true));
            if (res.getDeletedCount() != count) {
                logger.error("{} StreamInfo were deleted out of {} for stream {}", new Object[]{res.getDeletedCount(), count, streamId});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveToken(Token token) {
        boolean result = false;
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            if (token.getStreamId() != null && token.getTokenId() != null) {
                try {
                    this.tokenDatastore.save((Object)token);
                    result = true;
                }
                catch (Exception e) {
                    logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Token validateToken(Token token) {
        Token fetchedToken = null;
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            if (token.getTokenId() != null) {
                Query query = this.tokenDatastore.find(Token.class).filter(new Filter[]{Filters.eq((String)TOKEN_ID, (Object)token.getTokenId())});
                fetchedToken = (Token)query.first();
                if (fetchedToken != null && fetchedToken.getType().equals(token.getType()) && Instant.now().getEpochSecond() < fetchedToken.getExpireDate()) {
                    if (token.getRoomId() == null || token.getRoomId().isEmpty()) {
                        if (fetchedToken.getStreamId().equals(token.getStreamId())) {
                            query.delete(new DeleteOptions().multi(true));
                        } else {
                            fetchedToken = null;
                        }
                    }
                    return fetchedToken;
                }
                fetchedToken = null;
            }
        }
        return fetchedToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean revokeTokens(String streamId) {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            Query query = this.tokenDatastore.find(Token.class).filter(new Filter[]{Filters.eq((String)STREAM_ID, (Object)streamId)});
            DeleteResult delete = query.delete(new DeleteOptions().multi(true));
            return delete.getDeletedCount() >= 1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Token> listAllTokens(String streamId, int offset, int size) {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            return this.tokenDatastore.find(Token.class).filter(new Filter[]{Filters.eq((String)STREAM_ID, (Object)streamId)}).iterator(new FindOptions().skip(offset).limit(size)).toList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Subscriber> listAllSubscribers(String streamId, int offset, int size) {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            return this.subscriberDatastore.find(Subscriber.class).filter(new Filter[]{Filters.eq((String)STREAM_ID, (Object)streamId)}).iterator(new FindOptions().skip(offset).limit(size)).toList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addSubscriber(String streamId, Subscriber subscriber) {
        boolean result = false;
        if (subscriber != null) {
            MongoStore mongoStore = this;
            synchronized (mongoStore) {
                if (subscriber.getStreamId() != null && subscriber.getSubscriberId() != null) {
                    try {
                        this.subscriberDatastore.save((Object)subscriber);
                        result = true;
                    }
                    catch (Exception e) {
                        logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                    }
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteSubscriber(String streamId, String subscriberId) {
        boolean result = false;
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            try {
                Query query = this.subscriberDatastore.find(Subscriber.class).filter(new Filter[]{Filters.eq((String)STREAM_ID, (Object)streamId), Filters.eq((String)SUBSCRIBER_ID, (Object)subscriberId)});
                result = query.delete().getDeletedCount() == 1L;
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean blockSubscriber(String streamId, String subscriberId, String blockedType, int seconds) {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            if (streamId == null || subscriberId == null) {
                return false;
            }
            try {
                UpdateResult updateResult = this.subscriberDatastore.find(Subscriber.class).filter(new Filter[]{Filters.eq((String)STREAM_ID, (Object)streamId), Filters.eq((String)SUBSCRIBER_ID, (Object)subscriberId)}).update(UpdateOperators.set((String)"blockedType", (Object)blockedType), new UpdateOperator[]{UpdateOperators.set((String)"blockedUntilUnitTimeStampMs", (Object)(System.currentTimeMillis() + (long)(seconds * 1000)))}).execute();
                long matchedCount = updateResult.getMatchedCount();
                if (matchedCount == 0L) {
                    Subscriber subscriber = new Subscriber();
                    subscriber.setStreamId(streamId);
                    subscriber.setSubscriberId(subscriberId);
                    subscriber.setBlockedType(blockedType);
                    subscriber.setBlockedUntilUnitTimeStampMs(System.currentTimeMillis() + (long)(seconds * 1000));
                    this.subscriberDatastore.save((Object)subscriber);
                    return true;
                }
                return matchedCount == 1L;
            }
            catch (Exception e) {
                logger.error(e.getMessage());
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean revokeSubscribers(String streamId) {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            Query query = this.subscriberDatastore.find(Subscriber.class).filter(new Filter[]{Filters.eq((String)STREAM_ID, (Object)streamId)});
            DeleteResult delete = query.delete(new DeleteOptions().multi(true));
            return delete.getDeletedCount() >= 1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Subscriber getSubscriber(String streamId, String subscriberId) {
        Subscriber subscriber = null;
        if (subscriberId != null && streamId != null) {
            MongoStore mongoStore = this;
            synchronized (mongoStore) {
                try {
                    subscriber = (Subscriber)this.subscriberDatastore.find(Subscriber.class).filter(new Filter[]{Filters.eq((String)STREAM_ID, (Object)streamId), Filters.eq((String)SUBSCRIBER_ID, (Object)subscriberId)}).first();
                }
                catch (Exception e) {
                    logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                }
            }
        }
        return subscriber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean resetSubscribersConnectedStatus() {
        boolean result = false;
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            try {
                UpdateResult execute = this.subscriberDatastore.find(Subscriber.class).update(new UpdateOptions().multi(true), new UpdateOperator[]{UpdateOperators.set((String)"connected", (Object)false)});
                result = execute.getMatchedCount() > 1L;
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return result;
    }

    @Override
    public boolean setMp4Muxing(String streamId, int enabled) {
        return this.setRecordMuxing(streamId, enabled, "mp4Enabled");
    }

    @Override
    public boolean setWebMMuxing(String streamId, int enabled) {
        return this.setRecordMuxing(streamId, enabled, "webMEnabled");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setRecordMuxing(String streamId, int enabled, String field) {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            try {
                if (streamId != null && (enabled == 1 || enabled == 0 || enabled == -1)) {
                    UpdateResult result = this.datastore.find(Broadcast.class).filter(new Filter[]{Filters.eq((String)STREAM_ID, (Object)streamId)}).update(UpdateOperators.set((String)field, (Object)enabled), new UpdateOperator[0]).execute();
                    boolean bl = result.getMatchedCount() == 1L;
                    return bl;
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteToken(String tokenId) {
        boolean result = false;
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            try {
                return this.tokenDatastore.find(Token.class).filter(new Filter[]{Filters.eq((String)TOKEN_ID, (Object)tokenId)}).delete().getDeletedCount() == 1L;
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Token getToken(String tokenId) {
        Token token = null;
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            try {
                token = (Token)this.tokenDatastore.find(Token.class).filter(new Filter[]{Filters.eq((String)TOKEN_ID, (Object)tokenId)}).first();
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLocalLiveBroadcastCount(String hostAddress) {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            return this.datastore.find(Broadcast.class).filter(new Filter[]{Filters.and((Filter[])new Filter[]{Filters.or((Filter[])new Filter[]{Filters.eq((String)ORIGIN_ADDRESS, (Object)hostAddress), Filters.exists((String)ORIGIN_ADDRESS).not()}), Filters.eq((String)STATUS, (Object)"broadcasting")})}).count();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Broadcast> getLocalLiveBroadcasts(String hostAddress) {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            return this.datastore.find(Broadcast.class).filter(new Filter[]{Filters.and((Filter[])new Filter[]{Filters.or((Filter[])new Filter[]{Filters.eq((String)ORIGIN_ADDRESS, (Object)hostAddress), Filters.exists((String)ORIGIN_ADDRESS).not()}), Filters.eq((String)STATUS, (Object)"broadcasting")})}).iterator().toList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean createP2PConnection(P2PConnection conn) {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            try {
                if (conn != null) {
                    this.datastore.save((Object)conn);
                    return true;
                }
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteP2PConnection(String streamId) {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            try {
                return this.datastore.find(P2PConnection.class).filter(new Filter[]{Filters.eq((String)STREAM_ID, (Object)streamId)}).delete().getDeletedCount() == 1L;
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public P2PConnection getP2PConnection(String streamId) {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            try {
                return (P2PConnection)this.datastore.find(P2PConnection.class).filter(new Filter[]{Filters.eq((String)STREAM_ID, (Object)streamId)}).first();
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addSubTrack(String mainTrackId, String subTrackId) {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            try {
                if (subTrackId != null) {
                    return this.datastore.find(Broadcast.class).filter(new Filter[]{Filters.eq((String)STREAM_ID, (Object)mainTrackId)}).update((UpdateOperator)UpdateOperators.push((String)"subTrackStreamIds", (Object)subTrackId), new UpdateOperator[0]).execute().getMatchedCount() == 1L;
                }
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeSubTrack(String mainTrackId, String subTrackId) {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            try {
                if (subTrackId != null) {
                    return this.datastore.find(Broadcast.class).filter(new Filter[]{Filters.eq((String)STREAM_ID, (Object)mainTrackId)}).update(UpdateOperators.pullAll((String)"subTrackStreamIds", Arrays.asList(subTrackId)), new UpdateOperator[0]).execute().getMatchedCount() == 1L;
                }
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int resetBroadcasts(String hostAddress) {
        int totalOperationCount = 0;
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            totalOperationCount = (int)((long)totalOperationCount + this.datastore.find(Broadcast.class).filter(new Filter[]{Filters.and((Filter[])new Filter[]{Filters.or((Filter[])new Filter[]{Filters.eq((String)ORIGIN_ADDRESS, (Object)hostAddress), Filters.exists((String)ORIGIN_ADDRESS).not()}), Filters.eq((String)"zombi", (Object)true)})}).delete(new DeleteOptions().multi(true)).getDeletedCount());
            totalOperationCount = (int)((long)totalOperationCount + this.datastore.find(Broadcast.class).filter(new Filter[]{Filters.or((Filter[])new Filter[]{Filters.eq((String)ORIGIN_ADDRESS, (Object)hostAddress), Filters.exists((String)ORIGIN_ADDRESS).not()})}).update(UpdateOperators.set((String)WEBRTC_VIEWER_COUNT, (Object)0), new UpdateOperator[]{UpdateOperators.set((String)HLS_VIEWER_COUNT, (Object)0), UpdateOperators.set((String)RTMP_VIEWER_COUNT, (Object)0), UpdateOperators.set((String)STATUS, (Object)"finished")}).execute(new UpdateOptions().multi(true)).getModifiedCount());
            totalOperationCount = (int)((long)totalOperationCount + this.datastore.find(StreamInfo.class).filter(new Filter[]{Filters.eq((String)"host", (Object)hostAddress)}).delete(new DeleteOptions().multi(true)).getDeletedCount());
        }
        return totalOperationCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTotalWebRTCViewersCount() {
        long now = System.currentTimeMillis();
        if (now - this.totalWebRTCViewerCountLastUpdateTime > 5000L) {
            MongoStore mongoStore = this;
            synchronized (mongoStore) {
                int total = 0;
                MorphiaCursor cursor = this.datastore.aggregate(Broadcast.class).match(new Filter[]{Filters.eq((String)STATUS, (Object)"broadcasting")}).group(Group.group().field("total", AccumulatorExpressions.sum((Expression)Expressions.field((String)WEBRTC_VIEWER_COUNT), (Expression[])new Expression[0]))).execute(Summation.class);
                if (cursor.hasNext()) {
                    total = ((Summation)cursor.next()).getTotal();
                }
                this.totalWebRTCViewerCount = total;
                this.totalWebRTCViewerCountLastUpdateTime = now;
            }
        }
        return this.totalWebRTCViewerCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveViewerInfo(WebRTCViewerInfo info) {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            if (info == null) {
                return;
            }
            this.datastore.save((Object)info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<WebRTCViewerInfo> getWebRTCViewerList(int offset, int size, String sortBy, String orderBy, String search) {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            Query query = this.datastore.find(WebRTCViewerInfo.class);
            if (size > 250) {
                size = 250;
            }
            FindOptions findOptions = new FindOptions().skip(offset).limit(size);
            if (sortBy != null && orderBy != null && !sortBy.isEmpty() && !orderBy.isEmpty()) {
                findOptions.sort(new Sort[]{orderBy.equals("desc") ? Sort.descending((String)sortBy) : Sort.ascending((String)sortBy)});
            }
            if (search != null && !search.isEmpty()) {
                logger.info("Server side search is called for WebRTCViewerInfo = {}", (Object)search);
                query.filter(new Filter[]{Filters.regex((String)VIEWER_ID).caseInsensitive().pattern(".*" + search + ".*")});
            }
            return query.iterator(findOptions).toList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteWebRTCViewerInfo(String viewerId) {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            return this.datastore.find(WebRTCViewerInfo.class).filter(new Filter[]{Filters.eq((String)VIEWER_ID, (Object)viewerId)}).delete().getDeletedCount() == 1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateStreamMetaData(String streamId, String metaData) {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            try {
                Query query = this.datastore.find(Broadcast.class).filter(new Filter[]{Filters.eq((String)STREAM_ID, (Object)streamId)});
                return query.update(UpdateOperators.set((String)META_DATA, (Object)metaData), new UpdateOperator[0]).execute().getMatchedCount() == 1L;
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
        }
        return false;
    }

    public Datastore getSubscriberDatastore() {
        return this.subscriberDatastore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SubscriberMetadata getSubscriberMetaData(String subscriberId) {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            try {
                return (SubscriberMetadata)this.datastore.find(SubscriberMetadata.class).filter(new Filter[]{Filters.eq((String)SUBSCRIBER_ID, (Object)subscriberId)}).first();
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putSubscriberMetaData(String subscriberId, SubscriberMetadata metadata) {
        try {
            Query query = this.datastore.find(SubscriberMetadata.class).filter(new Filter[]{Filters.eq((String)SUBSCRIBER_ID, (Object)subscriberId)});
            long deletedCount = query.delete().getDeletedCount();
            if (deletedCount > 0L) {
                logger.info("There is a SubsriberMetadata exists in database. It's deleted(deletedCount:{}) and it'll put to make it easy and compatible.", (Object)deletedCount);
            }
            metadata.setSubscriberId(subscriberId);
            MongoStore mongoStore = this;
            synchronized (mongoStore) {
                this.datastore.save((Object)metadata);
            }
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    public Datastore getConferenceRoomDatastore() {
        return this.conferenceRoomDatastore;
    }

    @Override
    public List<Broadcast> getSubtracks(String mainTrackId, int offset, int size, String role) {
        return this.getSubtracks(mainTrackId, offset, size, role, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Broadcast> getSubtracks(String mainTrackId, int offset, int size, String role, String status) {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            LogicalFilter roleFilter = this.getFilterForSubtracks(mainTrackId, role, status);
            return this.datastore.find(Broadcast.class).filter(new Filter[]{roleFilter}).iterator(new FindOptions().skip(offset).limit(size)).toList();
        }
    }

    private LogicalFilter getFilterForSubtracks(String mainTrackId, String role, String status) {
        LogicalFilter filter = Filters.and((Filter[])new Filter[]{Filters.eq((String)MAIN_TRACK_STREAM_ID, (Object)mainTrackId)});
        if (StringUtils.isNotBlank((CharSequence)role)) {
            filter.add(Filters.eq((String)ROLE, (Object)role));
        }
        if (StringUtils.isNotBlank((CharSequence)status)) {
            filter.add(Filters.eq((String)STATUS, (Object)status));
        }
        return filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getSubtrackCount(String mainTrackId, String role, String status) {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            return this.datastore.find(Broadcast.class).filter(new Filter[]{this.getFilterForSubtracks(mainTrackId, role, status)}).count();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Broadcast> getActiveSubtracks(String mainTrackId, String role) {
        LogicalFilter filterForSubtracks = this.getFilterForSubtracks(mainTrackId, role, "broadcasting");
        long activeIntervalValue = System.currentTimeMillis() - 20000L;
        filterForSubtracks.add(Filters.gte((String)UPDATE_TIME_FIELD, (Object)activeIntervalValue));
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            return this.datastore.find(Broadcast.class).filter(new Filter[]{filterForSubtracks}).iterator().toList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getActiveSubtracksCount(String mainTrackId, String role) {
        LogicalFilter filterForSubtracks = this.getFilterForSubtracks(mainTrackId, role, "broadcasting");
        long activeIntervalValue = System.currentTimeMillis() - 20000L;
        filterForSubtracks.add(Filters.gte((String)UPDATE_TIME_FIELD, (Object)activeIntervalValue));
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            return this.datastore.find(Broadcast.class).filter(new Filter[]{filterForSubtracks}).count();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasSubtracks(String streamId) {
        LogicalFilter filterForSubtracks = this.getFilterForSubtracks(streamId, null, null);
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            return this.datastore.find(Broadcast.class).filter(new Filter[]{filterForSubtracks}).first() != null;
        }
    }

    @Entity
    public static class Summation {
        private int total;

        public int getTotal() {
            return this.total;
        }

        public void setTotal(int total) {
            this.total = total;
        }
    }
}

