/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.datastore.db.types;

import dev.morphia.annotations.Entity;
import dev.morphia.annotations.Field;
import dev.morphia.annotations.Id;
import dev.morphia.annotations.Index;
import dev.morphia.annotations.Indexes;
import io.swagger.v3.oas.annotations.media.Schema;
import org.bson.types.ObjectId;

@Entity(value="detection")
@Indexes(value={@Index(fields={@Field(value="dbId")})})
@Schema(description="The TensorFlow detected object class")
public class TensorFlowObject {
    @Schema(description="The id of the detected object")
    @Id
    private ObjectId dbId;
    @Schema(description="The name of the detected object")
    private String objectName;
    @Schema(description="The probability of the detected object")
    private float probability;
    @Schema(description="The time of the detected object")
    private long detectionTime;
    @Schema(description="The id of the detected image")
    private String imageId;
    @Schema(description="The x coordinate of the upper-left corner of detected object frame")
    private double minX;
    @Schema(description="The y coordinate of the upper-left corner of detected object frame")
    private double minY;
    @Schema(description="The x coordinate of the lower-right corner of detected object frame")
    private double maxX;
    @Schema(description="The y coordinate of the lower-right corner of detected object frame")
    private double maxY;

    public TensorFlowObject(String name, float probability, String imageId) {
        this.objectName = name;
        this.probability = probability;
        this.imageId = imageId;
    }

    public TensorFlowObject(String objectName, float probability, long detectionTime) {
        this.objectName = objectName;
        this.probability = probability;
        this.detectionTime = detectionTime;
    }

    public TensorFlowObject() {
    }

    public long getDetectionTime() {
        return this.detectionTime;
    }

    public void setDetectionTime(long detectionTime) {
        this.detectionTime = detectionTime;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void setObjectName(String objectName) {
        this.objectName = objectName;
    }

    public float getProbability() {
        return this.probability;
    }

    public void setProbability(float probability) {
        this.probability = probability;
    }

    public ObjectId getDbId() {
        return this.dbId;
    }

    public void setDbId(ObjectId dbId) {
        this.dbId = dbId;
    }

    public String getImageId() {
        return this.imageId;
    }

    public void setImageId(String imageId) {
        this.imageId = imageId;
    }

    public double getMinX() {
        return this.minX;
    }

    public void setMinX(double minX) {
        this.minX = minX;
    }

    public double getMinY() {
        return this.minY;
    }

    public void setMinY(double minY) {
        this.minY = minY;
    }

    public double getMaxX() {
        return this.maxX;
    }

    public void setMaxX(double maxX) {
        this.maxX = maxX;
    }

    public double getMaxY() {
        return this.maxY;
    }

    public void setMaxY(double maxY) {
        this.maxY = maxY;
    }
}

