/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.muxer;

import io.antmedia.AppSettings;
import io.antmedia.FFmpegUtilities;
import io.antmedia.muxer.MuxAdaptor;
import io.antmedia.rest.RestServiceBase;
import io.vertx.core.Vertx;
import io.vertx.core.impl.ConcurrentHashSet;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.bytedeco.ffmpeg.avcodec.AVBSFContext;
import org.bytedeco.ffmpeg.avcodec.AVBitStreamFilter;
import org.bytedeco.ffmpeg.avcodec.AVCodec;
import org.bytedeco.ffmpeg.avcodec.AVCodecContext;
import org.bytedeco.ffmpeg.avcodec.AVCodecParameters;
import org.bytedeco.ffmpeg.avcodec.AVPacket;
import org.bytedeco.ffmpeg.avformat.AVFormatContext;
import org.bytedeco.ffmpeg.avformat.AVIOContext;
import org.bytedeco.ffmpeg.avformat.AVStream;
import org.bytedeco.ffmpeg.avutil.AVChannelLayout;
import org.bytedeco.ffmpeg.avutil.AVDictionary;
import org.bytedeco.ffmpeg.avutil.AVRational;
import org.bytedeco.ffmpeg.global.avcodec;
import org.bytedeco.ffmpeg.global.avformat;
import org.bytedeco.ffmpeg.global.avutil;
import org.bytedeco.javacpp.BytePointer;
import org.red5.server.api.IContext;
import org.red5.server.api.scope.IScope;
import org.red5.server.api.stream.IStreamFilenameGenerator;
import org.red5.server.stream.DefaultStreamFilenameGenerator;
import org.red5.server.util.ScopeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;

public abstract class Muxer {
    public static final String BITSTREAM_FILTER_HEVC_MP4TOANNEXB = "hevc_mp4toannexb";
    public static final String BITSTREAM_FILTER_H264_MP4TOANNEXB = "h264_mp4toannexb";
    private long currentVoDTimeStamp = 0L;
    protected String extension;
    protected String format;
    protected boolean isInitialized = false;
    protected Map<String, String> options = new HashMap<String, String>();
    protected Logger logger;
    protected static Logger loggerStatic = LoggerFactory.getLogger(Muxer.class);
    protected AVFormatContext outputFormatContext;
    public static final String DATE_TIME_PATTERN = "yyyy-MM-dd_HH-mm-ss.SSS";
    protected File file;
    protected Vertx vertx;
    protected IScope scope;
    private boolean addDateTimeToResourceName = false;
    protected AtomicBoolean isRunning = new AtomicBoolean(false);
    protected byte[] videoExtradata = null;
    public static final String TEMP_EXTENSION = ".tmp_extension";
    protected int time2log = 0;
    protected AVPacket audioPkt;
    protected List<Integer> registeredStreamIndexList = new ArrayList<Integer>();
    protected Set<String> bsfVideoNames = new ConcurrentHashSet();
    private Set<String> bsfAudioNames = new ConcurrentHashSet();
    protected String streamId = null;
    protected Map<Integer, AVRational> inputTimeBaseMap = new ConcurrentHashMap<Integer, AVRational>();
    protected List<AVBSFContext> bsfFilterContextList = new ArrayList<AVBSFContext>();
    protected Set<AVBSFContext> bsfAudioFilterContextList = new ConcurrentHashSet();
    protected int videoWidth;
    protected int videoHeight;
    protected volatile boolean headerWritten = false;
    protected String initialResourceNameWithoutExtension;
    protected AVPacket tmpPacket;
    protected long firstAudioDts = 0L;
    protected long firstVideoDts = 0L;
    protected AVPacket videoPkt;
    protected int rotation;
    public static final int SEGMENT_INDEX_LENGTH = 9;
    protected Map<Integer, Integer> inputOutputStreamIndexMap = new ConcurrentHashMap<Integer, Integer>();
    private int resolution;
    public static final AVRational avRationalTimeBase = new AVRational();
    protected String subFolder = null;
    protected boolean firstKeyFrameReceived = true;
    private long lastPts;
    protected AVDictionary optionDictionary = new AVDictionary(null);
    private long firstPacketDtsMs = -1L;
    private long audioNotWrittenCount;
    private long videoNotWrittenCount;
    private long totalSizeInBytes;
    private long startTimeInSeconds;
    private long currentTimeInSeconds;

    protected Muxer(Vertx vertx) {
        this.vertx = vertx;
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    public static File getPreviewFile(IScope scope, String name, String extension) {
        String appScopeName = ScopeUtils.findApplication(scope).getName();
        return new File(String.format("%s/webapps/%s/%s", System.getProperty("red5.root"), appScopeName, "previews/" + name + extension));
    }

    public static File getRecordFile(IScope scope, String name, String extension, String subFolder) {
        IStreamFilenameGenerator generator = (IStreamFilenameGenerator)ScopeUtils.getScopeService(scope, IStreamFilenameGenerator.class, DefaultStreamFilenameGenerator.class);
        String fileName = generator.generateFilename(scope, name, extension, IStreamFilenameGenerator.GenerationType.RECORD, subFolder);
        File file = null;
        if (generator.resolvesToAbsolutePath()) {
            file = new File(fileName);
        } else {
            Resource resource = scope.getContext().getResource(fileName);
            if (resource.exists()) {
                try {
                    file = resource.getFile();
                    loggerStatic.debug("File exists: {} writable: {}", (Object)file.exists(), (Object)file.canWrite());
                }
                catch (IOException ioe) {
                    loggerStatic.error("File error: {}", (Object)ExceptionUtils.getStackTrace((Throwable)ioe));
                }
            } else {
                String appScopeName = ScopeUtils.findApplication(scope).getName();
                file = new File(String.format("%s/webapps/%s/%s", System.getProperty("red5.root"), appScopeName, fileName));
            }
        }
        return file;
    }

    public static File getUserRecordFile(IScope scope, String userVoDFolder, String name) {
        String appScopeName = ScopeUtils.findApplication(scope).getName();
        return new File(String.format("%s/webapps/%s/%s", System.getProperty("red5.root"), appScopeName, "streams/" + userVoDFolder + "/" + name));
    }

    public synchronized boolean addStream(AVCodec codec, AVCodecContext codecContext, int streamIndex) {
        AVCodecParameters codecParameter = new AVCodecParameters();
        int ret = avcodec.avcodec_parameters_from_context((AVCodecParameters)codecParameter, (AVCodecContext)codecContext);
        if (ret < 0) {
            this.logger.error("Cannot get codec parameters for {}", (Object)this.streamId);
            return false;
        }
        return this.addStream(codecParameter, codecContext.time_base(), streamIndex);
    }

    public String getOutputURL() {
        return this.file.getAbsolutePath();
    }

    public boolean openIO() {
        if ((this.getOutputFormatContext().oformat().flags() & 1) == 0) {
            AVIOContext pb = new AVIOContext(null);
            String url = this.getOutputURL();
            int ret = avformat.avio_open2((AVIOContext)pb, (String)url, (int)2, null, (AVDictionary)this.getOptionDictionary());
            if (ret < 0) {
                this.logger.warn("Could not open output url: {} ", (Object)url);
                return false;
            }
            this.getOutputFormatContext().pb(pb);
        }
        return true;
    }

    public synchronized boolean prepareIO() {
        if (this.isRunning.get()) {
            this.logger.warn("Muxer is already running for stream: {} so it's not preparing io again and returning", (Object)this.streamId);
            return false;
        }
        boolean result = false;
        if (this.openIO()) {
            result = this.writeHeader();
        }
        return result;
    }

    public boolean writeHeader() {
        int ret;
        AVDictionary optionsDictionary = null;
        if (!this.options.isEmpty()) {
            optionsDictionary = new AVDictionary();
            Set<String> keySet = this.options.keySet();
            for (String key : keySet) {
                avutil.av_dict_set((AVDictionary)optionsDictionary, (String)key, (String)this.options.get(key), (int)0);
            }
        }
        if ((ret = avformat.avformat_write_header((AVFormatContext)this.getOutputFormatContext(), (AVDictionary)optionsDictionary)) < 0) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Could not write header. File: {} Error: {}", (Object)this.file.getAbsolutePath(), (Object)Muxer.getErrorDefinition(ret));
            }
            this.clearResource();
            return false;
        }
        this.logger.info("Header is written for stream:{} and url:{}", (Object)this.streamId, (Object)this.getOutputURL());
        if (optionsDictionary != null) {
            avutil.av_dict_free((AVDictionary)optionsDictionary);
        }
        this.isRunning.set(true);
        this.headerWritten = true;
        return true;
    }

    public synchronized void writeTrailer() {
        if (!this.isRunning.get() || this.outputFormatContext == null) {
            this.logger.warn("OutputFormatContext is not initialized or it is freed for stream: {}", (Object)this.streamId);
            return;
        }
        this.logger.info("writing trailer for stream: {}", (Object)this.streamId);
        this.isRunning.set(false);
        avformat.av_write_trailer((AVFormatContext)this.outputFormatContext);
        this.clearResource();
    }

    protected synchronized void clearResource() {
        if (this.tmpPacket != null) {
            avcodec.av_packet_free((AVPacket)this.tmpPacket);
            this.tmpPacket = null;
        }
        if (this.videoPkt != null) {
            avcodec.av_packet_free((AVPacket)this.videoPkt);
            this.videoPkt = null;
        }
        if (this.audioPkt != null) {
            avcodec.av_packet_free((AVPacket)this.audioPkt);
            this.audioPkt = null;
        }
        for (AVBSFContext videoBsfFilterContext : this.bsfFilterContextList) {
            avcodec.av_bsf_free((AVBSFContext)videoBsfFilterContext);
        }
        this.bsfFilterContextList.clear();
        if (this.outputFormatContext != null && (this.outputFormatContext.oformat().flags() & 1) == 0 && this.outputFormatContext.pb() != null && (this.outputFormatContext.flags() & 0x80) == 0) {
            avformat.avio_closep((AVIOContext)this.outputFormatContext.pb());
        }
        if (this.outputFormatContext != null) {
            avformat.avformat_free_context((AVFormatContext)this.outputFormatContext);
            this.outputFormatContext = null;
        }
        avutil.av_dict_free((AVDictionary)this.optionDictionary);
    }

    public synchronized void writePacket(AVPacket pkt, AVStream stream) {
        if (this.checkToDropPacket(pkt, stream.codecpar().codec_type())) {
            return;
        }
        if (!this.isRunning.get() || !this.registeredStreamIndexList.contains(pkt.stream_index())) {
            this.logPacketIssue("Not writing packet1 for {} - Is running:{} or stream index({}) is registered: {} to {}", this.streamId, this.isRunning.get(), pkt.stream_index(), this.registeredStreamIndexList.contains(pkt.stream_index()), this.getOutputURL());
            return;
        }
        int inputStreamIndex = pkt.stream_index();
        int outputStreamIndex = this.inputOutputStreamIndexMap.get(inputStreamIndex);
        AVStream outStream = this.outputFormatContext.streams(outputStreamIndex);
        pkt.stream_index(outputStreamIndex);
        this.writePacket(pkt, this.inputTimeBaseMap.get(inputStreamIndex), outStream.time_base(), outStream.codecpar().codec_type());
        pkt.stream_index(inputStreamIndex);
    }

    public void logPacketIssue(String format, Object ... arguments) {
        if (this.time2log % 200 == 0) {
            this.logger.warn(format, arguments);
            this.time2log = 0;
        }
        ++this.time2log;
    }

    public synchronized void writePacket(AVPacket pkt, AVCodecContext codecContext) {
        if (!this.isRunning.get() || !this.registeredStreamIndexList.contains(pkt.stream_index())) {
            this.logPacketIssue("Not writing packet for {} - Is running:{} or stream index({}) is registered: {}", this.streamId, this.isRunning.get(), pkt.stream_index(), this.registeredStreamIndexList.contains(pkt.stream_index()));
            return;
        }
        int inputStreamIndex = pkt.stream_index();
        int outputStreamIndex = this.inputOutputStreamIndexMap.get(inputStreamIndex);
        AVStream outStream = this.outputFormatContext.streams(outputStreamIndex);
        AVRational codecTimebase = this.inputTimeBaseMap.get(inputStreamIndex);
        int codecType = outStream.codecpar().codec_type();
        if (!this.checkToDropPacket(pkt, codecType)) {
            this.writePacket(pkt, codecTimebase, outStream.time_base(), codecType);
        }
    }

    public ByteBuffer getPacketBufferWithExtradata(byte[] extradata, AVPacket pkt) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(extradata.length + pkt.size());
        byteBuffer.put(extradata);
        if (pkt.size() > 0) {
            this.logger.debug("Adding extradata to record muxer packet pkt size:{}", (Object)pkt.size());
            byteBuffer.put(pkt.data().position(0L).limit((long)pkt.size()).asByteBuffer());
        }
        return byteBuffer;
    }

    public void setAudioBitreamFilter(String bsfName) {
        this.bsfAudioNames.add(bsfName);
    }

    public Set<String> getBsfAudioNames() {
        return this.bsfAudioNames;
    }

    public void setBitstreamFilter(String bsfName) {
        this.bsfVideoNames.add(bsfName);
    }

    public String getBitStreamFilter() {
        if (!this.bsfVideoNames.isEmpty()) {
            return this.bsfVideoNames.iterator().next();
        }
        return null;
    }

    public File getFile() {
        return this.file;
    }

    public String getFileName() {
        if (this.file != null) {
            return this.file.getName();
        }
        return null;
    }

    public String getFormat() {
        return this.format;
    }

    public void init(IScope scope, String name, int resolution, String subFolder, int videoBitrate) {
        this.streamId = name;
        this.init(scope, name, resolution, true, subFolder, videoBitrate);
    }

    public void init(IScope scope, String name, int resolution, boolean overrideIfExist, String subFolder, int bitrate) {
        if (!this.isInitialized) {
            this.isInitialized = true;
            this.scope = scope;
            this.resolution = resolution;
            AppSettings appSettings = this.getAppSettings();
            this.initialResourceNameWithoutExtension = this.getExtendedName(name, resolution, bitrate, appSettings.getFileNameFormat());
            this.setSubfolder(subFolder);
            this.file = this.getResourceFile(scope, this.initialResourceNameWithoutExtension, this.extension, this.subFolder);
            File parentFile = this.file.getParentFile();
            if (!parentFile.exists()) {
                parentFile.mkdirs();
            } else {
                File tempFile = this.getResourceFile(scope, this.initialResourceNameWithoutExtension, this.extension + TEMP_EXTENSION, this.subFolder);
                if (!overrideIfExist && (this.file.exists() || tempFile.exists())) {
                    Object tmpName = this.initialResourceNameWithoutExtension;
                    int i = 1;
                    do {
                        tempFile = this.getResourceFile(scope, (String)tmpName, this.extension + TEMP_EXTENSION, this.subFolder);
                        this.file = this.getResourceFile(scope, (String)tmpName, this.extension, this.subFolder);
                        tmpName = this.initialResourceNameWithoutExtension + "_" + i;
                        ++i;
                    } while (this.file.exists() || tempFile.exists());
                }
            }
            this.audioPkt = avcodec.av_packet_alloc();
            avcodec.av_init_packet((AVPacket)this.audioPkt);
            this.videoPkt = avcodec.av_packet_alloc();
            avcodec.av_init_packet((AVPacket)this.videoPkt);
            this.tmpPacket = avcodec.av_packet_alloc();
            avcodec.av_init_packet((AVPacket)this.tmpPacket);
        }
    }

    public void setSubfolder(String subFolder) {
        this.subFolder = subFolder;
    }

    public AppSettings getAppSettings() {
        IContext context = this.scope.getContext();
        ApplicationContext appCtx = context.getApplicationContext();
        return (AppSettings)appCtx.getBean("app.settings");
    }

    public String getExtendedName(String name, int resolution, int bitrate, String fileNameFormat) {
        Object resourceName = name;
        int bitrateKbps = bitrate / 1000;
        LocalDateTime ldt = LocalDateTime.now();
        this.currentVoDTimeStamp = ldt.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
        if (this.addDateTimeToResourceName) {
            resourceName = name + "-" + ldt.format(DateTimeFormatter.ofPattern(DATE_TIME_PATTERN));
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Date time resource name: {} local date time: {}", resourceName, (Object)ldt.format(DateTimeFormatter.ofPattern(DATE_TIME_PATTERN)));
            }
        }
        String lowerCaseFormat = fileNameFormat.toLowerCase();
        if (resolution != 0 && lowerCaseFormat.contains("%r") && bitrateKbps != 0 && lowerCaseFormat.contains("%b")) {
            resourceName = (String)resourceName + (lowerCaseFormat.indexOf("r") > lowerCaseFormat.indexOf("b") ? "_" + bitrateKbps + "kbps" + resolution + "p" : "_" + resolution + "p" + bitrateKbps + "kbps");
        } else if (resolution != 0 && lowerCaseFormat.contains("%r") && (bitrateKbps == 0 || !lowerCaseFormat.contains("%b"))) {
            resourceName = (String)resourceName + "_" + resolution + "p";
        } else if ((resolution == 0 || !lowerCaseFormat.contains("%r")) && bitrateKbps != 0 && lowerCaseFormat.contains("%b")) {
            resourceName = (String)resourceName + "_" + bitrateKbps + "kbps";
        } else if (!lowerCaseFormat.contains("%r") && !lowerCaseFormat.contains("%b") && resolution != 0) {
            this.logger.info("No identifier found for file name, adding resolution");
            resourceName = (String)resourceName + "_" + resolution + "p";
        }
        return resourceName;
    }

    public File getResourceFile(IScope scope, String name, String extension, String subFolder) {
        return Muxer.getRecordFile(scope, name, extension, subFolder);
    }

    public boolean isAddDateTimeToSourceName() {
        return this.addDateTimeToResourceName;
    }

    public void setAddDateTimeToSourceName(boolean addDateTimeToSourceName) {
        this.addDateTimeToResourceName = addDateTimeToSourceName;
    }

    public synchronized boolean addVideoStream(int width, int height, AVRational timebase, int codecId, int streamIndex, boolean isAVC, AVCodecParameters codecpar) {
        boolean result = false;
        AVFormatContext outputContext = this.getOutputFormatContext();
        if (outputContext != null && this.isCodecSupported(codecId) && !this.isRunning.get()) {
            this.registeredStreamIndexList.add(streamIndex);
            AVStream outStream = avformat.avformat_new_stream((AVFormatContext)outputContext, null);
            outStream.codecpar().width(width);
            outStream.codecpar().height(height);
            outStream.codecpar().codec_id(codecId);
            outStream.codecpar().codec_type(0);
            outStream.codecpar().format(0);
            outStream.codecpar().codec_tag(0);
            AVRational timeBase = new AVRational();
            timeBase.num(1).den(1000);
            this.inputTimeBaseMap.put(streamIndex, timeBase);
            this.inputOutputStreamIndexMap.put(streamIndex, outStream.index());
            this.videoWidth = width;
            this.videoHeight = height;
            result = true;
        }
        return result;
    }

    public synchronized boolean addAudioStream(int sampleRate, AVChannelLayout channelLayout, int codecId, int streamIndex) {
        boolean result = false;
        AVFormatContext outputContext = this.getOutputFormatContext();
        if (outputContext != null && this.isCodecSupported(codecId)) {
            this.registeredStreamIndexList.add(streamIndex);
            AVStream outStream = avformat.avformat_new_stream((AVFormatContext)outputContext, null);
            outStream.codecpar().sample_rate(sampleRate);
            outStream.codecpar().ch_layout(channelLayout);
            outStream.codecpar().codec_id(codecId);
            outStream.codecpar().codec_type(1);
            outStream.codecpar().codec_tag(0);
            AVRational timeBase = new AVRational();
            timeBase.num(1).den(sampleRate);
            this.inputTimeBaseMap.put(streamIndex, timeBase);
            this.inputOutputStreamIndexMap.put(streamIndex, outStream.index());
            result = true;
        }
        return result;
    }

    public AVStream avNewStream(AVFormatContext context) {
        return avformat.avformat_new_stream((AVFormatContext)context, null);
    }

    public synchronized boolean addStream(AVCodecParameters codecParameters, AVRational timebase, int streamIndex) {
        if (this.isRunning.get()) {
            this.logger.warn("It is already running and cannot add new stream while it's running for stream:{} and output:{}", (Object)this.streamId, (Object)this.getOutputURL());
            return false;
        }
        boolean result = false;
        AVFormatContext outputContext = this.getOutputFormatContext();
        if (outputContext != null && this.isCodecSupported(codecParameters.codec_id()) && (codecParameters.codec_type() == 1 || codecParameters.codec_type() == 0)) {
            String codecType;
            AVStream outStream = this.avNewStream(outputContext);
            this.registeredStreamIndexList.add(streamIndex);
            if (codecParameters.codec_type() == 0) {
                codecType = "video";
                for (String bsfVideoName : this.bsfVideoNames) {
                    AVBSFContext videoBitstreamFilter = this.initVideoBitstreamFilter(bsfVideoName, codecParameters, timebase);
                    if (videoBitstreamFilter == null) continue;
                    codecParameters = videoBitstreamFilter.par_out();
                    timebase = videoBitstreamFilter.time_base_out();
                }
                this.videoWidth = codecParameters.width();
                this.videoHeight = codecParameters.height();
            } else {
                codecType = "audio";
                for (String bsfAudioName : this.bsfAudioNames) {
                    AVBSFContext audioBitstreamFilter = this.initAudioBitstreamFilter(bsfAudioName, codecParameters, timebase);
                    if (audioBitstreamFilter == null) continue;
                    codecParameters = audioBitstreamFilter.par_out();
                    timebase = audioBitstreamFilter.time_base_out();
                }
            }
            avcodec.avcodec_parameters_copy((AVCodecParameters)outStream.codecpar(), (AVCodecParameters)codecParameters);
            this.logger.info("Adding timebase to the input time base map index:{} value: {}/{} for stream:{} type:{}", new Object[]{outStream.index(), timebase.num(), timebase.den(), this.streamId, codecType});
            this.inputTimeBaseMap.put(streamIndex, timebase);
            this.inputOutputStreamIndexMap.put(streamIndex, outStream.index());
            outStream.codecpar().codec_tag(0);
            result = true;
        } else if (codecParameters.codec_type() == 2) {
            if (codecParameters.codec_id() == 98313) {
                AVStream outStream = this.avNewStream(outputContext);
                this.registeredStreamIndexList.add(streamIndex);
                avcodec.avcodec_parameters_copy((AVCodecParameters)outStream.codecpar(), (AVCodecParameters)codecParameters);
                this.logger.info("Adding ID3 stream timebase to the input time base map index:{} value: {}/{} for stream:{}", new Object[]{outStream.index(), timebase.num(), timebase.den(), this.streamId});
                this.inputTimeBaseMap.put(streamIndex, timebase);
                this.inputOutputStreamIndexMap.put(streamIndex, outStream.index());
            }
            result = true;
        } else {
            this.logger.warn("Stream is not added for muxing to {} for stream:{}", (Object)this.getFileName(), (Object)this.streamId);
        }
        return result;
    }

    public AVBSFContext initAudioBitstreamFilter(String bsfAudioName, AVCodecParameters codecParameters, AVRational timebase) {
        AVBSFContext audioBsfFilterContext = this.initBitstreamFilter(bsfAudioName, codecParameters, timebase);
        if (audioBsfFilterContext != null) {
            this.bsfAudioFilterContextList.add(audioBsfFilterContext);
        }
        return audioBsfFilterContext;
    }

    public AVBSFContext initVideoBitstreamFilter(String bsfVideoName, AVCodecParameters codecParameters, AVRational timebase) {
        AVBSFContext videoBsfFilterContext = this.initBitstreamFilter(bsfVideoName, codecParameters, timebase);
        if (videoBsfFilterContext != null) {
            this.bsfFilterContextList.add(videoBsfFilterContext);
        }
        return videoBsfFilterContext;
    }

    private AVBSFContext initBitstreamFilter(String bsfVideoName, AVCodecParameters codecParameters, AVRational timebase) {
        AVBitStreamFilter bsfilter = avcodec.av_bsf_get_by_name((String)bsfVideoName);
        if (bsfilter == null) {
            this.logger.error("cannot find bit stream filter for {}", (Object)bsfVideoName);
            return null;
        }
        AVBSFContext videoBsfFilterContext = new AVBSFContext(null);
        int ret = avcodec.av_bsf_alloc((AVBitStreamFilter)bsfilter, (AVBSFContext)videoBsfFilterContext);
        if (ret < 0) {
            this.logger.error("cannot allocate bsf context for {}", (Object)this.getOutputURL());
            return null;
        }
        ret = avcodec.avcodec_parameters_copy((AVCodecParameters)videoBsfFilterContext.par_in(), (AVCodecParameters)codecParameters);
        if (ret < 0) {
            this.logger.error("cannot copy input codec parameters for {}", (Object)this.getOutputURL());
            return null;
        }
        videoBsfFilterContext.time_base_in(timebase);
        ret = avcodec.av_bsf_init((AVBSFContext)videoBsfFilterContext);
        if (ret < 0) {
            this.logger.error("cannot init bit stream filter context for {}", (Object)this.getOutputURL());
            return null;
        }
        return videoBsfFilterContext;
    }

    public synchronized void writeVideoBuffer(ByteBuffer encodedVideoFrame, long dts, int frameRotation, int streamIndex, boolean isKeyFrame, long firstFrameTimeStamp, long pts) {
        VideoBuffer videoBuffer = new VideoBuffer();
        videoBuffer.setEncodedVideoFrame(encodedVideoFrame);
        videoBuffer.setTimeStamps(dts, pts, firstFrameTimeStamp, pts);
        videoBuffer.setFrameRotation(frameRotation);
        videoBuffer.setStreamIndex(streamIndex);
        videoBuffer.setKeyFrame(isKeyFrame);
        this.writeVideoBuffer(videoBuffer);
    }

    public synchronized void writeVideoBuffer(VideoBuffer buffer) {
        if (!this.isRunning.get()) {
            this.logPacketIssue("Not writing VideoBuffer for {} because Is running:{}", this.streamId, this.isRunning.get());
            return;
        }
        this.rotation = buffer.getFrameRotation();
        this.videoPkt.stream_index(buffer.getStreamIndex());
        this.videoPkt.pts(buffer.getPts());
        this.videoPkt.dts(buffer.getDts());
        if (buffer.isKeyFrame()) {
            this.videoPkt.flags(this.videoPkt.flags() | 1);
        }
        buffer.getEncodedVideoFrame().rewind();
        this.videoPkt.data(new BytePointer(buffer.getEncodedVideoFrame()));
        this.videoPkt.size(buffer.getEncodedVideoFrame().limit());
        this.videoPkt.position(0L);
        this.writePacket(this.videoPkt, (AVCodecContext)null);
        avcodec.av_packet_unref((AVPacket)this.videoPkt);
    }

    public synchronized void writeAudioBuffer(ByteBuffer audioFrame, int streamIndex, long timestamp) {
        if (!this.isRunning.get()) {
            this.logPacketIssue("Not writing AudioBuffer for {} because Is running:{}", this.streamId, this.isRunning.get());
            return;
        }
        this.audioPkt.stream_index(streamIndex);
        this.audioPkt.pts(timestamp);
        this.audioPkt.dts(timestamp);
        audioFrame.rewind();
        this.audioPkt.flags(this.audioPkt.flags() | 1);
        this.audioPkt.data(new BytePointer(audioFrame));
        this.audioPkt.size(audioFrame.limit());
        this.audioPkt.position(0L);
        this.writePacket(this.audioPkt, (AVCodecContext)null);
        avcodec.av_packet_unref((AVPacket)this.audioPkt);
    }

    public List<Integer> getRegisteredStreamIndexList() {
        return this.registeredStreamIndexList;
    }

    public void setIsRunning(AtomicBoolean isRunning) {
        this.isRunning = isRunning;
    }

    public void setOption(String optionName, String value) {
        avutil.av_dict_set((AVDictionary)this.optionDictionary, (String)optionName, (String)value, (int)0);
    }

    public AVDictionary getOptionDictionary() {
        return this.optionDictionary;
    }

    public abstract boolean isCodecSupported(int var1);

    public abstract AVFormatContext getOutputFormatContext();

    public boolean checkToDropPacket(AVPacket pkt, int codecType) {
        if (!this.firstKeyFrameReceived && codecType == 0) {
            if (this.firstPacketDtsMs == -1L) {
                this.firstVideoDts = pkt.dts();
                this.firstPacketDtsMs = avutil.av_rescale_q((long)pkt.dts(), (AVRational)this.inputTimeBaseMap.get(pkt.stream_index()), (AVRational)MuxAdaptor.TIME_BASE_FOR_MS);
            } else if (this.firstVideoDts == -1L) {
                this.firstVideoDts = avutil.av_rescale_q((long)this.firstPacketDtsMs, (AVRational)MuxAdaptor.TIME_BASE_FOR_MS, (AVRational)this.inputTimeBaseMap.get(pkt.stream_index()));
                if (pkt.dts() - this.firstVideoDts < 0L) {
                    this.firstVideoDts = pkt.dts();
                }
            }
            int keyFrame = pkt.flags() & 1;
            if (keyFrame == 1) {
                this.firstKeyFrameReceived = true;
                this.logger.warn("First key frame received for stream: {}", (Object)this.streamId);
            } else {
                this.logger.info("First video packet is not key frame. It will drop for direct muxing. Stream {}", (Object)this.streamId);
                return true;
            }
        }
        return false;
    }

    public int getVideoWidth() {
        return this.videoWidth;
    }

    public int getVideoHeight() {
        return this.videoHeight;
    }

    public long getAverageBitrate() {
        long duration = this.currentTimeInSeconds - this.startTimeInSeconds;
        if (duration > 0L) {
            return this.totalSizeInBytes / duration * 8L;
        }
        return 0L;
    }

    protected synchronized void writePacket(AVPacket pkt, AVRational inputTimebase, AVRational outputTimebase, int codecType) {
        AVFormatContext context = this.getOutputFormatContext();
        long pts = pkt.pts();
        long dts = pkt.dts();
        long duration = pkt.duration();
        long pos = pkt.pos();
        pkt.duration(avutil.av_rescale_q((long)pkt.duration(), (AVRational)inputTimebase, (AVRational)outputTimebase));
        pkt.pos(-1L);
        this.totalSizeInBytes += (long)pkt.size();
        this.currentTimeInSeconds = avutil.av_rescale_q((long)pkt.dts(), (AVRational)inputTimebase, (AVRational)avRationalTimeBase);
        if (this.startTimeInSeconds == 0L) {
            this.startTimeInSeconds = this.currentTimeInSeconds;
        }
        if (codecType == 1) {
            if (this.firstPacketDtsMs == -1L) {
                this.firstAudioDts = pkt.dts();
                this.firstPacketDtsMs = avutil.av_rescale_q((long)pkt.dts(), (AVRational)this.inputTimeBaseMap.get(pkt.stream_index()), (AVRational)MuxAdaptor.TIME_BASE_FOR_MS);
                this.logger.debug("The first incoming packet is audio and its packet dts:{}ms streamId:{} ", (Object)this.firstPacketDtsMs, (Object)this.streamId);
            } else if (this.firstAudioDts == -1L) {
                this.firstAudioDts = avutil.av_rescale_q((long)this.firstPacketDtsMs, (AVRational)MuxAdaptor.TIME_BASE_FOR_MS, (AVRational)this.inputTimeBaseMap.get(pkt.stream_index()));
                this.logger.debug("First packetDtsMs:{}ms is already received calculated the firstAudioDts:{} and incoming packet dts:{} streamId:{}", new Object[]{this.firstPacketDtsMs, this.firstAudioDts, pkt.dts(), this.streamId});
                if (pkt.dts() - this.firstAudioDts < 0L) {
                    this.firstAudioDts = pkt.dts();
                }
            }
            pkt.pts(avutil.av_rescale_q_rnd((long)(pkt.pts() - this.firstAudioDts), (AVRational)inputTimebase, (AVRational)outputTimebase, (int)8197));
            pkt.dts(avutil.av_rescale_q_rnd((long)(pkt.dts() - this.firstAudioDts), (AVRational)inputTimebase, (AVRational)outputTimebase, (int)8197));
            int ret = avcodec.av_packet_ref((AVPacket)this.tmpPacket, (AVPacket)pkt);
            if (ret < 0) {
                this.logger.error("Cannot copy audio packet for {}", (Object)this.streamId);
                return;
            }
            this.writeAudioFrame(this.tmpPacket, inputTimebase, outputTimebase, context, dts);
            avcodec.av_packet_unref((AVPacket)this.tmpPacket);
        } else if (codecType == 0) {
            int ret;
            pkt.pts(avutil.av_rescale_q_rnd((long)(pkt.pts() - this.firstVideoDts), (AVRational)inputTimebase, (AVRational)outputTimebase, (int)8197));
            pkt.dts(avutil.av_rescale_q_rnd((long)(pkt.dts() - this.firstVideoDts), (AVRational)inputTimebase, (AVRational)outputTimebase, (int)8197));
            boolean isKeyFrame = false;
            if ((pkt.flags() & 1) == 1) {
                isKeyFrame = true;
            }
            if ((ret = avcodec.av_packet_ref((AVPacket)this.tmpPacket, (AVPacket)pkt)) < 0) {
                this.logger.error("Cannot copy video packet for {}", (Object)this.streamId);
                return;
            }
            this.addExtradataIfRequired(pkt, isKeyFrame);
            this.lastPts = this.tmpPacket.pts();
            this.writeVideoFrame(this.tmpPacket, context);
            avcodec.av_packet_unref((AVPacket)this.tmpPacket);
        } else {
            pkt.pts(avutil.av_rescale_q_rnd((long)pkt.pts(), (AVRational)inputTimebase, (AVRational)outputTimebase, (int)8197));
            pkt.dts(avutil.av_rescale_q_rnd((long)pkt.dts(), (AVRational)inputTimebase, (AVRational)outputTimebase, (int)8197));
            this.writeDataFrame(pkt, context);
        }
        pkt.pts(pts);
        pkt.dts(dts);
        pkt.duration(duration);
        pkt.pos(pos);
    }

    public void writeDataFrame(AVPacket pkt, AVFormatContext context) {
        int ret = avcodec.av_packet_ref((AVPacket)this.tmpPacket, (AVPacket)pkt);
        if (ret < 0) {
            this.logger.error("Cannot copy data packet for {}", (Object)this.streamId);
            return;
        }
        ret = avformat.av_write_frame((AVFormatContext)context, (AVPacket)this.tmpPacket);
        if (ret < 0 && this.logger.isWarnEnabled()) {
            this.logPacketIssue("cannot frame to muxer({}) not audio and not video. Error is {} ", this.file.getName(), Muxer.getErrorDefinition(ret));
        }
        avcodec.av_packet_unref((AVPacket)this.tmpPacket);
    }

    public void addExtradataIfRequired(AVPacket pkt, boolean isKeyFrame) {
        if (this.videoExtradata != null && this.videoExtradata.length > 0 && isKeyFrame) {
            ByteBuffer byteBuffer = this.getPacketBufferWithExtradata(this.videoExtradata, pkt);
            byteBuffer.position(0);
            this.tmpPacket.data(new BytePointer(byteBuffer));
            this.tmpPacket.size(byteBuffer.limit());
        }
    }

    protected void writeVideoFrame(AVPacket pkt, AVFormatContext context) {
        int ret;
        for (AVBSFContext videoBsfFilterContext : this.bsfFilterContextList) {
            ret = avcodec.av_bsf_send_packet((AVBSFContext)videoBsfFilterContext, (AVPacket)pkt);
            if (ret < 0) {
                this.logger.warn("Cannot send packet to bit stream filter for stream:{}", (Object)this.streamId);
                return;
            }
            avcodec.av_bsf_receive_packet((AVBSFContext)videoBsfFilterContext, (AVPacket)pkt);
        }
        this.logger.trace("write video packet pts:{} dts:{}", (Object)pkt.pts(), (Object)pkt.dts());
        ret = avformat.av_write_frame((AVFormatContext)context, (AVPacket)pkt);
        if (ret < 0) {
            ++this.videoNotWrittenCount;
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("cannot write video frame to muxer({}). Pts: {} dts:{}  Error is {} ", new Object[]{this.file.getName(), pkt.pts(), pkt.dts(), Muxer.getErrorDefinition(ret)});
            }
        }
    }

    protected void writeAudioFrame(AVPacket pkt, AVRational inputTimebase, AVRational outputTimebase, AVFormatContext context, long dts) {
        int ret;
        for (AVBSFContext audioBsfFilterContext : this.bsfAudioFilterContextList) {
            ret = avcodec.av_bsf_send_packet((AVBSFContext)audioBsfFilterContext, (AVPacket)pkt);
            if (ret < 0) {
                this.logger.warn("Cannot send packet to bit stream filter for stream:{}", (Object)this.streamId);
                return;
            }
            avcodec.av_bsf_receive_packet((AVBSFContext)audioBsfFilterContext, (AVPacket)pkt);
        }
        this.logger.trace("write audio packet pts:{} dts:{}", (Object)pkt.pts(), (Object)pkt.dts());
        ret = avformat.av_write_frame((AVFormatContext)context, (AVPacket)pkt);
        if (ret < 0) {
            ++this.audioNotWrittenCount;
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("cannot write audio frame to muxer({}).Pts: {} dts:{}. Error is {} ", new Object[]{this.file.getName(), pkt.pts(), pkt.dts(), Muxer.getErrorDefinition(ret)});
            }
        }
    }

    public static long getDurationInMs(File f, String streamId) {
        return Muxer.getDurationInMs(f.getAbsolutePath(), streamId);
    }

    public static long getDurationInMs(String url, String streamId) {
        AVFormatContext inputFormatContext = avformat.avformat_alloc_context();
        if (streamId != null) {
            streamId = RestServiceBase.replaceCharsForSecurity(streamId);
        }
        if (url != null) {
            url = RestServiceBase.replaceCharsForSecurity(url);
        }
        if (avformat.avformat_open_input((AVFormatContext)inputFormatContext, (String)url, null, (AVDictionary)null) < 0) {
            loggerStatic.info("cannot open input context for duration for stream: {} for file:{}", (Object)streamId, (Object)url);
            avformat.avformat_close_input((AVFormatContext)inputFormatContext);
            return -2L;
        }
        int ret = avformat.avformat_find_stream_info((AVFormatContext)inputFormatContext, (AVDictionary)null);
        if (ret < 0) {
            loggerStatic.info("Could not find stream information for stream: {} for file:{}", (Object)streamId, (Object)url);
            avformat.avformat_close_input((AVFormatContext)inputFormatContext);
            return -3L;
        }
        long durationInMS = -1L;
        if (inputFormatContext.duration() != avutil.AV_NOPTS_VALUE) {
            durationInMS = inputFormatContext.duration() / 1000L;
        }
        avformat.avformat_close_input((AVFormatContext)inputFormatContext);
        return durationInMS;
    }

    public static String getErrorDefinition(int errorCode) {
        byte[] data = new byte[128];
        avutil.av_strerror((int)errorCode, (byte[])data, (long)data.length);
        return FFmpegUtilities.byteArrayToString(data);
    }

    public synchronized void contextWillChange(AVCodecContext codecContext, int streamIndex) {
    }

    public synchronized void contextChanged(AVCodecContext codecContext, int streamIndex) {
        if (codecContext.codec_type() == 0) {
            this.videoWidth = codecContext.width();
            this.videoHeight = codecContext.height();
            this.videoExtradata = new byte[codecContext.extradata_size()];
            if (this.videoExtradata.length > 0) {
                BytePointer extraDataPointer = codecContext.extradata();
                extraDataPointer.get(this.videoExtradata).close();
                extraDataPointer.close();
                this.logger.info("extra data 0: {}  1: {}, 2:{}, 3:{}, 4:{}", new Object[]{this.videoExtradata[0], this.videoExtradata[1], this.videoExtradata[2], this.videoExtradata[3], this.videoExtradata[4]});
            }
        }
        this.inputTimeBaseMap.put(streamIndex, codecContext.time_base());
    }

    public Map<Integer, AVRational> getInputTimeBaseMap() {
        return this.inputTimeBaseMap;
    }

    public AVPacket getTmpPacket() {
        return this.tmpPacket;
    }

    public AtomicBoolean getIsRunning() {
        return this.isRunning;
    }

    public long getCurrentVoDTimeStamp() {
        return this.currentVoDTimeStamp;
    }

    public void setCurrentVoDTimeStamp(long currentVoDTimeStamp) {
        this.currentVoDTimeStamp = currentVoDTimeStamp;
    }

    public int getResolution() {
        return this.resolution;
    }

    public long getLastPts() {
        return this.lastPts;
    }

    public static String replaceDoubleSlashesWithSingleSlash(String url) {
        return url.replaceAll("(?<!:)//", "/");
    }

    public long getVideoNotWrittenCount() {
        return this.videoNotWrittenCount;
    }

    public long getAudioNotWrittenCount() {
        return this.audioNotWrittenCount;
    }

    public void writeMetaData(String data, long dts) {
    }

    static {
        avRationalTimeBase.num(1);
        avRationalTimeBase.den(1);
    }

    public static class VideoBuffer {
        private ByteBuffer encodedVideoFrame;
        private long dts;
        private long pts;
        private long firstFrameTimeStamp;
        private long originalFrameTimeMs;
        private int frameRotation;
        private int streamIndex;
        private boolean keyFrame;

        public void setEncodedVideoFrame(ByteBuffer encodedVideoFrame) {
            this.encodedVideoFrame = encodedVideoFrame;
        }

        public void setTimeStamps(long dts, long pts, long firstFrameTimeStamp, long originalFrameTimeMs) {
            this.dts = dts;
            this.pts = pts;
            this.firstFrameTimeStamp = firstFrameTimeStamp;
            this.originalFrameTimeMs = originalFrameTimeMs;
        }

        public void setFrameRotation(int frameRotation) {
            this.frameRotation = frameRotation;
        }

        public void setStreamIndex(int streamIndex) {
            this.streamIndex = streamIndex;
        }

        public void setKeyFrame(boolean isKeyFrame) {
            this.keyFrame = isKeyFrame;
        }

        public ByteBuffer getEncodedVideoFrame() {
            return this.encodedVideoFrame;
        }

        public long getDts() {
            return this.dts;
        }

        public long getPts() {
            return this.pts;
        }

        public long getFirstFrameTimeStamp() {
            return this.firstFrameTimeStamp;
        }

        public int getFrameRotation() {
            return this.frameRotation;
        }

        public int getStreamIndex() {
            return this.streamIndex;
        }

        public boolean isKeyFrame() {
            return this.keyFrame;
        }

        public long getOriginalFrameTimeMs() {
            return this.originalFrameTimeMs;
        }
    }
}

