/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.muxer.parser;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Parser {
    protected int currentBit;
    protected byte[] data;
    protected boolean errorOccured = false;
    protected int width;
    protected int height;
    private boolean nalUnitParsing;
    private static Logger logger = LoggerFactory.getLogger(Parser.class);

    public Parser(byte[] data, int offset, boolean nalUnitParsing) {
        this.nalUnitParsing = nalUnitParsing;
        this.data = data;
        this.currentBit = offset * 8;
        this.parse();
    }

    protected abstract void parse();

    protected int readBit() {
        int nIndex = this.currentBit / 8;
        int nOffset = this.currentBit % 8 + 1;
        ++this.currentBit;
        int result = this.data[nIndex] >> 8 - nOffset & 1;
        if (this.nalUnitParsing && this.currentBit % 8 == 0 && (nIndex = this.currentBit / 8) >= 2 && this.data[nIndex - 2] == 0 && this.data[nIndex - 1] == 0 && this.data[nIndex] == 3) {
            this.currentBit += 8;
        }
        return result;
    }

    protected int readBits(int n) {
        int r = 0;
        for (int i = 0; i < n; ++i) {
            r |= this.readBit() << n - i - 1;
        }
        return r;
    }

    protected int readExponentialGolombCode() {
        int i;
        int r = 0;
        for (i = 0; this.readBit() == 0 && i < 32; ++i) {
        }
        r = this.readBits(i);
        return r += (1 << i) - 1;
    }

    protected int readSE() {
        int r = this.readExponentialGolombCode();
        r = (r & 1) != 0 ? (r + 1) / 2 : -(r / 2);
        return r;
    }

    protected byte[] readByte(int numBytes) {
        byte[] result = new byte[numBytes];
        for (int i = 0; i < numBytes; ++i) {
            result[i] = (byte)this.readBits(8);
        }
        return result;
    }

    public boolean isErrorOccured() {
        return this.errorOccured;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }
}

