/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.plugin;

import io.antmedia.plugin.api.IFrameListener;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.bytedeco.ffmpeg.avutil.AVFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrameFeeder {
    private String streamId;
    private Queue<IFrameListener> listeners = new ConcurrentLinkedQueue<IFrameListener>();
    private static final Logger logger = LoggerFactory.getLogger(FrameFeeder.class);

    public FrameFeeder(String streamId) {
        this.streamId = streamId;
    }

    public AVFrame onVideoFrame(AVFrame frame) {
        IFrameListener iFrameListener;
        AVFrame processedFrame = frame;
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext() && (processedFrame = (iFrameListener = (IFrameListener)iterator.next()).onVideoFrame(this.streamId, processedFrame)) != null) {
        }
        return processedFrame;
    }

    public AVFrame onAudioFrame(AVFrame frame) {
        IFrameListener iFrameListener;
        AVFrame processedFrame = frame;
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext() && (processedFrame = (iFrameListener = (IFrameListener)iterator.next()).onAudioFrame(this.streamId, processedFrame)) != null) {
        }
        return processedFrame;
    }

    public void addListener(IFrameListener listener) {
        this.listeners.add(listener);
    }

    public void writeTrailer() {
        for (IFrameListener iFrameListener : this.listeners) {
            iFrameListener.writeTrailer(this.streamId);
        }
    }

    public void removeFrameListener(IFrameListener listener) {
        this.listeners.remove(listener);
    }
}

