/*
 * Decompiled with CFR 0.152.
 */
package org.red5.codec;

import org.apache.mina.core.buffer.IoBuffer;
import org.red5.codec.AVCVideo;
import org.red5.codec.VideoCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HEVCVideo
extends AVCVideo {
    private static Logger log = LoggerFactory.getLogger(HEVCVideo.class);
    static final String CODEC_NAME = "HEVC";

    @Override
    public String getName() {
        return CODEC_NAME;
    }

    @Override
    public boolean canDropFrames() {
        return true;
    }

    @Override
    public boolean canHandleData(IoBuffer data) {
        boolean result = false;
        if (data.limit() > 0) {
            result = (data.get() & 0xF) == VideoCodec.HEVC.getId();
            data.rewind();
        }
        return result;
    }

    @Override
    public boolean addData(IoBuffer data, int timestamp) {
        if (data.hasRemaining()) {
            int start = data.position();
            byte frameType = data.get();
            byte hevcType = data.get();
            if ((frameType & 0xF) == VideoCodec.HEVC.getId()) {
                if ((frameType & 0xF0) == 16) {
                    if (log.isDebugEnabled()) {
                        log.debug("Keyframe - HEVC type: {}", (Object)hevcType);
                    }
                    data.rewind();
                    this.setFrames(data, timestamp, hevcType);
                } else if (this.bufferInterframes) {
                    if (log.isDebugEnabled()) {
                        log.debug("Interframe - HEVC type: {}", (Object)hevcType);
                    }
                    data.rewind();
                    this.setInterFrame(data);
                }
            } else {
                log.debug("Non-hevc data, rejecting");
                data.position(start);
                return false;
            }
            data.position(start);
        }
        return true;
    }
}

