/*
 * Decompiled with CFR 0.152.
 */
package org.red5.io;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.red5.io.FileKeyFrameMetaCache;
import org.red5.io.flv.IKeyFrameDataAnalyzer;

public class CachingFileKeyFrameMetaCache
extends FileKeyFrameMetaCache {
    private Map<String, IKeyFrameDataAnalyzer.KeyFrameMeta> inMemoryMetaCache = new HashMap<String, IKeyFrameDataAnalyzer.KeyFrameMeta>();
    private ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private int maxCacheEntry = 500;
    private Random random = new Random();

    private void freeCachingMetadata() {
        int cacheSize = this.inMemoryMetaCache.size();
        int randomIndex = this.random.nextInt(cacheSize);
        Map.Entry<String, IKeyFrameDataAnalyzer.KeyFrameMeta> entryToRemove = null;
        for (Map.Entry<String, IKeyFrameDataAnalyzer.KeyFrameMeta> cacheEntry : this.inMemoryMetaCache.entrySet()) {
            if (randomIndex == 0) {
                entryToRemove = cacheEntry;
                break;
            }
            --randomIndex;
        }
        if (entryToRemove != null) {
            this.inMemoryMetaCache.remove(entryToRemove.getKey());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IKeyFrameDataAnalyzer.KeyFrameMeta loadKeyFrameMeta(File file) {
        IKeyFrameDataAnalyzer.KeyFrameMeta keyFrameMeta;
        this.rwLock.readLock().lock();
        try {
            String canonicalPath;
            block12: {
                canonicalPath = file.getCanonicalPath();
                if (!this.inMemoryMetaCache.containsKey(canonicalPath)) {
                    this.rwLock.readLock().unlock();
                    this.rwLock.writeLock().lock();
                    try {
                        IKeyFrameDataAnalyzer.KeyFrameMeta keyFrameMeta2;
                        if (this.inMemoryMetaCache.size() >= this.maxCacheEntry) {
                            this.freeCachingMetadata();
                        }
                        if ((keyFrameMeta2 = super.loadKeyFrameMeta(file)) != null) {
                            this.inMemoryMetaCache.put(canonicalPath, keyFrameMeta2);
                            break block12;
                        }
                        IKeyFrameDataAnalyzer.KeyFrameMeta keyFrameMeta3 = null;
                        return keyFrameMeta3;
                    }
                    finally {
                        this.rwLock.writeLock().unlock();
                        this.rwLock.readLock().lock();
                    }
                }
            }
            keyFrameMeta = this.inMemoryMetaCache.get(canonicalPath);
            return keyFrameMeta;
        }
        catch (IOException e) {
            keyFrameMeta = null;
            return keyFrameMeta;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    @Override
    public void removeKeyFrameMeta(File file) {
        this.rwLock.writeLock().lock();
        try {
            String canonicalPath = file.getCanonicalPath();
            this.inMemoryMetaCache.remove(canonicalPath);
        }
        catch (IOException iOException) {
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
        super.removeKeyFrameMeta(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveKeyFrameMeta(File file, IKeyFrameDataAnalyzer.KeyFrameMeta meta) {
        this.rwLock.writeLock().lock();
        try {
            String canonicalPath = file.getCanonicalPath();
            if (this.inMemoryMetaCache.containsKey(canonicalPath)) {
                this.inMemoryMetaCache.remove(canonicalPath);
            }
        }
        catch (IOException iOException) {
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
        super.saveKeyFrameMeta(file, meta);
    }

    public void setMaxCacheEntry(int maxCacheEntry) {
        this.maxCacheEntry = maxCacheEntry;
    }
}

