/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.adapter;

import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.red5.server.adapter.MultiThreadedApplicationAdapter;
import org.red5.server.api.IClient;
import org.red5.server.api.IConnection;
import org.red5.server.api.scope.IScope;

public class ApplicationAdapter
extends MultiThreadedApplicationAdapter {
    private Semaphore lock;

    @Override
    public boolean start(IScope scope) {
        if (this.lock == null) {
            this.lock = new Semaphore(1, true);
        }
        try {
            this.lock.tryAcquire(1L, TimeUnit.SECONDS);
            boolean bl = super.start(scope);
            return bl;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            Thread.currentThread().interrupt();
        }
        finally {
            this.lock.release();
        }
        return false;
    }

    @Override
    public void stop(IScope scope) {
        try {
            this.lock.tryAcquire(1L, TimeUnit.SECONDS);
            super.stop(scope);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            Thread.currentThread().interrupt();
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean connect(IConnection conn, IScope scope, Object[] params) {
        try {
            this.lock.tryAcquire(1L, TimeUnit.SECONDS);
            boolean bl = super.connect(conn, scope, params);
            return bl;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            Thread.currentThread().interrupt();
        }
        finally {
            this.lock.release();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect(IConnection conn, IScope scope) {
        try {
            this.lock.tryAcquire(1L, TimeUnit.SECONDS);
            super.disconnect(conn, scope);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            Thread.currentThread().interrupt();
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean join(IClient client, IScope scope) {
        try {
            this.lock.tryAcquire(1L, TimeUnit.SECONDS);
            boolean bl = super.join(client, scope);
            return bl;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            Thread.currentThread().interrupt();
        }
        finally {
            this.lock.release();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void leave(IClient client, IScope scope) {
        try {
            this.lock.tryAcquire(1L, TimeUnit.SECONDS);
            super.leave(client, scope);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            Thread.currentThread().interrupt();
        }
        finally {
            this.lock.release();
        }
    }
}

