/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.scheduling;

import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.red5.server.api.scheduling.IScheduledJob;
import org.red5.server.api.scheduling.ISchedulingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.quartz.QuartzJobBean;

public class QuartzSchedulingServiceJob
extends QuartzJobBean {
    private Logger log = LoggerFactory.getLogger(QuartzSchedulingServiceJob.class);
    protected static final String SCHEDULING_SERVICE = "scheduling_service";
    protected static final String SCHEDULED_JOB = "scheduled_job";
    private JobDataMap jobDataMap;

    public void setJobDataMap(JobDataMap jobDataMap) {
        this.log.debug("Set job data map: {}", (Object)jobDataMap);
        this.jobDataMap = jobDataMap;
    }

    public void execute() {
        this.log.debug("execute");
        ISchedulingService service = null;
        Object job = null;
        try {
            service = (ISchedulingService)this.jobDataMap.get((Object)SCHEDULING_SERVICE);
            job = (IScheduledJob)this.jobDataMap.get((Object)SCHEDULED_JOB);
            job.execute(service);
        }
        catch (Throwable e) {
            if (job == null) {
                this.log.error("Job not found");
            }
            this.log.error("Job {} execution failed", (Object)job.toString(), (Object)e);
        }
    }

    protected void executeInternal(JobExecutionContext executionContext) throws JobExecutionException {
        this.log.debug("execute: {}", (Object)executionContext);
        ISchedulingService service = null;
        Object job = null;
        try {
            JobDetail jobDetail = executionContext.getJobDetail();
            JobDataMap dataMap = jobDetail.getJobDataMap();
            service = (ISchedulingService)dataMap.get((Object)SCHEDULING_SERVICE);
            job = (IScheduledJob)dataMap.get((Object)SCHEDULED_JOB);
            job.execute(service);
        }
        catch (Throwable e) {
            if (job == null) {
                this.log.error("Job not found");
            }
            this.log.error("Job {} execution failed", (Object)job.toString(), (Object)e);
        }
    }
}

