/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.tomcat;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.util.Map;
import javax.management.JMX;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Loader;
import org.apache.catalina.Valve;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardHost;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.red5.server.ContextLoader;
import org.red5.server.LoaderBase;
import org.red5.server.jmx.mxbeans.ContextLoaderMXBean;
import org.red5.server.jmx.mxbeans.TomcatVHostLoaderMXBean;
import org.red5.server.tomcat.TomcatApplicationLoader;
import org.red5.server.tomcat.TomcatLoader;
import org.red5.server.util.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.XmlWebApplicationContext;

@ManagedResource(objectName="org.red5.server:type=TomcatVHostLoader", description="TomcatVHostLoader")
public class TomcatVHostLoader
extends TomcatLoader
implements TomcatVHostLoaderMXBean {
    private static Logger log = LoggerFactory.getLogger(TomcatVHostLoader.class);
    protected String webappRoot;
    protected String name;
    protected String domain;
    protected boolean autoDeploy;
    protected boolean liveDeploy;
    protected boolean startChildren = true;
    protected boolean unpackWARs;
    private ObjectName oName;
    private String defaultApplicationContextId = "default.context";

    @Override
    public void start() throws ServletException {
        File[] dirs;
        log.info("Loading tomcat virtual host");
        if (this.webappFolder != null && this.webappFolder.equals(this.webappRoot)) {
            log.error("Web application root cannot be the same as base");
            return;
        }
        ClassLoader classloader = Thread.currentThread().getContextClassLoader();
        if (this.host == null) {
            this.host = this.createHost();
        }
        this.host.setParentClassLoader(classloader);
        Object propertyPrefix = this.name;
        if (this.domain != null) {
            propertyPrefix = (String)propertyPrefix + "_" + this.domain.replace('.', '_');
        }
        log.debug("Generating name (for props) {}", propertyPrefix);
        System.setProperty((String)propertyPrefix + ".webapp.root", this.webappRoot);
        log.info("Virtual host root: {}", (Object)this.webappRoot);
        log.info("Virtual host context id: {}", (Object)this.defaultApplicationContextId);
        File appDirBase = new File(this.webappRoot);
        for (File file : dirs = appDirBase.listFiles(new TomcatLoader.DirectoryFilter())) {
            String dirName = "/" + file.getName();
            if (null != this.host.findChild(dirName)) continue;
            String webappContextDir = FileUtil.formatPath(appDirBase.getAbsolutePath(), dirName);
            Context ctx = null;
            if ("/root".equals(dirName) || "/root".equalsIgnoreCase(dirName)) {
                log.debug("Adding ROOT context");
                ctx = this.addContext("/", webappContextDir);
            } else {
                log.debug("Adding context from directory scan: {}", (Object)dirName);
                ctx = this.addContext(dirName, webappContextDir);
            }
            log.debug("Context: {}", (Object)ctx);
            webappContextDir = null;
        }
        appDirBase = null;
        dirs = null;
        if (log.isDebugEnabled()) {
            for (File file : this.host.findChildren()) {
                log.debug("Context child name: {}", (Object)file.getName());
            }
        }
        engine.addChild((Container)this.host);
        try {
            log.info("Starting Tomcat virtual host");
            LoaderBase.setApplicationLoader(new TomcatApplicationLoader(embedded, this.host, applicationContext));
            for (File file : this.host.findChildren()) {
                if (!(file instanceof StandardContext)) continue;
                StandardContext ctx = (StandardContext)file;
                ServletContext servletContext = ctx.getServletContext();
                log.debug("Context initialized: {}", (Object)servletContext.getContextPath());
                servletContext.setAttribute("red5.host.id", (Object)this.getHostId());
                String prefix = servletContext.getRealPath("/");
                log.debug("Path: {}", (Object)prefix);
                try {
                    ApplicationContext context;
                    Loader cldr = ctx.getLoader();
                    log.debug("Loader type: {}", (Object)cldr.getClass().getName());
                    ClassLoader webClassLoader = cldr.getClassLoader();
                    log.debug("Webapp classloader: {}", (Object)webClassLoader);
                    XmlWebApplicationContext appctx = new XmlWebApplicationContext();
                    appctx.setClassLoader(webClassLoader);
                    URL internalAppConfig = this.getClass().getClassLoader().getResource("WEB-INF/application.xml");
                    appctx.setConfigLocations(new String[]{"/WEB-INF/red5-*.xml", internalAppConfig.toString()});
                    if (applicationContext.containsBean(this.defaultApplicationContextId)) {
                        appctx.setParent((ApplicationContext)applicationContext.getBean(this.defaultApplicationContextId));
                    } else {
                        log.warn("{} bean was not found in context: {}", (Object)this.defaultApplicationContextId, (Object)applicationContext.getDisplayName());
                        if (applicationContext.containsBean("context.loader")) {
                            ContextLoader contextLoader = (ContextLoader)applicationContext.getBean("context.loader");
                            appctx.setParent(contextLoader.getContext(this.defaultApplicationContextId));
                        } else {
                            log.debug("Context loader was not found, trying JMX");
                            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
                            ContextLoaderMXBean proxy = null;
                            ObjectName oName = null;
                            try {
                                oName = new ObjectName("org.red5.server:name=contextLoader,type=ContextLoader");
                                if (mbs.isRegistered(oName)) {
                                    proxy = JMX.newMXBeanProxy(mbs, oName, ContextLoaderMXBean.class, true);
                                    log.debug("Context loader was found");
                                    proxy.setParentContext(this.defaultApplicationContextId, appctx.getId());
                                } else {
                                    log.warn("Context loader was not found");
                                }
                            }
                            catch (Exception e) {
                                log.warn("Exception looking up ContextLoader", (Throwable)e);
                            }
                        }
                    }
                    if (log.isDebugEnabled() && (context = appctx.getParent()) != null) {
                        log.debug("Parent application context: {}", (Object)context.getDisplayName());
                    }
                    appctx.setServletContext(servletContext);
                    servletContext.setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, (Object)appctx);
                    appctx.refresh();
                }
                catch (Throwable t) {
                    log.error("Error setting up context: {}", (Object)servletContext.getContextPath(), (Object)t);
                    log.error(ExceptionUtils.getStackTrace((Throwable)t));
                }
            }
        }
        catch (Exception e) {
            log.error("Error loading Tomcat virtual host", (Throwable)e);
        }
    }

    @Override
    public void destroy() throws Exception {
        Container[] children;
        log.debug("TomcatVHostLoader un-init");
        for (Container c : children = this.host.findChildren()) {
            if (!(c instanceof StandardContext)) continue;
            try {
                ((StandardContext)c).stop();
                this.host.removeChild(c);
            }
            catch (Exception e) {
                log.error("Could not stop context: {}", (Object)c.getName(), (Object)e);
            }
        }
        Object propertyPrefix = this.name;
        if (this.domain != null) {
            propertyPrefix = (String)propertyPrefix + "_" + this.domain.replace('.', '_');
        }
        System.clearProperty((String)propertyPrefix + ".webapp.root");
        try {
            ((StandardHost)this.host).stop();
        }
        catch (LifecycleException e) {
            log.error("Could not stop host: {}", (Object)this.host.getName(), (Object)e);
        }
        engine.removeChild((Container)this.host);
        this.unregisterJMX();
    }

    @Override
    public boolean startWebApplication(String applicationName) throws ServletException {
        boolean result = false;
        log.info("Starting Tomcat virtual host - Web application");
        log.info("Virtual host root: {}", (Object)this.webappRoot);
        log.info("Virtual host context id: {}", (Object)this.defaultApplicationContextId);
        String contextName = "/" + applicationName;
        Container cont = null;
        cont = this.host.findChild(contextName);
        if (cont == null) {
            log.debug("Context did not exist in host");
            String webappContextDir = FileUtil.formatPath(this.webappRoot, applicationName);
            Context ctx = this.addContext(contextName, webappContextDir);
            cont = ctx;
        } else {
            log.debug("Context already exists in host");
        }
        try {
            ApplicationContext context;
            ServletContext servletContext = ((Context)cont).getServletContext();
            log.debug("Context initialized: {}", (Object)servletContext.getContextPath());
            String prefix = servletContext.getRealPath("/");
            log.debug("Path: {}", (Object)prefix);
            Loader cldr = ((Context)cont).getLoader();
            log.debug("Loader type: {}", (Object)cldr.getClass().getName());
            ClassLoader webClassLoader = cldr.getClassLoader();
            log.debug("Webapp classloader: {}", (Object)webClassLoader);
            XmlWebApplicationContext appctx = new XmlWebApplicationContext();
            appctx.setClassLoader(webClassLoader);
            appctx.setConfigLocations(new String[]{"/WEB-INF/red5-*.xml"});
            if (applicationContext.containsBean(this.defaultApplicationContextId)) {
                appctx.setParent((ApplicationContext)applicationContext.getBean(this.defaultApplicationContextId));
            } else {
                log.warn("{} bean was not found in context: {}", (Object)this.defaultApplicationContextId, (Object)applicationContext.getDisplayName());
                if (applicationContext.containsBean("context.loader")) {
                    ContextLoader contextLoader = (ContextLoader)applicationContext.getBean("context.loader");
                    appctx.setParent(contextLoader.getContext(this.defaultApplicationContextId));
                } else {
                    log.debug("Context loader was not found, trying JMX");
                    MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
                    ContextLoaderMXBean proxy = null;
                    ObjectName oName = null;
                    try {
                        oName = new ObjectName("org.red5.server:name=contextLoader,type=ContextLoader");
                        if (mbs.isRegistered(oName)) {
                            proxy = JMX.newMXBeanProxy(mbs, oName, ContextLoaderMXBean.class, true);
                            log.debug("Context loader was found");
                            proxy.setParentContext(this.defaultApplicationContextId, appctx.getId());
                        } else {
                            log.warn("Context loader was not found");
                        }
                    }
                    catch (Exception e) {
                        log.warn("Exception looking up ContextLoader", (Throwable)e);
                    }
                }
            }
            if (log.isDebugEnabled() && (context = appctx.getParent()) != null) {
                log.debug("Parent application context: {}", (Object)context.getDisplayName());
            }
            appctx.setServletContext(servletContext);
            servletContext.setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, (Object)appctx);
            appctx.refresh();
            result = true;
        }
        catch (Throwable t) {
            log.error("Error setting up context: {}", (Object)applicationName, (Object)t);
            log.error(ExceptionUtils.getStackTrace((Throwable)t));
        }
        return result;
    }

    public Host createHost() {
        log.debug("Creating host");
        StandardHost stdHost = new StandardHost();
        stdHost.setAppBase(this.webappRoot);
        stdHost.setAutoDeploy(this.autoDeploy);
        if (this.domain == null) {
            stdHost.setName(this.name);
        } else {
            stdHost.setDomain(this.domain);
            stdHost.setName(this.name + "." + this.domain);
        }
        stdHost.setStartChildren(this.startChildren);
        stdHost.setUnpackWARs(this.unpackWARs);
        stdHost.setCopyXML(true);
        return stdHost;
    }

    @Override
    public Host getHost() {
        return this.host;
    }

    @Override
    public void addAlias(String alias) {
        log.debug("Adding alias: {}", (Object)alias);
        this.host.addAlias(alias);
    }

    @Override
    public void removeAlias(String alias) {
        String[] aliases;
        log.debug("Removing alias: {}", (Object)alias);
        for (String s : aliases = this.host.findAliases()) {
            if (!alias.equals(s)) continue;
            this.host.removeAlias(alias);
            break;
        }
    }

    @Override
    public void addValve(Valve valve) {
        log.debug("Adding valve: {}", (Object)valve);
        log.debug("Valve info: {}", (Object)valve);
        ((StandardHost)this.host).addValve(valve);
    }

    @Override
    public void removeValve(String valveInfo) {
        log.debug("Removing valve: {}", (Object)valveInfo);
        try {
            String[] valveNames;
            for (String s : valveNames = ((StandardHost)this.host).getValveNames()) {
                log.debug("Valve name: {}", (Object)s);
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
    }

    @Override
    public void setContexts(Map<String, String> contexts) throws ServletException {
        log.debug("setContexts: {}", (Object)contexts.size());
        for (Map.Entry<String, String> entry : contexts.entrySet()) {
            this.host.addChild((Container)embedded.addWebapp(entry.getKey(), this.webappRoot + entry.getValue()));
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    @Override
    public void setDomain(String domain) {
        this.domain = domain;
    }

    @Override
    public String getWebappRoot() {
        return this.webappRoot;
    }

    @Override
    public void setWebappRoot(String webappRoot) {
        this.webappRoot = webappRoot;
    }

    @Override
    public boolean getAutoDeploy() {
        return this.autoDeploy;
    }

    @Override
    public void setAutoDeploy(boolean autoDeploy) {
        this.autoDeploy = autoDeploy;
    }

    @Override
    public boolean getLiveDeploy() {
        return this.liveDeploy;
    }

    @Override
    public void setLiveDeploy(boolean liveDeploy) {
        this.liveDeploy = liveDeploy;
    }

    @Override
    public boolean getStartChildren() {
        return this.startChildren;
    }

    @Override
    public void setStartChildren(boolean startChildren) {
        this.startChildren = startChildren;
    }

    @Override
    public boolean getUnpackWARs() {
        return this.unpackWARs;
    }

    @Override
    public void setUnpackWARs(boolean unpackWARs) {
        this.unpackWARs = unpackWARs;
    }

    public String getDefaultApplicationContextId() {
        return this.defaultApplicationContextId;
    }

    public void setDefaultApplicationContextId(String defaultApplicationContextId) {
        this.defaultApplicationContextId = defaultApplicationContextId;
    }

    @Override
    protected void registerJMX() {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            this.oName = new ObjectName(String.format("org.red5.server:type=TomcatVHostLoader,name=%s,domain=%s", this.name, this.domain));
            if (!mbs.isRegistered(this.oName)) {
                mbs.registerMBean(this, this.oName);
            } else {
                log.debug("ContextLoader is already registered in JMX");
            }
        }
        catch (Exception e) {
            log.warn("Error on jmx registration", (Throwable)e);
        }
    }

    @Override
    protected void unregisterJMX() {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            mbs.unregisterMBean(this.oName);
        }
        catch (Exception e) {
            log.warn("Exception unregistering", (Throwable)e);
        }
    }
}

