/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.analytic;

import io.antmedia.AntMediaApplicationAdapter;
import io.antmedia.analytic.model.PlayEvent;
import io.antmedia.analytic.model.WatchTimeEvent;
import io.antmedia.filter.JWTFilter;
import io.antmedia.logger.LoggerUtils;
import io.antmedia.rest.model.Result;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.info.Contact;
import io.swagger.v3.oas.annotations.info.Info;
import io.swagger.v3.oas.annotations.info.License;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import org.springframework.web.context.WebApplicationContext;

@OpenAPIDefinition(info=@Info(description="Ant Media Server - Player Analytic Events Endpoint. It just logs the incoming player events", version="v2.0", title="Ant Media Server - Player Analytic Events Endpoint", contact=@Contact(name="Ant Media Info", email="contact@antmedia.io", url="https://antmedia.io"), license=@License(name="Apache 2.0", url="https://www.apache.org/licenses/LICENSE-2.0")))
@Component
@Path(value="/")
public class AnalyticEventLogger {
    @Context
    protected ServletContext servletContext;
    protected ApplicationContext appCtx;
    protected AntMediaApplicationAdapter appInstance;

    public ApplicationContext getAppContext() {
        if (this.servletContext != null) {
            this.appCtx = (ApplicationContext)this.servletContext.getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
        }
        return this.appCtx;
    }

    public AntMediaApplicationAdapter getApplication() {
        ApplicationContext appContext;
        if (this.appInstance == null && (appContext = this.getAppContext()) != null) {
            this.appInstance = (AntMediaApplicationAdapter)appContext.getBean("web.handler");
        }
        return this.appInstance;
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="/events/play")
    @Produces(value={"application/json"})
    public Response postEvent(@Context HttpServletRequest request, PlayEvent event) {
        if (!this.isAuthorized(event)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        event.setApp(this.getApplication().getScope().getName());
        if (event.getTimeMs() == 0L) {
            event.setTimeMs(System.currentTimeMillis());
        }
        event.setClientIP(this.getClientIpAddress(request));
        LoggerUtils.logAnalyticsFromClient(event);
        return Response.ok((Object)new Result(true)).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="/events/watch-time")
    @Produces(value={"application/json"})
    public Response postEvent(@Context HttpServletRequest request, WatchTimeEvent event) {
        if (!this.isAuthorized(event)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        event.setApp(this.getApplication().getScope().getName());
        if (event.getTimeMs() == 0L) {
            event.setTimeMs(System.currentTimeMillis());
        }
        event.setClientIP(this.getClientIpAddress(request));
        LoggerUtils.logAnalyticsFromClient(event);
        return Response.ok((Object)new Result(true)).build();
    }

    private boolean isAuthorized(PlayEvent event) {
        return !this.getApplication().getAppSettings().isSecureAnalyticEndpoint() || JWTFilter.isJWTTokenValid(this.getApplication().getAppSettings().getJwtSecretKey(), event.getToken());
    }

    private String getClientIpAddress(HttpServletRequest request) {
        String ipAddress = request.getHeader("X-Forwarded-For");
        if (ipAddress == null) {
            ipAddress = request.getRemoteAddr();
        }
        return ipAddress;
    }
}

