/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.datastore.db.types;

import com.fasterxml.jackson.annotation.JsonIgnore;
import dev.morphia.annotations.Entity;
import dev.morphia.annotations.Field;
import dev.morphia.annotations.Id;
import dev.morphia.annotations.Index;
import dev.morphia.annotations.Indexes;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import org.bson.types.ObjectId;

@Entity(value="vod")
@Indexes(value={@Index(fields={@Field(value="vodId")}), @Index(fields={@Field(value="vodName")}), @Index(fields={@Field(value="streamId")}), @Index(fields={@Field(value="streamName")})})
@Schema(description="The recorded video-on-demand object class")
public class VoD
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String USER_VOD = "userVod";
    public static final String STREAM_VOD = "streamVod";
    public static final String UPLOADED_VOD = "uploadedVod";
    public static final String PROCESS_STATUS_INQUEUE = "inqueue";
    public static final String PROCESS_STATUS_PROCESSING = "processing";
    public static final String PROCESS_STATUS_FINISHED = "finished";
    public static final String PROCESS_STATUS_FAILED = "failed";
    @JsonIgnore
    @Id
    private ObjectId dbId;
    @Schema(description="The object id of the VoD")
    private String streamName;
    @Schema(description="The name of the VoD")
    private String vodName;
    @Schema(description="The stream id of the VoD")
    private String streamId;
    @Schema(description="The creation date of the VoD")
    private long creationDate;
    @Schema(description="The start time of the VoD recording in milliseconds (UTC- Unix epoch)")
    private long startTime;
    @Schema(description="The duration of the VoD")
    private long duration;
    @Schema(description="The size of the VoD file in bytes")
    private long fileSize;
    @Schema(description="The path of the VoD")
    private String filePath;
    @Schema(description="The id of the VoD")
    private String vodId;
    @Schema(description="The type of the VoD, such as userVod, streamVod, uploadedVod")
    private String type;
    @Schema(description="The file path for the preview of the VoD")
    private String previewFilePath;
    @Schema(description="The status of the VoD processing. It can be inqueue, processing, finished, failed")
    private String processStatus;
    @Schema(description="The start time of the VoD processing in milliseconds (UTC- Unix epoch)", accessMode=Schema.AccessMode.READ_ONLY)
    private long processStartTime;
    @Schema(description="The end time of the VoD processing in milliseconds", accessMode=Schema.AccessMode.READ_ONLY)
    private long processEndTime;

    public VoD() {
    }

    public VoD(String streamName, String streamId, String filePath, String vodName, long creationDate, long startTime, long duration, long fileSize, String type, String vodId, String previewFilePath) {
        this.streamName = streamName;
        this.streamId = streamId;
        this.vodName = vodName;
        this.creationDate = creationDate;
        this.startTime = startTime;
        this.duration = duration;
        this.filePath = filePath;
        this.fileSize = fileSize;
        this.type = type;
        this.vodId = vodId;
        this.previewFilePath = previewFilePath;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public void setFileSize(long fileSize) {
        this.fileSize = fileSize;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public void setStreamName(String streamName) {
        this.streamName = streamName;
    }

    public String getVodName() {
        return this.vodName;
    }

    public void setVodName(String vodName) {
        this.vodName = vodName;
    }

    public String getStreamId() {
        return this.streamId;
    }

    public void setStreamId(String streamId) {
        this.streamId = streamId;
    }

    public long getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(long creationDate) {
        this.creationDate = creationDate;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public String getVodId() {
        return this.vodId;
    }

    public void setVodId(String vodId) {
        this.vodId = vodId;
    }

    public String getPreviewFilePath() {
        return this.previewFilePath;
    }

    public void setPreviewFilePath(String previewFilePath) {
        this.previewFilePath = previewFilePath;
    }

    public String getProcessStatus() {
        return this.processStatus;
    }

    public void setProcessStatus(String processStatus) {
        this.processStatus = processStatus;
    }

    public long getProcessStartTime() {
        return this.processStartTime;
    }

    public void setProcessStartTime(long processStartTime) {
        this.processStartTime = processStartTime;
    }

    public long getProcessEndTime() {
        return this.processEndTime;
    }

    public void setProcessEndTime(long processEndTime) {
        this.processEndTime = processEndTime;
    }
}

