/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.storage;

import com.amazonaws.AmazonClientException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.event.ProgressEventType;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazonaws.services.s3.model.ListObjectsV2Result;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.amazonaws.services.s3.model.StorageClass;
import com.amazonaws.services.s3.transfer.TransferManager;
import com.amazonaws.services.s3.transfer.TransferManagerBuilder;
import com.amazonaws.services.s3.transfer.Upload;
import io.antmedia.storage.StorageClient;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmazonS3StorageClient
extends StorageClient {
    private AmazonS3 amazonS3;
    private TransferManager transferManager;
    private long multipartUploadThreshold = 0x500000L;
    protected static Logger logger = LoggerFactory.getLogger(AmazonS3StorageClient.class);

    public AmazonS3 getAmazonS3() {
        if (this.amazonS3 == null) {
            this.amazonS3 = this.initAmazonS3();
        }
        return this.amazonS3;
    }

    public AmazonS3 initAmazonS3() {
        AmazonS3ClientBuilder builder = AmazonS3ClientBuilder.standard();
        if (this.getEndpoint() != null && !this.getEndpoint().isEmpty() && this.getRegion() != null) {
            builder = (AmazonS3ClientBuilder)builder.withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(this.getEndpoint(), this.getRegion()));
        }
        if (this.getAccessKey() != null) {
            BasicAWSCredentials awsCredentials = new BasicAWSCredentials(this.getAccessKey(), this.getSecretKey());
            builder = (AmazonS3ClientBuilder)builder.withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)awsCredentials));
        }
        if ((this.getEndpoint() == null || this.getEndpoint().isEmpty()) && this.getRegion() != null) {
            builder = (AmazonS3ClientBuilder)builder.withRegion(Regions.fromName((String)this.getRegion()));
        }
        builder.withClientConfiguration(new ClientConfiguration().withMaxConnections(100).withConnectionTimeout(120000).withMaxErrorRetry(15));
        return (AmazonS3)builder.build();
    }

    public List<String> getObjects(String prefix) {
        ArrayList<String> list = new ArrayList<String>();
        if (this.isEnabled()) {
            AmazonS3 s3 = this.getAmazonS3();
            ListObjectsV2Result objects = s3.listObjectsV2(this.getStorageName(), prefix);
            this.convert2List(list, objects.getObjectSummaries());
        }
        return list;
    }

    public void convert2List(List<String> list, List<S3ObjectSummary> objectSummaries) {
        for (S3ObjectSummary s3ObjectSummary : objectSummaries) {
            list.add(s3ObjectSummary.getKey());
        }
    }

    @Override
    public void delete(String key) {
        if (this.isEnabled()) {
            AmazonS3 s3 = this.getAmazonS3();
            s3.deleteObject(this.getStorageName(), key);
        } else {
            logger.debug("S3 is not enabled to delete the file: {}", (Object)key);
        }
    }

    @Override
    public boolean fileExist(String key) {
        if (this.isEnabled()) {
            return this.getAmazonS3().doesObjectExist(this.getStorageName(), key);
        }
        logger.debug("S3 is not enabled to check the file existence: {}", (Object)key);
        return false;
    }

    public void save(File file, String type) {
        this.save(type + "/" + file.getName(), file);
    }

    @Override
    public void save(String key, InputStream inputStream, boolean waitForCompletion) {
        this.save(key, null, inputStream, false, waitForCompletion);
    }

    @Override
    public void save(String key, File file, boolean deleteLocalFile) {
        this.save(key, file, null, deleteLocalFile, false);
    }

    public void save(String key, File file, InputStream inputStream, boolean deleteLocalFile, boolean waitForCompletion) {
        if (this.isEnabled()) {
            TransferManager tm = this.getTransferManager();
            ObjectMetadata metadata = new ObjectMetadata();
            if (this.getCacheControl() != null) {
                metadata.setCacheControl(this.getCacheControl());
            }
            PutObjectRequest putRequest = file != null ? new PutObjectRequest(this.getStorageName(), key, file).withMetadata(metadata) : new PutObjectRequest(this.getStorageName(), key, inputStream, metadata);
            putRequest.setCannedAcl(this.getCannedAcl());
            if (this.checkStorageClass(this.getStorageClass())) {
                putRequest.withStorageClass(this.getStorageClass().toUpperCase());
            }
            Upload upload = tm.upload(putRequest);
            logger.info("File {} upload has started with key: {}", (Object)(file != null ? file.getName() : ""), (Object)key);
            this.listenUploadProgress(key, file, deleteLocalFile, upload);
            if (waitForCompletion) {
                try {
                    upload.waitForCompletion();
                }
                catch (AmazonClientException e) {
                    logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                }
                catch (InterruptedException e) {
                    logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                    Thread.currentThread().interrupt();
                }
            }
        } else {
            logger.debug("S3 is not enabled to save the file: {}", (Object)key);
        }
    }

    private void listenUploadProgress(String key, File file, boolean deleteLocalFile, Upload upload) {
        upload.addProgressListener(event -> {
            if (event.getEventType() == ProgressEventType.TRANSFER_FAILED_EVENT) {
                logger.error("S3 - Error: Upload failed with key {}", (Object)key);
            } else if (event.getEventType() == ProgressEventType.TRANSFER_COMPLETED_EVENT) {
                if (deleteLocalFile) {
                    this.deleteFile(file);
                }
                logger.info("File uploaded to S3 with key: {}", (Object)key);
            }
            if (this.progressListener != null) {
                this.progressListener.progressChanged(event);
            }
        });
    }

    public boolean checkStorageClass(String s3StorageClass) {
        logger.debug("Requested storage class = {}", (Object)s3StorageClass);
        for (int i = 0; i < StorageClass.values().length; ++i) {
            if (!StorageClass.values()[i].toString().equalsIgnoreCase(s3StorageClass)) continue;
            return true;
        }
        return false;
    }

    public TransferManager getTransferManager() {
        if (this.transferManager == null) {
            this.transferManager = TransferManagerBuilder.standard().withS3Client(this.getAmazonS3()).withMultipartUploadThreshold(Long.valueOf(this.multipartUploadThreshold)).build();
        }
        return this.transferManager;
    }

    public void deleteFile(File file) {
        try {
            Files.delete(file.toPath());
        }
        catch (IOException e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    @Override
    public void reset() {
        this.amazonS3 = null;
        this.transferManager = null;
    }

    public CannedAccessControlList getCannedAcl() {
        switch (this.getPermission()) {
            case "public-read": {
                return CannedAccessControlList.PublicRead;
            }
            case "private": {
                return CannedAccessControlList.Private;
            }
            case "public-read-write": {
                return CannedAccessControlList.PublicReadWrite;
            }
            case "authenticated-read": {
                return CannedAccessControlList.AuthenticatedRead;
            }
            case "log-delivery-write": {
                return CannedAccessControlList.LogDeliveryWrite;
            }
            case "bucket-owner-read": {
                return CannedAccessControlList.BucketOwnerRead;
            }
            case "bucket-owner-full-control": {
                return CannedAccessControlList.BucketOwnerFullControl;
            }
            case "aws-exec-read": {
                return CannedAccessControlList.AwsExecRead;
            }
        }
        return CannedAccessControlList.PublicRead;
    }

    public long getMultipartUploadThreshold() {
        return this.multipartUploadThreshold;
    }

    public void setMultipartUploadThreshold(long multipartUploadThreshold) {
        this.multipartUploadThreshold = multipartUploadThreshold;
    }
}

