/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.storage;

import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageOptions;
import io.antmedia.storage.StorageClient;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GCPStorageClient
extends StorageClient {
    protected static Logger logger = LoggerFactory.getLogger(GCPStorageClient.class);
    private Storage storage;

    public Storage getGCPStorage() {
        if (this.storage == null) {
            this.storage = (Storage)StorageOptions.getDefaultInstance().getService();
        }
        return this.storage;
    }

    @Override
    public void delete(String key) {
        if (this.isEnabled()) {
            this.getGCPStorage().delete(this.getStorageName(), key, new Storage.BlobSourceOption[0]);
        } else {
            logger.debug("Storage is not enabled to delete the file: {}", (Object)key);
        }
    }

    @Override
    public boolean fileExist(String key) {
        if (this.isEnabled()) {
            Blob blob = this.getGCPStorage().get(this.getStorageName(), key, new Storage.BlobGetOption[0]);
            return blob != null;
        }
        logger.debug("Storage is not enabled to check the file existence: {}", (Object)key);
        return false;
    }

    @Override
    public void save(String key, InputStream inputStream, boolean waitForCompletion) {
        if (this.isEnabled()) {
            BlobInfo blobInfo = BlobInfo.newBuilder((String)this.getStorageName(), (String)key).build();
            try {
                this.getGCPStorage().createFrom(blobInfo, inputStream, new Storage.BlobWriteOption[0]);
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        } else {
            logger.debug("Storage is not enabled to save the file: {}", (Object)key);
        }
    }

    @Override
    public void save(String key, File file, boolean deleteLocalFile) {
        logger.info("save key:{} file:{}:", (Object)key, (Object)file.getName());
        BlobInfo blobInfo = BlobInfo.newBuilder((String)this.getStorageName(), (String)key).build();
        try {
            this.getGCPStorage().create(blobInfo, Files.readAllBytes(file.toPath()), new Storage.BlobTargetOption[0]);
        }
        catch (IOException e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        if (deleteLocalFile) {
            this.deleteFile(file);
        }
    }

    public void deleteFile(File file) {
        try {
            Files.delete(file.toPath());
        }
        catch (IOException e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    @Override
    public void reset() {
        this.storage = null;
    }
}

