/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.valves;

import io.antmedia.AntMediaApplicationAdapter;
import io.antmedia.analytic.model.PlayerStatsEvent;
import io.antmedia.filter.TokenFilterManager;
import io.antmedia.logger.LoggerUtils;
import jakarta.servlet.ServletException;
import java.io.IOException;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.context.WebApplicationContext;

public class DataTransferValve
extends ValveBase {
    public void invoke(Request request, Response response) throws IOException, ServletException {
        this.getNext().invoke(request, response);
        String streamId = TokenFilterManager.getStreamId(request.getRequestURI());
        String method = request.getMethod();
        if (StringUtils.isNotBlank((CharSequence)streamId) && ("GET".equals(method) || "HEAD".equals(method))) {
            String subscriberId = request.getParameter("subscriberId");
            if (subscriberId != null) {
                subscriberId = subscriberId.replaceAll("[\n|\r|\t]", "_");
            }
            String clientIP = request.getRemoteAddr().replaceAll("[\n|\r|\t]", "_");
            long bytesWritten = response.getBytesWritten(false);
            ConfigurableWebApplicationContext context = (ConfigurableWebApplicationContext)request.getServletContext().getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
            PlayerStatsEvent playerStatsEvent = new PlayerStatsEvent();
            playerStatsEvent.setStreamId(streamId);
            playerStatsEvent.setUri(request.getRequestURI());
            playerStatsEvent.setSubscriberId(subscriberId);
            playerStatsEvent.setApp(((AntMediaApplicationAdapter)context.getBean("web.handler")).getScope().getName());
            playerStatsEvent.setByteTransferred(bytesWritten);
            playerStatsEvent.setClientIP(clientIP);
            this.log(playerStatsEvent);
        }
    }

    public void log(PlayerStatsEvent playerStatsEvent) {
        LoggerUtils.logAnalyticsFromServer(playerStatsEvent);
    }
}

