/*
 * Decompiled with CFR 0.152.
 */
package org.red5.io.amf;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.Vector;
import org.apache.commons.beanutils.BeanMap;
import org.apache.mina.core.buffer.IoBuffer;
import org.red5.annotations.Anonymous;
import org.red5.io.amf.AMF;
import org.red5.io.amf3.ByteArray;
import org.red5.io.object.BaseOutput;
import org.red5.io.object.ICustomSerializable;
import org.red5.io.object.RecordSet;
import org.red5.io.object.Serializer;
import org.red5.io.utils.XMLUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class Output
extends BaseOutput
implements org.red5.io.object.Output {
    protected static Logger log = LoggerFactory.getLogger(Output.class);
    protected IoBuffer buf;

    public Output(IoBuffer buf) {
        this.buf = buf;
    }

    @Override
    public boolean isCustom(Object custom) {
        return false;
    }

    protected boolean checkWriteReference(Object obj) {
        if (this.hasReference(obj)) {
            this.writeReference(obj);
            return true;
        }
        return false;
    }

    @Override
    public void writeArray(Collection<?> array) {
        if (!this.checkWriteReference(array)) {
            this.storeReference(array);
            this.buf.put((byte)10);
            this.buf.putInt(array.size());
            for (Object item : array) {
                Serializer.serialize(this, item);
            }
        }
    }

    @Override
    public void writeArray(Object[] array) {
        log.debug("writeArray - array: {}", array);
        if (array != null) {
            if (!this.checkWriteReference(array)) {
                this.storeReference(array);
                this.buf.put((byte)10);
                this.buf.putInt(array.length);
                for (Object item : array) {
                    Serializer.serialize(this, item);
                }
            }
        } else {
            this.writeNull();
        }
    }

    @Override
    public void writeArray(Object array) {
        if (array != null) {
            if (!this.checkWriteReference(array)) {
                this.storeReference(array);
                this.buf.put((byte)10);
                this.buf.putInt(Array.getLength(array));
                for (int i = 0; i < Array.getLength(array); ++i) {
                    Serializer.serialize(this, Array.get(array, i));
                }
            }
        } else {
            this.writeNull();
        }
    }

    @Override
    public void writeMap(Map<Object, Object> map) {
        if (!this.checkWriteReference(map)) {
            this.storeReference(map);
            this.buf.put((byte)8);
            int maxInt = -1;
            int i = 0;
            while (i < map.size()) {
                try {
                    if (!map.containsKey(i)) {
                    }
                }
                catch (ClassCastException err) {}
                break;
                maxInt = i++;
            }
            this.buf.putInt(maxInt + 1);
            for (Map.Entry<Object, Object> entry : map.entrySet()) {
                String key = entry.getKey().toString();
                if ("length".equals(key)) continue;
                this.putString(key);
                Serializer.serialize(this, entry.getValue());
            }
            if (maxInt >= 0) {
                this.putString("length");
                Serializer.serialize(this, maxInt + 1);
            }
            this.buf.put(AMF.END_OF_OBJECT_SEQUENCE);
        }
    }

    @Override
    public void writeMap(Collection<?> array) {
        if (!this.checkWriteReference(array)) {
            this.storeReference(array);
            this.buf.put((byte)8);
            this.buf.putInt(array.size() + 1);
            int idx = 0;
            for (Object item : array) {
                if (item != null) {
                    this.putString(String.valueOf(idx++));
                    Serializer.serialize(this, item);
                    continue;
                }
                ++idx;
            }
            this.putString("length");
            Serializer.serialize(this, array.size() + 1);
            this.buf.put(AMF.END_OF_OBJECT_SEQUENCE);
        }
    }

    @Override
    public void writeRecordSet(RecordSet recordset) {
        if (!this.checkWriteReference(recordset)) {
            this.storeReference(recordset);
            this.buf.put((byte)16);
            this.putString("RecordSet");
            Map<String, Object> info = recordset.serialize();
            this.putString("serverInfo");
            Serializer.serialize(this, info);
            this.buf.put(AMF.END_OF_OBJECT_SEQUENCE);
        }
    }

    @Override
    public void writeBoolean(Boolean bol) {
        this.buf.put((byte)1);
        this.buf.put(bol != false ? (byte)1 : 0);
    }

    @Override
    public void writeCustom(Object custom) {
    }

    @Override
    public void writeDate(Date date) {
        this.buf.put((byte)11);
        this.buf.putDouble((double)date.getTime());
        this.buf.putShort((short)(TimeZone.getDefault().getRawOffset() / 60 / 1000));
    }

    @Override
    public void writeNull() {
        this.buf.put((byte)5);
    }

    @Override
    public void writeNumber(Number num) {
        this.buf.put((byte)0);
        this.buf.putDouble(num.doubleValue());
    }

    @Override
    public void writeReference(Object obj) {
        log.debug("Write reference");
        this.buf.put((byte)7);
        this.buf.putShort(this.getReferenceId(obj));
    }

    @Override
    public void writeObject(Object object) {
        if (!this.checkWriteReference(object)) {
            this.storeReference(object);
            BeanMap beanMap = new BeanMap(object);
            Set attrs = beanMap.keySet();
            log.trace("Bean map keys: {}", (Object)attrs);
            if (attrs.size() == 0 || attrs.size() == 1 && beanMap.containsKey((Object)"class")) {
                this.writeArbitraryObject(object);
                return;
            }
            Class<?> objectClass = object.getClass();
            if (!objectClass.isAnnotationPresent(Anonymous.class)) {
                this.buf.put((byte)16);
                Output.putString(this.buf, Serializer.getClassName(objectClass));
            } else {
                this.buf.put((byte)3);
            }
            if (object instanceof ICustomSerializable) {
                ((ICustomSerializable)object).serialize(this);
                this.buf.put(AMF.END_OF_OBJECT_SEQUENCE);
                return;
            }
            for (Object key : attrs) {
                String fieldName = key.toString();
                log.debug("Field name: {} class: {}", (Object)fieldName, objectClass);
                Field field = this.getField(objectClass, fieldName);
                Method getter = this.getGetter(objectClass, beanMap, fieldName);
                if (!Serializer.serializeField(fieldName, field, getter)) continue;
                Output.putString(this.buf, fieldName);
                Serializer.serialize(this, field, getter, object, beanMap.get(key));
            }
            this.buf.put(AMF.END_OF_OBJECT_SEQUENCE);
        }
    }

    protected Field getField(Class<?> objectClass, String keyName) {
        Field field = null;
        Class<?> clazz = objectClass;
        while (!clazz.equals(Object.class)) {
            Field[] fields = clazz.getDeclaredFields();
            if (fields.length > 0) {
                for (Field fld : fields) {
                    if (!fld.getName().equals(keyName)) continue;
                    field = fld;
                    break;
                }
            }
            clazz = clazz.getSuperclass();
        }
        return field;
    }

    protected Method getGetter(Class<?> objectClass, BeanMap beanMap, String keyName) {
        return beanMap.getReadMethod(keyName);
    }

    @Override
    public void writeObject(Map<Object, Object> map) {
        if (!this.checkWriteReference(map)) {
            this.storeReference(map);
            this.buf.put((byte)3);
            boolean isBeanMap = map instanceof BeanMap;
            for (Map.Entry<Object, Object> entry : map.entrySet()) {
                if (isBeanMap && "class".equals(entry.getKey())) continue;
                this.putString(entry.getKey().toString());
                Serializer.serialize(this, entry.getValue());
            }
            this.buf.put(AMF.END_OF_OBJECT_SEQUENCE);
        }
    }

    protected void writeArbitraryObject(Object object) {
        log.debug("writeObject");
        Class<?> objectClass = object.getClass();
        if (!objectClass.isAnnotationPresent(Anonymous.class)) {
            this.buf.put((byte)16);
            Output.putString(this.buf, Serializer.getClassName(objectClass));
        } else {
            this.buf.put((byte)3);
        }
        for (Field field : objectClass.getFields()) {
            Object value;
            String fieldName = field.getName();
            log.debug("Field: {} class: {}", (Object)field, objectClass);
            if (!Serializer.serializeField(fieldName, field, null)) continue;
            try {
                value = field.get(object);
            }
            catch (IllegalAccessException err) {
                continue;
            }
            Output.putString(this.buf, fieldName);
            Serializer.serialize(this, field, null, object, value);
        }
        this.buf.put(AMF.END_OF_OBJECT_SEQUENCE);
    }

    @Override
    public void writeString(String string) {
        byte[] encoded = Output.encodeString(string);
        int len = encoded.length;
        if (len < 65535) {
            this.buf.put((byte)2);
            this.buf.put((byte)(len >> 8 & 0xFF));
            this.buf.put((byte)(len & 0xFF));
        } else {
            this.buf.put((byte)12);
            this.buf.putInt(len);
        }
        this.buf.put(encoded);
    }

    @Override
    public void writeByteArray(ByteArray array) {
        throw new RuntimeException("ByteArray objects not supported with AMF0");
    }

    @Override
    public void writeVectorInt(Vector<Integer> vector) {
        throw new RuntimeException("Vector objects not supported with AMF0");
    }

    @Override
    public void writeVectorUInt(Vector<Long> vector) {
        throw new RuntimeException("Vector objects not supported with AMF0");
    }

    @Override
    public void writeVectorNumber(Vector<Double> vector) {
        throw new RuntimeException("Vector objects not supported with AMF0");
    }

    @Override
    public void writeVectorObject(Vector<Object> vector) {
        throw new RuntimeException("Vector objects not supported with AMF0");
    }

    protected static byte[] encodeString(String string) {
        ByteBuffer buf = AMF.CHARSET.encode(string);
        byte[] encoded = new byte[buf.remaining()];
        buf.get(encoded);
        return encoded;
    }

    public static void putString(IoBuffer buf, String string) {
        byte[] encoded = Output.encodeString(string);
        if (encoded.length < 65535) {
            buf.put((byte)(encoded.length >> 8 & 0xFF));
            buf.put((byte)(encoded.length & 0xFF));
        } else {
            buf.putInt(encoded.length);
        }
        buf.put(encoded);
    }

    @Override
    public void putString(String string) {
        Output.putString(this.buf, string);
    }

    @Override
    public void writeXML(Document xml) {
        this.buf.put((byte)15);
        this.putString(XMLUtils.docToString(xml));
    }

    public void writeXML(String xml) {
        this.buf.put((byte)15);
        this.putString(xml);
    }

    public IoBuffer buf() {
        return this.buf;
    }

    public void reset() {
        this.clearReferences();
    }
}

