/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.tomcat;

import jakarta.servlet.ServletContext;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.core.StandardContext;
import org.red5.logging.Red5LoggerFactory;
import org.red5.server.api.IApplicationContext;
import org.slf4j.Logger;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.context.WebApplicationContext;

public class TomcatApplicationContext
implements IApplicationContext {
    protected static Logger log = Red5LoggerFactory.getLogger(TomcatApplicationContext.class);
    private Context context;

    protected TomcatApplicationContext(Context context) {
        log.debug("new context: {}", (Object)context);
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void stop() {
        log.debug("stop");
        try {
            ServletContext servlet = this.context.getServletContext();
            Object o = servlet.getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
            if (o != null) {
                log.debug("Spring context for {} was found", (Object)this.context.getName());
                ConfigurableWebApplicationContext appCtx = (ConfigurableWebApplicationContext)o;
                if (appCtx.isRunning()) {
                    log.debug("Context was running, attempting to stop");
                    appCtx.stop();
                }
                if (appCtx.isActive()) {
                    log.debug("Context is active, attempting to close");
                    appCtx.close();
                }
            } else {
                log.warn("Spring context for {} was not found", (Object)this.context.getName());
            }
        }
        catch (Exception e) {
            log.error("Could not stop spring context", (Throwable)e);
        }
        this.context.getParent().removeChild((Container)this.context);
        if (this.context instanceof StandardContext) {
            StandardContext ctx = (StandardContext)this.context;
            LifecycleState state = ctx.getState();
            if (state == LifecycleState.DESTROYED || state == LifecycleState.DESTROYING) return;
            try {
                if (state == LifecycleState.STOPPED || state == LifecycleState.STOPPING) return;
                ctx.stop();
                return;
            }
            catch (Exception e) {
                log.error("Could not stop context", (Throwable)e);
                return;
            }
            finally {
                try {
                    ctx.destroy();
                }
                catch (Exception e) {
                    log.error("Could not destroy context", (Throwable)e);
                }
            }
        }
        log.warn("Context is not standardContext to stop {}", (Object)this.context.getPath());
    }

    public Context getContext() {
        return this.context;
    }
}

