/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.console.rest;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.antmedia.AppSettings;
import io.antmedia.console.rest.CommonRestService;
import io.antmedia.datastore.db.types.Licence;
import io.antmedia.datastore.db.types.User;
import io.antmedia.rest.model.Result;
import io.antmedia.settings.ServerSettings;
import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.info.Contact;
import io.swagger.v3.oas.annotations.info.Info;
import io.swagger.v3.oas.annotations.info.License;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.springframework.stereotype.Component;

@OpenAPIDefinition(info=@Info(title="Ant Media Server Management Panel REST API", version="v2.0", description="Ant Media Server Management Panel REST API", contact=@Contact(name="Ant Media Info", email="contact@antmedia.io", url="https://antmedia.io"), license=@License(name="Apache 2.0", url="http://www.apache.org")), externalDocs=@ExternalDocumentation(description="External Docs", url="https://antmedia.io"))
@Component
@Path(value="/v2")
public class RestServiceV2
extends CommonRestService {
    @Override
    @Operation(summary="Creates a new user", description="Creates a new user. If user object is null or if user is not authenticated, new user won't be created.", responses={@ApiResponse(responseCode="200", description="Successful operation", content={@Content(schema=@Schema(implementation=Result.class))})})
    @POST
    @Path(value="/users")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Result addUser(@Parameter(description="User object. If it is null, new user won't be created.", required=true) User user) {
        return super.addUser(user);
    }

    @Override
    @Operation(summary="Edit the user", description="Edit the user in the server management panel's user list. It can change password or user type (admin, read-only).", responses={@ApiResponse(responseCode="200", description="Successful operation", content={@Content(schema=@Schema(implementation=Result.class))})})
    @PUT
    @Path(value="/users")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Result editUser(@Parameter(description="User to be edited. It finds the user with username.", required=true) User user) {
        return super.editUser(user);
    }

    @Override
    @Operation(summary="Delete the user", description="Delete the user from the server management panel's user list", responses={@ApiResponse(responseCode="200", description="Successful operation", content={@Content(schema=@Schema(implementation=Result.class))})})
    @DELETE
    @Path(value="/users/{username}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Result deleteUser(@Parameter(description="User name or e-mail of the user to be deleted", required=true) @PathParam(value="username") String userName) {
        return super.deleteUser(userName);
    }

    @Override
    @Operation(summary="Returns if user is blocked", description="User is blocked for a specific time if there are login attempts", responses={@ApiResponse(responseCode="200", description="Successful operation", content={@Content(schema=@Schema(implementation=Result.class))})})
    @GET
    @Consumes(value={"application/json"})
    @Path(value="/users/{usermail}/blocked")
    @Produces(value={"application/json"})
    public Result getBlockedStatus(@Parameter(description="User name or e-mail of the user to check its status") @PathParam(value="usermail") String usermail) {
        return super.getBlockedStatus(usermail);
    }

    @Override
    @Operation(summary="Returns user list", description="Returns user list in the server management panel", responses={@ApiResponse(responseCode="200", description="Successful operation", content={@Content(schema=@Schema(implementation=List.class))})})
    @GET
    @Path(value="/user-list")
    @Produces(value={"application/json"})
    public List<User> getUserList() {
        return super.getUserList();
    }

    @Override
    @Operation(summary="Returns admin status", description="Returns whether current user is admin or not. If user is admin, it can call POST/PUT/DELETE methods", responses={@ApiResponse(responseCode="200", description="Successful operation", content={@Content(schema=@Schema(implementation=Result.class))})})
    @GET
    @Path(value="/admin-status")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Result isAdmin() {
        return super.isAdmin();
    }

    @Override
    @Operation(summary="Creates initial user", description="Creates initial user. This is a one time scenario when initial user creation required and shouldn't be used otherwise. User object is required and can't be null", responses={@ApiResponse(responseCode="200", description="Successful operation", content={@Content(schema=@Schema(implementation=Result.class))})})
    @POST
    @Path(value="/users/initial")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Result addInitialUser(@Parameter(description="User object. If it is null, new user won't be created.", required=true) User user) {
        return super.addInitialUser(user);
    }

    @Override
    @Operation(summary="Checks first login status", description="Checks first login status. If server being logged in first time, it returns true, otherwise false.", responses={@ApiResponse(responseCode="200", description="Successful operation", content={@Content(schema=@Schema(implementation=Result.class))})})
    @GET
    @Path(value="/first-login-status")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Result isFirstLogin() {
        return super.isFirstLogin();
    }

    @Override
    @Operation(summary="Authenticates user", description="Authenticates user with given username and password. Requires user object to authenticate.", responses={@ApiResponse(responseCode="200", description="Successful operation", content={@Content(schema=@Schema(implementation=Result.class))})})
    @POST
    @Path(value="/users/authenticate")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Result authenticateUser(@Parameter(description="User object to authenticate", required=true) User user) {
        return super.authenticateUser(user);
    }

    @Override
    @DELETE
    @Path(value="/users/logout")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Result deleteSession() {
        return super.deleteSession();
    }

    @Override
    @Operation(summary="Changes the given user's password", responses={@ApiResponse(responseCode="200", description="Successful operation")})
    @POST
    @Path(value="/users/password")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Result changeUserPassword(@Parameter(description="User object to change the password", required=true) User user) {
        return super.changeUserPassword(user);
    }

    @Override
    @Operation(summary="Returns true if user is authenticated to call rest api operations", responses={@ApiResponse(responseCode="200", description="Successful operation")})
    @GET
    @Path(value="/authentication-status")
    @Produces(value={"application/json"})
    public Result isAuthenticatedRest() {
        return super.isAuthenticatedRest();
    }

    @Override
    @Operation(summary="Returns system information", responses={@ApiResponse(responseCode="200", description="Successful operation")})
    @GET
    @Path(value="/system-status")
    @Produces(value={"application/json"})
    public String getSystemInfo() {
        return super.getSystemInfo();
    }

    @Override
    @Operation(summary="Returns JVM memory information", responses={@ApiResponse(responseCode="200", description="Successful operation")})
    @GET
    @Path(value="/jvm-memory-status")
    @Produces(value={"application/json"})
    public String getJVMMemoryInfo() {
        return super.getJVMMemoryInfo();
    }

    @Override
    @Operation(summary="Gets system memory status", responses={@ApiResponse(responseCode="200", description="Successful operation")})
    @GET
    @Path(value="/system-memory-status")
    @Produces(value={"application/json"})
    public String getSystemMemoryInfo() {
        return super.getSystemMemoryInfo();
    }

    @Override
    @Operation(summary="Gets system file status", responses={@ApiResponse(responseCode="200", description="Successful operation")})
    @GET
    @Path(value="/file-system-status")
    @Produces(value={"application/json"})
    public String getFileSystemInfo() {
        return super.getFileSystemInfo();
    }

    @Override
    @Operation(summary="Returns system cpu load, process cpu load and process cpu time", responses={@ApiResponse(responseCode="200", description="Successful operation")})
    @GET
    @Path(value="/cpu-status")
    @Produces(value={"application/json"})
    public String getCPUInfo() {
        return super.getCPUInfo();
    }

    @Override
    @Operation(summary="Gets thread dump in plain text", responses={@ApiResponse(responseCode="200", description="Successful operation")})
    @GET
    @Path(value="/thread-dump")
    @Produces(value={"text/plain"})
    public String getThreadDump() {
        return super.getThreadDump();
    }

    @Override
    @Operation(summary="Gets thread dump in json format", responses={@ApiResponse(responseCode="200", description="Successful operation")})
    @GET
    @Path(value="/thread-dump-json")
    @Produces(value={"application/json"})
    public String getThreadDumpJSON() {
        return super.getThreadDumpJSON();
    }

    @Override
    @Operation(summary="Returns processor's thread information", responses={@ApiResponse(responseCode="200", description="Successful operation")})
    @GET
    @Path(value="/threads")
    @Produces(value={"application/json"})
    public String getThreadsInfo() {
        return super.getThreadsInfo();
    }

    @Override
    @Operation(summary="Returns heap dump", responses={@ApiResponse(responseCode="200", description="Returns the heap dump")})
    @GET
    @Path(value="/heap-dump")
    @Produces(value={"application/octet-stream"})
    public Response getHeapDump() {
        return super.getHeapDump();
    }

    @Override
    @Operation(summary="Gets server time", responses={@ApiResponse(responseCode="200", description="Successful operation")})
    @GET
    @Path(value="/server-time")
    @Produces(value={"application/json"})
    public String getServerTime() {
        return super.getServerTime();
    }

    @Override
    @Operation(summary="Gets system resource information", responses={@ApiResponse(responseCode="200", description="Successful operation")})
    @GET
    @Path(value="/system-resources")
    @Produces(value={"application/json"})
    public String getSystemResourcesInfo() {
        return super.getSystemResourcesInfo();
    }

    @Override
    @Operation(summary="Gets GPU information", responses={@ApiResponse(responseCode="200", description="Successful operation")})
    @GET
    @Path(value="/gpu-status")
    @Produces(value={"application/json"})
    public String getGPUInfo() {
        return super.getGPUInfo();
    }

    @Override
    @Operation(summary="Returns the version of Ant Media Server", responses={@ApiResponse(responseCode="200", description="Successful operation")})
    @GET
    @Path(value="/version")
    @Produces(value={"application/json"})
    public String getVersion() {
        return super.getVersion();
    }

    @Operation(summary="Trigger garbage collector", responses={@ApiResponse(responseCode="200", description="Garbage collection triggered")})
    @POST
    @Path(value="/system/gc")
    @Produces(value={"application/json"})
    public Result triggerGc() {
        System.gc();
        return new Result(true);
    }

    @Override
    @Operation(summary="Gets the applications in the server", responses={@ApiResponse(responseCode="200", description="Successful operation")})
    @GET
    @Path(value="/applications")
    @Produces(value={"application/json"})
    public String getApplications() {
        return super.getApplications();
    }

    @Operation(summary="Returns total number of live streams", responses={@ApiResponse(responseCode="200", description="Successful operation")})
    @GET
    @Path(value="/live-clients-size")
    @Produces(value={"application/json"})
    public String getTotalLiveStreamSize() {
        return super.getLiveClientsSize();
    }

    @Override
    @Operation(summary="Gets application info", responses={@ApiResponse(responseCode="200", description="Successful operation")})
    @GET
    @Path(value="/applications-info")
    @Produces(value={"application/json"})
    public String getApplicationInfo() {
        return super.getApplicationInfo();
    }

    @Override
    @Operation(summary="Returns live streams in the specified application", responses={@ApiResponse(responseCode="200", description="Successful operation")})
    @GET
    @Path(value="/applications/live-streams/{appname}")
    @Produces(value={"application/json"})
    public String getAppLiveStreams(@Parameter(description="Application name", required=true) @PathParam(value="appname") String name) {
        return super.getAppLiveStreams(name);
    }

    @Override
    @Operation(summary="Changes the application settings", responses={@ApiResponse(responseCode="200", description="Successful operation")})
    @POST
    @Path(value="/applications/settings/{appname}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public String changeSettings(@Parameter(description="Application name", required=true) @PathParam(value="appname") String appname, @Parameter(description="New application settings, null fields will be set to default values", required=true) AppSettings newSettings) {
        return super.changeSettings(appname, newSettings);
    }

    @Override
    @Operation(summary="Checks whether application or applications have shutdown properly", responses={@ApiResponse(responseCode="200", description="Returns the shutdown status of entered applications."), @ApiResponse(responseCode="400", description="Either entered in wrong format or typed incorrectly application names")})
    @GET
    @Path(value="/shutdown-proper-status")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response isShutdownProperly(@Parameter(description="Application name", required=true) @QueryParam(value="appNames") String appNamesArray) {
        return super.isShutdownProperly(appNamesArray);
    }

    @Override
    @Operation(summary="Set application or applications shutdown property to true", responses={@ApiResponse(responseCode="200", description="Shutdown status set")})
    @GET
    @Path(value="/shutdown-properly")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public boolean setShutdownStatus(@Parameter(description="Application name", required=true) @QueryParam(value="appNames") String appNamesArray) {
        return super.setShutdownStatus(appNamesArray);
    }

    @Override
    @Operation(summary="Changes server settings", responses={@ApiResponse(responseCode="200", description="Server settings changed")})
    @POST
    @Path(value="/server-settings")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public String changeServerSettings(@Parameter(description="Server settings", required=true) ServerSettings serverSettings) {
        return super.changeServerSettings(serverSettings);
    }

    @Override
    @Operation(summary="Changes ssl settings", responses={@ApiResponse(responseCode="200", description="SSL settings configured, server will be restarted")})
    @POST
    @Path(value="/ssl-settings")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    public Result configureSsl(@Parameter(description="SSL settings", required=true) @QueryParam(value="domain") String domain, @QueryParam(value="type") String type, @FormDataParam(value="fullChainFile") InputStream fullChainFile, @FormDataParam(value="fullChainFile") FormDataContentDisposition fullChainFileDetail, @FormDataParam(value="privateKeyFile") InputStream privateKeyFile, @FormDataParam(value="privateKeyFile") FormDataContentDisposition privateKeyFileDetail, @FormDataParam(value="chainFile") InputStream chainFile, @FormDataParam(value="chainFile") FormDataContentDisposition chainFileDetail) {
        return super.configureSsl(domain, type, fullChainFile, fullChainFileDetail, privateKeyFile, privateKeyFileDetail, chainFile, chainFileDetail);
    }

    @Override
    @Operation(summary="Returns true if the server is enterprise edition", responses={@ApiResponse(responseCode="200", description="Enterprise edition status")})
    @GET
    @Path(value="/enterprise-edition")
    @Produces(value={"application/json"})
    public Result isEnterpriseEdition() {
        return super.isEnterpriseEdition();
    }

    @Override
    @Operation(summary="Returns the specified application settings", responses={@ApiResponse(responseCode="200", description="Application settings returned")})
    @GET
    @Path(value="/applications/settings/{appname}")
    @Produces(value={"application/json"})
    public AppSettings getSettings(@Parameter(description="Application name", required=true) @PathParam(value="appname") String appname) {
        return super.getSettings(appname);
    }

    @Override
    @Operation(summary="Returns the server settings", responses={@ApiResponse(responseCode="200", description="Server settings returned")})
    @GET
    @Path(value="/server-settings")
    @Produces(value={"application/json"})
    public ServerSettings getServerSettings() {
        return super.getServerSettings();
    }

    @Override
    @Operation(summary="Returns license status", responses={@ApiResponse(responseCode="200", description="License status returned")})
    @GET
    @Path(value="/licence-status")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Licence getLicenceStatus(@Parameter(description="License key", required=true) @QueryParam(value="key") String key) {
        return super.getLicenceStatus(key);
    }

    @Override
    @Operation(summary="Returns the last checked license status", responses={@ApiResponse(responseCode="200", description="Last checked license status returned")})
    @GET
    @Path(value="/last-licence-status")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Licence getLicenceStatus() {
        return super.getLicenceStatus();
    }

    @Override
    @Operation(summary="Resets the viewer counts and broadcasts statuses in the db", responses={@ApiResponse(responseCode="200", description="Broadcasts reset successfully")})
    @POST
    @Path(value="/applications/{appname}/reset")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Result resetBroadcast(@Parameter(description="Application name", required=true) @PathParam(value="appname") String appname) {
        return super.resetBroadcast(appname);
    }

    @Override
    @Operation(summary="Returns the server mode", responses={@ApiResponse(responseCode="200", description="Server mode returned")})
    @GET
    @Path(value="/cluster-mode-status")
    @Produces(value={"application/json"})
    public Result isInClusterMode() {
        return super.isInClusterMode();
    }

    @Override
    @Operation(summary="Gets log file", responses={@ApiResponse(responseCode="200", description="Log file retrieved successfully")})
    @GET
    @Path(value="/log-file/{offsetSize}/{charSize}")
    @Produces(value={"application/json"})
    public String getLogFile(@Parameter(description="Char size of the log", required=true) @PathParam(value="charSize") int charSize, @Parameter(description="Log type. ERROR can be used to get only error logs", required=true) @QueryParam(value="logType") String logType, @Parameter(description="Offset of the retrieved log", required=true) @PathParam(value="offsetSize") long offsetSize) throws IOException {
        return super.getLogFile(charSize, logType, offsetSize);
    }

    @Operation(summary="Creates a new application with given name", responses={@ApiResponse(responseCode="200", description="Application created successfully")})
    @POST
    @Consumes(value={"application/json"})
    @Path(value="/applications/{appName}")
    @Produces(value={"application/json"})
    public Result createApplication(@Parameter(description="Name for the new application", required=true) @PathParam(value="appName") String appName) {
        return this.createApplication(appName, null);
    }

    @Override
    @Operation(summary="Creates a new application with given name and supports uploading custom WAR files", responses={@ApiResponse(responseCode="200", description="Custom application created successfully")})
    @PUT
    @Consumes(value={"multipart/form-data"})
    @Path(value="/applications/{appName}")
    @Produces(value={"application/json"})
    public Result createApplication(@Parameter(description="Name for the new application", required=true) @PathParam(value="appName") String appName, @Parameter(description="file", required=true) @FormDataParam(value="file") InputStream inputStream) {
        boolean applicationAlreadyExist;
        Result result = appName != null && appName.matches("^[a-zA-Z0-9]*$") ? (!(applicationAlreadyExist = this.isApplicationExists(appName)) ? super.createApplication(appName, inputStream) : new Result(false, "Application with the same name already exists")) : new Result(false, "Application name is not alphanumeric. Please provide alphanumeric characters");
        return result;
    }

    public boolean isApplicationExists(String appName) {
        return this.getApplication().getRootScope().getScope(appName) != null;
    }

    @Override
    @Operation(summary="Deletes application with the given name", responses={@ApiResponse(responseCode="200", description="Application deleted successfully")})
    @DELETE
    @Path(value="/applications/{appName}")
    @Produces(value={"application/json"})
    public Result deleteApplication(@Parameter(description="Name of the application to delete", required=true) @PathParam(value="appName") String appName, @Parameter(description="Whether to delete associated database", required=true) @QueryParam(value="deleteDB") boolean deleteDB) {
        if (appName != null) {
            return super.deleteApplication(appName, deleteDB);
        }
        return new Result(false, "Application name is not defined");
    }

    @Operation(summary="Returns the hostname to check liveness with HTTP type healthcheck", responses={@ApiResponse(responseCode="200", description="Liveness check response")})
    @GET
    @Path(value="/liveness")
    @Produces(value={"application/json"})
    public Response liveness() {
        Response.Status statusCode;
        String status;
        long startTimeMs = System.currentTimeMillis();
        JsonObject jsonObject = new JsonObject();
        String hostname = this.getHostname();
        if (hostname != null) {
            status = "ok";
            statusCode = Response.Status.OK;
        } else {
            hostname = "unknown";
            status = "error";
            statusCode = Response.Status.INTERNAL_SERVER_ERROR;
        }
        jsonObject.addProperty("host", hostname);
        jsonObject.addProperty("status", status);
        Gson gson = new Gson();
        long elapsedTimeMs = System.currentTimeMillis() - startTimeMs;
        if (elapsedTimeMs > 1000L) {
            logger.warn("GET liveness method takes {}ms to return", (Object)elapsedTimeMs);
        }
        return Response.status((Response.Status)statusCode).entity((Object)gson.toJson((JsonElement)jsonObject)).build();
    }

    public String getHostname() {
        String hostname = null;
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            hostname = inetAddress.getHostName();
        }
        catch (UnknownHostException e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        return hostname;
    }
}

