/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.datastore.db.types;

import dev.morphia.annotations.Entity;
import io.antmedia.datastore.db.types.ConnectionEvent;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;

@Schema(description="Statistics for each subsciber to the stream")
@Entity
public class SubscriberStats {
    @Schema(description="The subscriber id of the subscriber")
    private String subscriberId;
    @Schema(description="The stream id of the token")
    private String streamId;
    @Schema(description="List of connection events")
    private List<ConnectionEvent> connectionEvents = new ArrayList<ConnectionEvent>();
    @Schema(description="Average video bitrate for a subscriber")
    private long avgVideoBitrate;
    @Schema(description="Average audio bitrate for a subscriber")
    private long avgAudioBitrate;

    public String getSubscriberId() {
        return this.subscriberId;
    }

    public void setSubscriberId(String subscriberId) {
        this.subscriberId = subscriberId;
    }

    public String getStreamId() {
        return this.streamId;
    }

    public void setStreamId(String streamId) {
        this.streamId = streamId;
    }

    public List<ConnectionEvent> getConnectionEvents() {
        return this.connectionEvents;
    }

    public void setConnectionEvents(List<ConnectionEvent> connectionEvents) {
        this.connectionEvents = connectionEvents;
    }

    public void addConnectionEvent(ConnectionEvent connectionEvent) {
        this.connectionEvents.add(connectionEvent);
    }

    public void setAvgVideoBitrate(long avgVideoBitrate) {
        this.avgVideoBitrate = avgVideoBitrate;
    }

    public long getAvgVideoBitrate() {
        return this.avgVideoBitrate;
    }

    public void setAvgAudioBitrate(long avgAudioBitrate) {
        this.avgAudioBitrate = avgAudioBitrate;
    }

    public long getAvgAudioBitrate() {
        return this.avgAudioBitrate;
    }
}

