/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.datastore.db.types;

import dev.morphia.annotations.Entity;
import dev.morphia.annotations.Field;
import dev.morphia.annotations.Id;
import dev.morphia.annotations.Index;
import dev.morphia.annotations.Indexes;
import io.swagger.v3.oas.annotations.media.Schema;
import org.bson.types.ObjectId;

@Entity(value="token")
@Indexes(value={@Index(fields={@Field(value="tokenId")})})
@Schema(description="The one-time token class")
public class Token {
    public static final String PUBLISH_TOKEN = "publish";
    public static final String PLAY_TOKEN = "play";
    @Schema(description="The db id of the token")
    @Id
    private ObjectId dbId;
    @Schema(description="The token id")
    private String tokenId;
    @Schema(description="The stream id associated with the token")
    private String streamId;
    @Schema(description="The expiration date of the token")
    private long expireDate;
    @Schema(description="The type of the token")
    private String type;
    @Schema(description="The id of the conference room which requested streams belong to")
    private String roomId;

    public String getRoomId() {
        return this.roomId;
    }

    public void setRoomId(String roomName) {
        this.roomId = roomName;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getTokenId() {
        return this.tokenId;
    }

    public void setTokenId(String tokenId) {
        this.tokenId = tokenId;
    }

    public String getStreamId() {
        return this.streamId;
    }

    public void setStreamId(String streamId) {
        this.streamId = streamId;
    }

    public long getExpireDate() {
        return this.expireDate;
    }

    public void setExpireDate(long expireDate) {
        this.expireDate = expireDate;
    }
}

