/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.filter;

import io.antmedia.AppSettings;
import io.antmedia.filter.AbstractFilter;
import io.antmedia.filter.RestProxyFilter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IPFilter
extends AbstractFilter {
    protected static Logger log = LoggerFactory.getLogger(IPFilter.class);

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        if (this.isAllowed(request.getRemoteAddr()) || RestProxyFilter.isNodeCommunicationTokenValid(httpRequest.getHeader("ClusterAuthorization"), this.getAppSettings().getClusterCommunicationKey(), httpRequest.getRequestURI())) {
            chain.doFilter(request, response);
            return;
        }
        if (((HttpServletRequest)request).getRequestURL().toString().contains("rest/v2/acm")) {
            chain.doFilter(request, response);
            return;
        }
        ((HttpServletResponse)response).sendError(403, "Not allowed IP");
    }

    public boolean isAllowed(String remoteIPAdrress) {
        AppSettings appSettings = this.getAppSettings();
        boolean result = false;
        if (appSettings != null) {
            result = appSettings.isIpFilterEnabled() ? this.checkCIDRList(appSettings.getAllowedCIDRList(), remoteIPAdrress) : true;
        }
        return result;
    }
}

