/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.ipcamera.onvifdiscovery;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProbeSenderThread
extends Thread {
    private Thread probeReceiverThread;
    private DatagramSocket socket;
    private CountDownLatch serverStarted;
    private CountDownLatch serverFinished;
    private InetAddress address;
    private String probeMsgTemplate;
    private Logger logger = LoggerFactory.getLogger(ProbeSenderThread.class);

    public ProbeSenderThread(InetAddress address, DatagramSocket socket, String probeMsgTemplate, CountDownLatch serverStarted, CountDownLatch serverFinished, Thread probeReceiverThread) {
        this.probeReceiverThread = probeReceiverThread;
        this.serverStarted = serverStarted;
        this.serverFinished = serverFinished;
        this.socket = socket;
        this.address = address;
        this.probeMsgTemplate = probeMsgTemplate;
    }

    @Override
    public void run() {
        String uuid = UUID.randomUUID().toString();
        String probe = this.probeMsgTemplate.replaceAll("<wsa:MessageID>urn:uuid:.*</wsa:MessageID>", "<wsa:MessageID>urn:uuid:" + uuid + "</wsa:MessageID>");
        this.probeReceiverThread.start();
        try {
            this.serverStarted.await(1000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            this.logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            Thread.currentThread().interrupt();
        }
        try {
            this.socket.send(new DatagramPacket(probe.getBytes(), probe.length(), this.address, 3702));
        }
        catch (IOException e1) {
            this.logger.error(ExceptionUtils.getStackTrace((Throwable)e1));
        }
        try {
            this.serverFinished.await(4000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            this.logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            Thread.currentThread().interrupt();
        }
    }
}

