/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.muxer.parser;

import io.antmedia.muxer.parser.Parser;

public class SPSParser
extends Parser {
    public SPSParser(byte[] data, int offset) {
        super(data, offset, true);
    }

    @Override
    protected void parse() {
        int sizeOfScalingList;
        int bit_depth_chroma_minus8;
        int frameCropLeftOffset = 0;
        int frameCropRightOffset = 0;
        int frameCropTopOffset = 0;
        int frameCropBottomOffset = 0;
        int profileIdc = this.readBits(8);
        this.readBits(8);
        this.readBits(8);
        this.readExponentialGolombCode();
        if (profileIdc == 100 || profileIdc == 110 || profileIdc == 122 || profileIdc == 244 || profileIdc == 44 || profileIdc == 83 || profileIdc == 86 || profileIdc == 118) {
            int chromaFormatIdc = this.readExponentialGolombCode();
            if (chromaFormatIdc == 3) {
                int n = this.readBit();
            }
            int bit_depth_luma_minus8 = this.readExponentialGolombCode();
            bit_depth_chroma_minus8 = this.readExponentialGolombCode();
            int qpprime_y_zero_transform_bypass_flag = this.readBit();
            int seqScalingMatrixPresentFlag = this.readBit();
            if (seqScalingMatrixPresentFlag != 0) {
                int i = 0;
                for (i = 0; i < 8; ++i) {
                    int seqScalingListPresentFlag = this.readBit();
                    if (seqScalingListPresentFlag == 0) continue;
                    sizeOfScalingList = i < 6 ? 16 : 64;
                    int lastScale = 8;
                    int nextScale = 8;
                    int j = 0;
                    for (j = 0; j < sizeOfScalingList; ++j) {
                        if (nextScale != 0) {
                            int deltaScale = this.readSE();
                            nextScale = (lastScale + deltaScale + 256) % 256;
                        }
                        lastScale = nextScale == 0 ? lastScale : nextScale;
                    }
                }
            }
        }
        int log2_max_frame_num_minus4 = this.readExponentialGolombCode();
        int picOrderCntType = this.readExponentialGolombCode();
        if (picOrderCntType == 0) {
            bit_depth_chroma_minus8 = this.readExponentialGolombCode();
        } else if (picOrderCntType == 1) {
            int delta_pic_order_always_zero_flag = this.readBit();
            int offset_for_non_ref_pic = this.readSE();
            int offset_for_top_to_bottom_field = this.readSE();
            int num_ref_frames_in_pic_order_cnt_cycle = this.readExponentialGolombCode();
            for (int i = 0; i < num_ref_frames_in_pic_order_cnt_cycle; ++i) {
                this.readSE();
            }
        }
        int max_num_ref_frames = this.readExponentialGolombCode();
        int gaps_in_frame_num_value_allowed_flag = this.readBit();
        int picWidthInMbsMinus1 = this.readExponentialGolombCode();
        int picHeightInMapUnitsMinus1 = this.readExponentialGolombCode();
        int frameMbsOnlyFlag = this.readBit();
        if (frameMbsOnlyFlag == 0) {
            sizeOfScalingList = this.readBit();
        }
        int direct_8x8_inference_flag = this.readBit();
        int frameCroppingFlag = this.readBit();
        if (frameCroppingFlag != 0) {
            frameCropLeftOffset = this.readExponentialGolombCode();
            frameCropRightOffset = this.readExponentialGolombCode();
            frameCropTopOffset = this.readExponentialGolombCode();
            frameCropBottomOffset = this.readExponentialGolombCode();
        }
        int vui_parameters_present_flag = this.readBit();
        this.width = (picWidthInMbsMinus1 + 1) * 16 - frameCropRightOffset * 2 - frameCropLeftOffset * 2;
        this.height = (2 - frameMbsOnlyFlag) * (picHeightInMapUnitsMinus1 + 1) * 16 - frameCropBottomOffset * 2 - frameCropTopOffset * 2;
    }
}

