/*
 * Decompiled with CFR 0.152.
 */
package org.red5.io.utils;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

public class HexCharset
extends Charset {
    private static final String codeHEX = "0123456789ABCDEF";
    private static final String codehex = "0123456789abcdef";
    private String codes;
    private Integer measure;

    public HexCharset(boolean caps) {
        super(caps ? "HEX" : "hex", new String[]{"HEX"});
        this.codes = caps ? codeHEX : codehex;
    }

    public HexCharset(boolean caps, int measure) {
        super((caps ? "HEX" : "hex") + ":" + measure, new String[]{"HEX"});
        this.codes = caps ? codeHEX : codehex;
        this.measure = measure;
    }

    @Override
    public CharsetEncoder newEncoder() {
        return new Encoder();
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new Decoder();
    }

    @Override
    public boolean contains(Charset cs) {
        return cs instanceof HexCharset;
    }

    private class Encoder
    extends CharsetEncoder {
        private boolean unpaired;
        private int nyble;

        private Encoder() {
            super(HexCharset.this, 0.49f, 1.0f);
        }

        @Override
        protected CoderResult implFlush(ByteBuffer out) {
            if (!this.unpaired) {
                this.implReset();
                return CoderResult.UNDERFLOW;
            }
            throw new IllegalArgumentException("Hex string must be an even number of digits");
        }

        @Override
        public CoderResult encodeLoop(CharBuffer in, ByteBuffer out) {
            while (in.remaining() > 0) {
                if (out.remaining() <= 0) {
                    return CoderResult.OVERFLOW;
                }
                char inch = in.get();
                if (Character.isWhitespace(inch)) continue;
                int d = Character.digit(inch, 16);
                if (d < 0) {
                    throw new IllegalArgumentException("Bad hex character " + inch);
                }
                if (this.unpaired) {
                    out.put((byte)(this.nyble | d));
                } else {
                    this.nyble = d << 4;
                }
                this.unpaired = !this.unpaired;
            }
            return CoderResult.UNDERFLOW;
        }

        @Override
        protected void implReset() {
            this.unpaired = false;
            this.nyble = 0;
        }
    }

    private class Decoder
    extends CharsetDecoder {
        private int charCount;

        private Decoder() {
            super(HexCharset.this, 2.0f, HexCharset.this.measure == null ? 2.0f : 2.0f + 2.0f / (float)HexCharset.this.measure.intValue());
        }

        @Override
        public CoderResult decodeLoop(ByteBuffer in, CharBuffer out) {
            while (in.remaining() > 0) {
                if (HexCharset.this.measure != null && this.charCount >= HexCharset.this.measure) {
                    if (out.remaining() == 0) {
                        return CoderResult.OVERFLOW;
                    }
                    out.put('\n');
                    this.charCount = 0;
                }
                if (out.remaining() < 2) {
                    return CoderResult.OVERFLOW;
                }
                int b = in.get() & 0xFF;
                out.put(HexCharset.this.codes.charAt(b >>> 4));
                out.put(HexCharset.this.codes.charAt(b & 0xF));
                this.charCount += 2;
            }
            return CoderResult.UNDERFLOW;
        }

        @Override
        protected void implReset() {
            this.charCount = 0;
        }
    }
}

