/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.rtmp.status;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.red5.annotations.Anonymous;
import org.red5.io.object.ICustomSerializable;
import org.red5.io.object.Output;
import org.red5.io.object.Serializer;
import org.red5.server.net.rtmp.status.Status;

@Anonymous
public class StatusObject
implements Serializable,
ICustomSerializable,
Externalizable {
    private static final long serialVersionUID = 8817297676191096283L;
    public static final String ERROR = "error";
    public static final String STATUS = "status";
    public static final String WARNING = "warning";
    protected String code;
    protected String level;
    protected String description = "";
    protected Object application;
    protected Map<String, Object> additional;

    public StatusObject() {
    }

    public StatusObject(String code, String level) {
        this.code = code;
        this.level = level;
    }

    public StatusObject(String code, String level, String description) {
        this.code = code;
        this.level = level;
        this.description = description;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getLevel() {
        return this.level;
    }

    public void setLevel(String level) {
        this.level = level;
    }

    public void setApplication(Object application) {
        this.application = application;
    }

    public Object getApplication() {
        return this.application;
    }

    public String toString() {
        return String.format("Status code: %s level: %s description: %s", this.code, this.level, this.description);
    }

    public Status asStatus() {
        return new Status(this.getCode(), this.getLevel(), this.getDescription());
    }

    public void setAdditional(String name, Object value) {
        if ("code,level,description,application".indexOf(name) != -1) {
            throw new RuntimeException("the name \"" + name + "\" is reserved");
        }
        if (this.additional == null) {
            this.additional = new HashMap<String, Object>();
        }
        this.additional.put(name, value);
    }

    @Override
    public void serialize(Output output) {
        output.putString("level");
        output.writeString(this.getLevel());
        output.putString("code");
        output.writeString(this.getCode());
        output.putString("description");
        output.writeString(this.getDescription());
        if (this.application != null) {
            output.putString("application");
            Serializer.serialize(output, this.application);
        }
        if (this.additional != null) {
            for (Map.Entry<String, Object> entry : this.additional.entrySet()) {
                output.putString(entry.getKey());
                Serializer.serialize(output, entry.getValue());
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.code = (String)in.readObject();
        this.description = (String)in.readObject();
        this.level = (String)in.readObject();
        this.additional = (Map)in.readObject();
        this.application = in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.code);
        out.writeObject(this.description);
        out.writeObject(this.level);
        if (this.application != null) {
            out.writeObject(this.additional);
        }
        if (this.additional != null) {
            out.writeObject(this.application);
        }
    }
}

