/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.datastore.db;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import io.antmedia.datastore.db.DataStore;
import io.antmedia.datastore.db.types.Broadcast;
import io.antmedia.datastore.db.types.ConferenceRoom;
import io.antmedia.datastore.db.types.Endpoint;
import io.antmedia.datastore.db.types.P2PConnection;
import io.antmedia.datastore.db.types.SocialEndpointCredentials;
import io.antmedia.datastore.db.types.StreamInfo;
import io.antmedia.datastore.db.types.Subscriber;
import io.antmedia.datastore.db.types.TensorFlowObject;
import io.antmedia.datastore.db.types.Token;
import io.antmedia.datastore.db.types.VoD;
import java.io.File;
import java.lang.reflect.Type;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.mapdb.BTreeMap;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.mapdb.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapDBStore
extends DataStore {
    private DB db;
    private BTreeMap<String, String> map;
    private BTreeMap<String, String> vodMap;
    private BTreeMap<String, String> detectionMap;
    private BTreeMap<String, String> socialEndpointsCredentialsMap;
    private BTreeMap<String, String> tokenMap;
    private BTreeMap<String, String> subscriberMap;
    private BTreeMap<String, String> conferenceRoomMap;
    private BTreeMap<String, String> playlistMap;
    private Gson gson;
    private String dbName;
    protected static Logger logger = LoggerFactory.getLogger(MapDBStore.class);
    private static final String MAP_NAME = "BROADCAST";
    private static final String VOD_MAP_NAME = "VOD";
    private static final String PLAYLIST_MAP_NAME = "PLAYLIST";
    private static final String DETECTION_MAP_NAME = "DETECTION";
    private static final String TOKEN = "TOKEN";
    private static final String SUBSCRIBER = "SUBSCRIBER";
    private static final String SOCIAL_ENDPONT_CREDENTIALS_MAP_NAME = "SOCIAL_ENDPONT_CREDENTIALS_MAP_NAME";
    private static final String CONFERENCE_ROOM_MAP_NAME = "CONFERENCE_ROOM";

    public MapDBStore(String dbName) {
        this.dbName = dbName;
        this.db = DBMaker.fileDB((String)dbName).fileMmapEnableIfSupported().transactionEnable().make();
        this.map = this.db.treeMap(MAP_NAME).keySerializer(Serializer.STRING).valueSerializer(Serializer.STRING).counterEnable().createOrOpen();
        this.vodMap = this.db.treeMap(VOD_MAP_NAME).keySerializer(Serializer.STRING).valueSerializer(Serializer.STRING).counterEnable().createOrOpen();
        this.playlistMap = this.db.treeMap(PLAYLIST_MAP_NAME).keySerializer(Serializer.STRING).valueSerializer(Serializer.STRING).counterEnable().createOrOpen();
        this.detectionMap = this.db.treeMap(DETECTION_MAP_NAME).keySerializer(Serializer.STRING).valueSerializer(Serializer.STRING).counterEnable().createOrOpen();
        this.socialEndpointsCredentialsMap = this.db.treeMap(SOCIAL_ENDPONT_CREDENTIALS_MAP_NAME).keySerializer(Serializer.STRING).valueSerializer(Serializer.STRING).counterEnable().createOrOpen();
        this.tokenMap = this.db.treeMap(TOKEN).keySerializer(Serializer.STRING).valueSerializer(Serializer.STRING).counterEnable().createOrOpen();
        this.subscriberMap = this.db.treeMap(SUBSCRIBER).keySerializer(Serializer.STRING).valueSerializer(Serializer.STRING).counterEnable().createOrOpen();
        this.conferenceRoomMap = this.db.treeMap(CONFERENCE_ROOM_MAP_NAME).keySerializer(Serializer.STRING).valueSerializer(Serializer.STRING).counterEnable().createOrOpen();
        GsonBuilder builder = new GsonBuilder();
        this.gson = builder.create();
        this.available = true;
    }

    public BTreeMap<String, String> getVodMap() {
        return this.vodMap;
    }

    public void setVodMap(BTreeMap<String, String> vodMap) {
        this.vodMap = vodMap;
    }

    public BTreeMap<String, String> getMap() {
        return this.map;
    }

    public void setMap(BTreeMap<String, String> map) {
        this.map = map;
    }

    public BTreeMap<String, String> getDetectionMap() {
        return this.detectionMap;
    }

    public void setDetectionMap(BTreeMap<String, String> detectionMap) {
        this.detectionMap = detectionMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String save(Broadcast broadcast) {
        String streamId = null;
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            if (broadcast != null) {
                try {
                    if (broadcast.getStreamId() == null) {
                        streamId = RandomStringUtils.randomNumeric((int)24);
                        broadcast.setStreamId(streamId);
                    }
                    streamId = broadcast.getStreamId();
                    Object rtmpURL = broadcast.getRtmpURL();
                    if (rtmpURL != null) {
                        rtmpURL = (String)rtmpURL + streamId;
                    }
                    broadcast.setRtmpURL((String)rtmpURL);
                    if (broadcast.getStatus() == null) {
                        broadcast.setStatus("created");
                    }
                    this.map.put((Object)streamId, (Object)this.gson.toJson((Object)broadcast));
                    this.db.commit();
                }
                catch (Exception e) {
                    logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                    streamId = null;
                }
            }
        }
        return streamId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Broadcast get(String id) {
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            String jsonString;
            if (id != null && (jsonString = (String)this.map.get((Object)id)) != null) {
                return (Broadcast)this.gson.fromJson(jsonString, Broadcast.class);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VoD getVoD(String id) {
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            String jsonString;
            if (id != null && (jsonString = (String)this.vodMap.get((Object)id)) != null) {
                return (VoD)this.gson.fromJson(jsonString, VoD.class);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateStatus(String id, String status) {
        boolean result = false;
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            String jsonString;
            if (id != null && (jsonString = (String)this.map.get((Object)id)) != null) {
                Broadcast broadcast = (Broadcast)this.gson.fromJson(jsonString, Broadcast.class);
                broadcast.setStatus(status);
                if (status.equals("broadcasting")) {
                    broadcast.setStartTime(System.currentTimeMillis());
                } else if (status.equals("finished")) {
                    broadcast.setRtmpViewerCount(0);
                    broadcast.setWebRTCViewerCount(0);
                    broadcast.setHlsViewerCount(0);
                }
                String jsonVal = this.gson.toJson((Object)broadcast);
                String previousValue = (String)this.map.replace((Object)id, (Object)jsonVal);
                this.db.commit();
                logger.debug("updateStatus replacing id {} having value {} to {}", new Object[]{id, previousValue, jsonVal});
                result = true;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateDuration(String id, long duration) {
        boolean result = false;
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            String jsonString;
            if (id != null && (jsonString = (String)this.map.get((Object)id)) != null) {
                Broadcast broadcast = (Broadcast)this.gson.fromJson(jsonString, Broadcast.class);
                broadcast.setDuration(Long.valueOf(duration));
                String jsonVal = this.gson.toJson((Object)broadcast);
                String previousValue = (String)this.map.replace((Object)id, (Object)jsonVal);
                this.db.commit();
                result = true;
                logger.debug("updateStatus replacing id {} having value {} to {}", new Object[]{id, previousValue, jsonVal});
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addEndpoint(String id, Endpoint endpoint) {
        boolean result = false;
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            String jsonString;
            if (id != null && endpoint != null && (jsonString = (String)this.map.get((Object)id)) != null) {
                Broadcast broadcast = (Broadcast)this.gson.fromJson(jsonString, Broadcast.class);
                ArrayList<Endpoint> endPointList = broadcast.getEndPointList();
                if (endPointList == null) {
                    endPointList = new ArrayList<Endpoint>();
                }
                endPointList.add(endpoint);
                broadcast.setEndPointList(endPointList);
                this.map.replace((Object)id, (Object)this.gson.toJson((Object)broadcast));
                this.db.commit();
                result = true;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeEndpoint(String id, Endpoint endpoint, boolean checkRTMPUrl) {
        boolean result = false;
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            Broadcast broadcast;
            List endPointList;
            String jsonString;
            if (id != null && endpoint != null && (jsonString = (String)this.map.get((Object)id)) != null && (endPointList = (broadcast = (Broadcast)this.gson.fromJson(jsonString, Broadcast.class)).getEndPointList()) != null) {
                Iterator iterator = endPointList.iterator();
                while (iterator.hasNext()) {
                    Endpoint endpointItem = (Endpoint)iterator.next();
                    if (checkRTMPUrl) {
                        if (!endpointItem.getRtmpUrl().equals(endpoint.getRtmpUrl())) continue;
                        iterator.remove();
                        result = true;
                        break;
                    }
                    if (!endpointItem.getEndpointServiceId().equals(endpoint.getEndpointServiceId())) continue;
                    iterator.remove();
                    result = true;
                    break;
                }
                if (result) {
                    broadcast.setEndPointList(endPointList);
                    this.map.replace((Object)id, (Object)this.gson.toJson((Object)broadcast));
                    this.db.commit();
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAllEndpoints(String id) {
        boolean result = false;
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            String jsonString;
            if (id != null && (jsonString = (String)this.map.get((Object)id)) != null) {
                Broadcast broadcast = (Broadcast)this.gson.fromJson(jsonString, Broadcast.class);
                broadcast.setEndPointList(null);
                this.map.replace((Object)id, (Object)this.gson.toJson((Object)broadcast));
                this.db.commit();
                result = true;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getBroadcastCount() {
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            return this.map.getSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getActiveBroadcastCount() {
        int activeBroadcastCount = 0;
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            Collection values = this.map.values();
            for (String broadcastString : values) {
                Broadcast broadcast = (Broadcast)this.gson.fromJson(broadcastString, Broadcast.class);
                String status = broadcast.getStatus();
                if (status == null || !status.equals("broadcasting")) continue;
                ++activeBroadcastCount;
            }
        }
        return activeBroadcastCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(String id) {
        boolean result = false;
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            boolean bl = result = this.map.remove((Object)id) != null;
            if (result) {
                this.db.commit();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ConferenceRoom> getConferenceRoomList(int offset, int size, String sortBy, String orderBy, String search) {
        ArrayList list = new ArrayList();
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            Collection conferenceRooms = this.conferenceRoomMap.getValues();
            for (String roomString : conferenceRooms) {
                ConferenceRoom room = (ConferenceRoom)this.gson.fromJson(roomString, ConferenceRoom.class);
                list.add(room);
            }
        }
        if (search != null && !search.isEmpty()) {
            logger.info("server side search called for Conference Room = {}", (Object)search);
            list = this.searchOnServerConferenceRoom(list, search);
        }
        return this.sortAndCropConferenceRoomList(list, offset, size, sortBy, orderBy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Broadcast> getBroadcastListV2(String type, String search) {
        ArrayList list = new ArrayList();
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            Collection broadcasts = this.map.getValues();
            if (type != null && !type.isEmpty()) {
                for (String broadcastString : broadcasts) {
                    Broadcast broadcast = (Broadcast)this.gson.fromJson(broadcastString, Broadcast.class);
                    if (!broadcast.getType().equals(type)) continue;
                    list.add(broadcast);
                }
            } else {
                for (String broadcastString : broadcasts) {
                    Broadcast broadcast = (Broadcast)this.gson.fromJson(broadcastString, Broadcast.class);
                    list.add((Broadcast)broadcast);
                }
            }
        }
        if (search != null && !search.isEmpty()) {
            logger.info("server side search called for Broadcast searchString = {}", (Object)search);
            list = this.searchOnServer(list, search);
        }
        return list;
    }

    public List<Broadcast> getBroadcastList(int offset, int size, String type, String sortBy, String orderBy, String search) {
        List<Broadcast> list = null;
        list = this.getBroadcastListV2(type, search);
        return this.sortAndCropBroadcastList(list, offset, size, sortBy, orderBy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<VoD> getVodListV2(String streamId, String search) {
        ArrayList vods = new ArrayList();
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            Collection values = this.vodMap.values();
            int length = values.size();
            int i = 0;
            for (String vodString : values) {
                VoD vod = (VoD)this.gson.fromJson(vodString, VoD.class);
                if (streamId != null && !streamId.isEmpty()) {
                    if (vod.getStreamId().equals(streamId)) {
                        vods.add(vod);
                    }
                } else {
                    vods.add(vod);
                }
                if (++i <= length) continue;
                logger.error("Inconsistency in DB. It's likely db file({}) is damaged", (Object)this.dbName);
                break;
            }
            if (search != null && !search.isEmpty()) {
                logger.info("server side search called for VoD searchString = {}", (Object)search);
                vods = this.searchOnServerVod(vods, search);
            }
            return vods;
        }
    }

    public List<VoD> getVodList(int offset, int size, String sortBy, String orderBy, String streamId, String search) {
        List<VoD> vods = null;
        vods = this.getVodListV2(streamId, search);
        return this.sortAndCropVodList(vods, offset, size, sortBy, orderBy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String addVod(VoD vod) {
        String id = null;
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            try {
                if (vod.getVodId() == null) {
                    vod.setVodId(RandomStringUtils.randomNumeric((int)24));
                }
                id = vod.getVodId();
                this.vodMap.put((Object)vod.getVodId(), (Object)this.gson.toJson((Object)vod));
                this.db.commit();
                logger.warn("VoD is saved to DB {} with voID {}", (Object)vod.getVodName(), (Object)id);
            }
            catch (Exception e) {
                logger.error(e.getMessage());
                id = null;
            }
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Broadcast> getExternalStreamsList() {
        ArrayList<Broadcast> streamsList = new ArrayList<Broadcast>();
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            int i;
            Object[] objectArray = this.map.getValues().toArray();
            Broadcast[] broadcastArray = new Broadcast[objectArray.length];
            for (i = 0; i < objectArray.length; ++i) {
                broadcastArray[i] = (Broadcast)this.gson.fromJson((String)objectArray[i], Broadcast.class);
            }
            for (i = 0; i < broadcastArray.length; ++i) {
                if (!broadcastArray[i].getType().equals("ipCamera") && !broadcastArray[i].getType().equals("streamSource")) continue;
                streamsList.add((Broadcast)this.gson.fromJson((String)objectArray[i], Broadcast.class));
            }
        }
        return streamsList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            this.available = false;
            this.db.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteVod(String id) {
        boolean result = false;
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            boolean bl = result = this.vodMap.remove((Object)id) != null;
            if (result) {
                this.db.commit();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTotalVodNumber() {
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            return this.vodMap.size();
        }
    }

    public long getPartialVodNumber(String search) {
        List<VoD> vods = this.getVodListV2(null, search);
        return vods.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int fetchUserVodList(File userfile) {
        if (userfile == null) {
            return 0;
        }
        int numberOfSavedFiles = 0;
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            int i = 0;
            Collection vodFiles = this.vodMap.values();
            int size = vodFiles.size();
            ArrayList<VoD> vodList = new ArrayList<VoD>();
            for (Object vodString : vodFiles) {
                vodList.add((VoD)this.gson.fromJson((String)vodString, VoD.class));
                if (++i <= size) continue;
                logger.error("Inconsistency in DB. It's likely db file({}) is damaged", (Object)this.dbName);
                break;
            }
            boolean result = false;
            for (VoD vod : vodList) {
                if (!vod.getType().equals("userVod")) continue;
                boolean bl = result = this.vodMap.remove((Object)vod.getVodId()) != null;
                if (result) {
                    this.db.commit();
                    continue;
                }
                logger.error("MapDB VoD is not synchronized. It's likely db files({}) is damaged", (Object)this.dbName);
            }
            File[] listOfFiles = userfile.listFiles();
            if (listOfFiles != null) {
                for (File file : listOfFiles) {
                    String fileExtension = FilenameUtils.getExtension((String)file.getName());
                    if (!file.isFile() || !"mp4".equals(fileExtension) && !"flv".equals(fileExtension) && !"mkv".equals(fileExtension)) continue;
                    long fileSize = file.length();
                    long unixTime = System.currentTimeMillis();
                    String path = file.getPath();
                    String[] subDirs = path.split(Pattern.quote(File.separator));
                    Integer pathLength = subDirs.length;
                    String relativePath = "streams/" + subDirs[pathLength - 2] + "/" + subDirs[pathLength - 1];
                    String vodId = RandomStringUtils.randomNumeric((int)24);
                    VoD newVod = new VoD("vodFile", "vodFile", relativePath, file.getName(), unixTime, 0L, fileSize, "userVod", vodId);
                    this.addVod(newVod);
                    ++numberOfSavedFiles;
                }
            }
        }
        return numberOfSavedFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean updateSourceQualityParametersLocal(String id, String quality, double speed, int pendingPacketQueue) {
        boolean result = false;
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            String jsonString;
            if (id != null && (jsonString = (String)this.map.get((Object)id)) != null) {
                Broadcast broadcast = (Broadcast)this.gson.fromJson(jsonString, Broadcast.class);
                broadcast.setSpeed(speed);
                if (quality != null) {
                    broadcast.setQuality(quality);
                }
                broadcast.setPendingPacketSize(pendingPacketQueue);
                this.map.replace((Object)id, (Object)this.gson.toJson((Object)broadcast));
                this.db.commit();
                result = true;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocialEndpointCredentials addSocialEndpointCredentials(SocialEndpointCredentials credentials) {
        SocialEndpointCredentials addedCredential = null;
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            if (credentials != null && credentials.getAccountName() != null && credentials.getAccessToken() != null && credentials.getServiceName() != null) {
                if (credentials.getId() == null) {
                    String id = RandomStringUtils.randomAlphanumeric((int)6);
                    credentials.setId(id);
                    this.socialEndpointsCredentialsMap.put((Object)id, (Object)this.gson.toJson((Object)credentials));
                    this.db.commit();
                    addedCredential = credentials;
                } else if (this.socialEndpointsCredentialsMap.get((Object)credentials.getId()) != null) {
                    this.socialEndpointsCredentialsMap.put((Object)credentials.getId(), (Object)this.gson.toJson((Object)credentials));
                    this.db.commit();
                    addedCredential = credentials;
                } else {
                    logger.error("Credentials Map for social endpoint is null");
                }
            } else if (credentials != null) {
                logger.error("Some of Credentials parameters are null. Accoutn name is null:{} token is null:{}, serviceName is null:{}", new Object[]{credentials.getAccountName() == null, credentials.getAccessToken() == null, credentials.getServiceName() == null});
            } else {
                logger.error("Credentials are null");
            }
        }
        return addedCredential;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SocialEndpointCredentials> getSocialEndpoints(int offset, int size) {
        ArrayList<SocialEndpointCredentials> list = new ArrayList<SocialEndpointCredentials>();
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            Collection values = this.socialEndpointsCredentialsMap.values();
            int t = 0;
            int itemCount = 0;
            if (size > 50) {
                size = 50;
            }
            if (offset < 0) {
                offset = 0;
            }
            for (String credentialString : values) {
                if (t < offset) {
                    ++t;
                    continue;
                }
                list.add((SocialEndpointCredentials)this.gson.fromJson(credentialString, SocialEndpointCredentials.class));
                if (++itemCount < size) continue;
                break;
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeSocialEndpointCredentials(String id) {
        boolean result = false;
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            boolean bl = result = this.socialEndpointsCredentialsMap.remove((Object)id) != null;
            if (result) {
                this.db.commit();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocialEndpointCredentials getSocialEndpointCredentials(String id) {
        SocialEndpointCredentials credential = null;
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            String jsonString;
            if (id != null && (jsonString = (String)this.socialEndpointsCredentialsMap.get((Object)id)) != null) {
                credential = (SocialEndpointCredentials)this.gson.fromJson(jsonString, SocialEndpointCredentials.class);
            }
        }
        return credential;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTotalBroadcastNumber() {
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            return this.map.size();
        }
    }

    public long getPartialBroadcastNumber(String search) {
        List<Broadcast> broadcasts = this.getBroadcastListV2(null, search);
        return broadcasts.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveDetection(String id, long timeElapsed, List<TensorFlowObject> detectedObjects) {
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            try {
                if (detectedObjects != null) {
                    for (TensorFlowObject tensorFlowObject : detectedObjects) {
                        tensorFlowObject.setDetectionTime(timeElapsed);
                    }
                    this.detectionMap.put((Object)id, (Object)this.gson.toJson(detectedObjects));
                    this.db.commit();
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TensorFlowObject> getDetection(String id) {
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            String jsonString;
            if (id != null && (jsonString = (String)this.detectionMap.get((Object)id)) != null) {
                Type listType = new TypeToken<ArrayList<TensorFlowObject>>(){}.getType();
                return (List)this.gson.fromJson(jsonString, listType);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TensorFlowObject> getDetectionList(String idFilter, int offsetSize, int batchSize) {
        ArrayList<TensorFlowObject> list = new ArrayList<TensorFlowObject>();
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            Type listType = new TypeToken<ArrayList<TensorFlowObject>>(){}.getType();
            int offsetCount = 0;
            int batchCount = 0;
            if (batchSize > 50) {
                batchSize = 50;
            }
            Iterator keyIterator = this.detectionMap.keyIterator();
            while (keyIterator.hasNext()) {
                String keyValue = (String)keyIterator.next();
                if (!keyValue.startsWith(idFilter)) continue;
                if (offsetCount < offsetSize) {
                    ++offsetCount;
                    continue;
                }
                if (batchCount >= batchSize) break;
                List detectedList = (List)this.gson.fromJson((String)this.detectionMap.get((Object)keyValue), listType);
                list.addAll(detectedList);
                batchCount = list.size();
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getObjectDetectedTotal(String id) {
        ArrayList list = new ArrayList();
        Type listType = new TypeToken<ArrayList<TensorFlowObject>>(){}.getType();
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            Iterator keyIterator = this.detectionMap.keyIterator();
            while (keyIterator.hasNext()) {
                String keyValue = (String)keyIterator.next();
                if (!keyValue.startsWith(id)) continue;
                List detectedList = (List)this.gson.fromJson((String)this.detectionMap.get((Object)keyValue), listType);
                list.addAll(detectedList);
            }
        }
        return list.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateBroadcastFields(String streamId, Broadcast broadcast) {
        boolean result = false;
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            try {
                logger.debug("inside of editStreamSourceInfo {}", (Object)broadcast.getStreamId());
                Broadcast oldBroadcast = this.get(streamId);
                if (oldBroadcast != null) {
                    this.updateStreamInfo(oldBroadcast, broadcast);
                    this.map.replace((Object)streamId, (Object)this.gson.toJson((Object)oldBroadcast));
                    this.db.commit();
                    result = true;
                }
            }
            catch (Exception e) {
                result = false;
            }
        }
        logger.debug("result inside edit camera:{} ", (Object)result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized boolean updateHLSViewerCountLocal(String streamId, int diffCount) {
        boolean result = false;
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            Broadcast broadcast;
            if (streamId != null && (broadcast = this.get(streamId)) != null) {
                int hlsViewerCount = broadcast.getHlsViewerCount();
                broadcast.setHlsViewerCount(hlsViewerCount += diffCount);
                this.map.replace((Object)streamId, (Object)this.gson.toJson((Object)broadcast));
                this.db.commit();
                result = true;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized boolean updateWebRTCViewerCountLocal(String streamId, boolean increment) {
        boolean result = false;
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            Broadcast broadcast;
            if (streamId != null && (broadcast = this.get(streamId)) != null) {
                int webRTCViewerCount = broadcast.getWebRTCViewerCount();
                webRTCViewerCount = increment ? ++webRTCViewerCount : --webRTCViewerCount;
                if (webRTCViewerCount >= 0) {
                    broadcast.setWebRTCViewerCount(webRTCViewerCount);
                    this.map.replace((Object)streamId, (Object)this.gson.toJson((Object)broadcast));
                    result = true;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized boolean updateRtmpViewerCountLocal(String streamId, boolean increment) {
        boolean result = false;
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            Broadcast broadcast;
            if (streamId != null && (broadcast = this.get(streamId)) != null) {
                int rtmpViewerCount = broadcast.getRtmpViewerCount();
                rtmpViewerCount = increment ? ++rtmpViewerCount : --rtmpViewerCount;
                if (rtmpViewerCount >= 0) {
                    broadcast.setRtmpViewerCount(rtmpViewerCount);
                    this.map.replace((Object)streamId, (Object)this.gson.toJson((Object)broadcast));
                    result = true;
                }
            }
        }
        return result;
    }

    public void addStreamInfoList(List<StreamInfo> streamInfoList) {
    }

    public List<StreamInfo> getStreamInfoList(String streamId) {
        return new ArrayList<StreamInfo>();
    }

    public void clearStreamInfoList(String streamId) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveToken(Token token) {
        boolean result = false;
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            if (token.getStreamId() != null && token.getTokenId() != null) {
                try {
                    this.tokenMap.put((Object)token.getTokenId(), (Object)this.gson.toJson((Object)token));
                    this.db.commit();
                    result = true;
                }
                catch (Exception e) {
                    logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Token validateToken(Token token) {
        Token fetchedToken = null;
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            String jsonToken;
            if (token.getTokenId() != null && (jsonToken = (String)this.tokenMap.get((Object)token.getTokenId())) != null) {
                fetchedToken = (Token)this.gson.fromJson(jsonToken, Token.class);
                if (fetchedToken.getType().equals(token.getType()) && Instant.now().getEpochSecond() < fetchedToken.getExpireDate()) {
                    if (token.getRoomId() == null || token.getRoomId().isEmpty()) {
                        if (fetchedToken.getStreamId().equals(token.getStreamId())) {
                            boolean result;
                            boolean bl = result = this.tokenMap.remove((Object)token.getTokenId()) != null;
                            if (result) {
                                this.db.commit();
                            }
                        } else {
                            fetchedToken = null;
                        }
                    }
                    return fetchedToken;
                }
                fetchedToken = null;
            }
        }
        return fetchedToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean revokeTokens(String streamId) {
        boolean result = false;
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            int i;
            Object[] objectArray = this.tokenMap.getValues().toArray();
            Token[] tokenArray = new Token[objectArray.length];
            for (i = 0; i < objectArray.length; ++i) {
                tokenArray[i] = (Token)this.gson.fromJson((String)objectArray[i], Token.class);
            }
            for (i = 0; i < tokenArray.length; ++i) {
                if (tokenArray[i].getStreamId().equals(streamId)) {
                    boolean bl = result = this.tokenMap.remove((Object)tokenArray[i].getTokenId()) != null;
                    if (!result) break;
                }
                this.db.commit();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Token> listAllTokens(String streamId, int offset, int size) {
        ArrayList<Token> list = new ArrayList<Token>();
        ArrayList<Token> listToken = new ArrayList<Token>();
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            Collection values = this.tokenMap.values();
            int t = 0;
            int itemCount = 0;
            if (size > 50) {
                size = 50;
            }
            if (offset < 0) {
                offset = 0;
            }
            Iterator iterator = values.iterator();
            while (iterator.hasNext()) {
                Token token = (Token)this.gson.fromJson((String)iterator.next(), Token.class);
                if (!token.getStreamId().equals(streamId)) continue;
                list.add(token);
            }
            Iterator listIterator = list.iterator();
            while (itemCount < size && listIterator.hasNext()) {
                if (t < offset) {
                    ++t;
                    listIterator.next();
                    continue;
                }
                listToken.add((Token)listIterator.next());
                ++itemCount;
            }
        }
        return listToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Subscriber> listAllSubscribers(String streamId, int offset, int size) {
        ArrayList<Subscriber> list = new ArrayList<Subscriber>();
        ArrayList<Subscriber> listSubscriber = new ArrayList<Subscriber>();
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            Collection values = this.subscriberMap.values();
            int t = 0;
            int itemCount = 0;
            if (size > 50) {
                size = 50;
            }
            if (offset < 0) {
                offset = 0;
            }
            Iterator iterator = values.iterator();
            while (iterator.hasNext()) {
                Subscriber subscriber = (Subscriber)this.gson.fromJson((String)iterator.next(), Subscriber.class);
                if (!subscriber.getStreamId().equals(streamId)) continue;
                list.add(subscriber);
            }
            Iterator listIterator = list.iterator();
            while (itemCount < size && listIterator.hasNext()) {
                if (t < offset) {
                    ++t;
                    listIterator.next();
                    continue;
                }
                listSubscriber.add((Subscriber)listIterator.next());
                ++itemCount;
            }
        }
        return listSubscriber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addSubscriber(String streamId, Subscriber subscriber) {
        boolean result = false;
        if (subscriber != null) {
            MapDBStore mapDBStore = this;
            synchronized (mapDBStore) {
                if (subscriber.getStreamId() != null && subscriber.getSubscriberId() != null) {
                    try {
                        this.subscriberMap.put((Object)subscriber.getSubscriberKey(), (Object)this.gson.toJson((Object)subscriber));
                        this.db.commit();
                        result = true;
                    }
                    catch (Exception e) {
                        logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                    }
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteSubscriber(String streamId, String subscriberId) {
        boolean result = false;
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            try {
                boolean bl = result = this.subscriberMap.remove((Object)Subscriber.getDBKey((String)streamId, (String)subscriberId)) != null;
                if (result) {
                    this.db.commit();
                }
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean revokeSubscribers(String streamId) {
        boolean result = false;
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            int i;
            Object[] objectArray = this.subscriberMap.getValues().toArray();
            Subscriber[] subscriberArray = new Subscriber[objectArray.length];
            for (i = 0; i < objectArray.length; ++i) {
                subscriberArray[i] = (Subscriber)this.gson.fromJson((String)objectArray[i], Subscriber.class);
            }
            for (i = 0; i < subscriberArray.length; ++i) {
                String subscriberStreamId = subscriberArray[i].getStreamId();
                if (subscriberStreamId != null && subscriberStreamId.equals(streamId)) {
                    boolean bl = result = this.subscriberMap.remove((Object)subscriberArray[i].getSubscriberKey()) != null;
                    if (!result) break;
                }
                this.db.commit();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Subscriber getSubscriber(String streamId, String subscriberId) {
        Subscriber subscriber = null;
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            String jsonString;
            if (subscriberId != null && streamId != null && (jsonString = (String)this.subscriberMap.get((Object)Subscriber.getDBKey((String)streamId, (String)subscriberId))) != null) {
                subscriber = (Subscriber)this.gson.fromJson(jsonString, Subscriber.class);
            }
        }
        return subscriber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resetSubscribersConnectedStatus() {
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            try {
                Collection subcribersRaw = this.subscriberMap.values();
                for (String subscriberRaw : subcribersRaw) {
                    Subscriber subscriber;
                    if (subscriberRaw == null || (subscriber = (Subscriber)this.gson.fromJson(subscriberRaw, Subscriber.class)) == null) continue;
                    subscriber.setConnected(false);
                    this.subscriberMap.put((Object)subscriber.getSubscriberKey(), (Object)this.gson.toJson((Object)subscriber));
                }
                this.db.commit();
                return true;
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setMp4Muxing(String streamId, int enabled) {
        boolean result = false;
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            String jsonString;
            if (streamId != null && (jsonString = (String)this.map.get((Object)streamId)) != null && (enabled == 1 || enabled == 0 || enabled == -1)) {
                Broadcast broadcast = (Broadcast)this.gson.fromJson(jsonString, Broadcast.class);
                broadcast.setMp4Enabled(enabled);
                this.map.replace((Object)streamId, (Object)this.gson.toJson((Object)broadcast));
                this.db.commit();
                result = true;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setWebMMuxing(String streamId, int enabled) {
        boolean result = false;
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            String jsonString;
            if (streamId != null && (jsonString = (String)this.map.get((Object)streamId)) != null && (enabled == 1 || enabled == 0 || enabled == -1)) {
                Broadcast broadcast = (Broadcast)this.gson.fromJson(jsonString, Broadcast.class);
                broadcast.setWebMEnabled(enabled);
                this.map.replace((Object)streamId, (Object)this.gson.toJson((Object)broadcast));
                this.db.commit();
                result = true;
            }
        }
        return result;
    }

    public void saveStreamInfo(StreamInfo streamInfo) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createConferenceRoom(ConferenceRoom room) {
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            boolean result = false;
            if (room != null && room.getRoomId() != null) {
                this.conferenceRoomMap.put((Object)room.getRoomId(), (Object)this.gson.toJson((Object)room));
                this.db.commit();
                result = true;
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean editConferenceRoom(String roomId, ConferenceRoom room) {
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            boolean result = false;
            if (roomId != null && room != null && room.getRoomId() != null) {
                boolean bl = result = this.conferenceRoomMap.replace((Object)roomId, (Object)this.gson.toJson((Object)room)) != null;
                if (result) {
                    this.db.commit();
                }
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteConferenceRoom(String roomId) {
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            boolean result = false;
            if (roomId != null && !roomId.isEmpty()) {
                boolean bl = result = this.conferenceRoomMap.remove((Object)roomId) != null;
                if (result) {
                    this.db.commit();
                }
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConferenceRoom getConferenceRoom(String roomId) {
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            String jsonString;
            if (roomId != null && (jsonString = (String)this.conferenceRoomMap.get((Object)roomId)) != null) {
                return (ConferenceRoom)this.gson.fromJson(jsonString, ConferenceRoom.class);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteToken(String tokenId) {
        boolean result = false;
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            boolean bl = result = this.tokenMap.remove((Object)tokenId) != null;
            if (result) {
                this.db.commit();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Token getToken(String tokenId) {
        Token token = null;
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            String jsonString;
            if (tokenId != null && (jsonString = (String)this.tokenMap.get((Object)tokenId)) != null) {
                token = (Token)this.gson.fromJson(jsonString, Token.class);
            }
        }
        return token;
    }

    public boolean createP2PConnection(P2PConnection conn) {
        return false;
    }

    public boolean deleteP2PConnection(String streamId) {
        return false;
    }

    public P2PConnection getP2PConnection(String streamId) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addSubTrack(String mainTrackId, String subTrackId) {
        boolean result = false;
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            String json = (String)this.map.get((Object)mainTrackId);
            Broadcast mainTrack = (Broadcast)this.gson.fromJson(json, Broadcast.class);
            ArrayList<String> subTracks = mainTrack.getSubTrackStreamIds();
            if (subTracks == null) {
                subTracks = new ArrayList<String>();
            }
            subTracks.add(subTrackId);
            mainTrack.setSubTrackStreamIds(subTracks);
            this.map.replace((Object)mainTrackId, (Object)this.gson.toJson((Object)mainTrack));
            this.db.commit();
            result = true;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int resetBroadcasts(String hostAddress) {
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            Collection broadcastsRawJSON = this.map.values();
            int size = broadcastsRawJSON.size();
            int updateOperations = 0;
            int zombieStreamCount = 0;
            int i = 0;
            for (String broadcastRaw : broadcastsRawJSON) {
                ++i;
                if (broadcastRaw != null) {
                    Broadcast broadcast = (Broadcast)this.gson.fromJson(broadcastRaw, Broadcast.class);
                    if (broadcast.isZombi()) {
                        ++zombieStreamCount;
                        this.map.remove((Object)broadcast.getStreamId());
                    } else {
                        ++updateOperations;
                        broadcast.setHlsViewerCount(0);
                        broadcast.setWebRTCViewerCount(0);
                        broadcast.setRtmpViewerCount(0);
                        broadcast.setStatus("finished");
                        this.map.put((Object)broadcast.getStreamId(), (Object)this.gson.toJson((Object)broadcast));
                    }
                }
                if (i <= size) continue;
                logger.error("Inconsistency in DB found in resetting broadcasts. It's likely db file({}) is damaged", (Object)this.dbName);
                break;
            }
            logger.info("Reset broadcasts result in deleting {} zombi streams and {} update operations", (Object)zombieStreamCount, (Object)updateOperations);
            this.db.commit();
            return updateOperations + zombieStreamCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotalWebRTCViewersCount() {
        long now = System.currentTimeMillis();
        if (now - this.totalWebRTCViewerCountLastUpdateTime > 5000L) {
            int total = 0;
            MapDBStore mapDBStore = this;
            synchronized (mapDBStore) {
                for (String json : this.map.getValues()) {
                    Broadcast broadcast = (Broadcast)this.gson.fromJson(json, Broadcast.class);
                    total += broadcast.getWebRTCViewerCount();
                }
            }
            this.totalWebRTCViewerCount = total;
            this.totalWebRTCViewerCountLastUpdateTime = now;
        }
        return this.totalWebRTCViewerCount;
    }
}

