/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.datastore.db;

import com.mongodb.AggregationOptions;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.WriteResult;
import dev.morphia.Datastore;
import dev.morphia.Key;
import dev.morphia.Morphia;
import dev.morphia.aggregation.Accumulator;
import dev.morphia.aggregation.Group;
import dev.morphia.query.Criteria;
import dev.morphia.query.FindOptions;
import dev.morphia.query.Query;
import dev.morphia.query.Sort;
import dev.morphia.query.UpdateOperations;
import dev.morphia.query.UpdateResults;
import io.antmedia.datastore.db.DataStore;
import io.antmedia.datastore.db.types.Broadcast;
import io.antmedia.datastore.db.types.ConferenceRoom;
import io.antmedia.datastore.db.types.Endpoint;
import io.antmedia.datastore.db.types.P2PConnection;
import io.antmedia.datastore.db.types.SocialEndpointCredentials;
import io.antmedia.datastore.db.types.StreamInfo;
import io.antmedia.datastore.db.types.Subscriber;
import io.antmedia.datastore.db.types.TensorFlowObject;
import io.antmedia.datastore.db.types.Token;
import io.antmedia.datastore.db.types.VoD;
import java.io.File;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoStore
extends DataStore {
    private static final String TOKEN_ID = "tokenId";
    private static final String STREAM_ID = "streamId";
    private Morphia morphia = new Morphia();
    private Datastore datastore;
    private Datastore vodDatastore;
    private Datastore endpointCredentialsDS;
    private Datastore tokenDatastore;
    private Datastore subscriberDatastore;
    private Datastore detectionMap;
    private Datastore conferenceRoomDatastore;
    protected static Logger logger = LoggerFactory.getLogger(MongoStore.class);
    public static final String IMAGE_ID = "imageId";
    public static final String STATUS = "status";
    private static final String ORIGIN_ADDRESS = "originAdress";
    private static final String START_TIME = "startTime";
    private static final String DURATION = "duration";
    private static final String CREATION_DATE = "creationDate";
    private static final String PLAYLIST_ID = "playlistId";
    private static final String RTMP_VIEWER_COUNT = "rtmpViewerCount";
    private static final String HLS_VIEWER_COUNT = "hlsViewerCount";
    private static final String WEBRTC_VIEWER_COUNT = "webRTCViewerCount";

    public MongoStore(String host, String username, String password, String dbName) {
        this.morphia.mapPackage("io.antmedia.datastore.db.types");
        String uri = MongoStore.getMongoConnectionUri(host, username, password);
        MongoClientURI mongoUri = new MongoClientURI(uri);
        MongoClient client = new MongoClient(mongoUri);
        this.datastore = this.morphia.createDatastore(client, dbName);
        this.vodDatastore = this.morphia.createDatastore(client, dbName + "VoD");
        this.endpointCredentialsDS = this.morphia.createDatastore(client, dbName + "_endpointCredentials");
        this.tokenDatastore = this.morphia.createDatastore(client, dbName + "_token");
        this.subscriberDatastore = this.morphia.createDatastore(client, dbName + "_subscriber");
        this.detectionMap = this.morphia.createDatastore(client, dbName + "detection");
        this.conferenceRoomDatastore = this.morphia.createDatastore(client, dbName + "room");
        this.tokenDatastore.ensureIndexes();
        this.subscriberDatastore.ensureIndexes();
        this.datastore.ensureIndexes();
        this.vodDatastore.ensureIndexes();
        this.endpointCredentialsDS.ensureIndexes();
        this.detectionMap.ensureIndexes();
        this.conferenceRoomDatastore.ensureIndexes();
        this.available = true;
    }

    public static String getMongoConnectionUri(String host, String username, String password) {
        Object credential = "";
        if (username != null && !username.isEmpty()) {
            credential = username + ":" + password + "@";
        }
        String uri = "mongodb://" + (String)credential + host;
        logger.info("uri:{}", (Object)uri);
        return uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String save(Broadcast broadcast) {
        if (broadcast == null) {
            return null;
        }
        try {
            Object streamId = null;
            if (broadcast.getStreamId() == null) {
                streamId = RandomStringUtils.randomAlphanumeric((int)12) + System.currentTimeMillis();
                broadcast.setStreamId((String)streamId);
            }
            streamId = broadcast.getStreamId();
            Object rtmpURL = broadcast.getRtmpURL();
            if (rtmpURL != null) {
                rtmpURL = (String)rtmpURL + (String)streamId;
            }
            broadcast.setRtmpURL((String)rtmpURL);
            if (broadcast.getStatus() == null) {
                broadcast.setStatus("created");
            }
            MongoStore mongoStore = this;
            synchronized (mongoStore) {
                Key key = this.datastore.save((Object)broadcast);
            }
            return streamId;
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Broadcast get(String id) {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            try {
                return (Broadcast)((Query)this.datastore.find(Broadcast.class).field(STREAM_ID).equal((Object)id)).first();
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VoD getVoD(String id) {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            try {
                return (VoD)((Query)this.vodDatastore.find(VoD.class).field("vodId").equal((Object)id)).first();
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateStatus(String id, String status) {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            try {
                Query query = (Query)this.datastore.createQuery(Broadcast.class).field(STREAM_ID).equal((Object)id);
                UpdateOperations ops = this.datastore.createUpdateOperations(Broadcast.class).set(STATUS, (Object)status);
                if (status.equals("broadcasting")) {
                    ops.set(START_TIME, (Object)System.currentTimeMillis());
                } else if (status.equals("finished")) {
                    ops.set(WEBRTC_VIEWER_COUNT, (Object)0);
                    ops.set(HLS_VIEWER_COUNT, (Object)0);
                    ops.set(RTMP_VIEWER_COUNT, (Object)0);
                }
                UpdateResults update = this.datastore.update(query, ops);
                return update.getUpdatedCount() == 1;
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateDuration(String id, long duration) {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            try {
                Query query = (Query)this.datastore.createQuery(Broadcast.class).field(STREAM_ID).equal((Object)id);
                UpdateOperations ops = this.datastore.createUpdateOperations(Broadcast.class).set(DURATION, (Object)duration);
                UpdateResults update = this.datastore.update(query, ops);
                return update.getUpdatedCount() == 1;
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addEndpoint(String id, Endpoint endpoint) {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            if (id != null && endpoint != null) {
                try {
                    Query query = (Query)this.datastore.createQuery(Broadcast.class).field(STREAM_ID).equal((Object)id);
                    UpdateOperations ops = this.datastore.createUpdateOperations(Broadcast.class).push("endPointList", (Object)endpoint);
                    UpdateResults update = this.datastore.update(query, ops);
                    return update.getUpdatedCount() == 1;
                }
                catch (Exception e) {
                    logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeEndpoint(String id, Endpoint endpoint, boolean checkRTMPUrl) {
        boolean result = false;
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            if (id != null && endpoint != null) {
                UpdateOperations ops;
                Query query = (Query)this.datastore.createQuery(Broadcast.class).field(STREAM_ID).equal((Object)id);
                UpdateResults update = this.datastore.update(query, ops = this.datastore.createUpdateOperations(Broadcast.class).removeAll("endPointList", (Object)endpoint));
                boolean bl = update.getUpdatedCount() == 1;
                return bl;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAllEndpoints(String id) {
        boolean result = false;
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            if (id != null) {
                UpdateOperations ops;
                Query query = (Query)this.datastore.createQuery(Broadcast.class).field(STREAM_ID).equal((Object)id);
                UpdateResults update = this.datastore.update(query, ops = this.datastore.createUpdateOperations(Broadcast.class).unset("endPointList"));
                boolean bl = update.getUpdatedCount() == 1;
                return bl;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getBroadcastCount() {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            return this.datastore.createQuery(Broadcast.class).count();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(String id) {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            try {
                Query query = (Query)this.datastore.createQuery(Broadcast.class).field(STREAM_ID).equal((Object)id);
                WriteResult delete = this.datastore.delete(query);
                return delete.getN() == 1;
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ConferenceRoom> getConferenceRoomList(int offset, int size, String sortBy, String orderBy, String search) {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            try {
                Query query = this.conferenceRoomDatastore.createQuery(ConferenceRoom.class);
                if (size > 50) {
                    size = 50;
                }
                if (sortBy != null && orderBy != null && !sortBy.isEmpty() && !orderBy.isEmpty()) {
                    query = query.order(new Sort[]{orderBy.equals("desc") ? Sort.descending((String)sortBy) : Sort.ascending((String)sortBy)});
                }
                if (search != null && !search.isEmpty()) {
                    logger.info("Server side search is called for Conference Rooom = {}", (Object)search);
                    Pattern regexp = Pattern.compile(search, 2);
                    query.criteria("roomId").containsIgnoreCase(search);
                    return query.find(new FindOptions().skip(offset).limit(size)).toList();
                }
                return query.find(new FindOptions().skip(offset).limit(size)).toList();
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Broadcast> getBroadcastList(int offset, int size, String type, String sortBy, String orderBy, String search) {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            try {
                Query query = this.datastore.find(Broadcast.class);
                if (size > 50) {
                    size = 50;
                }
                if (sortBy != null && orderBy != null && !sortBy.isEmpty() && !orderBy.isEmpty()) {
                    query = query.order(new Sort[]{orderBy.equals("desc") ? Sort.descending((String)sortBy) : Sort.ascending((String)sortBy)});
                }
                if (search != null && !search.isEmpty()) {
                    logger.info("Server side search is called for {}", (Object)search);
                    query.or(new Criteria[]{(Criteria)query.criteria("name").containsIgnoreCase(search), (Criteria)query.criteria(STREAM_ID).containsIgnoreCase(search)});
                    return query.find(new FindOptions().skip(offset).limit(size)).toList();
                }
                if (type != null && !type.isEmpty()) {
                    return ((Query)query.field("type").equal((Object)type)).find(new FindOptions().skip(offset).limit(size)).toList();
                }
                return query.find(new FindOptions().skip(offset).limit(size)).toList();
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return null;
    }

    public Datastore getDataStore() {
        return this.datastore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Broadcast> getExternalStreamsList() {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            try {
                Query query = this.datastore.createQuery(Broadcast.class);
                query.and(new Criteria[]{query.or(new Criteria[]{(Criteria)query.criteria("type").equal((Object)"ipCamera"), (Criteria)query.criteria("type").equal((Object)"streamSource")}), query.and(new Criteria[]{(Criteria)query.criteria(STATUS).notEqual((Object)"preparing"), (Criteria)query.criteria(STATUS).notEqual((Object)"broadcasting")})});
                List streamList = query.find().toList();
                UpdateOperations ops = this.datastore.createUpdateOperations(Broadcast.class).set(STATUS, (Object)"preparing");
                UpdateResults update = this.datastore.update(query, ops);
                int updatedCount = update.getUpdatedCount();
                if (updatedCount != streamList.size()) {
                    logger.error("Only {} stream status updated out of {}", (Object)updatedCount, (Object)streamList.size());
                }
                return streamList;
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            this.available = false;
            this.datastore.getMongo().close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String addVod(VoD vod) {
        String id = null;
        boolean result = false;
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            try {
                if (vod.getVodId() == null) {
                    vod.setVodId(RandomStringUtils.randomAlphanumeric((int)12) + System.currentTimeMillis());
                }
                this.vodDatastore.save((Object)vod);
                result = true;
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
            if (result) {
                id = vod.getVodId();
            }
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<VoD> getVodList(int offset, int size, String sortBy, String orderBy, String filterStreamId, String search) {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            Query query = this.vodDatastore.find(VoD.class);
            if (filterStreamId != null && !filterStreamId.isEmpty()) {
                query = (Query)query.field(STREAM_ID).equal((Object)filterStreamId);
            }
            if (sortBy != null && orderBy != null && !sortBy.isEmpty() && !orderBy.isEmpty()) {
                Object sortString;
                Object object = sortString = orderBy.contentEquals("desc") ? "-" : "";
                if (sortBy.contentEquals("name")) {
                    sortString = (String)sortString + "vodName";
                } else if (sortBy.contentEquals("date")) {
                    sortString = (String)sortString + CREATION_DATE;
                }
                query = query.order((String)sortString);
            }
            if (search != null && !search.isEmpty()) {
                logger.info("Server side search is called for VoD, searchString =  {}", (Object)search);
                query.or(new Criteria[]{(Criteria)query.criteria("vodName").containsIgnoreCase(search), (Criteria)query.criteria("vodId").containsIgnoreCase(search), (Criteria)query.criteria("streamName").containsIgnoreCase(search), (Criteria)query.criteria(STREAM_ID).containsIgnoreCase(search)});
                return query.find(new FindOptions().skip(offset).limit(size)).toList();
            }
            return query.find(new FindOptions().skip(offset).limit(size)).toList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteVod(String id) {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            try {
                Query query = (Query)this.vodDatastore.createQuery(VoD.class).field("vodId").equal((Object)id);
                WriteResult delete = this.vodDatastore.delete(query);
                return delete.getN() == 1;
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTotalVodNumber() {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            return this.vodDatastore.createQuery(VoD.class).count();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int fetchUserVodList(File userfile) {
        if (userfile == null) {
            return 0;
        }
        int numberOfSavedFiles = 0;
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            try {
                Query query = (Query)this.vodDatastore.createQuery(VoD.class).field("type").equal((Object)"userVod");
                WriteResult writeResult = this.vodDatastore.delete(query);
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
            WriteResult listOfFiles = userfile.listFiles();
            if (listOfFiles != null) {
                for (WriteResult file : listOfFiles) {
                    String fileExtension = FilenameUtils.getExtension((String)file.getName());
                    if (!file.isFile() || !"mp4".equals(fileExtension) && !"flv".equals(fileExtension) && !"mkv".equals(fileExtension)) continue;
                    long fileSize = file.length();
                    long unixTime = System.currentTimeMillis();
                    String filePath = file.getPath();
                    String[] subDirs = filePath.split(Pattern.quote(File.separator));
                    Integer pathLength = subDirs.length;
                    String relativePath = "streams/" + subDirs[pathLength - 2] + "/" + subDirs[pathLength - 1];
                    String vodId = RandomStringUtils.randomNumeric((int)24);
                    VoD newVod = new VoD("vodFile", "vodFile", relativePath, file.getName(), unixTime, 0L, fileSize, "userVod", vodId);
                    this.addVod(newVod);
                    ++numberOfSavedFiles;
                }
            }
        }
        return numberOfSavedFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateSourceQualityParametersLocal(String id, String quality, double speed, int pendingPacketQueue) {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            try {
                UpdateResults update;
                Query query = (Query)this.datastore.createQuery(Broadcast.class).field(STREAM_ID).equal((Object)id);
                UpdateOperations ops = this.datastore.createUpdateOperations(Broadcast.class).set("speed", (Object)speed).set("pendingPacketSize", (Object)pendingPacketQueue);
                if (quality != null) {
                    ops.set("quality", (Object)quality);
                }
                boolean bl = (update = this.datastore.update(query, ops)).getUpdatedCount() == 1;
                return bl;
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocialEndpointCredentials addSocialEndpointCredentials(SocialEndpointCredentials credentials) {
        SocialEndpointCredentials addedCredential = null;
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            if (credentials != null && credentials.getAccountName() != null && credentials.getAccessToken() != null && credentials.getServiceName() != null) {
                if (credentials.getId() == null) {
                    this.endpointCredentialsDS.save((Object)credentials);
                    addedCredential = credentials;
                } else {
                    SocialEndpointCredentials endpointCredentials = this.getSocialEndpointCredentials(credentials.getId());
                    if (endpointCredentials != null) {
                        UpdateOperations ops = this.endpointCredentialsDS.createUpdateOperations(SocialEndpointCredentials.class).set("accessToken", (Object)credentials.getAccessToken());
                        if (credentials.getAccountId() != null) {
                            ops.set("accountId", (Object)credentials.getAccountId());
                        }
                        if (credentials.getAccountName() != null) {
                            ops.set("accountName", (Object)credentials.getAccountName());
                        }
                        if (credentials.getAccountType() != null) {
                            ops.set("accountType", (Object)credentials.getAccountType());
                        }
                        if (credentials.getAuthTimeInMilliseconds() != null) {
                            ops.set("authTimeInMilliseconds", (Object)credentials.getAuthTimeInMilliseconds());
                        }
                        if (credentials.getExpireTimeInSeconds() != null) {
                            ops.set("expireTimeInSeconds", (Object)credentials.getExpireTimeInSeconds());
                        }
                        if (credentials.getRefreshToken() != null) {
                            ops.set("refreshToken", (Object)credentials.getRefreshToken());
                        }
                        if (credentials.getTokenType() != null) {
                            ops.set("tokenType", (Object)credentials.getTokenType());
                        }
                        UpdateResults update = this.endpointCredentialsDS.update((Object)endpointCredentials, ops);
                        addedCredential = credentials;
                    }
                }
            }
        }
        return addedCredential;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SocialEndpointCredentials> getSocialEndpoints(int offset, int size) {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            return this.endpointCredentialsDS.find(SocialEndpointCredentials.class).find(new FindOptions().skip(offset).limit(size)).toList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeSocialEndpointCredentials(String id) {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            try {
                Query query = (Query)this.endpointCredentialsDS.createQuery(SocialEndpointCredentials.class).field("id").equal((Object)new ObjectId(id));
                WriteResult delete = this.endpointCredentialsDS.delete(query);
                return delete.getN() == 1;
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocialEndpointCredentials getSocialEndpointCredentials(String id) {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            try {
                return (SocialEndpointCredentials)((Query)this.endpointCredentialsDS.createQuery(SocialEndpointCredentials.class).field("id").equal((Object)new ObjectId(id))).first();
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return null;
    }

    public Datastore getEndpointCredentialsDS() {
        return this.endpointCredentialsDS;
    }

    public void setEndpointCredentialsDS(Datastore endpointCredentialsDS) {
        this.endpointCredentialsDS = endpointCredentialsDS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTotalBroadcastNumber() {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            return this.datastore.createQuery(Broadcast.class).count();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getPartialBroadcastNumber(String search) {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            Query query = this.datastore.find(Broadcast.class);
            List list = null;
            if (search == null || search.isEmpty()) {
                return query.find(new FindOptions()).toList().size();
            }
            logger.info("Server side search is called for {}", (Object)search);
            query.or(new Criteria[]{(Criteria)query.criteria("name").containsIgnoreCase(search), (Criteria)query.criteria(STREAM_ID).containsIgnoreCase(search)});
            list = query.find(new FindOptions()).toList();
            return list.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getPartialVodNumber(String search) {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            Query query = this.vodDatastore.find(VoD.class);
            List list = null;
            if (search == null || search.isEmpty()) {
                return query.find(new FindOptions()).toList().size();
            }
            logger.info("Server side search is called for {}", (Object)search);
            query.or(new Criteria[]{(Criteria)query.criteria("vodName").containsIgnoreCase(search), (Criteria)query.criteria("vodId").containsIgnoreCase(search), (Criteria)query.criteria("streamName").containsIgnoreCase(search), (Criteria)query.criteria(STREAM_ID).containsIgnoreCase(search)});
            list = query.find(new FindOptions()).toList();
            return list.size();
        }
    }

    public Datastore getVodDatastore() {
        return this.vodDatastore;
    }

    public void setVodDatastore(Datastore vodDatastore) {
        this.vodDatastore = vodDatastore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getActiveBroadcastCount() {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            return this.datastore.find(Broadcast.class).filter(STATUS, (Object)"broadcasting").count();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveDetection(String id, long timeElapsed, List<TensorFlowObject> detectedObjects) {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            if (detectedObjects != null) {
                for (TensorFlowObject tensorFlowObject : detectedObjects) {
                    tensorFlowObject.setDetectionTime(timeElapsed);
                    tensorFlowObject.setImageId(id);
                    this.detectionMap.save((Object)tensorFlowObject);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TensorFlowObject> getDetectionList(String idFilter, int offsetSize, int batchSize) {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            try {
                if (batchSize > 50) {
                    batchSize = 50;
                }
                return ((Query)this.detectionMap.find(TensorFlowObject.class).field(IMAGE_ID).startsWith(idFilter)).find(new FindOptions().skip(offsetSize).limit(batchSize)).toList();
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TensorFlowObject> getDetection(String id) {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            try {
                return ((Query)this.detectionMap.find(TensorFlowObject.class).field(IMAGE_ID).equal((Object)id)).find().toList();
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getObjectDetectedTotal(String id) {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            return ((Query)this.detectionMap.find(TensorFlowObject.class).field(IMAGE_ID).equal((Object)id)).count();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateBroadcastFields(String streamId, Broadcast broadcast) {
        boolean result = false;
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            try {
                logger.warn("result inside edit camera: {}", (Object)result);
                Query query = (Query)this.datastore.createQuery(Broadcast.class).field(STREAM_ID).equal((Object)streamId);
                UpdateOperations ops = this.datastore.createUpdateOperations(Broadcast.class);
                if (broadcast.getName() != null) {
                    ops.set("name", (Object)broadcast.getName());
                }
                if (broadcast.getDescription() != null) {
                    ops.set("description", (Object)broadcast.getDescription());
                }
                if (broadcast.getUsername() != null) {
                    ops.set("username", (Object)broadcast.getUsername());
                }
                if (broadcast.getPassword() != null) {
                    ops.set("password", (Object)broadcast.getPassword());
                }
                if (broadcast.getIpAddr() != null) {
                    ops.set("ipAddr", (Object)broadcast.getIpAddr());
                }
                if (broadcast.getStreamUrl() != null) {
                    ops.set("streamUrl", (Object)broadcast.getStreamUrl());
                }
                if (broadcast.getLatitude() != null) {
                    ops.set("latitude", (Object)broadcast.getLatitude());
                }
                if (broadcast.getLongitude() != null) {
                    ops.set("longitude", (Object)broadcast.getLongitude());
                }
                if (broadcast.getAltitude() != null) {
                    ops.set("altitude", (Object)broadcast.getAltitude());
                }
                if (broadcast.getMainTrackStreamId() != null) {
                    ops.set("mainTrackStreamId", (Object)broadcast.getMainTrackStreamId());
                }
                if (broadcast.getPlayListItemList() != null) {
                    ops.set("playListItemList", (Object)broadcast.getPlayListItemList());
                }
                if (broadcast.getPlayListStatus() != null) {
                    ops.set("playListStatus", (Object)broadcast.getPlayListStatus());
                }
                if (broadcast.getEndPointList() != null) {
                    ops.set("endPointList", (Object)broadcast.getEndPointList());
                }
                this.prepareFields(broadcast, (UpdateOperations<Broadcast>)ops);
                ops.set("currentPlayIndex", (Object)broadcast.getCurrentPlayIndex());
                ops.set("receivedBytes", (Object)broadcast.getReceivedBytes());
                ops.set("bitrate", (Object)broadcast.getBitrate());
                ops.set("userAgent", (Object)broadcast.getUserAgent());
                ops.set("webRTCViewerLimit", (Object)broadcast.getWebRTCViewerLimit());
                ops.set("hlsViewerLimit", (Object)broadcast.getHlsViewerLimit());
                UpdateResults update = this.datastore.update(query, ops);
                return update.getUpdatedCount() == 1;
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
        }
        return false;
    }

    private void prepareFields(Broadcast broadcast, UpdateOperations<Broadcast> ops) {
        if (broadcast.getDuration() != 0L) {
            ops.set(DURATION, (Object)broadcast.getDuration());
        }
        if (broadcast.getStartTime() != 0L) {
            ops.set(START_TIME, (Object)broadcast.getStartTime());
        }
        if (broadcast.getOriginAdress() != null) {
            ops.set(ORIGIN_ADDRESS, (Object)broadcast.getOriginAdress());
        }
        if (broadcast.getStatus() != null) {
            ops.set(STATUS, (Object)broadcast.getStatus());
        }
        if (broadcast.getAbsoluteStartTimeMs() != 0L) {
            ops.set("absoluteStartTimeMs", (Object)broadcast.getAbsoluteStartTimeMs());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateHLSViewerCountLocal(String streamId, int diffCount) {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            try {
                Query query = (Query)this.datastore.createQuery(Broadcast.class).field(STREAM_ID).equal((Object)streamId);
                UpdateOperations ops = this.datastore.createUpdateOperations(Broadcast.class).inc(HLS_VIEWER_COUNT, (Number)diffCount);
                UpdateResults update = this.datastore.update(query, ops);
                return update.getUpdatedCount() == 1;
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
        }
        return false;
    }

    public boolean updateWebRTCViewerCountLocal(String streamId, boolean increment) {
        return this.updateViewerField(streamId, increment, WEBRTC_VIEWER_COUNT);
    }

    public boolean updateRtmpViewerCountLocal(String streamId, boolean increment) {
        return this.updateViewerField(streamId, increment, RTMP_VIEWER_COUNT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateViewerField(String streamId, boolean increment, String fieldName) {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            try {
                Query query = (Query)this.datastore.createQuery(Broadcast.class).field(STREAM_ID).equal((Object)streamId);
                if (!increment) {
                    query = query.filter(fieldName + " >", (Object)0);
                }
                UpdateOperations ops = this.datastore.createUpdateOperations(Broadcast.class);
                String field = fieldName;
                if (increment) {
                    ops.inc(field);
                } else {
                    ops.dec(field);
                }
                UpdateResults update = this.datastore.update(query, ops);
                return update.getUpdatedCount() == 1;
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveStreamInfo(StreamInfo streamInfo) {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            Query query = this.datastore.createQuery(StreamInfo.class);
            ArrayList<Criteria> criteriaList = new ArrayList<Criteria>();
            if (streamInfo.getVideoPort() != 0) {
                criteriaList.add((Criteria)query.criteria("videoPort").equal((Object)streamInfo.getVideoPort()));
                criteriaList.add((Criteria)query.criteria("audioPort").equal((Object)streamInfo.getVideoPort()));
                criteriaList.add((Criteria)query.criteria("dataChannelPort").equal((Object)streamInfo.getVideoPort()));
            }
            if (streamInfo.getAudioPort() != 0) {
                criteriaList.add((Criteria)query.criteria("videoPort").equal((Object)streamInfo.getAudioPort()));
                criteriaList.add((Criteria)query.criteria("audioPort").equal((Object)streamInfo.getAudioPort()));
                criteriaList.add((Criteria)query.criteria("dataChannelPort").equal((Object)streamInfo.getAudioPort()));
            }
            if (streamInfo.getDataChannelPort() != 0) {
                criteriaList.add((Criteria)query.criteria("videoPort").equal((Object)streamInfo.getDataChannelPort()));
                criteriaList.add((Criteria)query.criteria("audioPort").equal((Object)streamInfo.getDataChannelPort()));
                criteriaList.add((Criteria)query.criteria("dataChannelPort").equal((Object)streamInfo.getDataChannelPort()));
            }
            Criteria[] criteriaArray = new Criteria[criteriaList.size()];
            criteriaList.toArray(criteriaArray);
            if (criteriaArray.length > 0) {
                query.and(new Criteria[]{(Criteria)query.criteria("host").equal((Object)streamInfo.getHost()), query.or(criteriaArray)});
            } else {
                query.and(new Criteria[]{(Criteria)query.criteria("host").equal((Object)streamInfo.getHost())});
            }
            long count = query.count();
            if (count > 0L) {
                logger.error("{} port duplications are detected for host: {}, video port: {}, audio port:{}", new Object[]{count, streamInfo.getHost(), streamInfo.getVideoPort(), streamInfo.getAudioPort()});
                WriteResult res = this.datastore.delete(query);
                if ((long)res.getN() != count) {
                    logger.error("Only {} stream info were deleted out of {} having duplicated port.", (Object)res.getN(), (Object)count);
                }
            }
            this.datastore.save((Object)streamInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStreamInfoList(List<StreamInfo> streamInfoList) {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            for (StreamInfo streamInfo : streamInfoList) {
                this.datastore.save((Object)streamInfo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<StreamInfo> getStreamInfoList(String streamId) {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            return ((Query)this.datastore.find(StreamInfo.class).field(STREAM_ID).equal((Object)streamId)).find().toList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearStreamInfoList(String streamId) {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            Query query = (Query)this.datastore.createQuery(StreamInfo.class).field(STREAM_ID).equal((Object)streamId);
            long count = query.count();
            WriteResult res = this.datastore.delete(query);
            if ((long)res.getN() != count) {
                logger.error("{} StreamInfo were deleted out of {} for stream {}", new Object[]{res.getN(), count, streamId});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveToken(Token token) {
        boolean result = false;
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            if (token.getStreamId() != null && token.getTokenId() != null) {
                try {
                    this.tokenDatastore.save((Object)token);
                    result = true;
                }
                catch (Exception e) {
                    logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Token validateToken(Token token) {
        Token fetchedToken = null;
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            if (token.getTokenId() != null) {
                fetchedToken = (Token)((Query)this.tokenDatastore.find(Token.class).field(TOKEN_ID).equal((Object)token.getTokenId())).first();
                if (fetchedToken != null && fetchedToken.getType().equals(token.getType()) && Instant.now().getEpochSecond() < fetchedToken.getExpireDate()) {
                    if (token.getRoomId() == null || token.getRoomId().isEmpty()) {
                        if (fetchedToken.getStreamId().equals(token.getStreamId())) {
                            Query query = (Query)this.tokenDatastore.createQuery(Token.class).field(TOKEN_ID).equal((Object)token.getTokenId());
                            this.tokenDatastore.delete(query);
                        } else {
                            fetchedToken = null;
                        }
                    }
                    return fetchedToken;
                }
                fetchedToken = null;
            }
        }
        return fetchedToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean revokeTokens(String streamId) {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            Query query = (Query)this.tokenDatastore.createQuery(Token.class).field(STREAM_ID).equal((Object)streamId);
            WriteResult delete = this.tokenDatastore.delete(query);
            return delete.getN() >= 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Token> listAllTokens(String streamId, int offset, int size) {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            return ((Query)this.tokenDatastore.find(Token.class).field(STREAM_ID).equal((Object)streamId)).asList(new FindOptions().skip(offset).limit(size));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Subscriber> listAllSubscribers(String streamId, int offset, int size) {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            return ((Query)this.subscriberDatastore.find(Subscriber.class).field(STREAM_ID).equal((Object)streamId)).asList(new FindOptions().skip(offset).limit(size));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addSubscriber(String streamId, Subscriber subscriber) {
        boolean result = false;
        if (subscriber != null) {
            MongoStore mongoStore = this;
            synchronized (mongoStore) {
                if (subscriber.getStreamId() != null && subscriber.getSubscriberId() != null) {
                    try {
                        this.subscriberDatastore.save((Object)subscriber);
                        result = true;
                    }
                    catch (Exception e) {
                        logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                    }
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteSubscriber(String streamId, String subscriberId) {
        boolean result = false;
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            try {
                Query query = (Query)((Query)this.subscriberDatastore.createQuery(Subscriber.class).field(STREAM_ID).equal((Object)streamId)).field("subscriberId").equal((Object)subscriberId);
                WriteResult delete = this.subscriberDatastore.delete(query);
                result = delete.getN() == 1;
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean revokeSubscribers(String streamId) {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            Query query = (Query)this.subscriberDatastore.createQuery(Subscriber.class).field(STREAM_ID).equal((Object)streamId);
            WriteResult delete = this.subscriberDatastore.delete(query);
            return delete.getN() >= 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Subscriber getSubscriber(String streamId, String subscriberId) {
        Subscriber subscriber = null;
        if (subscriberId != null && streamId != null) {
            MongoStore mongoStore = this;
            synchronized (mongoStore) {
                try {
                    subscriber = (Subscriber)((Query)((Query)this.subscriberDatastore.find(Subscriber.class).field("subscriberId").equal((Object)subscriberId)).field(STREAM_ID).equal((Object)streamId)).get();
                }
                catch (Exception e) {
                    logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                }
            }
        }
        return subscriber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resetSubscribersConnectedStatus() {
        boolean result = false;
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            try {
                Query query = this.subscriberDatastore.createQuery(Subscriber.class);
                UpdateOperations ops = this.subscriberDatastore.createUpdateOperations(Subscriber.class).set("connected", (Object)false);
                this.subscriberDatastore.update(query, ops);
                result = true;
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return result;
    }

    public boolean setMp4Muxing(String streamId, int enabled) {
        return this.setRecordMuxing(streamId, enabled, "mp4Enabled");
    }

    public boolean setWebMMuxing(String streamId, int enabled) {
        return this.setRecordMuxing(streamId, enabled, "webMEnabled");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setRecordMuxing(String streamId, int enabled, String field) {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            try {
                if (streamId != null && (enabled == 1 || enabled == 0 || enabled == -1)) {
                    UpdateOperations ops;
                    Query query = (Query)this.datastore.createQuery(Broadcast.class).field(STREAM_ID).equal((Object)streamId);
                    UpdateResults update = this.datastore.update(query, ops = this.datastore.createUpdateOperations(Broadcast.class).set(field, (Object)enabled));
                    boolean bl = update.getUpdatedCount() == 1;
                    return bl;
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createConferenceRoom(ConferenceRoom room) {
        boolean result = false;
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            if (room != null && room.getRoomId() != null) {
                try {
                    this.conferenceRoomDatastore.save((Object)room);
                    result = true;
                }
                catch (Exception e) {
                    logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean editConferenceRoom(String roomId, ConferenceRoom room) {
        boolean result = false;
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            try {
                Query query = (Query)this.conferenceRoomDatastore.createQuery(ConferenceRoom.class).field("roomId").equal((Object)roomId);
                UpdateOperations ops = this.conferenceRoomDatastore.createUpdateOperations(ConferenceRoom.class).set("roomId", (Object)room.getRoomId()).set("startDate", (Object)room.getStartDate()).set("endDate", (Object)room.getEndDate()).set("roomStreamList", (Object)room.getRoomStreamList());
                UpdateResults update = this.conferenceRoomDatastore.update(query, ops);
                return update.getUpdatedCount() == 1;
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteConferenceRoom(String roomId) {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            try {
                Query query = (Query)this.conferenceRoomDatastore.createQuery(ConferenceRoom.class).field("roomId").equal((Object)roomId);
                WriteResult delete = this.conferenceRoomDatastore.delete(query);
                return delete.getN() == 1;
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConferenceRoom getConferenceRoom(String roomId) {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            try {
                return (ConferenceRoom)((Query)this.conferenceRoomDatastore.find(ConferenceRoom.class).field("roomId").equal((Object)roomId)).first();
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteToken(String tokenId) {
        boolean result = false;
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            try {
                Query query = (Query)this.tokenDatastore.createQuery(Token.class).field(TOKEN_ID).equal((Object)tokenId);
                WriteResult delete = this.tokenDatastore.delete(query);
                result = delete.getN() == 1;
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Token getToken(String tokenId) {
        Token token = null;
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            try {
                token = (Token)((Query)this.tokenDatastore.find(Token.class).field(TOKEN_ID).equal((Object)tokenId)).first();
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLocalLiveBroadcastCount(String hostAddress) {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            Query query = this.datastore.createQuery(Broadcast.class);
            query.and(new Criteria[]{query.or(new Criteria[]{(Criteria)query.criteria(ORIGIN_ADDRESS).doesNotExist(), (Criteria)query.criteria(ORIGIN_ADDRESS).equal((Object)hostAddress)}), (Criteria)query.criteria(STATUS).equal((Object)"broadcasting")});
            return query.count();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createP2PConnection(P2PConnection conn) {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            try {
                this.datastore.save((Object)conn);
                return true;
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteP2PConnection(String streamId) {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            try {
                Query query = (Query)this.datastore.createQuery(P2PConnection.class).field(STREAM_ID).equal((Object)streamId);
                WriteResult delete = this.datastore.delete(query);
                return delete.getN() == 1;
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public P2PConnection getP2PConnection(String streamId) {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            try {
                return (P2PConnection)((Query)this.datastore.find(P2PConnection.class).field(STREAM_ID).equal((Object)streamId)).first();
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addSubTrack(String mainTrackId, String subTrackId) {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            try {
                Query query = (Query)this.datastore.createQuery(Broadcast.class).field(STREAM_ID).equal((Object)mainTrackId);
                UpdateOperations ops = this.datastore.createUpdateOperations(Broadcast.class).push("subTrackStreamIds", (Object)subTrackId);
                UpdateResults update = this.datastore.update(query, ops);
                return update.getUpdatedCount() == 1;
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int resetBroadcasts(String hostAddress) {
        int totalOperationCount = 0;
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            Query querySI;
            WriteResult res;
            Query query = this.datastore.createQuery(Broadcast.class);
            query.and(new Criteria[]{query.or(new Criteria[]{(Criteria)query.criteria(ORIGIN_ADDRESS).doesNotExist(), (Criteria)query.criteria(ORIGIN_ADDRESS).equal((Object)hostAddress)}), (Criteria)query.criteria("zombi").equal((Object)true)});
            long count = query.count();
            if (count > 0L) {
                logger.error("There are {} streams for {} at start. They are deleted now.", (Object)count, (Object)hostAddress);
                res = this.datastore.delete(query);
                if ((long)res.getN() != count) {
                    logger.error("Only {} streams were deleted out of {} streams.", (Object)res.getN(), (Object)count);
                }
                totalOperationCount += res.getN();
            }
            Query queryUpdateStatus = this.datastore.createQuery(Broadcast.class);
            queryUpdateStatus.or(new Criteria[]{(Criteria)queryUpdateStatus.criteria(ORIGIN_ADDRESS).equal((Object)hostAddress), (Criteria)queryUpdateStatus.criteria(ORIGIN_ADDRESS).doesNotExist()});
            long broadcastCount = queryUpdateStatus.count();
            if (broadcastCount > 0L) {
                UpdateOperations ops = this.datastore.createUpdateOperations(Broadcast.class);
                ops.set(WEBRTC_VIEWER_COUNT, (Object)0);
                ops.set(HLS_VIEWER_COUNT, (Object)0);
                ops.set(RTMP_VIEWER_COUNT, (Object)0);
                ops.set(STATUS, (Object)"finished");
                UpdateResults update = this.datastore.update(queryUpdateStatus, ops);
                if ((long)update.getUpdatedCount() == broadcastCount) {
                    logger.info("{} of Broadcasts are reset. ", (Object)broadcastCount);
                } else {
                    logger.error("Broadcast reset count is not correct. {} stream info were updated out of {} streams.", (Object)update.getUpdatedCount(), (Object)broadcastCount);
                }
                totalOperationCount += update.getUpdatedCount();
            }
            if ((count = (querySI = (Query)this.datastore.createQuery(StreamInfo.class).field("host").equal((Object)hostAddress)).count()) > 0L) {
                logger.error("There are {} stream info adressing {} at start. They are deleted now.", (Object)count, (Object)hostAddress);
                res = this.datastore.delete(querySI);
                if ((long)res.getN() != count) {
                    logger.error("Only {} stream info were deleted out of {} streams.", (Object)res.getN(), (Object)count);
                }
                totalOperationCount += res.getN();
            }
        }
        return totalOperationCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotalWebRTCViewersCount() {
        long now = System.currentTimeMillis();
        if (now - this.totalWebRTCViewerCountLastUpdateTime > 5000L) {
            MongoStore mongoStore = this;
            synchronized (mongoStore) {
                int total = 0;
                Query query = this.datastore.createQuery(Broadcast.class);
                query.field(STATUS).equal((Object)"broadcasting");
                Iterator result = this.datastore.createAggregation(Broadcast.class).match(query).group("AllBroadcasts", new Group[]{Group.grouping((String)"total", (Accumulator)Group.sum((String)WEBRTC_VIEWER_COUNT))}).aggregate(Summation.class, AggregationOptions.builder().build());
                if (result.hasNext()) {
                    total = ((Summation)result.next()).getTotal();
                }
                this.totalWebRTCViewerCount = total;
                this.totalWebRTCViewerCountLastUpdateTime = now;
            }
        }
        return this.totalWebRTCViewerCount;
    }

    static class Summation {
        private int total;

        Summation() {
        }

        public int getTotal() {
            return this.total;
        }

        public void setTotal(int total) {
            this.total = total;
        }
    }
}

