/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.filter;

import io.antmedia.AppSettings;
import io.antmedia.filter.AbstractFilter;
import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.security.Keys;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import javax.crypto.SecretKey;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JWTFilter
extends AbstractFilter {
    protected static Logger log = LoggerFactory.getLogger(JWTFilter.class);
    public static final String JWT_TOKEN = "Authorization";
    private AppSettings appSettings;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.appSettings = this.getAppSettings();
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        if (this.appSettings != null && !this.appSettings.isJwtControlEnabled() || httpRequest.getHeader(JWT_TOKEN) != null && this.checkJWT(httpRequest.getHeader(JWT_TOKEN))) {
            chain.doFilter(request, response);
            return;
        }
        ((HttpServletResponse)response).sendError(403, "Invalid JWT Token");
    }

    private boolean checkJWT(String jwtString) {
        SecretKey key = Keys.hmacShaKeyFor((byte[])this.appSettings.getJwtSecretKey().getBytes(StandardCharsets.UTF_8));
        boolean result = false;
        try {
            Jwts.parserBuilder().setSigningKey((Key)key).build().parseClaimsJws(jwtString);
            result = true;
        }
        catch (JwtException ex) {
            result = false;
        }
        return result;
    }
}

