/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.settings;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.catalina.util.NetMask;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.bytedeco.ffmpeg.global.avutil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.webrtc.Logging;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ServerSettings
implements ApplicationContextAware {
    public static final String BEAN_NAME = "ant.media.server.settings";
    private static final String SETTINGS_HEART_BEAT_ENABLED = "server.heartbeatEnabled";
    private static final String SETTINGS_USE_GLOBAL_IP = "useGlobalIp";
    private static final String SETTINGS_NODE_GROUP = "nodeGroup";
    public static final String LOG_LEVEL_ALL = "ALL";
    public static final String LOG_LEVEL_TRACE = "TRACE";
    public static final String LOG_LEVEL_DEBUG = "DEBUG";
    public static final String LOG_LEVEL_INFO = "INFO";
    public static final String LOG_LEVEL_WARN = "WARN";
    public static final String LOG_LEVEL_ERROR = "ERROR";
    public static final String LOG_LEVEL_OFF = "OFF";
    public static final String DEFAULT_NODE_GROUP = "default";
    private static final String SETTINGS_CPU_MEASUREMENT_PERIOD_MS = "server.cpu_measurement_period_ms";
    private static final String SETTINGS_CPU_MEASUREMENT_WINDOW_SIZE = "server.cpu_measurement_window_size";
    private static final String SETTINGS_SERVER_DEFAULT_HTTP_PORT = "http.port";
    private String allowedDashboardCIDR;
    @JsonIgnore
    private List<NetMask> allowedCIDRList = new ArrayList<NetMask>();
    private static Logger logger = LoggerFactory.getLogger(ServerSettings.class);
    private static String localHostAddress;
    private static String globalHostAddress;
    private static String hostAddress;
    private String serverName;
    private String licenceKey;
    private boolean buildForMarket = false;
    private String logLevel = null;
    private String nativeLogLevel = "WARN";
    @Value(value="${server.heartbeatEnabled:true}")
    private boolean heartbeatEnabled;
    @Value(value="${useGlobalIp:false}")
    private boolean useGlobalIp;
    @Value(value="${nodeGroup:default}")
    private String nodeGroup = "default";
    private Logging.Severity webrtcLogLevel = Logging.Severity.LS_WARNING;
    @Value(value="${server.cpu_measurement_period_ms:1000}")
    private int cpuMeasurementPeriodMs;
    @Value(value="${server.cpu_measurement_window_size:5}")
    private int cpuMeasurementWindowSize;
    @Value(value="${http.port:5080}")
    private int defaultHttpPort;

    public boolean isBuildForMarket() {
        return this.buildForMarket;
    }

    public void setBuildForMarket(boolean buildForMarket) {
        this.buildForMarket = buildForMarket;
    }

    public String getLicenceKey() {
        return this.licenceKey;
    }

    public void setLicenceKey(String licenceKey) {
        this.licenceKey = licenceKey;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(String logLevel) {
        this.logLevel = logLevel;
    }

    public boolean isHeartbeatEnabled() {
        return this.heartbeatEnabled;
    }

    public void setHeartbeatEnabled(boolean heartbeatEnabled) {
        this.heartbeatEnabled = heartbeatEnabled;
    }

    public String getHostAddress() {
        if (hostAddress == null) {
            logger.warn("ServerSettings is not initialized yet so that return local host address: {}", (Object)ServerSettings.getLocalHostAddress());
            return ServerSettings.getLocalHostAddress();
        }
        return hostAddress;
    }

    public static String getGlobalHostAddress() {
        if (globalHostAddress == null) {
            InputStream in = null;
            try {
                in = new URL("http://checkip.amazonaws.com").openStream();
                globalHostAddress = IOUtils.toString((InputStream)in, (Charset)Charset.defaultCharset()).trim();
            }
            catch (IOException e) {
                try {
                    logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(in);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)in);
            }
            IOUtils.closeQuietly((InputStream)in);
        }
        return globalHostAddress;
    }

    public static String getLocalHostAddress() {
        if (localHostAddress == null) {
            long startTime = System.currentTimeMillis();
            try {
                localHostAddress = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
            long diff = System.currentTimeMillis() - startTime;
            if (diff > 1000L) {
                logger.warn("Getting host adress took {}ms. it's cached now and will return immediately from now on. You can  alternatively set serverName in conf/red5.properties file ", (Object)diff);
            }
        }
        return localHostAddress;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        hostAddress = this.useGlobalIp ? ServerSettings.getGlobalHostAddress() : ServerSettings.getLocalHostAddress();
    }

    public boolean isUseGlobalIp() {
        return this.useGlobalIp;
    }

    public void setUseGlobalIp(boolean useGlobalIp) {
        this.useGlobalIp = useGlobalIp;
    }

    public void setAllowedDashboardCIDR(String allowedDashboardCIDR) {
        this.allowedDashboardCIDR = allowedDashboardCIDR;
        this.allowedCIDRList = new ArrayList<NetMask>();
        this.fillFromInput(allowedDashboardCIDR, this.allowedCIDRList);
    }

    public String getAllowedDashboardCIDR() {
        return this.allowedDashboardCIDR;
    }

    public List<NetMask> getAllowedCIDRList() {
        if (this.allowedCIDRList.isEmpty()) {
            this.fillFromInput(this.allowedDashboardCIDR, this.allowedCIDRList);
        }
        return this.allowedCIDRList;
    }

    private List<String> fillFromInput(String input, List<NetMask> target) {
        target.clear();
        if (input == null || input.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<CallSite> messages = new LinkedList<CallSite>();
        for (String s : input.split("\\s*,\\s*")) {
            try {
                NetMask nm = new NetMask(s);
                target.add(nm);
            }
            catch (IllegalArgumentException e) {
                messages.add((CallSite)((Object)(s + ": " + e.getMessage())));
            }
        }
        return Collections.unmodifiableList(messages);
    }

    public String getNativeLogLevel() {
        return this.nativeLogLevel;
    }

    public void setNativeLogLevel(String nativeLogLevel) {
        switch (this.nativeLogLevel = nativeLogLevel) {
            case "ALL": 
            case "TRACE": {
                this.webrtcLogLevel = Logging.Severity.LS_VERBOSE;
                avutil.av_log_set_level((int)56);
                break;
            }
            case "DEBUG": {
                this.webrtcLogLevel = Logging.Severity.LS_VERBOSE;
                avutil.av_log_set_level((int)48);
                break;
            }
            case "INFO": {
                this.webrtcLogLevel = Logging.Severity.LS_INFO;
                avutil.av_log_set_level((int)32);
                break;
            }
            case "WARN": {
                this.webrtcLogLevel = Logging.Severity.LS_WARNING;
                avutil.av_log_set_level((int)24);
                break;
            }
            case "ERROR": {
                this.webrtcLogLevel = Logging.Severity.LS_ERROR;
                avutil.av_log_set_level((int)16);
                break;
            }
            case "OFF": {
                this.webrtcLogLevel = Logging.Severity.LS_NONE;
                avutil.av_log_set_level((int)-8);
                break;
            }
            default: {
                this.nativeLogLevel = LOG_LEVEL_WARN;
                this.webrtcLogLevel = Logging.Severity.LS_WARNING;
                avutil.av_log_set_level((int)24);
            }
        }
    }

    public Logging.Severity getWebRTCLogLevel() {
        return this.webrtcLogLevel;
    }

    public String getNodeGroup() {
        return this.nodeGroup;
    }

    public void setNodeGroup(String nodeGroup) {
        this.nodeGroup = nodeGroup;
    }

    public int getCpuMeasurementPeriodMs() {
        return this.cpuMeasurementPeriodMs;
    }

    public void setCpuMeasurementPeriodMs(int cpuMeasurementPeriodMs) {
        this.cpuMeasurementPeriodMs = cpuMeasurementPeriodMs;
    }

    public int getCpuMeasurementWindowSize() {
        return this.cpuMeasurementWindowSize;
    }

    public void setCpuMeasurementWindowSize(int cpuMeasurementWindowSize) {
        this.cpuMeasurementWindowSize = cpuMeasurementWindowSize;
    }

    public int getDefaultHttpPort() {
        return this.defaultHttpPort;
    }

    public void setDefaultHttpPort(int defaultHttpPort) {
        this.defaultHttpPort = defaultHttpPort;
    }
}

