/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.webrtc.adaptor;

import io.antmedia.websocket.WebSocketCommunityHandler;
import javax.websocket.Session;
import org.red5.logging.Red5LoggerFactory;
import org.slf4j.Logger;
import org.webrtc.DataChannel;
import org.webrtc.IceCandidate;
import org.webrtc.MediaConstraints;
import org.webrtc.MediaStream;
import org.webrtc.PeerConnection;
import org.webrtc.PeerConnectionFactory;
import org.webrtc.RtpReceiver;
import org.webrtc.SdpObserver;
import org.webrtc.SessionDescription;

public abstract class Adaptor
implements PeerConnection.Observer,
SdpObserver {
    protected PeerConnection peerConnection;
    private MediaConstraints sdpMediaConstraints;
    protected PeerConnectionFactory peerConnectionFactory;
    protected WebSocketCommunityHandler webSocketCommunityHandler;
    private String streamId;
    private Session session;
    protected static final Logger log = Red5LoggerFactory.getLogger(Adaptor.class);

    public Adaptor(WebSocketCommunityHandler websocketCommunityHandler) {
        this.webSocketCommunityHandler = websocketCommunityHandler;
    }

    public abstract void start();

    public abstract void stop();

    public void setPeerConnection(PeerConnection peerConnection) {
        this.peerConnection = peerConnection;
    }

    public PeerConnection getPeerConnection() {
        return this.peerConnection;
    }

    public void onSignalingChange(PeerConnection.SignalingState newState) {
    }

    public void onIceConnectionChange(PeerConnection.IceConnectionState newState) {
        if (newState == PeerConnection.IceConnectionState.DISCONNECTED || newState == PeerConnection.IceConnectionState.FAILED || newState == PeerConnection.IceConnectionState.CLOSED) {
            log.info("Ice connection state changed to {} so it's stopping", (Object)newState);
            this.stop();
        }
    }

    public void onIceConnectionReceivingChange(boolean receiving) {
    }

    public void onIceGatheringChange(PeerConnection.IceGatheringState newState) {
    }

    public void onIceCandidate(IceCandidate candidate) {
        log.warn("onIceCandidate");
        this.webSocketCommunityHandler.sendTakeCandidateMessage(candidate.sdpMLineIndex, candidate.sdpMid, candidate.sdp, this.streamId, this.session);
    }

    public void onIceCandidatesRemoved(IceCandidate[] candidates) {
    }

    public void onAddStream(MediaStream stream) {
    }

    public void onRemoveStream(MediaStream stream) {
    }

    public void onDataChannel(DataChannel dataChannel) {
    }

    public void onRenegotiationNeeded() {
    }

    public void onAddTrack(RtpReceiver receiver, MediaStream[] mediaStreams) {
    }

    public void onCreateSuccess(SessionDescription sdp) {
        log.warn("onCreate Success for stream: {}", (Object)this.streamId);
        if (this.peerConnection != null) {
            this.peerConnection.setLocalDescription(new SdpObserver(){

                public void onSetSuccess() {
                    log.info("set localdescription on set success  for {}", (Object)Adaptor.this.streamId);
                }

                public void onSetFailure(String error) {
                    log.info("set localdescription onSetFailure  for {}", (Object)Adaptor.this.streamId);
                }

                public void onCreateSuccess(SessionDescription sdp) {
                    log.info("set localdescription onCreateSuccess  for {}", (Object)Adaptor.this.streamId);
                }

                public void onCreateFailure(String error) {
                    log.info("set localdescription onCreateSuccess  for {}", (Object)Adaptor.this.streamId);
                }
            }, sdp);
        }
        String type = sdp.type == SessionDescription.Type.ANSWER ? "answer" : "offer";
        this.webSocketCommunityHandler.sendSDPConfiguration(sdp.description, type, this.streamId, this.session);
    }

    public void onSetSuccess() {
        log.warn("on setSuccess");
    }

    public void onCreateFailure(String error) {
        log.warn(error);
    }

    public void onSetFailure(String error) {
        log.warn(error);
    }

    public MediaConstraints getSdpMediaConstraints() {
        return this.sdpMediaConstraints;
    }

    public void setSdpMediaConstraints(MediaConstraints sdpMediaConstraints) {
        this.sdpMediaConstraints = sdpMediaConstraints;
    }

    public void setPeerConnectionFactory(PeerConnectionFactory peerConnectionFactory) {
        this.peerConnectionFactory = peerConnectionFactory;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public Session getSession() {
        return this.session;
    }

    public String getStreamId() {
        return this.streamId;
    }

    public void setStreamId(String streamId) {
        this.streamId = streamId;
    }
}

