/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.rtmpt;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.mina.core.buffer.IoBuffer;
import org.red5.server.api.IConnection;
import org.red5.server.api.Red5;
import org.red5.server.net.rtmp.RTMPConnection;
import org.red5.server.net.rtmp.codec.RTMPProtocolDecoder;
import org.red5.server.net.rtmp.codec.RTMPProtocolEncoder;
import org.red5.server.net.rtmp.message.Packet;
import org.red5.server.net.rtmpt.codec.RTMPTProtocolDecoder;
import org.red5.server.net.rtmpt.codec.RTMPTProtocolEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseRTMPTConnection
extends RTMPConnection {
    private static final Logger log = LoggerFactory.getLogger(BaseRTMPTConnection.class);
    private transient RTMPTProtocolDecoder decoder;
    private transient RTMPTProtocolEncoder encoder;
    private volatile boolean closing;
    private AtomicLong readBytes = new AtomicLong(0L);
    private AtomicLong writtenBytes = new AtomicLong(0L);
    private volatile IoBuffer buffer;
    protected volatile transient LinkedBlockingQueue<PendingData> pendingOutMessages = new LinkedBlockingQueue(8192);
    protected int maxInMessagesPerProcess = 16;
    protected long maxQueueOfferTime = 500L;
    protected int maxQueueOfferAttempts = 4;

    public BaseRTMPTConnection(String type) {
        super(type);
        this.buffer = IoBuffer.allocate((int)0).setAutoExpand(true);
    }

    public abstract IoBuffer getPendingMessages(int var1);

    public void close() {
        this.closing = true;
        if (this.pendingOutMessages.size() > 0) {
            if (log.isTraceEnabled()) {
                log.trace("Clearing pending messages out: {}", (Object)this.pendingOutMessages.size());
            }
            this.pendingOutMessages.clear();
        }
        if (this.buffer != null) {
            this.buffer.free();
            this.buffer = null;
        }
        super.close();
    }

    public boolean isClosing() {
        return this.closing;
    }

    public long getReadBytes() {
        return this.readBytes.get();
    }

    public void updateReadBytes(int read) {
        this.readBytes.addAndGet(read);
    }

    public long getWrittenBytes() {
        return this.writtenBytes.get();
    }

    public void updateWrittenBytes(int wrote) {
        this.writtenBytes.addAndGet(wrote);
    }

    public long getPendingMessages() {
        log.debug("Checking pending queue size. Session id: {} closing: {} state: {}", new Object[]{this.sessionId, this.closing, this.state});
        if (this.state.getState() == 5) {
            log.debug("Connection is disconnected");
            this.pendingOutMessages.clear();
        }
        return this.pendingOutMessages.size();
    }

    public List<?> decode(IoBuffer data) {
        log.debug("decode");
        if (this.closing || this.state.getState() == 5) {
            return Collections.EMPTY_LIST;
        }
        if (log.isTraceEnabled()) {
            log.trace("Current bytes read at decode: {}", (Object)data.limit());
        }
        this.buffer.put(data);
        this.buffer.flip();
        return this.decoder.decodeBuffer((RTMPConnection)this, this.buffer);
    }

    public void write(Packet packet) {
        block9: {
            if (log.isDebugEnabled()) {
                log.debug("write - packet: {}", (Object)packet);
            }
            if (this.closing || this.state.getState() == 5) {
                log.debug("No write completed due to connection disconnecting");
            } else {
                IoBuffer data = null;
                try {
                    if (log.isDebugEnabled()) {
                        log.debug("Local: {} this: {}", (Object)Red5.getConnectionLocal(), (Object)this);
                    }
                    Red5.setConnectionLocal((IConnection)this);
                    data = this.encoder.encodePacket(packet);
                    if (data != null) {
                        log.debug("Adding outgoing message packet");
                        PendingData pendingData = new PendingData(data, packet);
                        int attempt = 0;
                        while (!this.pendingOutMessages.offer(pendingData, this.maxQueueOfferTime, TimeUnit.MILLISECONDS)) {
                            log.trace("Packet was not added to out queue");
                            if (++attempt < this.maxQueueOfferAttempts) continue;
                            break block9;
                        }
                        break block9;
                    }
                    log.warn("Response buffer was null after encoding");
                }
                catch (InterruptedException ex) {
                    log.warn("Offering packet to out queue failed", (Throwable)ex);
                    ex.printStackTrace();
                    Thread.currentThread().interrupt();
                }
                catch (Exception e) {
                    log.error("Could not encode message {}", (Object)packet, (Object)e);
                }
            }
        }
    }

    public void writeRaw(IoBuffer packet) {
        if (log.isDebugEnabled()) {
            log.debug("write - io buffer: {}", (Object)packet);
        }
        PendingData pendingData = new PendingData(packet);
        try {
            int attempt = 0;
            while (!this.pendingOutMessages.offer(pendingData, this.maxQueueOfferTime, TimeUnit.MILLISECONDS)) {
                log.trace("Packet was not added to out queue");
                if (++attempt < this.maxQueueOfferAttempts) continue;
                break;
            }
        }
        catch (InterruptedException ex) {
            log.warn("Offering io buffer to out queue failed", (Throwable)ex);
            ex.printStackTrace();
            Thread.currentThread().interrupt();
        }
    }

    protected IoBuffer foldPendingMessages(int targetSize) {
        log.debug("foldPendingMessages - target size: {}", (Object)targetSize);
        IoBuffer result = null;
        if (!this.pendingOutMessages.isEmpty()) {
            int available = this.pendingOutMessages.size();
            LinkedList sendList = new LinkedList();
            this.pendingOutMessages.drainTo(sendList, Math.min(164, available));
            result = IoBuffer.allocate((int)targetSize).setAutoExpand(true);
            for (PendingData pendingMessage : sendList) {
                result.put(pendingMessage.getBuffer());
                Packet packet = pendingMessage.getPacket();
                if (packet != null) {
                    try {
                        this.handler.messageSent((RTMPConnection)this, packet);
                        this.writingMessage(packet);
                    }
                    catch (Exception e) {
                        log.error("Could not notify stream subsystem about sent message", (Throwable)e);
                    }
                    continue;
                }
                log.trace("Pending message did not have a packet");
            }
            sendList.clear();
            result.flip();
            if (log.isDebugEnabled()) {
                log.debug("Send size: {}", (Object)result.limit());
            }
        }
        return result;
    }

    public void setDecoder(RTMPProtocolDecoder decoder) {
        this.decoder = (RTMPTProtocolDecoder)decoder;
    }

    public void setEncoder(RTMPProtocolEncoder encoder) {
        this.encoder = (RTMPTProtocolEncoder)encoder;
    }

    public void setMaxInMessagesPerProcess(int maxInMessagesPerProcess) {
        this.maxInMessagesPerProcess = maxInMessagesPerProcess;
    }

    public void setMaxQueueOfferTime(long maxQueueOfferTime) {
        this.maxQueueOfferTime = maxQueueOfferTime;
    }

    public void setMaxQueueOfferAttempts(int maxQueueOfferAttempts) {
        this.maxQueueOfferAttempts = maxQueueOfferAttempts;
    }

    private static class PendingData {
        private final Packet packet;
        private final byte[] byteBuffer;

        private PendingData(IoBuffer buffer, Packet packet) {
            int size = buffer.limit();
            this.byteBuffer = new byte[size];
            buffer.get(this.byteBuffer);
            this.packet = packet;
            if (log.isTraceEnabled()) {
                log.trace("Buffer: {}", (Object)Arrays.toString(ArrayUtils.subarray((byte[])this.byteBuffer, (int)0, (int)32)));
            }
        }

        private PendingData(IoBuffer buffer) {
            int size = buffer.limit();
            this.byteBuffer = new byte[size];
            buffer.get(this.byteBuffer);
            this.packet = null;
            if (log.isTraceEnabled()) {
                log.trace("Buffer: {}", (Object)Arrays.toString(ArrayUtils.subarray((byte[])this.byteBuffer, (int)0, (int)32)));
            }
        }

        public byte[] getBuffer() {
            if (log.isTraceEnabled()) {
                log.trace("Get buffer: {}", (Object)Arrays.toString(ArrayUtils.subarray((byte[])this.byteBuffer, (int)0, (int)32)));
            }
            return this.byteBuffer;
        }

        public Packet getPacket() {
            return this.packet;
        }

        public int getBufferSize() {
            if (this.byteBuffer != null) {
                return this.byteBuffer.length;
            }
            return 0;
        }
    }
}

