/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import dev.morphia.annotations.Entity;
import dev.morphia.annotations.Field;
import dev.morphia.annotations.Id;
import dev.morphia.annotations.Index;
import dev.morphia.annotations.Indexes;
import dev.morphia.annotations.NotSaved;
import io.antmedia.EncoderSettings;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.catalina.util.NetMask;
import org.bson.types.ObjectId;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.PropertySource;

@Entity(value="AppSettings")
@Indexes(value={@Index(fields={@Field(value="appName")})})
@PropertySource(value={"/WEB-INF/red5-web.properties"})
@JsonIgnoreProperties(ignoreUnknown=true)
public class AppSettings {
    @JsonIgnore
    @Id
    private ObjectId dbId;
    public static final String PROPERTIES_FILE_PATH = "/WEB-INF/red5-web.properties";
    private static final String SETTINGS_ENCODING_SPECIFIC = "settings.encoding.specific";
    public static final String SETTINGS_ADD_DATE_TIME_TO_MP4_FILE_NAME = "settings.addDateTimeToMp4FileName";
    public static final String SETTINGS_HLS_MUXING_ENABLED = "settings.hlsMuxingEnabled";
    public static final String SETTINGS_DASH_MUXING_ENABLED = "settings.dashMuxingEnabled";
    public static final String SETTINGS_DASH_WINDOW_SIZE = "settings.dashWindowSize";
    public static final String SETTINGS_DASH_EXTRA_WINDOW_SIZE = "settings.dashExtraWindowSize";
    public static final String SETTINGS_ENCODER_SETTINGS_STRING = "settings.encoderSettingsString";
    public static final String SETTINGS_HLS_LIST_SIZE = "settings.hlsListSize";
    public static final String SETTINGS_HLS_TIME = "settings.hlsTime";
    public static final String SETTINGS_DASH_SEG_DURATION = "settings.dashSegDuration";
    public static final String SETTINGS_DASH_FRAGMENT_DURATION = "settings.dashFragmentDuration";
    public static final String SETTINGS_DASH_TARGET_LATENCY = "settings.dashTargetLatency";
    public static final String SETTINGS_WEBRTC_ENABLED = "settings.webRTCEnabled";
    public static final String SETTINGS_USE_ORIGINAL_WEBRTC_ENABLED = "settings.useOriginalWebRTCEnabled";
    public static final String SETTINGS_DELETE_HLS_FILES_ON_ENDED = "settings.deleteHLSFilesOnEnded";
    public static final String SETTINGS_DELETE_DASH_FILES_ON_ENDED = "settings.deleteDASHFilesOnEnded";
    public static final String SETTINGS_LISTENER_HOOK_URL = "settings.listenerHookURL";
    public static final String SETTINGS_ACCEPT_ONLY_STREAMS_IN_DATA_STORE = "settings.acceptOnlyStreamsInDataStore";
    public static final String SETTINGS_TOKEN_CONTROL_ENABLED = "settings.tokenControlEnabled";
    public static final String SETTINGS_PUBLISH_TOKEN_CONTROL_ENABLED = "settings.publishTokenControlEnabled";
    public static final String SETTINGS_PLAY_TOKEN_CONTROL_ENABLED = "settings.playTokenControlEnabled";
    public static final String SETTINGS_TIME_TOKEN_SUBSCRIBER_ONLY = "settings.timeTokenSubscriberOnly";
    public static final String SETTINGS_TIME_TOKEN_PERIOD = "settings.timeTokenPeriod";
    public static final String SETTINGS_HLS_PLAY_LIST_TYPE = "settings.hlsPlayListType";
    public static final String FACEBOOK_CLIENT_ID = "facebook.clientId";
    public static final String FACEBOOK_CLIENT_SECRET = "facebook.clientSecret";
    public static final String PERISCOPE_CLIENT_ID = "periscope.clientId";
    public static final String PERISCOPE_CLIENT_SECRET = "periscope.clientSecret";
    public static final String YOUTUBE_CLIENT_ID = "youtube.clientId";
    public static final String YOUTUBE_CLIENT_SECRET = "youtube.clientSecret";
    public static final String SETTINGS_VOD_FOLDER = "settings.vodFolder";
    public static final String SETTINGS_PREVIEW_OVERWRITE = "settings.previewOverwrite";
    private static final String SETTINGS_STALKER_DB_SERVER = "settings.stalkerDBServer";
    private static final String SETTINGS_STALKER_DB_USER_NAME = "settings.stalkerDBUsername";
    private static final String SETTINGS_STALKER_DB_PASSWORD = "settings.stalkerDBPassword";
    public static final String SETTINGS_OBJECT_DETECTION_ENABLED = "settings.objectDetectionEnabled";
    private static final String SETTINGS_CREATE_PREVIEW_PERIOD = "settings.createPreviewPeriod";
    public static final String SETTINGS_MP4_MUXING_ENABLED = "settings.mp4MuxingEnabled";
    public static final String SETTINGS_WEBM_MUXING_ENABLED = "settings.webMMuxingEnabled";
    private static final String SETTINGS_STREAM_FETCHER_BUFFER_TIME = "settings.streamFetcherBufferTime";
    public static final String SETTINGS_STREAM_FETCHER_RESTART_PERIOD = "settings.streamFetcherRestartPeriod";
    private static final String SETTINGS_STREAM_FETCHER_AUTO_START = "settings.streamFetcherAutoStart";
    private static final String SETTINGS_MUXER_FINISH_SCRIPT = "settings.muxerFinishScript";
    public static final String SETTINGS_WEBRTC_FRAME_RATE = "settings.webRTCFrameRate";
    public static final String SETTINGS_HASH_CONTROL_PUBLISH_ENABLED = "settings.hashControlPublishEnabled";
    public static final String SETTINGS_HASH_CONTROL_PLAY_ENABLED = "settings.hashControlPlayEnabled";
    public static final String TOKEN_HASH_SECRET = "tokenHashSecret";
    public static final String SETTINGS_WEBRTC_PORT_RANGE_MIN = "settings.webrtc.portRangeMin";
    public static final String SETTINGS_WEBRTC_PORT_RANGE_MAX = "settings.webrtc.portRangeMax";
    public static final String SETTINGS_WEBRTC_STUN_SERVER_URI = "settings.webrtc.stunServerURI";
    public static final String SETTINGS_WEBRTC_TCP_CANDIDATE_ENABLED = "settings.webrtc.tcpCandidateEnabled";
    public static final String SETTINGS_WEBRTC_SDP_SEMANTICS = "settings.webrtc.sdpSemantics";
    private static final String SETTINGS_ENCODING_ENCODER_NAME = "settings.encoding.encoderName";
    private static final String SETTINGS_ENCODING_PRESET = "settings.encoding.preset";
    private static final String SETTINGS_ENCODING_PROFILE = "settings.encoding.profile";
    private static final String SETTINGS_ENCODING_LEVEL = "settings.encoding.level";
    private static final String SETTINGS_ENCODING_RC = "settings.encoding.rc";
    private static final String SETTINGS_ENCODING_THREAD_COUNT = "settings.encoding.threadCount";
    private static final String SETTINGS_ENCODING_THREAD_TYPE = "settings.encoding.threadType";
    private static final String SETTINGS_PREVIEW_HEIGHT = "settings.previewHeight";
    private static final String SETTINGS_ENCODING_VP8_THREAD_COUNT = "settings.encoding.vp8.threadCount";
    private static final String SETTINGS_ENCODING_VP8_SPEED = "settings.encoding.vp8.speed";
    private static final String SETTINGS_ENCODING_VP8_DEADLINE = "settings.encoding.vp8.deadline";
    public static final String SETTINGS_GENERATE_PREVIEW = "settings.previewGenerate";
    public static final String SETTINGS_REMOTE_ALLOWED_CIDR = "settings.remoteAllowedCIDR";
    public static final String SETTINGS_WRITE_STATS_TO_DATASTORE = "settings.writeStatsToDatastore";
    public static final String SETTINGS_ENCODER_SELECTION_PREFERENCE = "settings.encoderSelectionPreference";
    public static final String SETTINGS_ALLOWED_PUBLISHER_IPS = "settings.allowedPublisherCIDR";
    public static final String BEAN_NAME = "app.settings";
    private static final String SETTINGS_EXCESSIVE_BANDWIDTH_THRESHOLD = "settings.excessiveBandwidth.threshold";
    private static final String SETTINGS_EXCESSIVE_BANDWIDTH_CALL_THRESHOLD = "settings.excessiveBandwidth.call.threshold";
    private static final String SETTINGS_PORT_ALLOCATOR_FLAGS = "settings.portAllocator.flags";
    private static final String SETTINGS_EXCESSIVE_BANDWIDTH_TRY_COUNT_BEFORE_SWITCH_BACK = "settings.excessiveBandwith.tryCount.beforeSwitchback";
    private static final String SETTINGS_EXCESSIVE_BANDWIDTH_ENABLED = "settings.excessiveBandwidth_enabled";
    private static final String SETTINGS_EXCESSIVE_BANDWIDTH_PACKET_LOSS_DIFF_THRESHOLD_FOR_SWITCH_BACK = "settings.excessiveBandwidth.packetLossDiffThreshold.forSwitchback";
    private static final String SETTINGS_EXCESSIVE_BANDWIDTH_RTT_MEASUREMENT_THRESHOLD_FOR_SWITCH_BACK = "settings.excessiveBandwidth.rttMeasurementDiffThreshold.forSwitchback";
    private static final String SETTINGS_REPLACE_CANDIDATE_ADDR_WITH_SERVER_ADDR = "settings.replaceCandidateAddrWithServerAddr";
    public static final String SETTINGS_DB_APP_NAME = "db.app.name";
    public static final String SETTINGS_ENCODING_TIMEOUT = "settings.encoding.timeout";
    public static final String SETTINGS_WEBRTC_CLIENT_START_TIMEOUT = "settings.webrtc.client.start.timeoutMs";
    public static final String SETTINGS_DEFAULT_DECODERS_ENABLED = "settings.defaultDecodersEnabled";
    public static final String SETTINGS_COLLECT_SOCIAL_MEDIA_ACTIVITY_ENABLED = "settings.collectSocialMediaActivityEnabled";
    private static final String SETTINGS_HTTP_FORWARDING_EXTENSION = "settings.httpforwarding.extension";
    private static final String SETTINGS_HTTP_FORWARDING_BASE_URL = "settings.httpforwarding.baseURL";
    private static final String SETTINGS_RTMP_MAX_ANALYZE_DURATION_MS = "settings.rtmp.maxAnalyzeDurationMS";
    private static final String SETTINGS_DISABLE_IPV6_CANDIDATES = "settings.disableIPv6Candidates";
    private static final String SETTINGS_RTSP_PULL_TRANSPORT_TYPE = "settings.rtspPullTransportType";
    public static final String SETTINGS_H264_ENABLED = "settings.h264Enabled";
    public static final String SETTINGS_VP8_ENABLED = "settings.vp8Enabled";
    public static final String SETTINGS_H265_ENABLED = "settings.h265Enabled";
    public static final String SETTINGS_MAX_FPS_ACCEPT = "settings.maxFpsAccept";
    public static final String SETTINGS_DATA_CHANNEL_ENABLED = "settings.dataChannelEnabled";
    public static final String SETTINGS_DATA_CHANNEL_PLAYER_DISTRIBUTION = "settings.dataChannelPlayerDistrubution";
    public static final String SETTINGS_MAX_RESOLUTION_ACCEPT = "settings.maxResolutionAccept";
    public static final String SETTINGS_MAX_BITRATE_ACCEPT = "settings.maxBitrateAccept";
    public static final String SETTINGS_AUDIO_BITRATE_SFU = "settings.audioBitrateSFU";
    public static final String DATA_CHANNEL_PLAYER_TO_NONE = "none";
    public static final String DATA_CHANNEL_PLAYER_TO_PUBLISHER = "publisher";
    public static final String DATA_CHANNEL_PLAYER_TO_ALL = "all";
    private static final String SETTINGS_HLS_FLAGS = "settings.hlsflags";
    public static final String SETTINGS_RTMP_INGEST_BUFFER_TIME_MS = "settings.rtmpIngestBufferTimeMs";
    public static final String SETTINGS_ACCEPT_ONLY_ROOMS_IN_DATA_STORE = "settings.acceptOnlyRoomsInDataStore";
    public static final String SETTINGS_DATA_CHANNEL_WEBHOOK_URL = "settings.dataChannelWebHook";
    public static final String SDP_SEMANTICS_PLAN_B = "planB";
    public static final String SDP_SEMANTICS_UNIFIED_PLAN = "unifiedPlan";
    private static final String SETTINGS_HEIGHT_RTMP_FORWARDING = "settings.heightRtmpForwarding";
    private static final String SETTINGS_AAC_ENCODING_ENABLED = "settings.aacEncodingEnabled";
    private static final String SETTINGS_GOP_SIZE = "settings.gopSize";
    private static final String SETTINGS_CONSTANT_RATE_FACTOR = "settings.constantRateFactor";
    private static final String SETTINGS_WEBRTC_VIEWER_LIMIT = "settings.webRTCViewerLimit";
    public static final String SETTINGS_JWT_SECRET_KEY = "settings.jwtSecretKey";
    public static final String SETTINGS_JWT_CONTROL_ENABLED = "settings.jwtControlEnabled";
    public static final String SETTINGS_IP_FILTER_ENABLED = "settings.ipFilterEnabled";
    private static final String SETTINGS_INGESTING_STREAM_LIMIT = "settings.ingestingStreamLimit";
    private static final String SETTINGS_WEBRTC_KEYFRAME_TIME = "settings.webRTCKeyframeTime";
    public static final String SETTINGS_JWT_STREAM_SECRET_KEY = "settings.jwtStreamSecretKey";
    public static final String SETTINGS_PLAY_JWT_CONTROL_ENABLED = "settings.playJwtControlEnabled";
    public static final String SETTINGS_PUBLISH_JWT_CONTROL_ENABLED = "settings.publishJwtControlEnabled";
    private static final String SETTINGS_DASH_ENABLE_LOW_LATENCY = "settings.dash.llEnabled";
    private static final String SETTINGS_HLS_ENABLE_LOW_LATENCY = "settings.dash.llHlsEnabled";
    private static final String SETTINGS_HLS_ENABLED_VIA_DASH_LOW_LATENCY = "settings.dash.hlsEnabled";
    private static final String SETTINGS_USE_TIMELINE_DASH_MUXING = "settings.dash.useTimeline";
    private static final String SETTINGS_DASH_HTTP_STREAMING = "settings.dash.httpStreaming";
    private static final String SETTINGS_S3_STREAMS_FOLDER_PATH = "settings.s3.streams.folder.path";
    private static final String SETTINGS_S3_PREVIEWS_FOLDER_PATH = "settings.s3.previews.folder.path";
    private static final String SETTINGS_DASH_HTTP_ENDPOINT = "settings.dash.httpEndpoint";
    private static final String SETTINGS_FORCE_DECODING = "settings.forceDecoding";
    public static final String SETTINGS_S3_RECORDING_ENABLED = "settings.s3RecordingEnabled";
    public static final String SETTINGS_S3_ACCESS_KEY = "settings.s3AccessKey";
    public static final String SETTINGS_S3_SECRET_KEY = "settings.s3SecretKey";
    public static final String SETTINGS_S3_REGION_NAME = "settings.s3RegionName";
    public static final String SETTINGS_S3_BUCKET_NAME = "settings.s3BucketName";
    public static final String SETTINGS_S3_ENDPOINT = "settings.s3Endpoint";
    public static final String SETTINGS_ENABLE_TIME_TOKEN_PLAY = "settings.enableTimeTokenForPlay";
    public static final String SETTINGS_ENABLE_TIME_TOKEN_PUBLISH = "settings.enableTimeTokenForPublish";
    public static final String SETTINGS_HLS_ENCRYPTION_KEY_INFO_FILE = "settings.hlsEncryptionKeyInfoFile";
    public static final String SETTINGS_JWKS_URL = "settings.jwksURL";
    public static final String SETTINGS_WEBHOOK_AUTHENTICATE_URL = "settings.webhookAuthenticateURL";
    public static final String SETTINGS_FORCE_ASPECT_RATIO_IN_TRANSCODING = "settings.forceAspectRationInTranscoding";
    @JsonIgnore
    @NotSaved
    private List<NetMask> allowedCIDRList = new ArrayList<NetMask>();
    private Object cidrLock = new Object();
    @Value(value="${settings.remoteAllowedCIDR:127.0.0.1}")
    private String remoteAllowedCIDR;
    @Value(value="${settings.mp4MuxingEnabled:false}")
    private boolean mp4MuxingEnabled;
    @Value(value="${settings.webMMuxingEnabled:false}")
    private boolean webMMuxingEnabled;
    @Value(value="${settings.addDateTimeToMp4FileName:false}")
    private boolean addDateTimeToMp4FileName;
    @Value(value="${settings.hlsMuxingEnabled:true}")
    private boolean hlsMuxingEnabled;
    @Value(value="${settings.encoderSettingsString}")
    private String encoderSettingsString;
    @Value(value="${settings.hlsListSize:#{null}}")
    private String hlsListSize;
    @Value(value="${settings.hlsTime:#{null}}")
    private String hlsTime;
    @Value(value="${settings.dashSegDuration:6}")
    private String dashSegDuration;
    @Value(value="${settings.dashFragmentDuration:0.5}")
    private String dashFragmentDuration;
    @Value(value="${settings.dashTargetLatency:3.5}")
    private String targetLatency;
    @Value(value="${settings.dashWindowSize:5}")
    private String dashWindowSize;
    @Value(value="${settings.dashExtraWindowSize:5}")
    private String dashExtraWindowSize;
    @Value(value="${settings.dash.llEnabled:true}")
    private boolean lLDashEnabled;
    @Value(value="${settings.dash.llHlsEnabled:false}")
    private boolean lLHLSEnabled;
    @Value(value="${settings.dash.hlsEnabled:false}")
    private boolean hlsEnabledViaDash;
    @Value(value="${settings.dash.useTimeline:false}")
    private boolean useTimelineDashMuxing;
    @Value(value="${settings.webRTCEnabled:true}")
    private boolean webRTCEnabled;
    @Value(value="${settings.useOriginalWebRTCEnabled:false}")
    private boolean useOriginalWebRTCEnabled;
    @Value(value="${settings.deleteHLSFilesOnEnded:true}")
    private boolean deleteHLSFilesOnEnded = true;
    @Value(value="${settings.deleteDASHFilesOnEnded:true}")
    private boolean deleteDASHFilesOnEnded = true;
    @Value(value="${tokenHashSecret:''}")
    private String tokenHashSecret;
    @Value(value="${settings.hashControlPublishEnabled:false}")
    private boolean hashControlPublishEnabled;
    @Value(value="${settings.hashControlPlayEnabled:false}")
    private boolean hashControlPlayEnabled;
    @Value(value="${settings.listenerHookURL:}")
    private String listenerHookURL;
    @Value(value="${settings.acceptOnlyStreamsInDataStore:false}")
    private boolean acceptOnlyStreamsInDataStore;
    @Value(value="${settings.acceptOnlyRoomsInDataStore:false}")
    private boolean acceptOnlyRoomsInDataStore;
    @Value(value="#{'${settings.publishTokenControlEnabled:${settings.tokenControlEnabled:false}}'}")
    private boolean publishTokenControlEnabled;
    @Value(value="#{'${settings.playTokenControlEnabled:${settings.tokenControlEnabled:false}}'}")
    private boolean playTokenControlEnabled;
    @Value(value="${settings.timeTokenSubscriberOnly:false}")
    @Deprecated
    private boolean timeTokenSubscriberOnly;
    @Value(value="${settings.enableTimeTokenForPlay:false}")
    private boolean enableTimeTokenForPlay;
    @Value(value="${settings.enableTimeTokenForPublish:false}")
    private boolean enableTimeTokenForPublish;
    @Value(value="${settings.timeTokenPeriod:60}")
    private int timeTokenPeriod;
    @Value(value="${settings.hlsPlayListType:#{null}}")
    private String hlsPlayListType;
    @Value(value="${facebook.clientId}")
    private String facebookClientId;
    @Value(value="${facebook.clientSecret}")
    private String facebookClientSecret;
    @Value(value="${periscope.clientId}")
    private String periscopeClientId;
    @Value(value="${periscope.clientSecret}")
    private String periscopeClientSecret;
    @Value(value="${youtube.clientId}")
    private String youtubeClientId;
    @Value(value="${youtube.clientSecret}")
    private String youtubeClientSecret;
    @Value(value="${settings.vodFolder}")
    private String vodFolder;
    @Value(value="${settings.previewOverwrite:false}")
    private boolean previewOverwrite;
    @Value(value="${settings.stalkerDBServer}")
    private String stalkerDBServer;
    @Value(value="${settings.stalkerDBUsername}")
    private String stalkerDBUsername;
    @Value(value="${settings.stalkerDBPassword}")
    private String stalkerDBPassword;
    @Value(value="${settings.objectDetectionEnabled:false}")
    private boolean objectDetectionEnabled;
    @Value(value="${settings.createPreviewPeriod:5000}")
    private int createPreviewPeriod;
    @Value(value="${settings.streamFetcherRestartPeriod:0}")
    private int restartStreamFetcherPeriod;
    @Value(value="${settings.streamFetcherAutoStart:true}")
    private boolean startStreamFetcherAutomatically;
    private int streamFetcherBufferTime = 0;
    @Value(value="${settings.hlsflags:delete_segments}")
    private String hlsflags;
    private String mySqlClientPath = "/usr/local/antmedia/mysql";
    @Value(value="${settings.muxerFinishScript:}")
    private String muxerFinishScript;
    @Value(value="${settings.webRTCFrameRate:30}")
    private int webRTCFrameRate;
    @Value(value="${settings.webrtc.portRangeMin:0}")
    private int webRTCPortRangeMin;
    @Value(value="${settings.webrtc.portRangeMax:0}")
    private int webRTCPortRangeMax;
    @Value(value="${settings.webrtc.stunServerURI:stun:stun1.l.google.com:19302}")
    private String stunServerURI;
    @Value(value="${settings.webrtc.tcpCandidateEnabled:false}")
    private boolean webRTCTcpCandidatesEnabled;
    @Value(value="${settings.webrtc.sdpSemantics:planB}")
    private String webRTCSdpSemantics;
    @Value(value="${settings.portAllocator.flags:0}")
    private int portAllocatorFlags;
    @Value(value="${settings.collectSocialMediaActivityEnabled:false}")
    private boolean collectSocialMediaActivity;
    @Value(value="${settings.encoding.encoderName:#{null}}")
    private String encoderName;
    @Value(value="${settings.encoding.preset:#{null}}")
    private String encoderPreset;
    @Value(value="${settings.encoding.profile:#{null}}")
    private String encoderProfile;
    @Value(value="${settings.encoding.level:#{null}}")
    private String encoderLevel;
    @Value(value="${settings.encoding.rc:#{null}}")
    private String encoderRc;
    @Value(value="${settings.encoding.specific:#{null}}")
    private String encoderSpecific;
    @Value(value="${settings.encoding.threadCount:0}")
    private int encoderThreadCount;
    @Value(value="${settings.encoding.threadType:0}")
    private int encoderThreadType;
    @Value(value="${settings.encoding.vp8.speed:4}")
    private int vp8EncoderSpeed;
    @Value(value="${settings.encoding.vp8.deadline:realtime}")
    private String vp8EncoderDeadline;
    @Value(value="${settings.encoding.vp8.threadCount:1}")
    private int vp8EncoderThreadCount;
    @Value(value="${settings.previewHeight:480}")
    private int previewHeight;
    @Value(value="${settings.previewGenerate:false}")
    private boolean generatePreview;
    @Value(value="${settings.writeStatsToDatastore:true}")
    private boolean writeStatsToDatastore;
    @Value(value="${settings.encoderSelectionPreference:'gpu_and_cpu'}")
    private String encoderSelectionPreference;
    @Value(value="${settings.allowedPublisherCIDR:#{null}}")
    private String allowedPublisherCIDR;
    @Value(value="${settings.excessiveBandwidth.threshold:300000}")
    private int excessiveBandwidthValue;
    @Value(value="${settings.excessiveBandwidth.call.threshold:3}")
    private int excessiveBandwidthCallThreshold;
    @Value(value="${settings.excessiveBandwith.tryCount.beforeSwitchback:4}")
    private int excessiveBandwithTryCountBeforeSwitchback;
    @Value(value="${settings.excessiveBandwidth_enabled:false}")
    private boolean excessiveBandwidthAlgorithmEnabled;
    @Value(value="${settings.excessiveBandwidth.packetLossDiffThreshold.forSwitchback:10}")
    private int packetLossDiffThresholdForSwitchback;
    @Value(value="${settings.excessiveBandwidth.rttMeasurementDiffThreshold.forSwitchback:20}")
    private int rttMeasurementDiffThresholdForSwitchback;
    @Value(value="${settings.replaceCandidateAddrWithServerAddr:false}")
    private boolean replaceCandidateAddrWithServerAddr;
    @Value(value="${db.app.name}")
    private String appName;
    @Value(value="${settings.encoding.timeout:5000}")
    private int encodingTimeout;
    @Value(value="${settings.webrtc.client.start.timeoutMs:5000}")
    private int webRTCClientStartTimeoutMs;
    @Deprecated
    @Value(value="${settings.defaultDecodersEnabled:false}")
    private boolean defaultDecodersEnabled;
    private long updateTime = 0L;
    private List<EncoderSettings> encoderSettings;
    @Value(value="${settings.httpforwarding.extension:''}")
    private String httpForwardingExtension;
    @Value(value="${settings.httpforwarding.baseURL:''}")
    private String httpForwardingBaseURL;
    @Value(value="${settings.rtmp.maxAnalyzeDurationMS:1500}")
    private int maxAnalyzeDurationMS;
    @Value(value="${settings.disableIPv6Candidates:true}")
    private boolean disableIPv6Candidates;
    @Value(value="${settings.rtspPullTransportType:tcp}")
    private String rtspPullTransportType;
    @Value(value="${settings.maxFpsAccept:0}")
    private int maxFpsAccept;
    @Value(value="${settings.maxResolutionAccept:0}")
    private int maxResolutionAccept;
    @Value(value="${settings.maxBitrateAccept:0}")
    private int maxBitrateAccept;
    @JsonIgnore
    @NotSaved
    private List<NetMask> allowedPublisherCIDRList = new ArrayList<NetMask>();
    @Value(value="${settings.h264Enabled:true}")
    private boolean h264Enabled = true;
    @Value(value="${settings.vp8Enabled:false}")
    private boolean vp8Enabled;
    @Value(value="${settings.h265Enabled:false}")
    private boolean h265Enabled;
    @Value(value="${settings.dataChannelEnabled:false}")
    private boolean dataChannelEnabled;
    @Value(value="${settings.dataChannelPlayerDistrubution:all}")
    private String dataChannelPlayerDistribution;
    @Value(value="${settings.rtmpIngestBufferTimeMs:0}")
    private long rtmpIngestBufferTimeMs;
    @Value(value="${settings.dataChannelWebHook:#{null}}")
    private String dataChannelWebHookURL;
    private String h265EncoderPreset;
    private String h265EncoderProfile;
    private String h265EncoderRc;
    private String h265EncoderSpecific;
    private String h265EncoderLevel;
    @Value(value="${settings.heightRtmpForwarding:360}")
    private int heightRtmpForwarding;
    @Value(value="${settings.audioBitrateSFU:96000}")
    private int audioBitrateSFU;
    @Value(value="${settings.dashMuxingEnabled:false}")
    private boolean dashMuxingEnabled;
    @Value(value="${settings.aacEncodingEnabled:true}")
    private boolean aacEncodingEnabled;
    @Value(value="${settings.gopSize:0}")
    private int gopSize;
    @Value(value="${settings.constantRateFactor:23}")
    private String constantRateFactor;
    @Value(value="${settings.webRTCViewerLimit:-1}")
    private int webRTCViewerLimit = -1;
    private boolean toBeDeleted = false;
    @Value(value="${settings.jwtSecretKey:#{null}}")
    private String jwtSecretKey;
    @Value(value="${settings.jwtControlEnabled:false}")
    private boolean jwtControlEnabled;
    @Value(value="${settings.ipFilterEnabled:true}")
    private boolean ipFilterEnabled;
    @Value(value="${settings.ingestingStreamLimit:-1}")
    private int ingestingStreamLimit;
    @Value(value="${settings.webRTCKeyframeTime:2000}")
    private int webRTCKeyframeTime;
    @Value(value="${settings.jwtStreamSecretKey:#{null}}")
    private String jwtStreamSecretKey;
    @Value(value="${settings.publishJwtControlEnabled:false}")
    private boolean publishJwtControlEnabled;
    @Value(value="${settings.playJwtControlEnabled:false}")
    private boolean playJwtControlEnabled;
    @Value(value="${settings.dash.httpStreaming:true}")
    private boolean dashHttpStreaming;
    @Value(value="${settings.s3.streams.folder.path:streams}")
    private String s3StreamsFolderPath;
    @Value(value="${settings.s3.previews.folder.path:previews}")
    private String s3PreviewsFolderPath;
    @Value(value="${settings.dash.httpEndpoint:#{null}}")
    private String dashHttpEndpoint;
    @Value(value="${settings.forceDecoding:false}")
    private boolean forceDecoding;
    @Value(value="${settings.s3RecordingEnabled:false}")
    private boolean s3RecordingEnabled;
    @Value(value="${settings.s3AccessKey:#{null}}")
    private String s3AccessKey;
    @Value(value="${settings.s3SecretKey:#{null}}")
    private String s3SecretKey;
    @Value(value="${settings.s3BucketName:#{null}}")
    private String s3BucketName;
    @Value(value="${settings.s3RegionName:#{null}}")
    private String s3RegionName;
    @Value(value="${settings.s3Endpoint:#{null}}")
    private String s3Endpoint;
    @Value(value="${settings.hlsEncryptionKeyInfoFile:#{null}}")
    private String hlsEncryptionKeyInfoFile;
    @Value(value="${settings.jwksURL:#{null}}")
    private String jwksURL;
    @Value(value="${settings.forceAspectRationInTranscoding:false}")
    private boolean forceAspectRatioInTranscoding;
    @Value(value="${settings.webhookAuthenticateURL:}")
    private String webhookAuthenticateURL;

    public boolean isWriteStatsToDatastore() {
        return this.writeStatsToDatastore;
    }

    public void setWriteStatsToDatastore(boolean writeStatsToDatastore) {
        this.writeStatsToDatastore = writeStatsToDatastore;
    }

    public boolean isAddDateTimeToMp4FileName() {
        return this.addDateTimeToMp4FileName;
    }

    public void setAddDateTimeToMp4FileName(boolean addDateTimeToMp4FileName) {
        this.addDateTimeToMp4FileName = addDateTimeToMp4FileName;
    }

    public boolean isMp4MuxingEnabled() {
        return this.mp4MuxingEnabled;
    }

    public void setMp4MuxingEnabled(boolean mp4MuxingEnabled) {
        this.mp4MuxingEnabled = mp4MuxingEnabled;
    }

    public boolean isHlsMuxingEnabled() {
        return this.hlsMuxingEnabled;
    }

    public void setHlsMuxingEnabled(boolean hlsMuxingEnabled) {
        this.hlsMuxingEnabled = hlsMuxingEnabled;
    }

    public boolean isDashMuxingEnabled() {
        return this.dashMuxingEnabled;
    }

    public void setDashMuxingEnabled(boolean dashMuxingEnabled) {
        this.dashMuxingEnabled = dashMuxingEnabled;
    }

    public String getHlsPlayListType() {
        return this.hlsPlayListType;
    }

    public void setHlsPlayListType(String hlsPlayListType) {
        this.hlsPlayListType = hlsPlayListType;
    }

    public String getHlsTime() {
        return this.hlsTime;
    }

    public void setHlsTime(String hlsTime) {
        this.hlsTime = hlsTime;
    }

    public String getHlsListSize() {
        return this.hlsListSize;
    }

    public void setHlsListSize(String hlsListSize) {
        this.hlsListSize = hlsListSize;
    }

    public boolean isWebRTCEnabled() {
        return this.webRTCEnabled;
    }

    public void setWebRTCEnabled(boolean webRTCEnabled) {
        this.webRTCEnabled = webRTCEnabled;
    }

    public static String encodersList2Str(List<EncoderSettings> encoderSettingsList) {
        if (encoderSettingsList == null) {
            return "";
        }
        JSONArray jsonArray = new JSONArray();
        for (EncoderSettings encoderSettings : encoderSettingsList) {
            JSONObject encoderJSON = new JSONObject();
            encoderJSON.put((Object)"height", (Object)encoderSettings.getHeight());
            encoderJSON.put((Object)"videoBitrate", (Object)encoderSettings.getVideoBitrate());
            encoderJSON.put((Object)"audioBitrate", (Object)encoderSettings.getAudioBitrate());
            encoderJSON.put((Object)"forceEncode", (Object)encoderSettings.isForceEncode());
            jsonArray.add((Object)encoderJSON);
        }
        return jsonArray.toJSONString();
    }

    public static List<EncoderSettings> encodersStr2List(String encoderSettingsString) {
        ArrayList<EncoderSettings> encoderSettingsList;
        block5: {
            if (encoderSettingsString == null) {
                return null;
            }
            encoderSettingsList = new ArrayList<EncoderSettings>();
            try {
                JSONParser jsonParser = new JSONParser();
                JSONArray jsonArray = (JSONArray)jsonParser.parse(encoderSettingsString);
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JSONObject jsObject = (JSONObject)jsonArray.get(i);
                    int height = Integer.parseInt(jsObject.get((Object)"height").toString());
                    int videoBitrate = Integer.parseInt(jsObject.get((Object)"videoBitrate").toString());
                    int audioBitrate = Integer.parseInt(jsObject.get((Object)"audioBitrate").toString());
                    boolean forceEncode = (Boolean)jsObject.get((Object)"forceEncode");
                    encoderSettingsList.add(new EncoderSettings(height, videoBitrate, audioBitrate, forceEncode));
                }
            }
            catch (ParseException e) {
                String[] values = encoderSettingsString.split(",");
                if (values.length < 3) break block5;
                for (int i = 0; i < values.length; ++i) {
                    int height = Integer.parseInt(values[i]);
                    int videoBitrate = Integer.parseInt(values[++i]);
                    int audioBitrate = Integer.parseInt(values[++i]);
                    encoderSettingsList.add(new EncoderSettings(height, videoBitrate, audioBitrate, true));
                }
            }
        }
        return encoderSettingsList;
    }

    public String getEncoderSettingsString() {
        return this.encoderSettingsString;
    }

    public List<EncoderSettings> getEncoderSettings() {
        return AppSettings.encodersStr2List(this.encoderSettingsString);
    }

    public void setEncoderSettings(List<EncoderSettings> settings) {
        this.encoderSettingsString = AppSettings.encodersList2Str(settings);
        this.encoderSettings = settings;
    }

    public void setEncoderSettingsString(String encoderSettingsString) {
        this.encoderSettingsString = encoderSettingsString;
    }

    public boolean isDeleteHLSFilesOnEnded() {
        return this.deleteHLSFilesOnEnded;
    }

    public void setDeleteHLSFilesOnEnded(boolean deleteHLSFilesOnEnded) {
        this.deleteHLSFilesOnEnded = deleteHLSFilesOnEnded;
    }

    public String getListenerHookURL() {
        return this.listenerHookURL;
    }

    public void setListenerHookURL(String listenerHookURL) {
        this.listenerHookURL = listenerHookURL;
    }

    public boolean isAcceptOnlyStreamsInDataStore() {
        return this.acceptOnlyStreamsInDataStore;
    }

    public void setAcceptOnlyStreamsInDataStore(boolean acceptOnlyStreamsInDataStore) {
        this.acceptOnlyStreamsInDataStore = acceptOnlyStreamsInDataStore;
    }

    public boolean isAcceptOnlyRoomsInDataStore() {
        return this.acceptOnlyRoomsInDataStore;
    }

    public void setAcceptOnlyRoomsInDataStore(boolean acceptOnlyRoomsInDataStore) {
        this.acceptOnlyRoomsInDataStore = acceptOnlyRoomsInDataStore;
    }

    public boolean isObjectDetectionEnabled() {
        return this.objectDetectionEnabled;
    }

    public void setObjectDetectionEnabled(Boolean objectDetectionEnabled) {
        this.objectDetectionEnabled = objectDetectionEnabled;
    }

    public String getYoutubeClientSecret() {
        return this.youtubeClientSecret;
    }

    public void setYoutubeClientSecret(String youtubeClientSecret) {
        this.youtubeClientSecret = youtubeClientSecret;
    }

    public String getYoutubeClientId() {
        return this.youtubeClientId;
    }

    public void setYoutubeClientId(String youtubeClientId) {
        this.youtubeClientId = youtubeClientId;
    }

    public String getPeriscopeClientSecret() {
        return this.periscopeClientSecret;
    }

    public void setPeriscopeClientSecret(String periscopeClientSecret) {
        this.periscopeClientSecret = periscopeClientSecret;
    }

    public String getPeriscopeClientId() {
        return this.periscopeClientId;
    }

    public void setPeriscopeClientId(String periscopeClientId) {
        this.periscopeClientId = periscopeClientId;
    }

    public String getFacebookClientSecret() {
        return this.facebookClientSecret;
    }

    public void setFacebookClientSecret(String facebookClientSecret) {
        this.facebookClientSecret = facebookClientSecret;
    }

    public String getFacebookClientId() {
        return this.facebookClientId;
    }

    public void setFacebookClientId(String facebookClientId) {
        this.facebookClientId = facebookClientId;
    }

    public String getVodFolder() {
        return this.vodFolder;
    }

    public void setVodFolder(String vodFolder) {
        this.vodFolder = vodFolder;
    }

    public int getCreatePreviewPeriod() {
        return this.createPreviewPeriod;
    }

    public void setCreatePreviewPeriod(int period) {
        this.createPreviewPeriod = period;
    }

    public boolean isPreviewOverwrite() {
        return this.previewOverwrite;
    }

    public void setPreviewOverwrite(boolean previewOverwrite) {
        this.previewOverwrite = previewOverwrite;
    }

    public String getStalkerDBServer() {
        return this.stalkerDBServer;
    }

    public void setStalkerDBServer(String stalkerDBServer) {
        this.stalkerDBServer = stalkerDBServer;
    }

    public String getStalkerDBUsername() {
        return this.stalkerDBUsername;
    }

    public void setStalkerDBUsername(String stalkerDBUsername) {
        this.stalkerDBUsername = stalkerDBUsername;
    }

    public String getStalkerDBPassword() {
        return this.stalkerDBPassword;
    }

    public void setStalkerDBPassword(String stalkerDBPassword) {
        this.stalkerDBPassword = stalkerDBPassword;
    }

    public int getRestartStreamFetcherPeriod() {
        return this.restartStreamFetcherPeriod;
    }

    public void setRestartStreamFetcherPeriod(int restartStreamFetcherPeriod) {
        this.restartStreamFetcherPeriod = restartStreamFetcherPeriod;
    }

    public int getStreamFetcherBufferTime() {
        return this.streamFetcherBufferTime;
    }

    public void setStreamFetcherBufferTime(int streamFetcherBufferTime) {
        this.streamFetcherBufferTime = streamFetcherBufferTime;
    }

    public String getHlsFlags() {
        return this.hlsflags;
    }

    public void setHlsflags(String hlsflags) {
        this.hlsflags = hlsflags;
    }

    public String getMySqlClientPath() {
        return this.mySqlClientPath;
    }

    public void setMySqlClientPath(String mySqlClientPath) {
        this.mySqlClientPath = mySqlClientPath;
    }

    public boolean isPublishTokenControlEnabled() {
        return this.publishTokenControlEnabled;
    }

    public void setPublishTokenControlEnabled(boolean publishTokenControlEnabled) {
        this.publishTokenControlEnabled = publishTokenControlEnabled;
    }

    public boolean isPlayTokenControlEnabled() {
        return this.playTokenControlEnabled;
    }

    public void setPlayTokenControlEnabled(boolean playTokenControlEnabled) {
        this.playTokenControlEnabled = playTokenControlEnabled;
    }

    @Deprecated
    public boolean isTimeTokenSubscriberOnly() {
        return this.timeTokenSubscriberOnly;
    }

    @Deprecated
    public void setTimeTokenSubscriberOnly(boolean timeTokenSubscriberOnly) {
        this.timeTokenSubscriberOnly = timeTokenSubscriberOnly;
    }

    public boolean isEnableTimeTokenForPlay() {
        return this.enableTimeTokenForPlay;
    }

    public void setEnableTimeTokenForPlay(boolean enableTimeTokenForPlay) {
        this.enableTimeTokenForPlay = enableTimeTokenForPlay;
    }

    public boolean isEnableTimeTokenForPublish() {
        return this.enableTimeTokenForPublish;
    }

    public void setEnableTimeTokenForPublish(boolean enableTimeTokenForPublish) {
        this.enableTimeTokenForPublish = enableTimeTokenForPublish;
    }

    public String getMuxerFinishScript() {
        return this.muxerFinishScript;
    }

    public void setMuxerFinishScript(String muxerFinishScript) {
        this.muxerFinishScript = muxerFinishScript;
    }

    public int getWebRTCFrameRate() {
        return this.webRTCFrameRate;
    }

    public void setWebRTCFrameRate(int webRTCFrameRate) {
        this.webRTCFrameRate = webRTCFrameRate;
    }

    public boolean isCollectSocialMediaActivity() {
        return this.collectSocialMediaActivity;
    }

    public void setCollectSocialMediaActivity(boolean collectSocialMediaActivity) {
        this.collectSocialMediaActivity = collectSocialMediaActivity;
    }

    public String getTokenHashSecret() {
        return this.tokenHashSecret;
    }

    public void setTokenHashSecret(String tokenHashSecret) {
        this.tokenHashSecret = tokenHashSecret;
    }

    public boolean isHashControlPlayEnabled() {
        return this.hashControlPlayEnabled;
    }

    public void setHashControlPlayEnabled(boolean hashControlPlayEnabled) {
        this.hashControlPlayEnabled = hashControlPlayEnabled;
    }

    public boolean isHashControlPublishEnabled() {
        return this.hashControlPublishEnabled;
    }

    public void setHashControlPublishEnabled(boolean hashControlPublishEnabled) {
        this.hashControlPublishEnabled = hashControlPublishEnabled;
    }

    public void resetDefaults() {
        this.mp4MuxingEnabled = false;
        this.addDateTimeToMp4FileName = false;
        this.hlsMuxingEnabled = true;
        this.hlsListSize = null;
        this.hlsTime = null;
        this.webRTCEnabled = false;
        this.deleteHLSFilesOnEnded = true;
        this.deleteDASHFilesOnEnded = true;
        this.acceptOnlyStreamsInDataStore = false;
        this.publishTokenControlEnabled = false;
        this.playTokenControlEnabled = false;
        this.timeTokenSubscriberOnly = false;
        this.enableTimeTokenForPlay = false;
        this.enableTimeTokenForPublish = false;
        this.hlsPlayListType = null;
        this.previewOverwrite = false;
        this.objectDetectionEnabled = false;
        this.createPreviewPeriod = 5000;
        this.restartStreamFetcherPeriod = 0;
        this.webRTCFrameRate = 20;
        this.hashControlPlayEnabled = false;
        this.hashControlPublishEnabled = false;
        this.tokenHashSecret = "";
        this.encoderSettingsString = "";
        this.remoteAllowedCIDR = "127.0.0.1";
        this.aacEncodingEnabled = true;
        this.ipFilterEnabled = true;
        this.ingestingStreamLimit = -1;
    }

    public int getWebRTCPortRangeMax() {
        return this.webRTCPortRangeMax;
    }

    public void setWebRTCPortRangeMax(int webRTCPortRangeMax) {
        this.webRTCPortRangeMax = webRTCPortRangeMax;
    }

    public int getWebRTCPortRangeMin() {
        return this.webRTCPortRangeMin;
    }

    public void setWebRTCPortRangeMin(int webRTCPortRangeMin) {
        this.webRTCPortRangeMin = webRTCPortRangeMin;
    }

    public String getStunServerURI() {
        return this.stunServerURI;
    }

    public void setStunServerURI(String stunServerURI) {
        this.stunServerURI = stunServerURI;
    }

    public boolean isWebRTCTcpCandidatesEnabled() {
        return this.webRTCTcpCandidatesEnabled;
    }

    public void setWebRTCTcpCandidatesEnabled(boolean webRTCTcpCandidatesEnabled) {
        this.webRTCTcpCandidatesEnabled = webRTCTcpCandidatesEnabled;
    }

    public String getEncoderName() {
        return this.encoderName;
    }

    public void setEncoderName(String encoderName) {
        this.encoderName = encoderName;
    }

    public String getEncoderPreset() {
        return this.encoderPreset;
    }

    public void setEncoderPreset(String encoderPreset) {
        this.encoderPreset = encoderPreset;
    }

    public String getEncoderProfile() {
        return this.encoderProfile;
    }

    public void setEncoderProfile(String encoderProfile) {
        this.encoderProfile = encoderProfile;
    }

    public String getEncoderLevel() {
        return this.encoderLevel;
    }

    public void setEncoderLevel(String encoderLevel) {
        this.encoderLevel = encoderLevel;
    }

    public String getEncoderRc() {
        return this.encoderRc;
    }

    public void setEncoderRc(String encoderRc) {
        this.encoderRc = encoderRc;
    }

    public String getEncoderSpecific() {
        return this.encoderSpecific;
    }

    public void setEncoderSpecific(String encoderSpecific) {
        this.encoderSpecific = encoderSpecific;
    }

    public int getPreviewHeight() {
        return this.previewHeight;
    }

    public void setPreviewHeight(int previewHeight) {
        this.previewHeight = previewHeight;
    }

    public boolean isUseOriginalWebRTCEnabled() {
        return this.useOriginalWebRTCEnabled;
    }

    public void setUseOriginalWebRTCEnabled(boolean useOriginalWebRTCEnabled) {
        this.useOriginalWebRTCEnabled = useOriginalWebRTCEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRemoteAllowedCIDR() {
        Object object = this.cidrLock;
        synchronized (object) {
            return this.remoteAllowedCIDR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRemoteAllowedCIDR(String remoteAllowedCIDR) {
        Object object = this.cidrLock;
        synchronized (object) {
            this.remoteAllowedCIDR = remoteAllowedCIDR;
            this.allowedCIDRList = new ArrayList<NetMask>();
            this.fillFromInput(remoteAllowedCIDR, this.allowedCIDRList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<NetMask> getAllowedCIDRList() {
        Object object = this.cidrLock;
        synchronized (object) {
            if (this.allowedCIDRList.isEmpty()) {
                this.fillFromInput(this.remoteAllowedCIDR, this.allowedCIDRList);
            }
            return this.allowedCIDRList;
        }
    }

    public String getAllowedPublisherCIDR() {
        return this.allowedPublisherCIDR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAllowedPublisherCIDR(String allowedPublisherCIDR) {
        Object object = this.cidrLock;
        synchronized (object) {
            this.allowedPublisherCIDR = allowedPublisherCIDR;
            this.allowedPublisherCIDRList = new ArrayList<NetMask>();
            this.fillFromInput(allowedPublisherCIDR, this.allowedPublisherCIDRList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<NetMask> getAllowedPublisherCIDRList() {
        Object object = this.cidrLock;
        synchronized (object) {
            if (this.allowedPublisherCIDRList.isEmpty()) {
                this.fillFromInput(this.allowedPublisherCIDR, this.allowedPublisherCIDRList);
            }
        }
        return this.allowedPublisherCIDRList;
    }

    private List<String> fillFromInput(String input, List<NetMask> target) {
        target.clear();
        if (input == null || input.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<CallSite> messages = new LinkedList<CallSite>();
        for (String s : input.split("\\s*,\\s*")) {
            try {
                NetMask nm = new NetMask(s);
                target.add(nm);
            }
            catch (IllegalArgumentException e) {
                messages.add((CallSite)((Object)(s + ": " + e.getMessage())));
            }
        }
        return Collections.unmodifiableList(messages);
    }

    public String getEncoderSelectionPreference() {
        return this.encoderSelectionPreference;
    }

    public void setEncoderSelectionPreference(String encoderSelectionPreference) {
        this.encoderSelectionPreference = encoderSelectionPreference;
    }

    public int getExcessiveBandwidthCallThreshold() {
        return this.excessiveBandwidthCallThreshold;
    }

    public void setExcessiveBandwidthCallThreshold(int excessiveBandwidthCallThreshold) {
        this.excessiveBandwidthCallThreshold = excessiveBandwidthCallThreshold;
    }

    public int getExcessiveBandwidthValue() {
        return this.excessiveBandwidthValue;
    }

    public void setExcessiveBandwidthValue(int excessiveBandwidthValue) {
        this.excessiveBandwidthValue = excessiveBandwidthValue;
    }

    public int getPortAllocatorFlags() {
        return this.portAllocatorFlags;
    }

    public void setPortAllocatorFlags(int flags) {
        this.portAllocatorFlags = flags;
    }

    public int getExcessiveBandwithTryCountBeforeSwitchback() {
        return this.excessiveBandwithTryCountBeforeSwitchback;
    }

    public boolean isExcessiveBandwidthAlgorithmEnabled() {
        return this.excessiveBandwidthAlgorithmEnabled;
    }

    public int getPacketLossDiffThresholdForSwitchback() {
        return this.packetLossDiffThresholdForSwitchback;
    }

    public int getRttMeasurementDiffThresholdForSwitchback() {
        return this.rttMeasurementDiffThresholdForSwitchback;
    }

    public void setExcessiveBandwithTryCountBeforeSwitchback(int excessiveBandwithTryCountBeforeSwitchback) {
        this.excessiveBandwithTryCountBeforeSwitchback = excessiveBandwithTryCountBeforeSwitchback;
    }

    public void setExcessiveBandwidthAlgorithmEnabled(boolean excessiveBandwidthAlgorithmEnabled) {
        this.excessiveBandwidthAlgorithmEnabled = excessiveBandwidthAlgorithmEnabled;
    }

    public void setPacketLossDiffThresholdForSwitchback(int packetLossDiffThresholdForSwitchback) {
        this.packetLossDiffThresholdForSwitchback = packetLossDiffThresholdForSwitchback;
    }

    public void setRttMeasurementDiffThresholdForSwitchback(int rttMeasurementDiffThresholdForSwitchback) {
        this.rttMeasurementDiffThresholdForSwitchback = rttMeasurementDiffThresholdForSwitchback;
    }

    public boolean isReplaceCandidateAddrWithServerAddr() {
        return this.replaceCandidateAddrWithServerAddr;
    }

    public void setReplaceCandidateAddrWithServerAddr(boolean replaceCandidateAddrWithServerAddr) {
        this.replaceCandidateAddrWithServerAddr = replaceCandidateAddrWithServerAddr;
    }

    public long getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(long updateTime) {
        this.updateTime = updateTime;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getAppName() {
        return this.appName;
    }

    public int getEncodingTimeout() {
        return this.encodingTimeout;
    }

    public void setEncodingTimeout(int encodingTimeout) {
        this.encodingTimeout = encodingTimeout;
    }

    public boolean isDefaultDecodersEnabled() {
        return this.defaultDecodersEnabled;
    }

    public void setDefaultDecodersEnabled(boolean defaultDecodersEnabled) {
        this.defaultDecodersEnabled = defaultDecodersEnabled;
    }

    public String getHttpForwardingExtension() {
        return this.httpForwardingExtension;
    }

    public void setHttpForwardingExtension(String httpForwardingExtension) {
        this.httpForwardingExtension = httpForwardingExtension;
    }

    public String getHttpForwardingBaseURL() {
        return this.httpForwardingBaseURL;
    }

    public void setHttpForwardingBaseURL(String httpForwardingBaseURL) {
        this.httpForwardingBaseURL = httpForwardingBaseURL;
    }

    public int getMaxAnalyzeDurationMS() {
        return this.maxAnalyzeDurationMS;
    }

    public void setMaxAnalyzeDurationMS(int maxAnalyzeDurationMS) {
        this.maxAnalyzeDurationMS = maxAnalyzeDurationMS;
    }

    public boolean isGeneratePreview() {
        return this.generatePreview;
    }

    public void setGeneratePreview(boolean generatePreview) {
        this.generatePreview = generatePreview;
    }

    public boolean isDisableIPv6Candidates() {
        return this.disableIPv6Candidates;
    }

    public void setDisableIPv6Candidates(boolean disableIPv6Candidates) {
        this.disableIPv6Candidates = disableIPv6Candidates;
    }

    public String getRtspPullTransportType() {
        return this.rtspPullTransportType;
    }

    public void setRtspPullTransportType(String rtspPullTransportType) {
        this.rtspPullTransportType = rtspPullTransportType;
    }

    public int getMaxResolutionAccept() {
        return this.maxResolutionAccept;
    }

    public void setMaxResolutionAccept(int maxResolutionAccept) {
        this.maxResolutionAccept = maxResolutionAccept;
    }

    public boolean isH264Enabled() {
        return this.h264Enabled;
    }

    public void setH264Enabled(boolean h264Enabled) {
        this.h264Enabled = h264Enabled;
    }

    public boolean isVp8Enabled() {
        return this.vp8Enabled;
    }

    public void setVp8Enabled(boolean vp8Enabled) {
        this.vp8Enabled = vp8Enabled;
    }

    public boolean isH265Enabled() {
        return this.h265Enabled;
    }

    public void setH265Enabled(boolean h265Enabled) {
        this.h265Enabled = h265Enabled;
    }

    public boolean isDataChannelEnabled() {
        return this.dataChannelEnabled;
    }

    public void setDataChannelEnabled(boolean dataChannelEnabled) {
        this.dataChannelEnabled = dataChannelEnabled;
    }

    public String getDataChannelPlayerDistribution() {
        return this.dataChannelPlayerDistribution;
    }

    public void setDataChannelPlayerDistribution(String dataChannelPlayerDistribution) {
        this.dataChannelPlayerDistribution = dataChannelPlayerDistribution;
    }

    public long getRtmpIngestBufferTimeMs() {
        return this.rtmpIngestBufferTimeMs;
    }

    public void setRtmpIngestBufferTimeMs(long rtmpIngestBufferTimeMs) {
        this.rtmpIngestBufferTimeMs = rtmpIngestBufferTimeMs;
    }

    public String getDataChannelWebHook() {
        return this.dataChannelWebHookURL;
    }

    public void setDataChannelWebHookURL(String dataChannelWebHookURL) {
        this.dataChannelWebHookURL = dataChannelWebHookURL;
    }

    public int getEncoderThreadCount() {
        return this.encoderThreadCount;
    }

    public void setEncoderThreadCount(int encoderThreadCount) {
        this.encoderThreadCount = encoderThreadCount;
    }

    public int getEncoderThreadType() {
        return this.encoderThreadType;
    }

    public void setEncoderThreadType(int encoderThreadType) {
        this.encoderThreadType = encoderThreadType;
    }

    public int getWebRTCClientStartTimeoutMs() {
        return this.webRTCClientStartTimeoutMs;
    }

    public void setWebRTCClientStartTimeoutMs(int webRTCClientStartTimeout) {
        this.webRTCClientStartTimeoutMs = webRTCClientStartTimeout;
    }

    public String getH265EncoderProfile() {
        return this.h265EncoderProfile;
    }

    public String getH265EncoderPreset() {
        return this.h265EncoderPreset;
    }

    public String getH265EncoderLevel() {
        return this.h265EncoderLevel;
    }

    public String getH265EncoderSpecific() {
        return this.h265EncoderSpecific;
    }

    public String getH265EncoderRc() {
        return this.h265EncoderRc;
    }

    public void setH265EncoderLevel(String encoderLevel) {
        this.h265EncoderLevel = encoderLevel;
    }

    public void setH265EncoderPreset(String preset) {
        this.h265EncoderPreset = preset;
    }

    public void setH265EncoderProfile(String profile) {
        this.h265EncoderProfile = profile;
    }

    public void setH265EncoderRc(String encoderRc) {
        this.h265EncoderRc = encoderRc;
    }

    public void setH265EncoderSpecific(String encoderSpecific) {
        this.h265EncoderSpecific = encoderSpecific;
    }

    public boolean isWebMMuxingEnabled() {
        return this.webMMuxingEnabled;
    }

    public void setWebMMuxingEnabled(boolean webMMuxingEnabled) {
        this.webMMuxingEnabled = webMMuxingEnabled;
    }

    public int getVp8EncoderSpeed() {
        return this.vp8EncoderSpeed;
    }

    public void setVp8EncoderSpeed(int vp8EncoderSpeed) {
        this.vp8EncoderSpeed = vp8EncoderSpeed;
    }

    public String getVp8EncoderDeadline() {
        return this.vp8EncoderDeadline;
    }

    public void setVp8EncoderDeadline(String vp8EncoderDeadline) {
        this.vp8EncoderDeadline = vp8EncoderDeadline;
    }

    public int getVp8EncoderThreadCount() {
        return this.vp8EncoderThreadCount;
    }

    public void setVp8EncoderThreadCount(int vp8EncoderThreadCount) {
        this.vp8EncoderThreadCount = vp8EncoderThreadCount;
    }

    public String getWebRTCSdpSemantics() {
        return this.webRTCSdpSemantics;
    }

    public void setWebRTCSdpSemantics(String webRTCSdpSemantics) {
        this.webRTCSdpSemantics = webRTCSdpSemantics;
    }

    public boolean isStartStreamFetcherAutomatically() {
        return this.startStreamFetcherAutomatically;
    }

    public void setStartStreamFetcherAutomatically(boolean startStreamFetcherAutomatically) {
        this.startStreamFetcherAutomatically = startStreamFetcherAutomatically;
    }

    public boolean isDeleteDASHFilesOnEnded() {
        return this.deleteDASHFilesOnEnded;
    }

    public void setDeleteDASHFilesOnEnded(boolean deleteDASHFilesOnEnded) {
        this.deleteDASHFilesOnEnded = deleteDASHFilesOnEnded;
    }

    public String getTargetLatency() {
        return this.targetLatency;
    }

    public void setTargetLatency(String targetLatency) {
        this.targetLatency = targetLatency;
    }

    public int getHeightRtmpForwarding() {
        return this.heightRtmpForwarding;
    }

    public void setHeightRtmpForwarding(int heightRtmpForwarding) {
        this.heightRtmpForwarding = heightRtmpForwarding;
    }

    public int getAudioBitrateSFU() {
        return this.audioBitrateSFU;
    }

    public void setAudioBitrateSFU(int audioBitrateSFU) {
        this.audioBitrateSFU = audioBitrateSFU;
    }

    public void setAacEncodingEnabled(boolean aacEncodingEnabled) {
        this.aacEncodingEnabled = aacEncodingEnabled;
    }

    public boolean isAacEncodingEnabled() {
        return this.aacEncodingEnabled;
    }

    public int getGopSize() {
        return this.gopSize;
    }

    public void setGopSize(int gopSize) {
        this.gopSize = gopSize;
    }

    public String getConstantRateFactor() {
        return this.constantRateFactor;
    }

    public void setConstantRateFactor(String constantRateFactor) {
        this.constantRateFactor = constantRateFactor;
    }

    public int getWebRTCViewerLimit() {
        return this.webRTCViewerLimit;
    }

    public void setWebRTCViewerLimit(int webRTCViewerLimit) {
        this.webRTCViewerLimit = webRTCViewerLimit;
    }

    public String getDashFragmentDuration() {
        return this.dashFragmentDuration;
    }

    public void setDashFragmentDuration(String dashFragmentDuration) {
        this.dashFragmentDuration = dashFragmentDuration;
    }

    public String getDashSegDuration() {
        return this.dashSegDuration;
    }

    public void setDashSegDuration(String dashSegDuration) {
        this.dashSegDuration = dashSegDuration;
    }

    public String getDashWindowSize() {
        return this.dashWindowSize;
    }

    public void setDashWindowSize(String dashWindowSize) {
        this.dashWindowSize = dashWindowSize;
    }

    public String getDashExtraWindowSize() {
        return this.dashExtraWindowSize;
    }

    public void setDashExtraWindowSize(String dashExtraWindowSize) {
        this.dashExtraWindowSize = dashExtraWindowSize;
    }

    public String getJwtSecretKey() {
        return this.jwtSecretKey;
    }

    public void setJwtSecretKey(String jwtSecretKey) {
        this.jwtSecretKey = jwtSecretKey;
    }

    public boolean isJwtControlEnabled() {
        return this.jwtControlEnabled;
    }

    public void setJwtControlEnabled(boolean jwtControlEnabled) {
        this.jwtControlEnabled = jwtControlEnabled;
    }

    public boolean isIpFilterEnabled() {
        return this.ipFilterEnabled;
    }

    public void setIpFilterEnabled(boolean ipFilterEnabled) {
        this.ipFilterEnabled = ipFilterEnabled;
    }

    public int getIngestingStreamLimit() {
        return this.ingestingStreamLimit;
    }

    public void setIngestingStreamLimit(int ingestingStreamLimit) {
        this.ingestingStreamLimit = ingestingStreamLimit;
    }

    public int getTimeTokenPeriod() {
        return this.timeTokenPeriod;
    }

    public void setTimeTokenPeriod(int timeTokenPeriod) {
        this.timeTokenPeriod = timeTokenPeriod;
    }

    public boolean isToBeDeleted() {
        return this.toBeDeleted;
    }

    public void setToBeDeleted(boolean toBeDeleted) {
        this.toBeDeleted = toBeDeleted;
    }

    public int getWebRTCKeyframeTime() {
        return this.webRTCKeyframeTime;
    }

    public void setWebRTCKeyframeTime(int webRTCKeyframeTime) {
        this.webRTCKeyframeTime = webRTCKeyframeTime;
    }

    public String getJwtStreamSecretKey() {
        return this.jwtStreamSecretKey;
    }

    public void setJwtStreamSecretKey(String jwtStreamSecretKey) {
        this.jwtStreamSecretKey = jwtStreamSecretKey;
    }

    public boolean isPublishJwtControlEnabled() {
        return this.publishJwtControlEnabled;
    }

    public void setPublishJwtControlEnabled(boolean publishJwtControlEnabled) {
        this.publishJwtControlEnabled = publishJwtControlEnabled;
    }

    public boolean isPlayJwtControlEnabled() {
        return this.playJwtControlEnabled;
    }

    public void setPlayJwtControlEnabled(boolean playJwtControlEnabled) {
        this.playJwtControlEnabled = playJwtControlEnabled;
    }

    public boolean islLDashEnabled() {
        return this.lLDashEnabled;
    }

    public void setlLDashEnabled(boolean lLDashEnabled) {
        this.lLDashEnabled = lLDashEnabled;
    }

    public boolean islLHLSEnabled() {
        return this.lLHLSEnabled;
    }

    public void setlLHLSEnabled(boolean lLHLSEnabled) {
        this.lLHLSEnabled = lLHLSEnabled;
    }

    public boolean isHlsEnabledViaDash() {
        return this.hlsEnabledViaDash;
    }

    public void setHlsEnabledViaDash(boolean hlsEnabledViaDash) {
        this.hlsEnabledViaDash = hlsEnabledViaDash;
    }

    public boolean isUseTimelineDashMuxing() {
        return this.useTimelineDashMuxing;
    }

    public void setUseTimelineDashMuxing(boolean useTimelineDashMuxing) {
        this.useTimelineDashMuxing = useTimelineDashMuxing;
    }

    public boolean isDashHttpStreaming() {
        return this.dashHttpStreaming;
    }

    public void setDashHttpStreaming(boolean dashHttpStreaming) {
        this.dashHttpStreaming = dashHttpStreaming;
    }

    public String getS3StreamsFolderPath() {
        return this.s3StreamsFolderPath;
    }

    public String getDashHttpEndpoint() {
        return this.dashHttpEndpoint;
    }

    public boolean isS3RecordingEnabled() {
        return this.s3RecordingEnabled;
    }

    public void setS3RecordingEnabled(boolean s3RecordingEnabled) {
        this.s3RecordingEnabled = s3RecordingEnabled;
    }

    public String getS3SecretKey() {
        return this.s3SecretKey;
    }

    public void setS3SecretKey(String s3SecretKey) {
        this.s3SecretKey = s3SecretKey;
    }

    public String getS3AccessKey() {
        return this.s3AccessKey;
    }

    public void setS3AccessKey(String s3AccessKey) {
        this.s3AccessKey = s3AccessKey;
    }

    public String getS3RegionName() {
        return this.s3RegionName;
    }

    public void setS3RegionName(String s3RegionName) {
        this.s3RegionName = s3RegionName;
    }

    public String getS3BucketName() {
        return this.s3BucketName;
    }

    public void setS3BucketName(String s3BucketName) {
        this.s3BucketName = s3BucketName;
    }

    public String getS3Endpoint() {
        return this.s3Endpoint;
    }

    public void setS3Endpoint(String s3Endpoint) {
        this.s3Endpoint = s3Endpoint;
    }

    public void setDashHttpEndpoint(String dashHttpEndpoint) {
        this.dashHttpEndpoint = dashHttpEndpoint;
    }

    public String getHlsEncryptionKeyInfoFile() {
        return this.hlsEncryptionKeyInfoFile;
    }

    public void setHlsEncryptionKeyInfoFile(String hlsEncryptionKeyInfoFile) {
        this.hlsEncryptionKeyInfoFile = hlsEncryptionKeyInfoFile;
    }

    public void setS3StreamsFolderPath(String s3StreamsFolderPath) {
        this.s3StreamsFolderPath = s3StreamsFolderPath;
    }

    public String getS3PreviewsFolderPath() {
        return this.s3PreviewsFolderPath;
    }

    public void setS3PreviewsFolderPath(String s3PreviewsFolderPath) {
        this.s3PreviewsFolderPath = s3PreviewsFolderPath;
    }

    public boolean isForceDecoding() {
        return this.forceDecoding;
    }

    public void setForceDecoding(boolean forceDecoding) {
        this.forceDecoding = forceDecoding;
    }

    public String getJwksURL() {
        return this.jwksURL;
    }

    public void setJwksURL(String jwksURL) {
        this.jwksURL = jwksURL;
    }

    public String getWebhookAuthenticateURL() {
        return this.webhookAuthenticateURL;
    }

    public void setWebhookAuthenticateURL(String webhookAuthenticateURL) {
        this.webhookAuthenticateURL = webhookAuthenticateURL;
    }

    public boolean isForceAspectRatioInTranscoding() {
        return this.forceAspectRatioInTranscoding;
    }

    public void setForceAspectRatioInTranscoding(boolean forceAspectRatioInTranscoding) {
        this.forceAspectRatioInTranscoding = forceAspectRatioInTranscoding;
    }
}

