/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.console;

import io.antmedia.AntMediaApplicationAdapter;
import io.antmedia.IApplicationAdaptorFactory;
import io.antmedia.cluster.IClusterNotifier;
import io.antmedia.console.datastore.ConsoleDataStoreFactory;
import io.antmedia.datastore.db.DataStore;
import io.antmedia.settings.ServerSettings;
import io.vertx.core.Vertx;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.red5.server.adapter.MultiThreadedApplicationAdapter;
import org.red5.server.api.IConnection;
import org.red5.server.api.IContext;
import org.red5.server.api.scope.IBroadcastScope;
import org.red5.server.api.scope.IGlobalScope;
import org.red5.server.api.scope.IScope;
import org.red5.server.api.scope.ScopeType;
import org.red5.server.scope.WebScope;
import org.red5.server.tomcat.WarDeployer;
import org.red5.server.util.ScopeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class AdminApplication
extends MultiThreadedApplicationAdapter {
    private static final Logger log = LoggerFactory.getLogger(AdminApplication.class);
    public static final String APP_NAME = "ConsoleApp";
    private ConsoleDataStoreFactory dataStoreFactory;
    private IScope rootScope;
    private ServerSettings serverSettings;
    private Vertx vertx;
    private WarDeployer warDeployer;
    private boolean isCluster = false;

    @Override
    public boolean appStart(IScope app) {
        this.isCluster = app.getContext().hasBean("tomcat.cluster");
        this.vertx = (Vertx)this.scope.getContext().getBean("vertxCore");
        this.warDeployer = (WarDeployer)app.getContext().getBean("warDeployer");
        if (this.isCluster) {
            IClusterNotifier clusterNotifier = (IClusterNotifier)app.getContext().getBean("tomcat.cluster");
            clusterNotifier.registerCreateAppListener(appName -> {
                log.info("Creating application with name {}", (Object)appName);
                return this.createApplication(appName);
            });
            clusterNotifier.registerDeleteAppListener(appName -> {
                log.info("Deleting application with name {}", (Object)appName);
                return this.deleteApplication(appName);
            });
        }
        return super.appStart(app);
    }

    @Override
    public boolean connect(IConnection conn, IScope scope, Object[] params) {
        this.scope = scope;
        return false;
    }

    @Override
    public void disconnect(IConnection conn, IScope scope) {
        super.disconnect(conn, scope);
    }

    public IScope getRootScope() {
        if (this.rootScope == null) {
            this.rootScope = ScopeUtils.findRoot(this.scope);
        }
        return this.rootScope;
    }

    public int getTotalLiveStreamSize() {
        List<String> appNames = this.getApplications();
        int size = 0;
        for (String name : appNames) {
            IScope scope = this.getRootScope().getScope(name);
            size += this.getAppLiveStreamCount(scope);
        }
        return size;
    }

    public List<ApplicationInfo> getApplicationInfo() {
        List<String> appNames = this.getApplications();
        ArrayList<ApplicationInfo> appsInfo = new ArrayList<ApplicationInfo>();
        for (String name : appNames) {
            if (name.equals(APP_NAME)) continue;
            ApplicationInfo info = new ApplicationInfo();
            info.name = name;
            info.liveStreamCount = this.getAppLiveStreamCount(this.getRootScope().getScope(name));
            info.vodCount = this.getVoDCount(this.getRootScope().getScope(name));
            info.storage = this.getStorage(name);
            appsInfo.add(info);
        }
        return appsInfo;
    }

    public AntMediaApplicationAdapter getApplicationAdaptor(IScope appScope) {
        return ((IApplicationAdaptorFactory)appScope.getContext().getApplicationContext().getBean("web.handler")).getAppAdaptor();
    }

    private long getStorage(String name) {
        File appFolder = new File("webapps/" + name);
        return FileUtils.sizeOfDirectory((File)appFolder);
    }

    private int getVoDCount(IScope appScope) {
        DataStore dataStore;
        AntMediaApplicationAdapter adapter;
        int size = 0;
        if (appScope != null && (adapter = ((IApplicationAdaptorFactory)appScope.getContext().getApplicationContext().getBean("web.handler")).getAppAdaptor()) instanceof AntMediaApplicationAdapter && (dataStore = adapter.getDataStore()) != null) {
            size = (int)dataStore.getTotalVodNumber();
        }
        return size;
    }

    public List<BroadcastInfo> getAppLiveStreams(String name) {
        IScope root = this.getRootScope();
        IScope appScope = root.getScope(name);
        ArrayList<BroadcastInfo> broadcastInfoList = new ArrayList<BroadcastInfo>();
        Set<String> basicScopeNames = appScope.getBasicScopeNames(ScopeType.BROADCAST);
        for (String scopeName : basicScopeNames) {
            IBroadcastScope broadcastScope = appScope.getBroadcastScope(scopeName);
            BroadcastInfo info = new BroadcastInfo(broadcastScope.getName(), broadcastScope.getConsumers().size());
            broadcastInfoList.add(info);
        }
        return broadcastInfoList;
    }

    public boolean deleteVoDStream(String appname, String streamName) {
        File vodStream = new File("webapps/" + appname + "/streams/" + streamName);
        boolean result = false;
        if (vodStream.exists()) {
            try {
                Files.delete(vodStream.toPath());
                result = true;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public List<String> getApplications() {
        IScope root = this.getRootScope();
        Set<String> names = root.getScopeNames();
        ArrayList<String> apps = new ArrayList<String>();
        for (String name : names) {
            if (name.equals("root")) continue;
            apps.add(name);
        }
        Collections.sort(apps);
        return apps;
    }

    public int getTotalConnectionSize() {
        IScope root = this.getRootScope();
        return root.getStatistics().getActiveClients();
    }

    public ApplicationContext getApplicationContext(String scopeName) {
        IContext context;
        IScope scope = this.getScope(scopeName);
        if (scope != null && (context = scope.getContext()) != null) {
            return context.getApplicationContext();
        }
        log.warn("Application:{} is not initilized", (Object)scopeName);
        return null;
    }

    private IScope getScope(String scopeName) {
        IGlobalScope root = (IGlobalScope)ScopeUtils.findRoot(this.scope);
        return this.getScopes(root, scopeName);
    }

    private IScope getScopes(IGlobalScope root, String scopeName) {
        if (root.getName().equals(scopeName)) {
            return root;
        }
        if (root instanceof IScope) {
            try {
                IScope scope = root.getScope(scopeName);
                if (scope != null) {
                    return scope;
                }
            }
            catch (NullPointerException npe) {
                log.debug(npe.toString());
            }
        }
        return null;
    }

    public ConsoleDataStoreFactory getDataStoreFactory() {
        return this.dataStoreFactory;
    }

    public void setDataStoreFactory(ConsoleDataStoreFactory dataStoreFactory) {
        this.dataStoreFactory = dataStoreFactory;
    }

    public int getAppLiveStreamCount(IScope appScope) {
        DataStore dataStore;
        AntMediaApplicationAdapter adapter;
        int size = 0;
        if (appScope != null && (adapter = ((IApplicationAdaptorFactory)appScope.getContext().getApplicationContext().getBean("web.handler")).getAppAdaptor()) instanceof AntMediaApplicationAdapter && (dataStore = adapter.getDataStore()) != null) {
            size = (int)dataStore.getActiveBroadcastCount();
        }
        return size;
    }

    public boolean createApplication(String appName) {
        boolean success = false;
        if (this.isCluster) {
            boolean result;
            String mongoHost = this.getDataStoreFactory().getDbHost();
            String mongoUser = this.getDataStoreFactory().getDbUser();
            String mongoPass = this.getDataStoreFactory().getDbPassword();
            success = result = this.runCreateAppScript(appName, true, mongoHost, mongoUser, mongoPass);
        } else {
            boolean result;
            success = result = this.runCreateAppScript(appName);
        }
        this.vertx.setTimer(3000L, i -> this.warDeployer.deploy(true));
        return success;
    }

    public boolean deleteApplication(String appName) {
        WebScope appScope = (WebScope)this.getRootScope().getScope(appName);
        this.getApplicationAdaptor(appScope).serverShuttingdown();
        boolean success = this.runDeleteAppScript(appName);
        this.warDeployer.undeploy(appName);
        try {
            appScope.destroy();
        }
        catch (Exception e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            success = false;
        }
        return success;
    }

    public boolean runCreateAppScript(String appName) {
        return this.runCreateAppScript(appName, false, null, null, null);
    }

    public boolean runCreateAppScript(String appName, boolean isCluster, String mongoHost, String mongoUser, String mongoPass) {
        Path currentRelativePath = Paths.get("", new String[0]);
        String webappsPath = currentRelativePath.toAbsolutePath().toString();
        String command = "/bin/bash create_app.sh -n " + appName + " -w true -p " + webappsPath + " -c " + isCluster;
        if (isCluster) {
            command = command + " -m " + mongoHost + " -u " + mongoUser + " -s " + mongoPass;
        }
        log.info("Creating application with command: {}", (Object)command);
        return this.runCommand(command);
    }

    public boolean runDeleteAppScript(String appName) {
        Path currentRelativePath = Paths.get("", new String[0]);
        String webappsPath = currentRelativePath.toAbsolutePath().toString();
        String command = "/bin/bash delete_app.sh -n " + appName + " -p " + webappsPath;
        return this.runCommand(command);
    }

    public boolean runCommand(String command) {
        boolean result = false;
        try {
            Process process = this.getProcess(command);
            result = process.waitFor() == 0;
        }
        catch (IOException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (InterruptedException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            Thread.currentThread().interrupt();
        }
        return result;
    }

    public Process getProcess(String command) throws IOException {
        ProcessBuilder pb = new ProcessBuilder(command.split(" "));
        pb.inheritIO().redirectOutput(ProcessBuilder.Redirect.INHERIT);
        pb.inheritIO().redirectError(ProcessBuilder.Redirect.INHERIT);
        return pb.start();
    }

    public void setVertx(Vertx vertx) {
        this.vertx = vertx;
    }

    public void setWarDeployer(WarDeployer warDeployer) {
        this.warDeployer = warDeployer;
    }

    public static class BroadcastInfo {
        public String name;
        public int watcherCount;

        public BroadcastInfo(String name, int watcherCount) {
            this.name = name;
            this.watcherCount = watcherCount;
        }
    }

    public static class ApplicationInfo {
        public String name;
        public int liveStreamCount;
        public int vodCount;
        public long storage;
    }
}

