/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.console.datastore;

import io.antmedia.console.datastore.AbstractConsoleDataStore;
import io.antmedia.console.datastore.MapDBStore;
import io.antmedia.console.datastore.MongoStore;
import org.springframework.beans.factory.annotation.Value;

public class ConsoleDataStoreFactory {
    private AbstractConsoleDataStore dataStore;
    @Value(value="${db.app.name:#{null}}")
    private String appName;
    @Value(value="${db.name:#{null}}")
    private String dbName;
    @Value(value="${db.type:#{null}}")
    private String dbType;
    @Value(value="${db.host:#{null}}")
    private String dbHost;
    @Value(value="${db.user:#{null}}")
    private String dbUser;
    @Value(value="${db.password:#{null}}")
    private String dbPassword;

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public String getDbType() {
        return this.dbType;
    }

    public void setDbType(String dbType) {
        this.dbType = dbType;
    }

    public String getDbHost() {
        return this.dbHost;
    }

    public void setDbHost(String dbHost) {
        this.dbHost = dbHost;
    }

    public String getDbUser() {
        return this.dbUser;
    }

    public void setDbUser(String dbUser) {
        this.dbUser = dbUser;
    }

    public String getDbPassword() {
        return this.dbPassword;
    }

    public void setDbPassword(String dbPassword) {
        this.dbPassword = dbPassword;
    }

    public AbstractConsoleDataStore getDataStore() {
        if (this.dataStore == null) {
            if (this.dbType.contentEquals("mongodb")) {
                this.dataStore = new MongoStore(this.dbHost, this.dbUser, this.dbPassword);
            } else if (this.dbType.contentEquals("mapdb")) {
                this.dataStore = new MapDBStore();
            }
        }
        return this.dataStore;
    }
}

