/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.console.datastore;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.WriteResult;
import dev.morphia.Datastore;
import dev.morphia.Morphia;
import dev.morphia.query.FindOptions;
import dev.morphia.query.Query;
import dev.morphia.query.UpdateOperations;
import dev.morphia.query.UpdateResults;
import io.antmedia.console.datastore.AbstractConsoleDataStore;
import io.antmedia.rest.model.User;
import io.antmedia.rest.model.UserType;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoStore
extends AbstractConsoleDataStore {
    private Morphia morphia;
    private Datastore datastore;
    protected static Logger logger = LoggerFactory.getLogger(MongoStore.class);
    protected volatile boolean available = false;

    public MongoStore(String dbHost, String dbUser, String dbPassword) {
        String dbName = "serverdb";
        String uri = io.antmedia.datastore.db.MongoStore.getMongoConnectionUri(dbHost, dbUser, dbPassword);
        MongoClientURI mongoUri = new MongoClientURI(uri);
        MongoClient client = new MongoClient(mongoUri);
        this.morphia = new Morphia();
        this.datastore = this.morphia.createDatastore(client, dbName);
        this.datastore.ensureIndexes();
        this.available = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<User> getUserList() {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            List<User> users = new ArrayList<User>();
            try {
                Query query = this.datastore.find(User.class);
                users = query.find(new FindOptions()).toList();
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
            return users;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addUser(String username, String password, UserType userType) {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            boolean result = false;
            if (username != null && password != null && userType != null) {
                User existingUser = (User)((Query)this.datastore.find(User.class).field("email").equal((Object)username)).get();
                if (existingUser == null) {
                    User user = new User(username, password, userType);
                    this.datastore.save((Object)user);
                    result = true;
                } else {
                    logger.warn("user with {} already exist", (Object)username);
                }
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean editUser(String username, String password, UserType userType) {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            try {
                Query query = (Query)this.datastore.createQuery(User.class).field("email").equal((Object)username);
                UpdateOperations ops = this.datastore.createUpdateOperations(User.class).set("email", (Object)username).set("password", (Object)password).set("userType", (Object)userType);
                UpdateResults update = this.datastore.update(query, ops);
                return update.getUpdatedCount() == 1;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteUser(String username) {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            try {
                Query query = (Query)this.datastore.createQuery(User.class).field("email").equal((Object)username);
                WriteResult delete = this.datastore.delete(query);
                return delete.getN() == 1;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doesUsernameExist(String username) {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            User existingUser = (User)((Query)this.datastore.find(User.class).field("email").equal((Object)username)).get();
            return existingUser != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doesUserExist(String username, String password) {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            User existingUser = (User)((Query)this.datastore.find(User.class).field("email").equal((Object)username)).get();
            if (existingUser != null) {
                return existingUser.getPassword().contentEquals(password);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public User getUser(String username) {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            return (User)((Query)this.datastore.find(User.class).field("email").equal((Object)username)).get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            this.datastore.delete(this.datastore.createQuery(User.class));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            this.available = false;
            this.datastore.getMongo().close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumberOfUserRecords() {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            return (int)this.datastore.getCount(User.class);
        }
    }

    @Override
    public boolean isAvailable() {
        return this.available;
    }
}

