/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.console.rest;

import ch.qos.logback.classic.Level;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.antmedia.AntMediaApplicationAdapter;
import io.antmedia.AppSettings;
import io.antmedia.IApplicationAdaptorFactory;
import io.antmedia.SystemUtils;
import io.antmedia.console.AdminApplication;
import io.antmedia.console.datastore.AbstractConsoleDataStore;
import io.antmedia.console.datastore.ConsoleDataStoreFactory;
import io.antmedia.datastore.db.types.Licence;
import io.antmedia.datastore.preference.PreferenceStore;
import io.antmedia.licence.ILicenceService;
import io.antmedia.rest.RestServiceBase;
import io.antmedia.rest.model.Result;
import io.antmedia.rest.model.User;
import io.antmedia.rest.model.UserType;
import io.antmedia.settings.ServerSettings;
import io.antmedia.statistic.StatsCollector;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.ws.rs.FormParam;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.codec.binary.Hex;
import org.red5.server.api.scope.IScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class CommonRestService {
    private static final String LOG_TYPE_ERROR = "error";
    private static final String FILE_NOT_EXIST = "There is no log yet";
    private static final String ERROR_LOG_LOCATION = "log/antmedia-error.log";
    private static final String SERVER_LOG_LOCATION = "log/ant-media-server.log";
    private static final String LOG_CONTENT = "logContent";
    private static final String LOG_CONTENT_SIZE = "logContentSize";
    private static final String LOG_FILE_SIZE = "logFileSize";
    private static final int MAX_CHAR_SIZE = 512000;
    private static final String LOG_LEVEL_ALL = "ALL";
    private static final String LOG_LEVEL_TRACE = "TRACE";
    private static final String LOG_LEVEL_DEBUG = "DEBUG";
    private static final String LOG_LEVEL_INFO = "INFO";
    private static final String LOG_LEVEL_WARN = "WARN";
    private static final String LOG_LEVEL_ERROR = "ERROR";
    private static final String LOG_LEVEL_OFF = "OFF";
    private static final String USER_PASSWORD = "user.password";
    public static final String USER_EMAIL = "user.email";
    public static final String IS_AUTHENTICATED = "isAuthenticated";
    public static final String SERVER_NAME = "server.name";
    public static final String LICENSE_KEY = "server.licence_key";
    public static final String MARKET_BUILD = "server.market_build";
    public static final String NODE_GROUP = "nodeGroup";
    Gson gson = new Gson();
    private AbstractConsoleDataStore dataStore;
    private static final String LOG_LEVEL = "logLevel";
    private static final String RED5_PROPERTIES_PATH = "conf/red5.properties";
    protected static final Logger logger = LoggerFactory.getLogger(CommonRestService.class);
    private static final String LICENSE_STATUS = "license";
    protected ApplicationContext applicationContext;
    @Context
    private ServletContext servletContext;
    @Context
    private HttpServletRequest servletRequest;
    private ConsoleDataStoreFactory dataStoreFactory;
    private ServerSettings serverSettings;
    private ILicenceService licenceService;
    private static final int BLOCKED_LOGIN_TIMEOUT_SECS = 300;
    private static final int ALLOWED_LOGIN_ATTEMPTS = 2;

    public int getAllowedLoginAttempts() {
        return 2;
    }

    public Result addUser(User user) {
        boolean result = false;
        String message = "";
        if (user != null) {
            if (!this.getDataStore().doesUsernameExist(user.getEmail())) {
                result = this.getDataStore().addUser(user.getEmail(), this.getMD5Hash(user.getPassword()), user.getUserType());
                logger.info("added user = {} user type = {} -> {}", new Object[]{user.getEmail(), user.getUserType(), result});
            } else {
                message = "User with the same e-mail already exists";
            }
        } else {
            message = "User object is null";
        }
        Result operationResult = new Result(result);
        operationResult.setMessage(message);
        return operationResult;
    }

    public Result addInitialUser(User user) {
        boolean result = false;
        int errorId = -1;
        if (this.getDataStore().getNumberOfUserRecords() == 0) {
            result = this.getDataStore().addUser(user.getEmail(), this.getMD5Hash(user.getPassword()), UserType.ADMIN);
        }
        Result operationResult = new Result(result);
        operationResult.setErrorId(errorId);
        return operationResult;
    }

    public Result isFirstLogin() {
        boolean result = false;
        if (this.getDataStore().getNumberOfUserRecords() == 0) {
            result = true;
        }
        return new Result(result);
    }

    public Result authenticateUser(User user) {
        String message = "";
        boolean tryToAuthenticate = false;
        if (user != null && user.getEmail() != null) {
            if (this.getDataStore().isUserBlocked(user.getEmail())) {
                if (Instant.now().getEpochSecond() - this.getDataStore().getBlockTime(user.getEmail()) > 300L) {
                    logger.info("Unblocking the user -> {}", (Object)user.getEmail());
                    this.getDataStore().setUnBlocked(user.getEmail());
                    this.getDataStore().resetInvalidLoginCount(user.getEmail());
                    tryToAuthenticate = true;
                } else {
                    message = "Too many login attempts. User is blocked for 300 secs";
                }
            } else {
                tryToAuthenticate = true;
            }
        }
        boolean result = false;
        if (tryToAuthenticate) {
            boolean bl = result = this.getDataStore().doesUserExist(user.getEmail(), user.getPassword()) || this.getDataStore().doesUserExist(user.getEmail(), this.getMD5Hash(user.getPassword()));
            if (result) {
                HttpSession session = this.servletRequest.getSession();
                session.setAttribute(IS_AUTHENTICATED, (Object)true);
                session.setAttribute(USER_EMAIL, (Object)user.getEmail());
                session.setAttribute(USER_PASSWORD, (Object)this.getMD5Hash(user.getPassword()));
                this.getDataStore().resetInvalidLoginCount(user.getEmail());
            } else {
                this.getDataStore().incrementInvalidLoginCount(user.getEmail());
                logger.info("Increased invalid login count to: {}", (Object)this.getDataStore().getInvalidLoginCount(user.getEmail()));
                if (this.getDataStore().getInvalidLoginCount(user.getEmail()) > 2) {
                    this.getDataStore().setBlocked(user.getEmail());
                    this.getDataStore().setBlockTime(user.getEmail(), Instant.now().getEpochSecond());
                    logger.info("User is blocked: {}", (Object)this.getDataStore().doesUsernameExist(user.getEmail()));
                }
            }
        }
        return new Result(result, message);
    }

    public void setRequestForTest(HttpServletRequest testRequest) {
        this.servletRequest = testRequest;
    }

    public Result isAdmin() {
        User currentUser;
        HttpSession session = this.servletRequest.getSession();
        if (CommonRestService.isAuthenticated(session) && (currentUser = this.getDataStore().getUser(session.getAttribute(USER_EMAIL).toString())).getUserType().equals((Object)UserType.ADMIN)) {
            return new Result(true, "User is admin");
        }
        return new Result(false, "User is not admin");
    }

    public Result editUser(User user) {
        boolean result = false;
        String message = "";
        HttpSession session = this.servletRequest.getSession();
        String userEmail = (String)session.getAttribute(USER_EMAIL);
        if (user != null && user.getEmail() != null && this.getDataStore().doesUsernameExist(user.getEmail())) {
            if (!userEmail.equals(user.getEmail())) {
                User oldUser = this.getDataStore().getUser(user.getEmail());
                this.getDataStore().deleteUser(user.getEmail());
                if (user.getNewPassword() != null && !user.getNewPassword().isEmpty()) {
                    logger.info("Changing password of user: {}", (Object)user.getEmail());
                    result = this.getDataStore().addUser(user.getEmail(), this.getMD5Hash(user.getNewPassword()), user.getUserType());
                } else {
                    logger.info("Changing type of user: {}", (Object)user.getEmail());
                    result = this.getDataStore().addUser(user.getEmail(), oldUser.getPassword(), user.getUserType());
                }
            } else {
                message = "User cannot edit itself";
            }
        } else {
            message = "Edited user is not found in database";
        }
        return new Result(result, message);
    }

    public Result deleteUser(String userName) {
        HttpSession session = this.servletRequest.getSession();
        String userEmail = (String)session.getAttribute(USER_EMAIL);
        boolean result = false;
        String message = "";
        if (!userEmail.equals(userName)) {
            result = this.getDataStore().deleteUser(userName);
            if (!result) {
                logger.info("Could not delete the user: {}", (Object)userName);
            }
        } else {
            message = "You cannot delete yourself";
        }
        if (result) {
            logger.info("Deleted user: {} ", (Object)userName);
        }
        return new Result(result, message);
    }

    public List<User> getUserList() {
        return this.getDataStore().getUserList();
    }

    public Result changeUserPassword(User user) {
        String userMail = (String)this.servletRequest.getSession().getAttribute(USER_EMAIL);
        return this.changeUserPasswordInternal(userMail, user);
    }

    public Result changeUserPasswordInternal(String userMail, User user) {
        boolean result = false;
        String message = null;
        if (userMail != null && user.getNewPassword() != null) {
            boolean bl = result = this.getDataStore().doesUserExist(userMail, user.getPassword()) || this.getDataStore().doesUserExist(userMail, this.getMD5Hash(user.getPassword()));
            if (result) {
                result = this.getDataStore().editUser(userMail, this.getMD5Hash(user.getNewPassword()), UserType.ADMIN);
                if (result) {
                    message = "Success";
                    HttpSession session = this.servletRequest.getSession();
                    if (session != null) {
                        session.setAttribute(IS_AUTHENTICATED, (Object)true);
                        session.setAttribute(USER_EMAIL, (Object)userMail);
                        session.setAttribute(USER_PASSWORD, (Object)this.getMD5Hash(user.getNewPassword()));
                    }
                }
            } else {
                message = "User not exist with that name and pass";
            }
        } else {
            message = "User name does not exist or there is no new password";
        }
        return new Result(result, message);
    }

    public Result isAuthenticatedRest() {
        return new Result(CommonRestService.isAuthenticated(this.servletRequest.getSession()));
    }

    public static boolean isAuthenticated(HttpSession session) {
        Object isAuthenticated = session.getAttribute(IS_AUTHENTICATED);
        Object userEmail = session.getAttribute(USER_EMAIL);
        Object userPassword = session.getAttribute(USER_PASSWORD);
        boolean result = false;
        if (isAuthenticated != null && userEmail != null && userPassword != null) {
            result = true;
        }
        return result;
    }

    public String getSystemInfo() {
        return this.gson.toJson((JsonElement)StatsCollector.getSystemInfoJSObject());
    }

    public String getJVMMemoryInfo() {
        return this.gson.toJson((JsonElement)StatsCollector.getJVMMemoryInfoJSObject());
    }

    public String getSystemMemoryInfo() {
        return this.gson.toJson((JsonElement)StatsCollector.getSysteMemoryInfoJSObject());
    }

    public String getFileSystemInfo() {
        return this.gson.toJson((JsonElement)StatsCollector.getFileSystemInfoJSObject());
    }

    public String getCPUInfo() {
        return this.gson.toJson((JsonElement)StatsCollector.getCPUInfoJSObject());
    }

    public String getThreadDump() {
        return Arrays.toString(StatsCollector.getThreadDump());
    }

    public String getThreadDumpJSON() {
        return this.gson.toJson((JsonElement)StatsCollector.getThreadDumpJSON());
    }

    public String getThreadsInfo() {
        return this.gson.toJson((JsonElement)StatsCollector.getThreadInfoJSONObject());
    }

    public Response getHeapDump() {
        SystemUtils.getHeapDump("heapdump.hprof");
        File file = new File("heapdump.hprof");
        return Response.ok((Object)file, (String)"application/octet-stream").header("Content-Disposition", (Object)("attachment; filename=\"" + file.getName() + "\"")).build();
    }

    public String getServerTime() {
        return this.gson.toJson((JsonElement)StatsCollector.getServerTime());
    }

    public String getSystemResourcesInfo() {
        AdminApplication application = this.getApplication();
        IScope rootScope = application.getRootScope();
        int totalLiveStreams = 0;
        LinkedList<IScope> scopes = new LinkedList<IScope>();
        List<String> appNames = application.getApplications();
        for (String name : appNames) {
            IScope scope = rootScope.getScope(name);
            scopes.add(scope);
            totalLiveStreams += application.getAppLiveStreamCount(scope);
        }
        JsonObject jsonObject = StatsCollector.getSystemResourcesInfo(scopes);
        jsonObject.addProperty("totalLiveStreamSize", (Number)totalLiveStreams);
        jsonObject.add(LICENSE_STATUS, this.gson.toJsonTree((Object)this.getLicenceStatus()));
        return this.gson.toJson((JsonElement)jsonObject);
    }

    public String getGPUInfo() {
        return this.gson.toJson((JsonElement)StatsCollector.getGPUInfoJSObject());
    }

    public String getVersion() {
        return this.gson.toJson((Object)RestServiceBase.getSoftwareVersion());
    }

    public String getApplications() {
        List<String> applications = this.getApplication().getApplications();
        JsonObject jsonObject = new JsonObject();
        JsonArray jsonArray = new JsonArray();
        for (String appName : applications) {
            if (appName.equals("ConsoleApp")) continue;
            jsonArray.add(appName);
        }
        jsonObject.add("applications", (JsonElement)jsonArray);
        return this.gson.toJson((JsonElement)jsonObject);
    }

    public String getLiveClientsSize() {
        int totalConnectionSize = this.getApplication().getTotalConnectionSize();
        int totalLiveStreamSize = this.getApplication().getTotalLiveStreamSize();
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("totalConnectionSize", (Number)totalConnectionSize);
        jsonObject.addProperty("totalLiveStreamSize", (Number)totalLiveStreamSize);
        return this.gson.toJson((JsonElement)jsonObject);
    }

    public String getApplicationInfo() {
        List<AdminApplication.ApplicationInfo> info = this.getApplication().getApplicationInfo();
        return this.gson.toJson(info);
    }

    public String getAppLiveStreams(@PathParam(value="appname") String name) {
        List<AdminApplication.BroadcastInfo> appLiveStreams = this.getApplication().getAppLiveStreams(name);
        return this.gson.toJson(appLiveStreams);
    }

    public String deleteVoDStream(@PathParam(value="appname") String name, @FormParam(value="streamName") String streamName) {
        boolean deleteVoDStream = this.getApplication().deleteVoDStream(name, streamName);
        return this.gson.toJson((Object)new Result(deleteVoDStream));
    }

    public String changeSettings(@PathParam(value="appname") String appname, AppSettings newSettings) {
        AntMediaApplicationAdapter adapter = ((IApplicationAdaptorFactory)this.getApplication().getApplicationContext(appname).getBean("web.handler")).getAppAdaptor();
        return this.gson.toJson((Object)new Result(adapter.updateSettings(newSettings, true, false)));
    }

    public boolean getShutdownStatus(@QueryParam(value="appNames") String appNamesArray) {
        String[] appNames;
        boolean appShutdownProblemExists = false;
        if (appNamesArray != null && (appNames = appNamesArray.split(",")) != null) {
            for (String appName : appNames) {
                AntMediaApplicationAdapter appAdaptor = this.getAppAdaptor(appName);
                if (appAdaptor.isShutdownProperly()) continue;
                appShutdownProblemExists = true;
                break;
            }
        }
        return !appShutdownProblemExists;
    }

    public AntMediaApplicationAdapter getAppAdaptor(String appName) {
        IApplicationAdaptorFactory adaptorFactory;
        ApplicationContext context;
        AntMediaApplicationAdapter appAdaptor = null;
        AdminApplication application = this.getApplication();
        if (application != null && (context = application.getApplicationContext(appName)) != null && (adaptorFactory = (IApplicationAdaptorFactory)context.getBean("web.handler")) != null) {
            appAdaptor = adaptorFactory.getAppAdaptor();
        }
        return appAdaptor;
    }

    public Response isShutdownProperly(@QueryParam(value="appNames") String appNamesArray) {
        boolean appShutdownProblemExists = false;
        Response response = null;
        if (appNamesArray != null) {
            String[] appNames = appNamesArray.split(",");
            if (appNames != null) {
                for (String appName : appNames) {
                    AntMediaApplicationAdapter appAdaptor = this.getAppAdaptor(appName);
                    if (appAdaptor != null) {
                        if (appAdaptor.isShutdownProperly()) continue;
                        appShutdownProblemExists = true;
                    } else {
                        response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new Result(false, "Either server may not be initialized or application name that does not exist is requested. ")).build();
                    }
                    break;
                }
            } else {
                response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new Result(false, "Bad parameter for appNames. ")).build();
            }
        } else {
            response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new Result(false, "Bad parameter for appNames. ")).build();
        }
        if (response == null) {
            response = Response.status((Response.Status)Response.Status.OK).entity((Object)new Result(!appShutdownProblemExists)).build();
        }
        return response;
    }

    public boolean setShutdownStatus(@QueryParam(value="appNames") String appNamesArray) {
        String[] appNames = appNamesArray.split(",");
        boolean result = true;
        for (String appName : appNames) {
            if (((IApplicationAdaptorFactory)this.getApplication().getApplicationContext(appName).getBean("web.handler")).getAppAdaptor().isShutdownProperly()) continue;
            ((IApplicationAdaptorFactory)this.getApplication().getApplicationContext(appName).getBean("web.handler")).getAppAdaptor().setShutdownProperly(true);
        }
        return result;
    }

    public String changeServerSettings(ServerSettings serverSettings) {
        PreferenceStore store = new PreferenceStore(RED5_PROPERTIES_PATH);
        String serverName = "";
        String licenceKey = "";
        if (serverSettings.getServerName() != null) {
            serverName = serverSettings.getServerName();
        }
        store.put(SERVER_NAME, serverName);
        this.getServerSettingsInternal().setServerName(serverName);
        if (serverSettings.getLicenceKey() != null) {
            licenceKey = serverSettings.getLicenceKey();
        }
        store.put(LICENSE_KEY, licenceKey);
        this.getServerSettingsInternal().setLicenceKey(licenceKey);
        store.put(MARKET_BUILD, String.valueOf(serverSettings.isBuildForMarket()));
        this.getServerSettingsInternal().setBuildForMarket(serverSettings.isBuildForMarket());
        store.put(NODE_GROUP, String.valueOf(serverSettings.getNodeGroup()));
        this.getServerSettingsInternal().setNodeGroup(serverSettings.getNodeGroup());
        ch.qos.logback.classic.Logger rootLogger = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)"ROOT");
        if (LOG_LEVEL_ALL.equals(serverSettings.getLogLevel()) || LOG_LEVEL_TRACE.equals(serverSettings.getLogLevel()) || LOG_LEVEL_DEBUG.equals(serverSettings.getLogLevel()) || LOG_LEVEL_INFO.equals(serverSettings.getLogLevel()) || LOG_LEVEL_WARN.equals(serverSettings.getLogLevel()) || LOG_LEVEL_ERROR.equals(serverSettings.getLogLevel()) || LOG_LEVEL_OFF.equals(serverSettings.getLogLevel())) {
            rootLogger.setLevel(this.currentLevelDetect(serverSettings.getLogLevel()));
            store.put(LOG_LEVEL, serverSettings.getLogLevel());
            this.getServerSettingsInternal().setLogLevel(serverSettings.getLogLevel());
        }
        return this.gson.toJson((Object)new Result(store.save()));
    }

    public Result isEnterpriseEdition() {
        boolean isEnterprise = RestServiceBase.isEnterprise();
        return new Result(isEnterprise, "");
    }

    public AppSettings getSettings(String appname) {
        AntMediaApplicationAdapter appAdaptor = this.getAppAdaptor(appname);
        if (appAdaptor != null) {
            return appAdaptor.getAppSettings();
        }
        logger.warn("getSettings for app: {} returns null. It's likely not initialized.", (Object)appname);
        return null;
    }

    public ServerSettings getServerSettings() {
        return this.getServerSettingsInternal();
    }

    public Licence getLicenceStatus(@QueryParam(value="key") String key) {
        if (key == null) {
            return null;
        }
        return this.getLicenceServiceInstance().checkLicence(key);
    }

    public Licence getLicenceStatus() {
        return this.getLicenceServiceInstance().getLastLicenseStatus();
    }

    public Result resetBroadcast(@PathParam(value="appname") String appname) {
        AntMediaApplicationAdapter appAdaptor = ((IApplicationAdaptorFactory)this.getApplication().getApplicationContext(appname).getBean("web.handler")).getAppAdaptor();
        return appAdaptor.resetBroadcasts();
    }

    public void setDataStore(AbstractConsoleDataStore dataStore) {
        this.dataStore = dataStore;
    }

    public AbstractConsoleDataStore getDataStore() {
        if (this.dataStore == null) {
            this.dataStore = this.getDataStoreFactory().getDataStore();
        }
        return this.dataStore;
    }

    private ServerSettings getServerSettingsInternal() {
        if (this.serverSettings == null) {
            WebApplicationContext ctxt = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.servletContext);
            this.serverSettings = (ServerSettings)ctxt.getBean("ant.media.server.settings");
        }
        return this.serverSettings;
    }

    public ILicenceService getLicenceServiceInstance() {
        if (this.licenceService == null) {
            WebApplicationContext ctxt = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.servletContext);
            this.licenceService = (ILicenceService)ctxt.getBean(ILicenceService.BeanName.LICENCE_SERVICE.toString());
        }
        return this.licenceService;
    }

    public AdminApplication getApplication() {
        WebApplicationContext ctxt = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.servletContext);
        return (AdminApplication)ctxt.getBean("web.handler");
    }

    public ConsoleDataStoreFactory getDataStoreFactory() {
        if (this.dataStoreFactory == null) {
            WebApplicationContext ctxt = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.servletContext);
            this.dataStoreFactory = (ConsoleDataStoreFactory)ctxt.getBean("dataStoreFactory");
        }
        return this.dataStoreFactory;
    }

    public void setDataStoreFactory(ConsoleDataStoreFactory dataStoreFactory) {
        this.dataStoreFactory = dataStoreFactory;
    }

    public Result isInClusterMode() {
        return new Result(this.isClusterMode(), "");
    }

    public String changeLogSettings(@PathParam(value="level") String logLevel) {
        ch.qos.logback.classic.Logger rootLogger = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)"ROOT");
        PreferenceStore store = new PreferenceStore(RED5_PROPERTIES_PATH);
        if (logLevel.equals(LOG_LEVEL_ALL) || logLevel.equals(LOG_LEVEL_TRACE) || logLevel.equals(LOG_LEVEL_DEBUG) || logLevel.equals(LOG_LEVEL_INFO) || logLevel.equals(LOG_LEVEL_WARN) || logLevel.equals(LOG_LEVEL_ERROR) || logLevel.equals(LOG_LEVEL_OFF)) {
            rootLogger.setLevel(this.currentLevelDetect(logLevel));
            store.put(LOG_LEVEL, logLevel);
        }
        return this.gson.toJson((Object)new Result(store.save()));
    }

    public Level currentLevelDetect(String logLevel) {
        if (logLevel.equals(LOG_LEVEL_OFF)) {
            Level currentLevel = Level.OFF;
            return currentLevel;
        }
        if (logLevel.equals(LOG_LEVEL_ERROR)) {
            Level currentLevel = Level.ERROR;
            return currentLevel;
        }
        if (logLevel.equals(LOG_LEVEL_WARN)) {
            Level currentLevel = Level.WARN;
            return currentLevel;
        }
        if (logLevel.equals(LOG_LEVEL_DEBUG)) {
            Level currentLevel = Level.DEBUG;
            return currentLevel;
        }
        if (logLevel.equals(LOG_LEVEL_TRACE)) {
            Level currentLevel = Level.ALL;
            return currentLevel;
        }
        if (logLevel.equals(LOG_LEVEL_ALL)) {
            Level currentLevel = Level.ALL;
            return currentLevel;
        }
        Level currentLevel = Level.INFO;
        return currentLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLogFile(@PathParam(value="charSize") int charSize, @QueryParam(value="logType") String logType, @PathParam(value="offsetSize") long offsetSize) throws IOException {
        long skipValue = 0L;
        int countKb = 0;
        int maxCount = 500;
        String logLocation = SERVER_LOG_LOCATION;
        if (logType.equals(LOG_TYPE_ERROR)) {
            logLocation = ERROR_LOG_LOCATION;
        }
        JsonObject jsonObject = new JsonObject();
        String logContent = "";
        File file = new File(logLocation);
        if (!file.isFile()) {
            logContent = FILE_NOT_EXIST;
            jsonObject.addProperty(LOG_CONTENT, logContent);
            return jsonObject.toString();
        }
        if (charSize > 512000) {
            charSize = 512000;
        }
        if (offsetSize != -1L) {
            skipValue = offsetSize;
            maxCount = charSize / 1024;
        } else if (file.length() > (long)charSize) {
            skipValue = file.length() - (long)charSize;
        }
        int contentSize = 0;
        if (file.length() > skipValue) {
            ByteArrayOutputStream ous = null;
            InputStream ios = null;
            try {
                byte[] buffer = new byte[1024];
                ous = new ByteArrayOutputStream();
                ios = new FileInputStream(file);
                ios.skip(skipValue);
                int read = 0;
                while ((read = ios.read(buffer)) != -1) {
                    ous.write(buffer, 0, read);
                    contentSize += read;
                    if (++countKb != maxCount) continue;
                    break;
                }
            }
            finally {
                try {
                    if (ous != null) {
                        ous.close();
                    }
                }
                catch (IOException e) {
                    logger.error(e.toString());
                }
                try {
                    if (ios != null) {
                        ios.close();
                    }
                }
                catch (IOException e) {
                    logger.error(e.toString());
                }
            }
            logContent = ous.toString("UTF-8");
        }
        jsonObject.addProperty(LOG_CONTENT, logContent);
        jsonObject.addProperty(LOG_CONTENT_SIZE, (Number)contentSize);
        jsonObject.addProperty(LOG_FILE_SIZE, (Number)file.length());
        return jsonObject.toString();
    }

    public String getMD5Hash(String pass) {
        String passResult = "";
        try {
            MessageDigest m = MessageDigest.getInstance("MD5");
            m.reset();
            m.update(pass.getBytes(Charset.forName("UTF8")));
            byte[] digestResult = m.digest();
            passResult = Hex.encodeHexString((byte[])digestResult);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return passResult;
    }

    public Result createApplication(String appName) {
        return new Result(this.getApplication().createApplication(appName));
    }

    public Result deleteApplication(String appName) {
        appName = appName.replaceAll("[\n\r\t]", "_");
        logger.info("delete application http request:{}", (Object)appName);
        AppSettings appSettings = this.getSettings(appName);
        boolean result = false;
        if (appSettings != null) {
            appSettings.setToBeDeleted(true);
            this.changeSettings(appName, appSettings);
            result = true;
            if (!this.isClusterMode()) {
                result = this.getApplication().deleteApplication(appName);
            }
        } else {
            logger.info("App settings is not available for app name:{}. App may be initializing", (Object)appName);
        }
        return new Result(result);
    }

    public boolean isClusterMode() {
        WebApplicationContext ctxt = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.servletContext);
        return ctxt.containsBean("tomcat.cluster");
    }

    public Result getBlockedStatus(String usermail) {
        return new Result(this.getDataStore().isUserBlocked(usermail));
    }
}

